/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.figures.decoration;

import com.ibm.etools.diagram.ui.internal.DiagramColors;
import com.ibm.etools.diagram.ui.internal.figures.CircleFigure;
import com.ibm.etools.diagram.ui.internal.figures.decoration.IHoverableAndSelectable;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;

public class CircleDecoration
extends CircleFigure
implements RotatableDecoration,
IHoverableAndSelectable {
    private boolean hover;
    private boolean selected;

    public CircleDecoration(Dimension dim) {
        super(dim);
    }

    public CircleDecoration(int diameter) {
        super(diameter);
    }

    public CircleDecoration(int width, int height) {
        super(width, height);
    }

    public boolean isHover() {
        return this.hover;
    }

    public boolean isSelected() {
        return this.selected;
    }

    @Override
    protected void paintFigure(Graphics g) {
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(this.getBounds());
        g.setBackgroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.wireRealized));
        g.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.wireRealized));
        if (this.hover) {
            g.setBackgroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.wireHoverCenter));
            g.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.wireHoverCenter));
        }
        g.fillOval(r);
        --r.width;
        --r.height;
        g.drawOval(r);
    }

    @Override
    public void setHover(boolean hover) {
        this.hover = hover;
    }

    public void setReferencePoint(Point p) {
        Point center = this.getBounds().getCenter().getCopy();
        Point ref = p.getCopy();
        Dimension difference = ref.getDifference(center);
        this.getBounds().translate(difference.width, difference.height);
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

