/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.figures;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.ui.internal.editparts.ProviderTitleEditPart;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.common.ui.services.icon.IconService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Image;

public class TitleFigure
extends NodeFigure {
    private final ProviderTitleEditPart part;
    private final IMapMode mm;
    private Image image;

    public TitleFigure(ProviderTitleEditPart part, IMapMode mm) {
        this.part = part;
        this.mm = mm;
        this.refreshImage();
    }

    public WrappingLabel getLabel() {
        return (WrappingLabel)this.getChildren().get(0);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension d = super.getPreferredSize(wHint, hHint);
        d.width = Math.min(d.width, MapModeUtil.getMapMode((IFigure)this).DPtoLP(200));
        return d;
    }

    public void handleMouseDoubleClicked(MouseEvent event) {
        super.handleMouseDoubleClicked(event);
    }

    public void handleMouseDragged(MouseEvent event) {
        super.handleMouseDragged(event);
    }

    public void handleMouseEntered(MouseEvent event) {
        super.handleMouseEntered(event);
    }

    public void handleMouseExited(MouseEvent event) {
        super.handleMouseExited(event);
    }

    public void handleMouseHover(MouseEvent event) {
        super.handleMouseHover(event);
    }

    public void handleMouseMoved(MouseEvent event) {
        super.handleMouseMoved(event);
    }

    public void handleMousePressed(MouseEvent event) {
        super.handleMousePressed(event);
    }

    public void handleMouseReleased(MouseEvent event) {
        super.handleMouseReleased(event);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        Rectangle r = this.getBounds().getCopy();
        Rectangle titleBackground = this.getBounds().getCopy();
        titleBackground = titleBackground.getCropped(this.getInsets());
        graphics.setLineWidth(1);
        if (this.image != null) {
            Rectangle imageRect = r.getCopy();
            imageRect.width = this.mm.DPtoLP(24);
            imageRect.height = this.mm.DPtoLP(24);
            graphics.drawImage(this.image, new Rectangle(this.image.getBounds()), imageRect);
        }
    }

    public void refreshImage() {
        CommonElement node = (CommonElement)ViewUtil.resolveSemanticElement((View)this.part.getPrimaryView());
        if (node != null) {
            int flags = 32;
            flags = node.isRealized() ? (flags |= 2) : (flags |= 4);
            Image newImage = IconService.getInstance().getIcon((IAdaptable)node, flags);
            if (this.image != newImage) {
                this.image = newImage;
                this.repaint();
            }
        }
    }
}

