/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.figures;

import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.model.DiagramModelElementTypeFactory;
import com.ibm.etools.diagram.ui.internal.DiagramColors;
import com.ibm.etools.diagram.ui.internal.editparts.ProviderNodeEditPart;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.forms.FormColors;

public class ProviderFigure
extends NodeFigure
implements HandleBounds {
    private final ProviderNodeEditPart host;
    private Color innerLineColor;
    private Color outerLineColor;
    private Color fillColor;
    private boolean roundRectangles = true;
    private boolean drawBorder;
    private boolean gradient = true;

    public ProviderFigure(ProviderNodeEditPart host) {
        IElementType type;
        this.host = host;
        EObject o = ViewUtil.resolveSemanticElement((View)((View)host.getModel()));
        if (o instanceof TypedElement && (type = ((TypedElement)o).getElementType()) instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) {
            DiagramModelElementTypeFactory.DiagramModelSpecializationType dType = (DiagramModelElementTypeFactory.DiagramModelSpecializationType)type;
            if (dType.getShapeStyle() == 2) {
                this.roundRectangles = false;
            } else if (dType.getShapeStyle() == 1) {
                this.roundRectangles = true;
            }
            this.gradient = dType.isGradient();
        }
        ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout(false);
        layout.setObserveVisibility(true);
        layout.setStretchMajorAxis(false);
        layout.setIgnoreInvisibleChildren(true);
        layout.setStretchMinorAxis(true);
        this.setLayoutManager((LayoutManager)layout);
    }

    public void add(IFigure figure, Object constraint, int index) {
        super.add(figure, constraint, index);
    }

    public IFigure getContentPane() {
        return this;
    }

    public boolean getDrawBorder() {
        return this.drawBorder;
    }

    public Rectangle getHandleBounds() {
        Rectangle r = this.getOuterRectangle();
        r.expand(MapModeUtil.getMapMode((IFigure)this).DPtoLP(1), MapModeUtil.getMapMode((IFigure)this).DPtoLP(1));
        return r;
    }

    private Rectangle getOuterRectangle() {
        Rectangle b = this.getClientArea();
        b = b.translate(MapModeUtil.getMapMode((IFigure)this).DPtoLP(3), MapModeUtil.getMapMode((IFigure)this).DPtoLP(6));
        b.height -= MapModeUtil.getMapMode((IFigure)this).DPtoLP(6);
        b.width -= MapModeUtil.getMapMode((IFigure)this).DPtoLP(3);
        if (this.getVisibleChildren() > 1) {
            b.height += MapModeUtil.getMapMode((IFigure)this).DPtoLP(5);
        }
        return b;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension d = super.getPreferredSize(wHint, hHint);
        return d;
    }

    private int getVisibleChildren() {
        int childrenSize = 0;
        List children = this.getChildren();
        for (IFigure fig : children) {
            if (!fig.isVisible()) continue;
            ++childrenSize;
        }
        return childrenSize;
    }

    public void invalidate() {
        super.invalidate();
    }

    protected void layout() {
        super.layout();
    }

    protected void paintFigure(Graphics graphics) {
        Color white = ColorConstants.white;
        Rectangle r = this.getOuterRectangle();
        Rectangle background = r.getCopy();
        graphics.setBackgroundColor(white);
        if (this.roundRectangles) {
            graphics.fillRoundRectangle(background, MapModeUtil.getMapMode((IFigure)this).DPtoLP(26), MapModeUtil.getMapMode((IFigure)this).DPtoLP(26));
        } else {
            graphics.fillRectangle(background);
        }
        Rectangle solidRectangle = r.getCopy();
        solidRectangle.y = solidRectangle.y + solidRectangle.height - 2 * MapModeUtil.getMapMode((IFigure)this).DPtoLP(13);
        solidRectangle.height = 2 * MapModeUtil.getMapMode((IFigure)this).DPtoLP(13);
        Rectangle solidClipRegion = solidRectangle.getCopy();
        solidClipRegion.y += MapModeUtil.getMapMode((IFigure)this).DPtoLP(13);
        solidClipRegion.height = MapModeUtil.getMapMode((IFigure)this).DPtoLP(13);
        Rectangle gradientRectangle = background.getCopy();
        if (this.gradient) {
            gradientRectangle.y += MapModeUtil.getMapMode((IFigure)this).DPtoLP(13);
            gradientRectangle.height = solidRectangle.y - gradientRectangle.y + MapModeUtil.getMapMode((IFigure)this).DPtoLP(13);
        }
        if (gradientRectangle.height > 0) {
            Rectangle oldClip = new Rectangle();
            graphics.getClip(oldClip);
            graphics.setClip(solidClipRegion);
            graphics.setBackgroundColor(this.fillColor);
            if (this.roundRectangles) {
                graphics.fillRoundRectangle(solidRectangle, MapModeUtil.getMapMode((IFigure)this).DPtoLP(26), MapModeUtil.getMapMode((IFigure)this).DPtoLP(26));
            } else {
                graphics.fillRectangle(background);
            }
            graphics.setClip(oldClip);
            if (this.gradient) {
                graphics.setForegroundColor(white);
                graphics.fillGradient(gradientRectangle, true);
            } else if (this.roundRectangles) {
                graphics.fillRoundRectangle(gradientRectangle, MapModeUtil.getMapMode((IFigure)this).DPtoLP(26), MapModeUtil.getMapMode((IFigure)this).DPtoLP(26));
            } else {
                graphics.fillRectangle(gradientRectangle);
            }
        }
        Rectangle expanded = background.getCopy();
        expanded.expand(MapModeUtil.getMapMode((IFigure)this).DPtoLP(1), MapModeUtil.getMapMode((IFigure)this).DPtoLP(1));
        if (this.drawBorder) {
            if (this.host.getSelected() == 0) {
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.shapeHoverInnerStroke));
                if (this.roundRectangles) {
                    graphics.drawRoundRectangle(background, MapModeUtil.getMapMode((IFigure)this).DPtoLP(26), MapModeUtil.getMapMode((IFigure)this).DPtoLP(26));
                } else {
                    graphics.drawRectangle(background);
                }
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.shapeHoverOuterStroke));
                if (this.roundRectangles) {
                    graphics.drawRoundRectangle(expanded, MapModeUtil.getMapMode((IFigure)this).DPtoLP(29), MapModeUtil.getMapMode((IFigure)this).DPtoLP(29));
                } else {
                    graphics.drawRectangle(expanded);
                }
            }
        } else {
            graphics.setForegroundColor(this.innerLineColor);
            if (this.roundRectangles) {
                graphics.drawRoundRectangle(background, MapModeUtil.getMapMode((IFigure)this).DPtoLP(26), MapModeUtil.getMapMode((IFigure)this).DPtoLP(26));
            } else {
                graphics.drawRectangle(background);
            }
            graphics.setForegroundColor(this.outerLineColor);
            if (this.roundRectangles) {
                graphics.drawRoundRectangle(expanded, MapModeUtil.getMapMode((IFigure)this).DPtoLP(29), MapModeUtil.getMapMode((IFigure)this).DPtoLP(29));
            } else {
                graphics.drawRectangle(expanded);
            }
        }
        if (this.host.getSelected() > 0) {
            graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.shapeSelectedInnerStroke));
            if (this.roundRectangles) {
                graphics.drawRoundRectangle(background, MapModeUtil.getMapMode((IFigure)this).DPtoLP(26), MapModeUtil.getMapMode((IFigure)this).DPtoLP(26));
            } else {
                graphics.drawRectangle(background);
            }
            graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.shapeSelectedOuterStroke));
            if (this.roundRectangles) {
                graphics.drawRoundRectangle(expanded, MapModeUtil.getMapMode((IFigure)this).DPtoLP(29), MapModeUtil.getMapMode((IFigure)this).DPtoLP(29));
            } else {
                graphics.drawRectangle(expanded);
            }
        }
    }

    public void remove(IFigure figure) {
        super.remove(figure);
    }

    public void setDrawBorder(boolean drawborder) {
        if (this.drawBorder != drawborder) {
            this.drawBorder = drawborder;
            this.repaint();
        }
    }

    public void setFillColor(RGB shapeFillRGB) {
        this.fillColor = DiagramColorRegistry.getInstance().getColor(shapeFillRGB);
        this.repaint();
    }

    public void setLineColor(RGB outerLineRGB) {
        RGB lineColor = FormColors.blend((RGB)new RGB(255, 255, 255), (RGB)outerLineRGB, (int)15);
        RGB outerLineColor = FormColors.blend((RGB)new RGB(255, 255, 255), (RGB)outerLineRGB, (int)50);
        this.innerLineColor = DiagramColorRegistry.getInstance().getColor(lineColor);
        this.outerLineColor = DiagramColorRegistry.getInstance().getColor(outerLineColor);
        this.repaint();
    }

    public void setValid(boolean value) {
        super.setValid(value);
    }
}

