/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.figures;

import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.model.DiagramModelElementTypeFactory;
import com.ibm.etools.diagram.ui.internal.DiagramColors;
import com.ibm.etools.diagram.ui.internal.editparts.ProviderCompartmentEditPart;
import com.ibm.etools.diagram.ui.internal.nls.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.ui.services.icon.IconService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class DiagramResizableCompartmentFigure
extends ResizableCompartmentFigure {
    private final boolean primary;
    private Color lineColor;
    private WrappingLabel titleLabel;
    private final ProviderCompartmentEditPart part;
    private boolean drawRoundRectangles = true;
    private boolean hover;

    public DiagramResizableCompartmentFigure(ProviderCompartmentEditPart part, String compartmentTitle, IMapMode mode, boolean primary) {
        super(compartmentTitle, mode);
        IElementType type;
        this.part = part;
        this.primary = primary;
        this.setTitle(compartmentTitle);
        EObject o = ViewUtil.resolveSemanticElement((View)((View)part.getModel()));
        if (o instanceof Compartment && (o = ((Compartment)o).getParent()) != null && (type = ((TypedElement)o).getElementType()) instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) {
            DiagramModelElementTypeFactory.DiagramModelSpecializationType dType = (DiagramModelElementTypeFactory.DiagramModelSpecializationType)type;
            if (dType.getShapeStyle() == 2) {
                this.drawRoundRectangles = false;
            } else if (dType.getShapeStyle() == 1) {
                this.drawRoundRectangles = true;
            }
        }
        ((ConstrainedToolbarLayout)this.getLayoutManager()).setMinorAlignment(1);
    }

    protected ScrollPane createScrollPane(IMapMode mm) {
        ScrollPane pane = super.createScrollPane(mm);
        pane.getContents().setBorder((Border)new MarginBorder(mm.DPtoLP(1)));
        return pane;
    }

    private Rectangle getInside() {
        return this.getClientArea().getCopy();
    }

    public Dimension getMinClientDimension() {
        if (this.primary) {
            if (this.getContentPane().getChildren().size() == 0) {
                Font f = this.getFont();
                Dimension d = FigureUtilities.getTextExtents((String)this.getNoItemsString(), (Font)f);
                d.height = MapModeUtil.getMapMode((IFigure)this).DPtoLP(d.height);
                d.width = MapModeUtil.getMapMode((IFigure)this).DPtoLP(d.width + 10);
                return d;
            }
            return super.getMinClientDimension();
        }
        DrawerStyle style = (DrawerStyle)((View)this.part.getModel()).getStyle(NotationPackage.eINSTANCE.getDrawerStyle());
        if (style != null) {
            boolean collapsed = style.isCollapsed();
            if (!collapsed && this.getContentPane().getChildren().size() == 0) {
                Font f = this.getFont();
                Dimension d = FigureUtilities.getTextExtents((String)this.getNoItemsString(), (Font)f);
                d.height = MapModeUtil.getMapMode((IFigure)this).DPtoLP(d.height);
                d.width = MapModeUtil.getMapMode((IFigure)this).DPtoLP(d.width);
                return d;
            }
            return new Dimension();
        }
        return new Dimension();
    }

    private String getNoItemsString() {
        String text = NLS.bind((String)Messages.NoX, (Object)this.part.getCompartmentName());
        return text;
    }

    protected void paintFigure(Graphics graphics) {
        Color white = ColorConstants.white;
        Rectangle insideBorder = this.getInside();
        if (this.primary) {
            graphics.setBackgroundColor(white);
            if (this.drawRoundRectangles) {
                graphics.fillRoundRectangle(insideBorder, MapModeUtil.getMapMode((IFigure)this).DPtoLP(14), MapModeUtil.getMapMode((IFigure)this).DPtoLP(14));
            } else {
                graphics.fillRectangle(insideBorder);
            }
            graphics.setForegroundColor(this.lineColor);
            if (this.drawRoundRectangles) {
                graphics.drawRoundRectangle(insideBorder, MapModeUtil.getMapMode((IFigure)this).DPtoLP(14), MapModeUtil.getMapMode((IFigure)this).DPtoLP(14));
            } else {
                graphics.drawRectangle(insideBorder);
            }
            if (this.drawRoundRectangles && this.getParent().getParent().getChildren().size() >= 3) {
                Rectangle bottomBorder = insideBorder.getCopy();
                bottomBorder.y = insideBorder.y + insideBorder.height - MapModeUtil.getMapMode((IFigure)this).DPtoLP(10);
                bottomBorder.height = MapModeUtil.getMapMode((IFigure)this).DPtoLP(10);
                Rectangle oldClip = new Rectangle();
                graphics.setClip(oldClip);
                Rectangle clip = bottomBorder.getCopy();
                clip.height = bottomBorder.height / 2;
                clip.y = bottomBorder.y + bottomBorder.height / 2;
                graphics.setClip(clip);
                graphics.setBackgroundColor(white);
                graphics.fillRectangle(bottomBorder);
                graphics.setForegroundColor(this.lineColor);
                graphics.drawRectangle(bottomBorder);
                graphics.setClip(oldClip);
            }
        } else {
            Color color2;
            Color color1;
            graphics.setBackgroundColor(white);
            graphics.fillRectangle(this.getInside());
            if (this.part.getSelected() > 0) {
                color1 = null;
                color2 = null;
                color1 = DiagramColorRegistry.getInstance().getColor(DiagramColors.shapeSelectedInnerStroke);
                color2 = DiagramColorRegistry.getInstance().getColor(DiagramColors.shapeSelectedOuterStroke);
                Rectangle inaLittle = this.getInside();
                inaLittle = inaLittle.shrink(MapModeUtil.getMapMode((IFigure)this).DPtoLP(1), MapModeUtil.getMapMode((IFigure)this).DPtoLP(1));
                graphics.setForegroundColor(color1);
                graphics.drawRectangle(inaLittle);
                graphics.setForegroundColor(color2);
                graphics.drawRectangle(this.getInside());
            } else if (this.hover) {
                color1 = null;
                color2 = null;
                color1 = DiagramColorRegistry.getInstance().getColor(DiagramColors.shapeHoverOuterStroke);
                color2 = DiagramColorRegistry.getInstance().getColor(DiagramColors.shapeHoverInnerStroke);
                Rectangle inaLittle = this.getInside();
                inaLittle = inaLittle.shrink(MapModeUtil.getMapMode((IFigure)this).DPtoLP(1), MapModeUtil.getMapMode((IFigure)this).DPtoLP(1));
                graphics.setForegroundColor(color1);
                graphics.drawRectangle(inaLittle);
                graphics.setForegroundColor(color2);
                graphics.drawRectangle(this.getInside());
            } else {
                graphics.setForegroundColor(this.lineColor);
                graphics.drawRectangle(this.getInside());
            }
        }
        if (this.getContentPane().getChildren().size() == 0) {
            Rectangle r = this.getClientArea();
            Point start = r.getTopLeft();
            start.x += MapModeUtil.getMapMode((IFigure)this).DPtoLP(5);
            graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.shapeUnrealizedFont));
            graphics.drawText(this.getNoItemsString(), start);
        }
        Color black = ColorConstants.black;
        graphics.setForegroundColor(black);
    }

    public void setHover(boolean hover) {
        if (this.hover != hover) {
            this.hover = hover;
            this.repaint();
        }
    }

    public void setLineColor(Color color) {
        if (this.lineColor != color) {
            this.lineColor = color;
            this.repaint();
        }
    }

    public void setTitle(String title) {
        if (title == null) {
            if (this.titleLabel != null) {
                this.getTextPane().remove((IFigure)this.titleLabel);
            }
        } else if (this.titleLabel == null) {
            this.titleLabel = new WrappingLabel(title);
            this.getTextPane().add((IFigure)this.titleLabel);
        } else {
            this.titleLabel.setText(title);
            IAdaptable compartment = (IAdaptable)this.part.resolveSemanticElement();
            Image icon = null;
            if (compartment != null) {
                icon = IconService.getInstance().getIcon(compartment, 18);
            }
            if (icon != null) {
                this.titleLabel.setIcon(icon);
            }
        }
    }
}

