/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.editpolicies.canonical;

import com.ibm.etools.diagram.model.internal.Debug;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelPackage;
import com.ibm.etools.diagram.model.internal.emf.INode;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.Model;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.model.DiagramModelElementTypeFactory;
import com.ibm.etools.diagram.model.internal.services.EdgeGeneratorService;
import com.ibm.etools.diagram.model.internal.services.NodeItemService;
import com.ibm.etools.diagram.ui.internal.DiagramPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalConnectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class ListCompartmentEditPolicy
extends CanonicalConnectionEditPolicy {
    private ObjectTracker tracker = null;
    private boolean collapsed = false;
    private Compartment compartmentObj = null;
    private boolean reEntrantRefresh = false;

    public void activate() {
        Compartment compartment;
        this.compartmentObj = compartment = (Compartment)this.resolveSemanticElement();
        if (!this.isCollapsed()) {
            NodeItemService.getInstance().compartmentExpanded(compartment);
        }
        this.collapsed = this.isCollapsed();
        super.activate();
        if (this.getNode() != null && this.getNode().getParent() != null && this.getNode().getParent().getModel() != null) {
            this.tracker = new ObjectTracker(this);
            ((IGraphicalEditPart)this.getHost()).getEditingDomain().addResourceSetListener((ResourceSetListener)this.tracker);
        }
    }

    protected boolean canCreateConnection(EditPart sep, EditPart tep, EObject connection) {
        if (sep != null && sep.isActive() && tep != null) {
            View src = (View)sep.getAdapter(View.class);
            View tgt = (View)tep.getAdapter(View.class);
            if (src != null && tgt != null) {
                return sep.getParent().getEditPolicy((Object)"Canonical") != null;
            }
        }
        return false;
    }

    protected List<View> cleanProviderCanonicalSemanticChildren(Collection<Edge> viewChildren, Collection<Object> semanticChildren) {
        Iterator<Edge> viewChildrenIT = viewChildren.iterator();
        ArrayList<View> orphaned = new ArrayList<View>();
        while (viewChildrenIT.hasNext()) {
            View viewChild = (View)viewChildrenIT.next();
            EObject semanticChild = viewChild.getElement();
            if (semanticChildren.contains(semanticChild)) {
                Item edgeGeneratorItem;
                Item actualItem;
                Item item;
                boolean removeFromSemList = true;
                if ((((Edge)viewChild).getSource() == null || ((Edge)viewChild).getSource().getElement() instanceof MNode) && (item = EdgeGeneratorService.getInstance().getEdgesItem(Collections.singletonList((Compartment)this.resolveSemanticElement()), (MEdge)semanticChild)) != null) {
                    orphaned.add(viewChild);
                    removeFromSemList = false;
                }
                if (((Edge)viewChild).getSource() != null && ((Edge)viewChild).getSource().getElement() instanceof Item && !(actualItem = (Item)((Edge)viewChild).getSource().getElement()).equals(edgeGeneratorItem = EdgeGeneratorService.getInstance().getEdgesItem(Collections.singletonList((Compartment)this.resolveSemanticElement()), (MEdge)semanticChild))) {
                    orphaned.add(viewChild);
                    removeFromSemList = false;
                }
                if (((Edge)viewChild).getTarget() == null || !((MEdge)semanticChild).getTarget().equals(ViewUtil.resolveSemanticElement((View)((Edge)viewChild).getTarget()))) {
                    orphaned.add(viewChild);
                    removeFromSemList = false;
                    Debug.noop();
                }
                if (!removeFromSemList) continue;
                semanticChildren.remove(semanticChild);
                continue;
            }
            orphaned.add(viewChild);
        }
        return orphaned;
    }

    public void deactivate() {
        if (!this.collapsed) {
            NodeItemService.getInstance().compartmentCollapsed(this.compartmentObj);
        }
        this.compartmentObj = null;
        if (this.tracker != null) {
            ((IGraphicalEditPart)this.getHost()).getEditingDomain().removeResourceSetListener((ResourceSetListener)this.tracker);
        }
        super.deactivate();
    }

    public void enableRefresh(boolean enable) {
        Debug.println((String)("Enable refresh set to " + enable + " for " + this.resolveSemanticElement()));
        super.enableRefresh(enable);
    }

    protected void executeCommand(final Command cmd) {
        boolean dirty = this.resolveSemanticElement().eResource().isModified();
        Map<String, Boolean> options = null;
        EditPart ep = this.getHost();
        while (ep != null && !(ep instanceof DiagramEditPart)) {
            ep = ep.getParent();
        }
        if (ep == null || ((DiagramEditPart)ep).isActivatingDiagram() || !EditPartUtil.isWriteTransactionInProgress((IGraphicalEditPart)((IGraphicalEditPart)this.getHost()), (boolean)false, (boolean)false)) {
            options = Collections.singletonMap("unprotected", Boolean.TRUE);
        } else {
            options = Collections.singletonMap("unprotected", Boolean.TRUE);
            Debug.noop();
        }
        AbstractEMFOperation operation = new AbstractEMFOperation(((IGraphicalEditPart)this.getHost()).getEditingDomain(), "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                cmd.execute();
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Status status = new Status(4, DiagramPlugin.getPluginId(), 4, "executeCommand", (Throwable)e);
            DiagramPlugin.getInstance().getLog().log((IStatus)status);
        }
        if (!dirty) {
            this.resolveSemanticElement().eResource().setModified(dirty);
        }
    }

    private String getCompartmentId() {
        String compartmentId = ((Compartment)this.resolveSemanticElement()).getType();
        return compartmentId;
    }

    protected Collection<Edge> getConnectionViews() {
        HashSet<Edge> retval = new HashSet<Edge>();
        List<View> children = this.getHostViewChildren();
        HashSet connections = new HashSet();
        for (View compartmentView : children) {
            if (!this.getCompartmentId().equals(compartmentView.getType())) continue;
            EList compartmentItems = compartmentView.getChildren();
            for (View compartmentItem : compartmentItems) {
                connections.addAll(compartmentItem.getSourceEdges());
            }
        }
        EditPart node = this.host().getParent();
        View nodeView = (View)node.getModel();
        EList list = nodeView.getSourceEdges();
        connections.addAll(list);
        for (Edge connection : connections) {
            if (!this.shouldIncludeConnection(connection, children)) continue;
            retval.add(connection);
        }
        return retval;
    }

    protected String getDefaultFactoryHint() {
        return "wde.nodeItem";
    }

    protected Command getDeleteViewCommand(View view) {
        return super.getDeleteViewCommand(view);
    }

    private EditPart getEditPartFor(EObject element) {
        List parts;
        if (element == null || element.eResource() == null) {
            return null;
        }
        EditPartViewer viewer = this.getHost().getViewer();
        if (viewer instanceof IDiagramGraphicalViewer && (parts = ((IDiagramGraphicalViewer)viewer).findEditPartsForElement(((XMLResource)element.eResource()).getID(element), INodeEditPart.class)).size() >= 1) {
            return (EditPart)parts.get(0);
        }
        return null;
    }

    private EditPart getEditPartFor(EObject element, EObject context) {
        EditPartViewer viewer;
        if (element != null && !(element instanceof View) && (viewer = this.getHost().getViewer()) instanceof IDiagramGraphicalViewer) {
            EObject container;
            EditPart containerEP;
            List parts = ((IDiagramGraphicalViewer)viewer).findEditPartsForElement(((XMLResource)element.eResource()).getID(element), INodeEditPart.class);
            if (parts.isEmpty() && (containerEP = this.getEditPartFor(container = element.eContainer(), null)) != null) {
                containerEP.refresh();
                parts = ((IDiagramGraphicalViewer)viewer).findEditPartsForElement(((XMLResource)element.eResource()).getID(element), INodeEditPart.class);
            }
            return this.findEditPartForElement(element, context, parts);
        }
        return (EditPart)this.host().getViewer().getEditPartRegistry().get(element);
    }

    protected List<View> getHostViewChildren() {
        List children = super.getViewChildren();
        List editParts = this.host().getParent().getChildren();
        for (EditPart part : editParts) {
            children.add((View)part.getModel());
        }
        return children;
    }

    private MNode getNode() {
        EObject o = this.resolveSemanticElement();
        MNode node = null;
        if (o instanceof Compartment) {
            node = ((Compartment)o).getParent();
        }
        return node;
    }

    private Command getReSourceEdgeCommand(final View source, final Edge edge) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        return new ICommandProxy((ICommand)new AbstractTransactionalCommand(editingDomain, "", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                edge.setSource(source);
                return CommandResult.newOKCommandResult();
            }
        });
    }

    protected List<EObject> getSemanticChildrenList() {
        Compartment compartment;
        ArrayList<EObject> children = new ArrayList<EObject>();
        EditPart host = this.getHost();
        View view = (View)host.getModel();
        EObject eObject = this.resolveSemanticElement();
        if (eObject instanceof Compartment && (compartment = (Compartment)eObject).getType().equals(view.getType())) {
            EList items = compartment.getItems();
            for (NodeItem item : items) {
                children.add((EObject)item);
                children.addAll((Collection<EObject>)item.getChildren());
            }
        }
        return children;
    }

    protected List<EObject> getSemanticConnectionsList() {
        ListCompartmentEditPart host = (ListCompartmentEditPart)this.getHost();
        EObject o = ((GraphicalEditPart)host.getParent()).resolveSemanticElement();
        if (!(o instanceof MNode)) {
            return Collections.EMPTY_LIST;
        }
        MNode providerNode = (MNode)o;
        ArrayList<EObject> edges = new ArrayList<EObject>((Collection<EObject>)providerNode.getOutput());
        String compartmentId = this.getCompartmentId();
        Iterator iter = edges.iterator();
        while (iter.hasNext()) {
            MEdge edge = (MEdge)iter.next();
            if (edge.getSource() == null || edge.getTarget() == null || edge.getModel() == null) {
                iter.remove();
                continue;
            }
            IElementType type = edge.getElementType();
            if (!(type instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) || compartmentId.equals(((DiagramModelElementTypeFactory.DiagramModelSpecializationType)type).getCompartment())) continue;
            iter.remove();
        }
        return edges;
    }

    protected EditPart getSourceEditPartFor(EObject connection) {
        EObject sel = this.getSourceElement(connection);
        EditPart sep = this.getEditPartFor(sel, connection);
        return sep;
    }

    protected EObject getSourceElement(EObject relationship) {
        ListCompartmentEditPart host = (ListCompartmentEditPart)this.getHost();
        Compartment object = (Compartment)host.resolveSemanticElement();
        Item item = EdgeGeneratorService.getInstance().getEdgesItem(Collections.singletonList(object), (MEdge)relationship);
        if (item == null && relationship.toString().indexOf("/action") == -1) {
            Debug.noop();
        }
        if (item == null) {
            Debug.noop();
        }
        return item == null ? object.getParent() : item;
    }

    protected EObject getTargetElement(EObject relationship) {
        return ((MEdge)relationship).getTarget();
    }

    protected void handleNotificationEvent(Notification event) {
        DrawerStyle style;
        if (NotationPackage.eINSTANCE.getDrawerStyle_Collapsed() == event.getFeature() && (style = (DrawerStyle)((View)this.host().getModel()).getStyle(NotationPackage.eINSTANCE.getDrawerStyle())) != null) {
            boolean collapsed = style.isCollapsed();
            if (this.collapsed) {
                if (!collapsed) {
                    NodeItemService.getInstance().compartmentExpanded((Compartment)this.resolveSemanticElement());
                }
            } else if (collapsed) {
                NodeItemService.getInstance().compartmentCollapsed((Compartment)this.resolveSemanticElement());
            }
            this.collapsed = collapsed;
        }
        super.handleNotificationEvent(event);
    }

    private boolean isCollapsed() {
        DrawerStyle dstyle = (DrawerStyle)((View)this.host().getModel()).getStyle(NotationPackage.eINSTANCE.getDrawerStyle());
        boolean isCollapsed = dstyle == null ? false : dstyle.isCollapsed();
        return isCollapsed;
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    protected void refreshOnActivate() {
        super.refreshOnActivate();
    }

    protected void refreshSemantic() {
        if (!this.reEntrantRefresh) {
            this.reEntrantRefresh = true;
            List createdViews = super.refreshSemanticChildren();
            List<IAdaptable> createdConnectionViews = this.refreshSemanticConnections(createdViews);
            if (createdViews.size() > 1) {
                DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(this.host().getEditingDomain(), createdViews, this.host());
                this.executeCommand((Command)new ICommandProxy((ICommand)layoutCmd));
            }
            ArrayList<IAdaptable> allViews = new ArrayList<IAdaptable>(createdConnectionViews.size() + createdViews.size());
            allViews.addAll(createdViews);
            allViews.addAll(createdConnectionViews);
            this.makeViewsMutable(allViews);
            this.reEntrantRefresh = false;
        }
    }

    protected List<IAdaptable> refreshSemanticConnections(List createdItems) {
        if (((View)this.host().getModel()).eResource() == null) {
            return Collections.EMPTY_LIST;
        }
        Collection<Edge> viewChildren = this.getConnectionViews();
        HashSet<Object> semanticChildren = new HashSet<Object>();
        semanticChildren.addAll(this.getSemanticConnectionsList());
        List<View> orphaned = this.cleanProviderCanonicalSemanticChildren(viewChildren, semanticChildren);
        ArrayList edges = new ArrayList();
        for (View element : orphaned) {
            edges.addAll(element.getSourceEdges());
        }
        if (edges.size() > 0) {
            Debug.noop();
        }
        ArrayList editPartsToRefresh = new ArrayList();
        for (Edge edge : orphaned) {
            editPartsToRefresh.add(this.host().getViewer().getEditPartRegistry().get(edge.getSource()));
        }
        Iterator<Object> iter = orphaned.iterator();
        while (iter.hasNext()) {
            boolean foundInSemantic;
            Edge edge = (Edge)iter.next();
            if (edge.getElement() == null || !(foundInSemantic = semanticChildren.remove(edge.getElement()))) continue;
            Item item = EdgeGeneratorService.getInstance().getEdgesItem(Collections.singletonList((Compartment)this.resolveSemanticElement()), (MEdge)edge.getElement());
            EditPart itemPart = this.getEditPartFor((EObject)item);
            View sourceView = null;
            sourceView = itemPart != null ? (View)itemPart.getModel() : (View)((View)this.getHost().getModel()).eContainer();
            Command cmd = this.getReSourceEdgeCommand(sourceView, edge);
            this.executeCommand(cmd);
            iter.remove();
        }
        if (orphaned.size() > 0) {
            this.deleteViews(orphaned.iterator());
        }
        for (EditPart editPart : editPartsToRefresh) {
            if (editPart == null) continue;
            editPart.refresh();
        }
        ArrayList<IAdaptable> viewDescriptors = new ArrayList<IAdaptable>();
        for (EObject eObject : semanticChildren) {
            Debug.println((String)("ListCompartment: Creating child for [" + eObject + "]"), (String)Debug.DiagramTraceOptions.DEBUG_INFO, null);
            Edge viewChild = this.createConnectionView(eObject, -1);
            if (viewChild == null) continue;
            viewDescriptors.add((IAdaptable)new EObjectAdapter((EObject)viewChild));
        }
        this.makeViewsMutable(viewDescriptors);
        HashSet<EditPart> ends = new HashSet<EditPart>();
        ListIterator li = viewDescriptors.listIterator();
        while (li.hasNext()) {
            EditPart targetEP;
            IAdaptable adaptable = (IAdaptable)li.next();
            Edge edge = (Edge)adaptable.getAdapter(Edge.class);
            EditPart sourceEP = this.getEditPartFor((EObject)edge.getSource(), (EObject)edge);
            if (sourceEP != null) {
                ends.add(sourceEP);
            }
            if ((targetEP = this.getEditPartFor((EObject)edge.getTarget(), (EObject)edge)) == null) continue;
            ends.add(targetEP);
        }
        for (EditPart end : ends) {
            end.refresh();
        }
        return viewDescriptors;
    }

    protected boolean shouldDeleteView(View view) {
        if (view.getType().indexOf("Struts") >= 0) {
            Debug.noop();
        }
        if (view.getType() != null && view.eResource() != null && (view.getType().endsWith("wde.nodeItem") || view.getType().endsWith("wde.subItem"))) {
            ArrayList edges = new ArrayList(view.getSourceEdges());
            for (Edge edge : edges) {
                if (edge.eResource() == null) continue;
                Command cmd = this.getReSourceEdgeCommand((View)view.eContainer().eContainer(), edge);
                this.executeCommand(cmd);
            }
        } else if (view instanceof Edge) {
            view.eResource();
        }
        return true;
    }

    protected boolean shouldHandleNotificationEvent(Notification event) {
        if (event.getNotifier().equals(this.getNode()) && event.getEventType() == 3 && event.getFeature().equals(DiagramModelPackage.eINSTANCE.getINode_Input())) {
            MEdge oldEdge = (MEdge)event.getNewValue();
            MNode source = oldEdge.getSource();
            if (source == null) {
                return false;
            }
            EditPart part = this.getEditPartFor((EObject)source);
            if (part != null) {
                ListCompartmentEditPolicy policy = (ListCompartmentEditPolicy)part.getEditPolicy((Object)"Canonical");
                policy.refresh();
            }
            return false;
        }
        return super.shouldHandleNotificationEvent(event);
    }

    protected boolean shouldIncludeConnection(Edge connection, Collection children) {
        if (!(connection.getElement() instanceof MEdge)) {
            return true;
        }
        MEdge modelEdge = (MEdge)connection.getElement();
        if (modelEdge == null) {
            return true;
        }
        if (!(modelEdge.eContainer() instanceof Model)) {
            return true;
        }
        IElementType type = modelEdge.getElementType();
        if (type instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) {
            String compartment = ((DiagramModelElementTypeFactory.DiagramModelSpecializationType)type).getCompartment();
            if (!this.getCompartmentId().equals(compartment)) {
                return false;
            }
        }
        if (connection.getSource() != null && this.host().resolveSemanticElement().eContainer().equals(connection.getSource().getElement())) {
            return true;
        }
        HashSet allEdges = new HashSet();
        for (View view : children) {
            EObject o = ViewUtil.resolveSemanticElement((View)view);
            if (o instanceof Compartment) {
                allEdges.addAll(((Compartment)o).getParent().getOutput());
                continue;
            }
            if (o instanceof Item) {
                if (((Item)o).getNode() == null) continue;
                allEdges.addAll(((Item)o).getNode().getOutput());
                continue;
            }
            if (!(o instanceof INode)) continue;
            allEdges.addAll(((INode)o).getOutput());
        }
        MEdge edgeModel = (MEdge)ViewUtil.resolveSemanticElement((View)connection);
        return allEdges.contains(edgeModel);
    }

    public static class ObjectTracker
    extends ResourceSetListenerImpl {
        private final ListCompartmentEditPolicy policy;
        private final Compartment compartment;

        public ObjectTracker(ListCompartmentEditPolicy policy) {
            super(NotificationFilter.createFeatureFilter((EStructuralFeature)DiagramModelPackage.eINSTANCE.getNodeItem_Children()).or(NotificationFilter.createNotifierTypeFilter((EClassifier)DiagramModelPackage.eINSTANCE.getProperty())));
            this.policy = policy;
            this.compartment = (Compartment)policy.resolveSemanticElement();
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            List notifications = event.getNotifications();
            for (Notification notification : notifications) {
                EObject notifier = (EObject)notification.getNotifier();
                while (notifier != null && !(notifier instanceof Compartment)) {
                    notifier = notifier.eContainer();
                }
                if (notifier == null || !notifier.equals(this.compartment)) continue;
                this.policy.refresh();
            }
        }
    }
}

