/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.editpolicies;

import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.emf.util.Model2Type;
import com.ibm.etools.diagram.model.internal.services.NodeItemService;
import com.ibm.etools.diagram.model.util.ModelUpdateUtils;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.SpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class ProviderCreationEditPolicy
extends CreationEditPolicy {
    protected Command getCreateElementAndViewCommand(CreateViewAndElementRequest request) {
        ICommandProxy proxy;
        ICommand cmd;
        boolean creatingItems = false;
        CreateElementRequestAdapter requestAdapter = request.getViewAndElementDescriptor().getCreateElementRequestAdapter();
        CreateElementRequest createElementRequest = (CreateElementRequest)requestAdapter.getAdapter(CreateElementRequest.class);
        if (createElementRequest.getContainer() == null) {
            SpecializationType special;
            IElementType type;
            View view = (View)this.getHost().getModel();
            Object hostElement = view instanceof Diagram ? view.getDiagram() : ViewUtil.resolveSemanticElement((View)view);
            if (hostElement == null) {
                return null;
            }
            boolean foundCompartment = false;
            if (hostElement instanceof MNode && (type = createElementRequest.getElementType()) instanceof SpecializationType && ((special = (SpecializationType)type).isSpecializationOf(Model2Type.NODEITEM) || special.isSpecializationOf(Model2Type.SUBITEM))) {
                creatingItems = true;
                MNode node = (MNode)hostElement;
                EList compartments = node.getCompartments();
                Iterator iter = compartments.iterator();
                while (iter.hasNext() && !foundCompartment) {
                    Compartment c = (Compartment)iter.next();
                    List items = NodeItemService.getInstance().getValidNodeItemsTypes(c);
                    List types = ModelUpdateUtils.convertIdsToElements((List)items);
                    for (IElementType nodeItemType : types) {
                        if (nodeItemType.equals(special)) {
                            createElementRequest.setContainer((EObject)c);
                            foundCompartment = true;
                            continue;
                        }
                        List subItems = NodeItemService.getInstance().getValidSubItemsTypes(c, nodeItemType.getId());
                        List subItemsTypes = ModelUpdateUtils.convertIdsToElements((List)subItems);
                        for (IElementType subItem : subItemsTypes) {
                            if (!special.equals(subItem)) continue;
                            NodeItem containerObject = null;
                            EList actualItems = c.getItems();
                            for (NodeItem nodeItem : actualItems) {
                                List subItemTypes = NodeItemService.getInstance().getValidSubItemsTypes(c, nodeItemType.getId());
                                if (!subItemTypes.contains(subItem.getId())) continue;
                                containerObject = nodeItem;
                                break;
                            }
                            if (containerObject == null) continue;
                            createElementRequest.setContainer(containerObject);
                            foundCompartment = true;
                        }
                    }
                }
            }
            if (!foundCompartment) {
                createElementRequest.setContainer((EObject)hostElement);
            }
        }
        Command superCmd = super.getCreateElementAndViewCommand(request);
        if (creatingItems && superCmd instanceof ICommandProxy && (cmd = (proxy = (ICommandProxy)superCmd).getICommand()) instanceof CompositeCommand) {
            Iterator itr = ((CompositeCommand)cmd).iterator();
            int count = 0;
            while (itr.hasNext()) {
                if (count == 1) {
                    itr.remove();
                }
                ++count;
            }
        }
        return superCmd;
    }
}

