/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.editpolicies;

import com.ibm.etools.diagram.model.internal.commands.ReorientEdgeCommand;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.ui.internal.adapters.OpenAdapter;
import com.ibm.etools.diagram.ui.internal.editpolicies.QuickCreateCommandFactory;
import com.ibm.etools.diagram.ui.internal.nls.Messages;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.OpenEditPolicy;
import org.eclipse.ui.PartInitException;

public class OpenFileEditPolicy
extends OpenEditPolicy {
    protected Command getOpenCommand(Request request) {
        ICommandProxy cmd = null;
        EObject o = ((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        MNode node = ReorientEdgeCommand.getTargetNode((EObject)o);
        if (node.isRealized()) {
            OpenAdapter openAdapter = (OpenAdapter)this.getHost().getAdapter(OpenAdapter.class);
            if (openAdapter != null) {
                cmd = new ICommandProxy((ICommand)new OpenEditorCommand(openAdapter));
            }
        } else {
            HashMap<String, Object> extendedData = new HashMap<String, Object>();
            extendedData.put("Create Resource", Boolean.TRUE);
            String value = node.getTitleProperty().getValue();
            cmd = new ICommandProxy(QuickCreateCommandFactory.getQuickCreateCommand((EObject)node, (IGraphicalEditPart)this.getHost(), value, extendedData));
        }
        return cmd;
    }

    private static class OpenEditorCommand
    extends AbstractCommand {
        private final OpenAdapter openAdapter;

        protected OpenEditorCommand(OpenAdapter openAdapter) {
            super(openAdapter.getOpenLabel() == null ? Messages.OpenEditor : openAdapter.getOpenLabel());
            this.openAdapter = openAdapter;
        }

        public boolean canRedo() {
            return false;
        }

        public boolean canUndo() {
            return false;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            try {
                this.openAdapter.openEditor();
            }
            catch (PartInitException e) {
                return CommandResult.newErrorCommandResult((String)e.getMessage());
            }
            return CommandResult.newOKCommandResult();
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            return CommandResult.newOKCommandResult();
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            return CommandResult.newOKCommandResult();
        }
    }
}

