/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.editparts;

import com.ibm.etools.diagram.model.internal.Debug;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.IRealizable;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.model.DiagramModelElementTypeFactory;
import com.ibm.etools.diagram.ui.internal.celleditor.TextEditPartDialogCellEditor;
import com.ibm.etools.diagram.ui.internal.editpolicies.NodeLabelDirectEditPolicy;
import com.ibm.etools.diagram.ui.internal.editpolicies.size.ProviderTextNonResizableEditPolicy;
import com.ibm.etools.diagram.ui.internal.services.PropertyDisplayService;
import com.ibm.etools.diagram.ui.internal.tools.CustomDirectEditManager;
import com.ibm.etools.diagram.ui.internal.tools.ITextAwareEditPartWithLabel;
import com.ibm.etools.diagram.ui.internal.tools.TextCellEditorLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.ui.services.icon.IconService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TextCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.label.ILabelDelegate;
import org.eclipse.gmf.runtime.diagram.ui.label.WrappingLabelDelegate;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class ProviderTextCompartmentEditPart
extends TextCompartmentEditPart
implements ITextAwareEditPartWithLabel {
    private DirectEditManager manager;
    private boolean setImage = false;

    public ProviderTextCompartmentEditPart(View view) {
        super((EObject)view);
    }

    protected boolean checkEdit() {
        View view = this.getPrimaryView();
        EObject o = view.getElement();
        return !(o instanceof IRealizable) || !((IRealizable)o).isRealized();
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new NodeLabelDirectEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new ProviderTextNonResizableEditPolicy());
    }

    protected IFigure createFigure() {
        return new WrappingLabel();
    }

    protected ILabelDelegate createLabelDelegate() {
        WrappingLabelDelegate delegate = new WrappingLabelDelegate((WrappingLabel)this.getFigure());
        delegate.setTextAlignment(1);
        delegate.setAlignment(1);
        return delegate;
    }

    public String getEditText() {
        return super.getEditText();
    }

    protected DirectEditManager getManager() {
        TextCellEditorLocator locator = new TextCellEditorLocator(this.getLabelDelegate());
        if (this.manager == null) {
            this.manager = new CustomDirectEditManager(this, (GraphicalEditPart)this, TextEditPartDialogCellEditor.class, locator);
        }
        return this.manager;
    }

    private MNode getResourceNode() {
        EObject element = this.resolveSemanticElement();
        if (element != null) {
            MNode node = null;
            if (element instanceof MNode) {
                node = (MNode)element;
            } else {
                Compartment commonElement = (Compartment)element;
                node = commonElement.getParent();
            }
            return node;
        }
        return null;
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
            CreateUnspecifiedTypeConnectionRequest req = (CreateUnspecifiedTypeConnectionRequest)request;
            if (req.getSourceEditPart() != null) {
                EditPart part = this.getParent().getTargetEditPart(request);
                return part;
            }
            Debug.noop();
        } else if (request instanceof ReconnectRequest) {
            Debug.noop();
            EditPart part = this.getParent().getTargetEditPart(request);
            return part;
        }
        return super.getTargetEditPart(request);
    }

    protected String getToolTipText() {
        MNode node = this.getResourceNode();
        if (node == null) {
            return this.getEditText();
        }
        IElementType elementType = node.getElementType();
        if (elementType instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) {
            String tooltip = null;
            Property title = node.getTitleProperty();
            if (title != null) {
                tooltip = PropertyDisplayService.getInstance().getTooltip(title);
                if (tooltip == null) {
                    tooltip = this.getLabelText();
                }
            } else {
                tooltip = this.getLabelText();
            }
            if (tooltip == null) {
                Debug.noop();
            }
            return tooltip;
        }
        return this.getEditText();
    }

    @Override
    public WrappingLabel getWrappingLabel() {
        return (WrappingLabel)this.getFigure();
    }

    protected boolean isEditable() {
        Property property;
        MNode node = this.getResourceNode();
        if (node != null && (property = node.getTitleProperty()) != null) {
            return property.isEditable();
        }
        return true;
    }

    public boolean isSelectable() {
        return this.isEditable();
    }

    protected void performDirectEdit() {
        if (!this.checkEdit()) {
            return;
        }
        super.performDirectEdit();
    }

    private void performDirectEdit(char initialCharacter) {
        if (!this.checkEdit()) {
            return;
        }
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(initialCharacter);
        } else if (this.getManager() instanceof CustomDirectEditManager) {
            ((CustomDirectEditManager)this.getManager()).show(initialCharacter);
        } else {
            this.performDirectEdit();
        }
    }

    protected void performDirectEdit(Point eventLocation) {
        if (!this.checkEdit()) {
            return;
        }
        if (this.getManager().getClass() == TextDirectEditManager.class) {
            ((TextDirectEditManager)this.getManager()).show(eventLocation.getSWTPoint());
        } else {
            this.getManager().show();
        }
    }

    protected void performDirectEditRequest(Request request) {
        final Request theRequest = request;
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                @Override
                public void run() {
                    if (ProviderTextCompartmentEditPart.this.isActive() && ProviderTextCompartmentEditPart.this.isEditable()) {
                        ProviderTextCompartmentEditPart.this.showEditPart();
                        if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                            ProviderTextCompartmentEditPart.this.performDirectEdit(initialChar.charValue());
                        } else if (theRequest instanceof DirectEditRequest && ProviderTextCompartmentEditPart.this.getEditText().equals(ProviderTextCompartmentEditPart.this.getLabelText())) {
                            DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                            ProviderTextCompartmentEditPart.this.performDirectEdit(editRequest.getLocation());
                        } else {
                            ProviderTextCompartmentEditPart.this.performDirectEdit();
                        }
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public void performRequest(Request request) {
        if (!this.isEditModeEnabled() && !"open".equals(request.getType())) {
            return;
        }
        if ("open".equals(request.getType())) {
            EditPart targetEditPart = this.getParent().getParent();
            if (targetEditPart != null) {
                boolean isRealized = false;
                if (targetEditPart instanceof IGraphicalEditPart) {
                    MNode node = (MNode)((IGraphicalEditPart)targetEditPart).resolveSemanticElement();
                    isRealized = node.isRealized();
                }
                Command command = targetEditPart.getCommand(request);
                if (isRealized) {
                    if (command != null && command.canExecute()) {
                        try {
                            command.execute();
                        }
                        finally {
                            command.dispose();
                        }
                    }
                } else if (command != null) {
                    this.getDiagramEditDomain().getDiagramCommandStack().execute(command);
                    return;
                }
            }
            return;
        }
        super.performRequest(request);
    }

    protected void refreshFont() {
        String type;
        FontStyle style = (FontStyle)this.getPrimaryView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        FontData fontData = null;
        fontData = style != null ? new FontData(style.getFontName(), style.getFontHeight(), (style.isBold() ? 1 : 0) | (style.isItalic() ? 2 : 0)) : PreferenceConverter.getFontData((IPreferenceStore)((IPreferenceStore)this.getDiagramPreferencesHint().getPreferenceStore()), (String)"Appearance.defaultFont");
        EObject object = this.resolveSemanticElement();
        if (object instanceof TypedElement && (type = ((TypedElement)object).getType()).equals("wde.title")) {
            fontData.setStyle(1);
        }
        this.setFont(fontData);
    }

    protected void refreshFontColor() {
        FontStyle style = (FontStyle)this.getPrimaryView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null) {
            Integer colorInt = new Integer(style.getFontColor());
            EObject object = this.resolveSemanticElement();
            if (object instanceof Compartment) {
                object = ((Compartment)object).getParent();
            }
            if (object instanceof IRealizable && !((IRealizable)object).isRealized()) {
                colorInt = FigureUtilities.RGBToInteger((RGB)new RGB(184, 181, 168));
            }
            this.setFontColor(DiagramColorRegistry.getInstance().getColor(colorInt));
        }
    }

    public void refreshLabel() {
        super.refreshLabel();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        if (!this.setImage) {
            EObject o = this.resolveSemanticElement();
            Image image = IconService.getInstance().getIcon((IAdaptable)new EObjectAdapter(o), 18);
            if (image != null) {
                this.getLabel().setIcon(image);
            }
            this.setImage = true;
        }
    }

    public void setSelected(int value) {
        super.setSelected(value);
    }

    private void showEditPart() {
        EditPartViewer viewer;
        EditPart parent = this.getParent();
        if (parent != null && (viewer = parent.getViewer()) != null) {
            viewer.reveal((EditPart)this);
        }
    }
}

