/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.editparts;

import com.ibm.etools.diagram.model.internal.Debug;
import com.ibm.etools.diagram.model.internal.emf.Adaptable;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.IRealizable;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.ui.internal.celleditor.TextEditPartDialogCellEditor;
import com.ibm.etools.diagram.ui.internal.editpolicies.NodeLabelDirectEditPolicy;
import com.ibm.etools.diagram.ui.internal.editpolicies.OpenFileEditPolicy;
import com.ibm.etools.diagram.ui.internal.editpolicies.ProviderListItemComponentEditPolicy;
import com.ibm.etools.diagram.ui.internal.editpolicies.ResourceGraphicalNodeEditPolicy;
import com.ibm.etools.diagram.ui.internal.editpolicies.handles.ProviderConnectorHandleEditPolicy;
import com.ibm.etools.diagram.ui.internal.editpolicies.size.ProviderTextNonResizableEditPolicy;
import com.ibm.etools.diagram.ui.internal.figures.MyImageFigureEx;
import com.ibm.etools.diagram.ui.internal.figures.NodeItemFigure;
import com.ibm.etools.diagram.ui.internal.services.PropertyDisplayService;
import com.ibm.etools.diagram.ui.internal.tools.CustomDirectEditManager;
import com.ibm.etools.diagram.ui.internal.tools.ITextAwareEditPartWithLabel;
import com.ibm.etools.diagram.ui.internal.tools.TextCellEditorLocator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.AccessibleAnchorProvider;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.gmf.runtime.common.ui.services.icon.IconService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.label.ILabelDelegate;
import org.eclipse.gmf.runtime.diagram.ui.label.WrappingLabelDelegate;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;

public class NodeItemEditPart
extends ListItemEditPart
implements INodeEditPart,
ITextAwareEditPartWithLabel {
    private DirectEditManager manager;

    public NodeItemEditPart(View shapeView) {
        super((EObject)shapeView);
    }

    public void activate() {
        super.activate();
    }

    protected void addSemanticListeners() {
        super.addSemanticListeners();
    }

    protected void addSourceConnection(ConnectionEditPart connection, int index) {
        super.addSourceConnection(connection, index);
    }

    public boolean canAttachNote() {
        return false;
    }

    protected boolean checkEdit() {
        View view = this.getPrimaryView();
        EObject o = view.getElement();
        return !(o instanceof IRealizable) || !((IRealizable)o).isRealized();
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ProviderListItemComponentEditPolicy());
        this.installEditPolicy("OpenPolicy", (EditPolicy)new OpenFileEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ResourceGraphicalNodeEditPolicy());
        boolean hasHandles = true;
        EObject object = this.resolveSemanticElement();
        if (object instanceof IPropertyHolder) {
            hasHandles = PropertyDisplayService.getInstance().hasHandles(((IPropertyHolder)object).getTitleProperty());
        }
        if (hasHandles) {
            this.installEditPolicy("ConnectionHandlesPolicy", (EditPolicy)new ProviderConnectorHandleEditPolicy(false, true));
        } else {
            this.removeEditPolicy("ConnectionHandlesPolicy");
        }
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new ProviderTextNonResizableEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new NodeLabelDirectEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new AbstractEditPolicy(){

            public void eraseTargetFeedback(Request request) {
                if ("selection".equals(request.getType())) {
                    NodeItemFigure fig = (NodeItemFigure)NodeItemEditPart.this.getFigure();
                    fig.setDrawBorder(false);
                }
            }

            public void showTargetFeedback(Request request) {
                if ("selection".equals(request.getType())) {
                    NodeItemFigure fig = (NodeItemFigure)NodeItemEditPart.this.getFigure();
                    fig.setDrawBorder(true);
                }
            }

            public boolean understandsRequest(Request req) {
                return super.understandsRequest(req);
            }
        });
    }

    protected IFigure createFigure() {
        IMapMode mode = this.getMapMode();
        NodeItemFigure figure = new NodeItemFigure(this);
        figure.setBorder((Border)new MarginBorder(mode.DPtoLP(1), mode.DPtoLP(11), 0, mode.DPtoLP(11)));
        ToolbarLayout layout = new ToolbarLayout(true);
        layout.setSpacing(mode.DPtoLP(2));
        layout.setStretchMinorAxis(true);
        layout.setMinorAlignment(1);
        figure.setLayoutManager((LayoutManager)layout);
        MyImageFigureEx imageFigure = new MyImageFigureEx();
        EObject o = this.resolveSemanticElement();
        Image image = IconService.getInstance().getIcon((IAdaptable)new EObjectAdapter(o), 10);
        if (image != null) {
            imageFigure.setImage(image);
        }
        WrappingLabel label = new WrappingLabel();
        figure.add((IFigure)imageFigure);
        figure.add((IFigure)label);
        return figure;
    }

    protected ILabelDelegate createLabelDelegate() {
        NodeItemFigure label = (NodeItemFigure)this.getFigure();
        WrappingLabelDelegate newLabelDelegate = null;
        newLabelDelegate = label != null ? new WrappingLabelDelegate((WrappingLabel)label.getChildren().get(1)) : new WrappingLabelDelegate((WrappingLabel)this.getFigure());
        newLabelDelegate.setAlignment(1);
        newLabelDelegate.setTextAlignment(1);
        newLabelDelegate.setIconAlignment(1);
        return newLabelDelegate;
    }

    public void deactivate() {
        super.deactivate();
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEP == null) {
            this.accessibleEP = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    e.result = NodeItemEditPart.this.getToolTipText();
                }
            };
        }
        return this.accessibleEP;
    }

    public Object getAdapter(Class key) {
        if (key == AccessibleAnchorProvider.class) {
            return new NodeItemAnchorProvider();
        }
        Object o = super.getAdapter(key);
        if (o != null) {
            return o;
        }
        EObject e = this.resolveSemanticElement();
        if (e != null) {
            IFile file;
            if (key == IResource.class && (file = (IFile)Platform.getAdapterManager().getAdapter((Object)e, IFile.class)) != null) {
                return file;
            }
            Object obj = Platform.getAdapterManager().getAdapter((Object)e, key);
            if (obj != null) {
                return obj;
            }
            if (e instanceof Adaptable) {
                obj = ((Adaptable)e).getAdapter(key);
                return obj;
            }
        }
        return null;
    }

    public Command getCommand(Request _request) {
        if (_request instanceof CreateUnspecifiedTypeConnectionRequest) {
            Command cmd = super.getCommand(_request);
            Debug.noop();
            return cmd;
        }
        return super.getCommand(_request);
    }

    private CommonElement getCommonElement() {
        EObject element = this.resolveSemanticElement();
        if (element != null) {
            if (!(element instanceof CommonElement)) {
                return null;
            }
            CommonElement commonElement = (CommonElement)element;
            return commonElement;
        }
        return null;
    }

    public DragTracker getDragTracker(Request request) {
        return new SelectEditPartTracker((EditPart)this);
    }

    public IFigure getFigure() {
        return super.getFigure();
    }

    protected DirectEditManager getManager() {
        TextCellEditorLocator locator = new TextCellEditorLocator(this.getLabelDelegate());
        if (this.manager == null) {
            this.manager = new CustomDirectEditManager(this, (GraphicalEditPart)this, TextEditPartDialogCellEditor.class, locator);
        }
        return this.manager;
    }

    protected IMapMode getMapMode() {
        return super.getMapMode();
    }

    protected List getModelChildren() {
        List children = super.getModelChildren();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            View view = (View)iter.next();
            if (view.eResource() != null) continue;
            iter.remove();
        }
        return children;
    }

    protected List<Object> getModelSourceConnections() {
        ArrayList<Object> children = new ArrayList<Object>(ViewUtil.getSourceConnections((View)((View)this.getModel())));
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            View view = (View)iter.next();
            if (view.eResource() != null) continue;
            iter.remove();
        }
        return children;
    }

    protected List<Object> getModelTargetConnections() {
        ArrayList<Object> children = new ArrayList<Object>(ViewUtil.getTargetConnections((View)((View)this.getModel())));
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            View view = (View)iter.next();
            if (view.eResource() != null) continue;
            iter.remove();
        }
        return children;
    }

    protected NodeFigure getNodeFigure() {
        return (NodeFigure)this.getFigure();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        final ConnectionNodeEditPart connector = (ConnectionNodeEditPart)connEditPart;
        final String[] result = new String[]{""};
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                @Override
                public void run() {
                    Anchor a = ((Edge)connector.getModel()).getSourceAnchor();
                    result[0] = a instanceof IdentityAnchor ? ((IdentityAnchor)a).getId() : "";
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return this.getNodeFigure().getConnectionAnchor(result[0]);
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (request instanceof ReconnectRequest) {
            Point pt = ((DropRequest)request).getLocation().getCopy();
            ((ReconnectRequest)request).getConnectionEditPart().getFigure().translateToAbsolute((Translatable)pt);
            return this.getNodeFigure().getSourceConnectionAnchorAt(pt);
        }
        if (request instanceof DropRequest) {
            return this.getNodeFigure().getSourceConnectionAnchorAt(((DropRequest)request).getLocation());
        }
        return this.getNodeFigure().getSourceConnectionAnchorAt(null);
    }

    public List getSourceConnections() {
        return super.getSourceConnections();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        final ConnectionNodeEditPart connector = (ConnectionNodeEditPart)connEditPart;
        final String[] result = new String[]{""};
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                @Override
                public void run() {
                    Anchor a = ((Edge)connector.getModel()).getTargetAnchor();
                    result[0] = a instanceof IdentityAnchor ? ((IdentityAnchor)a).getId() : "";
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return this.getNodeFigure().getConnectionAnchor(result[0]);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        if (request instanceof ReconnectRequest) {
            Point pt = ((DropRequest)request).getLocation().getCopy();
            ((ReconnectRequest)request).getConnectionEditPart().getFigure().translateToAbsolute((Translatable)pt);
            return this.getNodeFigure().getTargetConnectionAnchorAt(pt);
        }
        if (request instanceof DropRequest) {
            return this.getNodeFigure().getTargetConnectionAnchorAt(((DropRequest)request).getLocation());
        }
        return this.getNodeFigure().getTargetConnectionAnchorAt(null);
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
            CreateUnspecifiedTypeConnectionRequest req = (CreateUnspecifiedTypeConnectionRequest)request;
            if ("connection start".equals(req.getType())) {
                return this;
            }
            if (req.getSourceEditPart() != null) {
                EditPart part = this.getParent().getTargetEditPart(request);
                return part;
            }
            Debug.noop();
        } else if (request instanceof ReconnectRequest) {
            Debug.noop();
            EditPart part = this.getParent().getTargetEditPart(request);
            return part;
        }
        return super.getTargetEditPart(request);
    }

    protected String getToolTipText() {
        CommonElement commonElement = this.getCommonElement();
        if (commonElement != null) {
            IElementType elementType = commonElement.getElementType();
            String tooltip = null;
            Property title = commonElement.getTitleProperty();
            if (title != null) {
                tooltip = PropertyDisplayService.getInstance().getTooltip(title);
                if (tooltip == null) {
                    tooltip = this.getEditText();
                }
            } else {
                tooltip = this.getEditText();
            }
            if (tooltip == null && elementType != null) {
                return elementType.getDisplayName();
            }
            if (tooltip == null) {
                return "";
            }
            return tooltip;
        }
        return this.getEditText();
    }

    @Override
    public WrappingLabel getWrappingLabel() {
        return (WrappingLabel)this.getFigure().getChildren().get(1);
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        if (this.getModelSourceConnections().size() > 0) {
            ((NodeItemFigure)this.getFigure()).setShadeBackground(true);
            this.refreshFont();
            this.refreshFontColor();
        } else {
            ((NodeItemFigure)this.getFigure()).setShadeBackground(false);
            this.refreshFont();
            this.refreshFontColor();
        }
        this.refreshSourceConnections();
        this.refreshTargetConnections();
    }

    public void installEditPolicy(Object key, EditPolicy editPolicy) {
        super.installEditPolicy(key, editPolicy);
    }

    protected boolean isEditable() {
        Property title;
        CommonElement element = this.getCommonElement();
        if (element != null && (title = element.getTitleProperty()) != null) {
            return title.isEditable();
        }
        return false;
    }

    public boolean isSelectable() {
        return true;
    }

    public final String mapConnectionAnchorToTerminal(ConnectionAnchor c) {
        return this.getNodeFigure().getConnectionAnchorTerminal(c);
    }

    public final ConnectionAnchor mapTerminalToConnectionAnchor(String terminal) {
        return this.getNodeFigure().getConnectionAnchor(terminal);
    }

    private void performDirectEdit(char initialCharacter) {
        if (!this.checkEdit()) {
            return;
        }
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(initialCharacter);
        } else if (this.getManager() instanceof CustomDirectEditManager) {
            ((CustomDirectEditManager)this.getManager()).show(initialCharacter);
        } else {
            this.performDirectEdit();
        }
    }

    protected void performDirectEdit(Point eventLocation) {
        if (!this.checkEdit()) {
            return;
        }
        this.getManager().show();
    }

    protected void performDirectEditRequest(Request request) {
        if (!this.checkEdit()) {
            return;
        }
        final Request theRequest = request;
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                @Override
                public void run() {
                    if (NodeItemEditPart.this.isActive() && NodeItemEditPart.this.isEditable()) {
                        NodeItemEditPart.this.showEditPart();
                        if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                            NodeItemEditPart.this.performDirectEdit(initialChar.charValue());
                        } else if (theRequest instanceof DirectEditRequest && NodeItemEditPart.this.getEditText().equals(NodeItemEditPart.this.getLabelText())) {
                            DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                            NodeItemEditPart.this.performDirectEdit(editRequest.getLocation());
                        } else {
                            NodeItemEditPart.this.performDirectEdit();
                        }
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public void performRequest(Request request) {
        if (!this.isEditModeEnabled() && !"open".equals(request.getType())) {
            return;
        }
        if ("open".equals(request.getType())) {
            EditPart targetEditPart = this.getTargetEditPart(request);
            Command command = targetEditPart.getCommand(request);
            if (command != null && command.canExecute()) {
                try {
                    command.execute();
                }
                finally {
                    command.dispose();
                }
            }
            return;
        }
        super.performRequest(request);
    }

    protected void refreshFont() {
        View view = this.getPrimaryView();
        if (view == null) {
            return;
        }
        FontStyle style = (FontStyle)view.getStyle(NotationPackage.eINSTANCE.getFontStyle());
        FontData fontData = null;
        fontData = style != null ? new FontData(style.getFontName(), style.getFontHeight(), (style.isBold() ? 1 : 0) | (style.isItalic() ? 2 : 0)) : PreferenceConverter.getFontData((IPreferenceStore)((IPreferenceStore)this.getDiagramPreferencesHint().getPreferenceStore()), (String)"Appearance.defaultFont");
        EObject object = this.resolveSemanticElement();
        if (object instanceof IPropertyHolder) {
            IPropertyHolder holder = (IPropertyHolder)object;
            Property property = holder.getTitleProperty();
            String name = PropertyDisplayService.getInstance().getFontName(property);
            if (name != null) {
                fontData.setName(name);
            }
            boolean bold = PropertyDisplayService.getInstance().isFontBold(property);
            boolean italic = PropertyDisplayService.getInstance().isFontItalic(property);
            fontData.setStyle((bold ? 1 : 0) | (italic ? 2 : 0));
        }
        this.setFont(fontData);
    }

    protected void refreshFontColor() {
        if (this.getPrimaryView() == null) {
            return;
        }
        boolean setColor = false;
        EObject object = this.resolveSemanticElement();
        if (object instanceof IPropertyHolder) {
            IPropertyHolder holder = (IPropertyHolder)object;
            Property property = holder.getTitleProperty();
            int color = PropertyDisplayService.getInstance().getFontColor(property);
            if (color != -1) {
                setColor = true;
                this.setFontColor(DiagramColorRegistry.getInstance().getColor(new Integer(color)));
            }
        }
        if (!setColor) {
            super.refreshFontColor();
        }
    }

    protected void refreshSourceConnections() {
        super.refreshSourceConnections();
        this.refreshLabel();
    }

    private void showEditPart() {
        EditPartViewer viewer;
        EditPart parent = this.getParent();
        if (parent != null && (viewer = parent.getViewer()) != null) {
            viewer.reveal((EditPart)this);
        }
    }

    protected class NodeItemAnchorProvider
    extends AbstractGraphicalEditPart.DefaultAccessibleAnchorProvider {
        protected NodeItemAnchorProvider() {
            super((AbstractGraphicalEditPart)NodeItemEditPart.this);
        }

        private List<Point> getDefaultLocations() {
            ArrayList<Point> list = new ArrayList<Point>();
            Rectangle r = NodeItemEditPart.this.getFigure().getBounds();
            Point p = r.getRight().getTranslated(MapModeUtil.getMapMode((IFigure)NodeItemEditPart.this.getFigure()).DPtoLP(-5), 0);
            NodeItemEditPart.this.getFigure().translateToAbsolute((Translatable)p);
            list.add(p);
            return list;
        }

        public List<Point> getSourceAnchorLocations() {
            return this.getDefaultLocations();
        }

        public List<Point> getTargetAnchorLocations() {
            return this.getDefaultLocations();
        }
    }
}

