/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.editparts;

import com.ibm.etools.diagram.model.internal.Debug;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelPackage;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.model.DiagramModelElementTypeFactory;
import com.ibm.etools.diagram.ui.internal.editparts.OnConnectionLocator;
import com.ibm.etools.diagram.ui.internal.figures.EdgeFigure;
import com.ibm.etools.diagram.ui.internal.figures.decoration.ArrowDecoration;
import com.ibm.etools.diagram.ui.internal.figures.decoration.CircleDecoration;
import com.ibm.etools.diagram.ui.internal.figures.decoration.IHoverableAndSelectable;
import com.ibm.etools.diagram.ui.internal.nls.Messages;
import com.ibm.etools.diagram.ui.internal.services.PropertyDisplayService;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gef.handles.ConnectionEndpointHandle;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.RGB;

public class EdgeEditPart
extends ConnectionNodeEditPart
implements PropertyChangeListener {
    private final Label toolTip = new Label();

    public EdgeEditPart(View view) {
        super(view);
    }

    public void activateFigure() {
        super.activateFigure();
    }

    protected Connection createConnectionFigure() {
        IElementType type;
        if (this.getModel() == null) {
            return null;
        }
        EdgeFigure conn = new EdgeFigure(this.getMapMode());
        conn.setOutline(true);
        EObject o = this.resolveSemanticElement();
        if (o instanceof MEdge && (type = ((MEdge)o).getElementType()) instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) {
            DiagramModelElementTypeFactory.DiagramModelSpecializationType dType = (DiagramModelElementTypeFactory.DiagramModelSpecializationType)type;
            if ("uni-directional".equals(dType.getDirectedEdgeStyle())) {
                conn.setSourceDecoration(this.getCircle((IFigure)conn), new OnConnectionLocator((Connection)conn, 0));
                conn.setTargetDecoration(this.getLineArrowhead((IFigure)conn));
            } else if ("bi-directional".equals(dType.getDirectedEdgeStyle())) {
                conn.setSourceDecoration(this.getLineArrowhead((IFigure)conn), new OnConnectionLocator((Connection)conn, 0));
                conn.setTargetDecoration(this.getLineArrowhead((IFigure)conn));
            } else {
                "non-directional".equals(dType.getDirectedEdgeStyle());
            }
        }
        return conn;
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.removeEditPolicy("GraphicalNodeEditPolicy");
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy(){

            protected List<ConnectionEndpointHandle> createSelectionHandles() {
                return Collections.singletonList(new ConnectionEndpointHandle((org.eclipse.gef.ConnectionEditPart)((ConnectionEditPart)this.getHost()), 3));
            }
        });
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new SemanticEditPolicy(){

            protected IEditCommandRequest completeRequest(IEditCommandRequest request) {
                IEditCommandRequest result = request;
                if (result instanceof DestroyRequest) {
                    DestroyRequest destroyRequest = (DestroyRequest)result;
                    if (this.getHostElement() != null) {
                        if (destroyRequest instanceof DestroyElementRequest) {
                            ((DestroyElementRequest)destroyRequest).setElementToDestroy(this.getHostElement());
                        } else {
                            result = new DestroyElementRequest(request.getEditingDomain(), this.getHostElement(), destroyRequest.isConfirmationRequired());
                        }
                    } else if (this.getHost() instanceof ConnectionEditPart) {
                        EObject container = ViewUtil.resolveSemanticElement((View)((Edge)this.getHost().getModel()).getSource());
                        EObject referenceObject = ViewUtil.resolveSemanticElement((View)((Edge)this.getHost().getModel()).getTarget());
                        if (destroyRequest instanceof DestroyReferenceRequest) {
                            DestroyReferenceRequest destroyReferenceRequest = (DestroyReferenceRequest)result;
                            destroyReferenceRequest.setContainer(container);
                            destroyReferenceRequest.setReferencedObject(referenceObject);
                        } else {
                            result = new DestroyReferenceRequest(((IGraphicalEditPart)this.getHost()).getEditingDomain(), container, null, referenceObject, destroyRequest.isConfirmationRequired());
                        }
                    }
                }
                return result;
            }

            private EObject getHostElement() {
                return ViewUtil.resolveSemanticElement((View)((View)this.getHost().getModel()));
            }
        });
        this.installEditPolicy("Selection Feedback", (EditPolicy)new AbstractEditPolicy(){

            public void eraseTargetFeedback(Request request) {
                if ("selection".equals(request.getType())) {
                    EdgeFigure fig = (EdgeFigure)EdgeEditPart.this.getFigure();
                    fig.setHover(false);
                    List children = fig.getChildren();
                    for (Figure decorator : children) {
                        if (!(decorator instanceof IHoverableAndSelectable)) continue;
                        ((IHoverableAndSelectable)decorator).setHover(false);
                    }
                }
            }

            public void showTargetFeedback(Request request) {
                if ("selection".equals(request.getType())) {
                    EdgeFigure fig = (EdgeFigure)EdgeEditPart.this.getFigure();
                    fig.setHover(true);
                    List children = fig.getChildren();
                    for (Figure decorator : children) {
                        if (!(decorator instanceof IHoverableAndSelectable)) continue;
                        ((IHoverableAndSelectable)decorator).setHover(true);
                    }
                }
            }

            public boolean understandsRequest(Request req) {
                return super.understandsRequest(req);
            }
        });
        this.installEditPolicy("Focus policy", (EditPolicy)new SelectionEditPolicy(){

            protected void hideSelection() {
                EdgeFigure fig = (EdgeFigure)EdgeEditPart.this.getFigure();
                fig.setSelected(false);
                List children = fig.getChildren();
                for (Figure decorator : children) {
                    if (!(decorator instanceof IHoverableAndSelectable)) continue;
                    ((IHoverableAndSelectable)decorator).setSelected(false);
                }
            }

            protected void showSelection() {
                EdgeFigure fig = (EdgeFigure)EdgeEditPart.this.getFigure();
                fig.setSelected(true);
                List children = fig.getChildren();
                for (Figure decorator : children) {
                    if (!(decorator instanceof IHoverableAndSelectable)) continue;
                    ((IHoverableAndSelectable)decorator).setSelected(true);
                }
            }
        });
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEP == null) {
            this.accessibleEP = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    Edge edge = (Edge)EdgeEditPart.this.getModel();
                    String sourceText = Messages.EdgeEditPart_0;
                    EObject sourceElement = edge.getSource().getElement();
                    if (sourceElement instanceof IPropertyHolder && (sourceText = PropertyDisplayService.getInstance().getPrintString(((IPropertyHolder)sourceElement).getTitleProperty())) == null) {
                        sourceText = ((IPropertyHolder)sourceElement).getTitleProperty().getValue();
                    }
                    String targetText = Messages.EdgeEditPart_1;
                    EObject targetElement = edge.getTarget().getElement();
                    if (targetElement instanceof IPropertyHolder && (targetText = PropertyDisplayService.getInstance().getPrintString(((IPropertyHolder)targetElement).getTitleProperty())) == null) {
                        targetText = ((IPropertyHolder)targetElement).getTitleProperty().getValue();
                    }
                    e.result = NLS.bind((String)Messages.EdgeEditPart_2, (Object[])new String[]{EdgeEditPart.this.toolTip.getText(), sourceText, targetText});
                }
            };
        }
        return this.accessibleEP;
    }

    private RotatableDecoration getCircle(IFigure figure) {
        CircleDecoration decoration = new CircleDecoration(this.getMapMode().DPtoLP(3), this.getMapMode().DPtoLP(3));
        return decoration;
    }

    public Command getCommand(Request _request) {
        return super.getCommand(_request);
    }

    private RotatableDecoration getLineArrowhead(IFigure figure) {
        ArrowDecoration decoration = new ArrowDecoration(this.getMapMode());
        decoration.setScale(this.getMapMode().DPtoLP(9), this.getMapMode().DPtoLP(5));
        return decoration;
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        IElementType type;
        EObject o;
        Object preferenceStore = this.getDiagramPreferencesHint().getPreferenceStore();
        if (preferenceStore instanceof IPreferenceStore && (o = this.resolveSemanticElement()) instanceof MEdge && (type = ((MEdge)o).getElementType()) instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) {
            DiagramModelElementTypeFactory.DiagramModelSpecializationType dType = (DiagramModelElementTypeFactory.DiagramModelSpecializationType)type;
            if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor()) {
                String lineHint = dType.getLineColorPreferencesHint();
                if (lineHint == null) {
                    return super.getPreferredValue(feature);
                }
                return FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)((IPreferenceStore)preferenceStore), (String)lineHint));
            }
            if (feature == NotationPackage.eINSTANCE.getFontStyle_FontColor()) {
                return FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)((IPreferenceStore)preferenceStore), (String)"Appearance.fontColor"));
            }
        }
        return this.getStructuralFeatureValue(feature);
    }

    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        if (NotationPackage.eINSTANCE.getIdentityAnchor_Id().equals(notification.getFeature())) {
            this.anchorChange();
        } else if (DiagramModelPackage.eINSTANCE.getIRealizable_Realized().equals(notification.getFeature())) {
            Debug.println((String)("EdgeEditPart responded to EMF realized event. Element:" + this.resolveSemanticElement()), (String)Debug.DiagramTraceOptions.TRACE_NOTATION, null);
            this.refreshLineStyle();
            this.refreshToolTip();
        }
    }

    public void refresh() {
        super.refresh();
        this.refreshToolTip();
    }

    protected void refreshLineStyle() {
        MEdge e;
        ((PolylineConnectionEx)this.getFigure()).setLineStyle(2);
        EObject o = this.resolveSemanticElement();
        if (o instanceof MEdge && (e = (MEdge)o).isRealized()) {
            ((PolylineConnectionEx)this.getFigure()).setLineStyle(1);
        }
    }

    private void refreshToolTip() {
        MEdge e;
        EObject o = this.resolveSemanticElement();
        String printString = ParserService.getInstance().getPrintString((IAdaptable)new EObjectAdapter(o));
        if (o instanceof MEdge && !(e = (MEdge)o).isRealized()) {
            printString = String.valueOf(printString) + "\n" + Messages.UnderlyingReferenceDoesNotExist;
        }
        this.toolTip.setText(printString);
        this.getFigure().setToolTip((IFigure)this.toolTip);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLineStyle();
    }
}

