/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.commands;

import com.ibm.etools.diagram.ui.internal.adapters.EdgeItemConnectionAdapter;
import com.ibm.etools.diagram.ui.internal.commands.EdgeInfo;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.ui.services.icon.IconService;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserService;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateOrSelectElementCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class CreateOrSelectEdgeCommand
extends CreateOrSelectElementCommand {
    private Command undoCommand;
    private Map<EdgeItemConnectionAdapter, Map<String, Object>> requestOptions;
    private CreateUnspecifiedTypeConnectionRequest request;
    private EditPart host;

    public CreateOrSelectEdgeCommand(Shell parentShell, List content, int style) {
        super(parentShell, content, style);
    }

    public CreateOrSelectEdgeCommand(Shell parentShell, List<EdgeItemConnectionAdapter> content) {
        super(parentShell, content);
    }

    public CreateOrSelectEdgeCommand(Shell parentShell, PopupMenu popupMenu) {
        super(parentShell, popupMenu);
    }

    public CreateOrSelectEdgeCommand(String label, Shell parentShell, List content) {
        super(label, parentShell, content);
    }

    public CreateOrSelectEdgeCommand(String label, Shell parentShell, List content, int style) {
        super(label, parentShell, content, style);
    }

    public void dispose() {
        if (this.undoCommand != null) {
            this.undoCommand.dispose();
        }
        super.dispose();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        assert (this.requestOptions != null);
        CommandResult cmdResult = super.doExecuteWithResult(progressMonitor, info);
        if (!cmdResult.getStatus().isOK()) {
            return cmdResult;
        }
        EdgeItemConnectionAdapter edgeInfo = (EdgeItemConnectionAdapter)cmdResult.getReturnValue();
        Map<String, Object> options = this.requestOptions.get(edgeInfo);
        CreateRequest createreq = this.request.getRequestForType(edgeInfo.getEdgeType());
        createreq.getExtendedData().putAll(options);
        Command cmd = this.host.getCommand((Request)createreq);
        if (cmd != null && cmd.canExecute()) {
            cmd.execute();
            this.undoCommand = cmd;
        }
        cmdResult = null;
        if (cmd instanceof CompoundCommand) {
            CompoundCommand cCmd = (CompoundCommand)cmd;
            List cmds = cCmd.getCommands();
            for (Command gefCmd : cmds) {
                if (!(gefCmd instanceof ICommandProxy)) continue;
                ICommandProxy proxy = (ICommandProxy)gefCmd;
                cmdResult = proxy.getICommand().getCommandResult();
                break;
            }
        }
        return cmdResult == null ? CommandResult.newOKCommandResult() : cmdResult;
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.undoCommand != null) {
            this.undoCommand.redo();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.undoCommand != null && this.undoCommand.canUndo()) {
            this.undoCommand.undo();
        }
        return CommandResult.newOKCommandResult();
    }

    protected ILabelProvider getLabelProvider() {
        return new ElementTypeLabelProvider();
    }

    public void setHost(EditPart host) {
        this.host = host;
    }

    public void setRequestOptions(Map<EdgeItemConnectionAdapter, Map<String, Object>> requestOptions) {
        this.requestOptions = requestOptions;
    }

    public void setUnspecifiedTypeConnectionRequest(CreateUnspecifiedTypeConnectionRequest request) {
        this.request = request;
    }

    public static class ElementTypeLabelProvider
    extends CreateOrSelectElementCommand.LabelProvider {
        public Image getImage(Object object) {
            if (object instanceof EdgeItemConnectionAdapter) {
                EdgeItemConnectionAdapter itemAdapter = (EdgeItemConnectionAdapter)object;
                if (itemAdapter.getItemType() == null && itemAdapter.getEdgeType() != null) {
                    return IconService.getInstance().getIcon((IAdaptable)itemAdapter.getEdgeType(), 18);
                }
                return IconService.getInstance().getIcon((IAdaptable)((EdgeItemConnectionAdapter)object), 18);
            }
            if (object instanceof EdgeInfo) {
                return IconService.getInstance().getIcon((IAdaptable)((EdgeInfo)object).edgeType, 18);
            }
            if (object instanceof IAdaptable) {
                return IconService.getInstance().getIcon((IAdaptable)object, 18);
            }
            return null;
        }

        public String getText(Object object) {
            if (object instanceof EdgeInfo) {
                EdgeInfo info = (EdgeInfo)object;
                if (info.displayText != null) {
                    return info.displayText;
                }
                return info.edgeType.getDisplayName();
            }
            if (object instanceof EdgeItemConnectionAdapter) {
                EdgeItemConnectionAdapter itemAdapter = (EdgeItemConnectionAdapter)object;
                if (itemAdapter.getItemType() == null && itemAdapter.getEdgeType() != null) {
                    return itemAdapter.getEdgeType().getDisplayName();
                }
                String text = ParserService.getInstance().getPrintString((IAdaptable)itemAdapter);
                if (text == null) {
                    return object.toString();
                }
                return text;
            }
            return object.toString();
        }
    }
}

