/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.celleditor;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public abstract class TextDialogCellEditor
extends DialogCellEditor {
    Composite editor;
    Control contents;
    protected Text defaultText;
    protected Button button;
    private final Object value = null;
    private ModifyListener modifyListener;
    private boolean isSelection = false;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;
    private boolean ignoreDeactivate = false;
    private boolean shouldCreate = true;
    private static final int defaultStyle = 0;

    public TextDialogCellEditor() {
        this.setStyle(0);
    }

    protected TextDialogCellEditor(Composite parent) {
        this(parent, 0);
    }

    protected TextDialogCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected void addFieldDecorators(ControlDecoration field) {
    }

    void checkDeleteable() {
        boolean oldIsDeleteable = this.isDeleteable;
        this.isDeleteable = this.isDeleteEnabled();
        if (oldIsDeleteable != this.isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    void checkSelectable() {
        boolean oldIsSelectable = this.isSelectable;
        this.isSelectable = this.isSelectAllEnabled();
        if (oldIsSelectable != this.isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    void checkSelection() {
        boolean oldIsSelection = this.isSelection;
        boolean bl = this.isSelection = this.defaultText.getSelectionCount() > 0;
        if (oldIsSelection != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    protected Control createContents(Composite cell) {
        this.defaultText = new Text(cell, 16384);
        this.defaultText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TextDialogCellEditor.this.keyReleaseOccured(e);
                if (TextDialogCellEditor.this.getControl() == null || TextDialogCellEditor.this.getControl().isDisposed()) {
                    return;
                }
                TextDialogCellEditor.this.checkSelection();
                TextDialogCellEditor.this.checkDeleteable();
                TextDialogCellEditor.this.checkSelectable();
            }
        });
        this.defaultText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    e.doit = false;
                    TextDialogCellEditor.this.setValueValid(true);
                    TextDialogCellEditor.this.fireCancelEditor();
                } else if (e.detail == 4) {
                    e.doit = false;
                    boolean oldValidState = TextDialogCellEditor.this.isValueValid();
                    boolean newValidState = TextDialogCellEditor.this.isCorrect(TextDialogCellEditor.this.getDefaultText().getText());
                    if (oldValidState) {
                        TextDialogCellEditor.this.valueChanged(oldValidState, newValidState);
                        if (newValidState) {
                            if ((e.stateMask & 0x20000) != 0) {
                                TextDialogCellEditor.this.shouldCreate = false;
                            }
                            TextDialogCellEditor.this.fireApplyEditorValue();
                        } else {
                            TextDialogCellEditor.this.fireCancelEditor();
                        }
                    } else {
                        TextDialogCellEditor.this.fireCancelEditor();
                    }
                }
            }
        });
        this.defaultText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TextDialogCellEditor.this.checkSelection();
                TextDialogCellEditor.this.checkDeleteable();
                TextDialogCellEditor.this.checkSelectable();
            }
        });
        this.defaultText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TextDialogCellEditor.this.handleFocusLost(e);
            }
        });
        this.defaultText.setText("");
        this.defaultText.addModifyListener(this.getModifyListener());
        ControlDecoration dec = new ControlDecoration((Control)this.defaultText, 16384, cell);
        this.addFieldDecorators(dec);
        return this.defaultText;
    }

    protected Control createControl(Composite parent) {
        Font font = parent.getFont();
        Color bg = parent.getBackground();
        this.editor = new Composite(parent, this.getStyle());
        this.editor.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                if (!TextDialogCellEditor.this.ignoreDeactivate) {
                    TextDialogCellEditor.this.handleDeactivate(event);
                }
            }
        });
        this.editor.setFont(font);
        this.editor.setBackground(bg);
        this.editor.setLayout((Layout)new DialogCellLayout());
        this.contents = this.createContents(this.editor);
        this.doSetValue(this.value);
        this.button = this.createButton(this.editor);
        if (this.button != null) {
            this.button.setFont(font);
            this.button.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\u001b') {
                        TextDialogCellEditor.this.fireCancelEditor();
                    }
                }
            });
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Object newValue = TextDialogCellEditor.this.openDialogBox((Control)TextDialogCellEditor.this.editor);
                    if (newValue != null) {
                        boolean oldValidState = TextDialogCellEditor.this.isValueValid();
                        boolean newValidState = TextDialogCellEditor.this.isCorrect(newValue);
                        if (newValidState) {
                            TextDialogCellEditor.this.markDirty();
                            TextDialogCellEditor.this.doSetValue(newValue);
                        } else {
                            TextDialogCellEditor.this.setErrorMessage(MessageFormat.format(TextDialogCellEditor.this.getErrorMessage(), newValue.toString()));
                        }
                        TextDialogCellEditor.this.valueChanged(oldValidState, newValidState);
                        TextDialogCellEditor.this.fireApplyEditorValue();
                    }
                }
            });
        }
        this.setValueValid(true);
        return this.editor;
    }

    protected Object doGetValue() {
        return this.defaultText.getText();
    }

    protected void doSetFocus() {
        if (this.defaultText != null) {
            this.defaultText.selectAll();
            this.defaultText.setFocus();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.defaultText != null && value instanceof String ? 1 : 0) != 0);
        this.defaultText.removeModifyListener(this.getModifyListener());
        this.defaultText.setText((String)value);
        this.defaultText.addModifyListener(this.getModifyListener());
    }

    protected void editOccured(ModifyEvent e) {
        String value = this.defaultText.getText();
        if (value == null) {
            value = "";
        }
        String typedValue = value;
        boolean oldValidState = this.isValueValid();
        boolean newValidState = this.isCorrect(typedValue);
        if (!newValidState) {
            this.setErrorMessage(this.getErrorMessage());
        }
        this.valueChanged(oldValidState, newValidState);
    }

    protected void fireApplyEditorValue() {
        super.fireApplyEditorValue();
    }

    protected void fireCancelEditor() {
        super.fireCancelEditor();
    }

    public Text getDefaultText() {
        return this.defaultText;
    }

    private ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TextDialogCellEditor.this.editOccured(e);
                }
            };
        }
        return this.modifyListener;
    }

    protected void handleDeactivate(Event event) {
    }

    protected void handleFocusLost(FocusEvent e) {
    }

    public boolean isCopyEnabled() {
        if (this.defaultText == null || this.defaultText.isDisposed()) {
            return false;
        }
        return this.defaultText.getSelectionCount() > 0;
    }

    protected boolean isCorrect(Object value) {
        return super.isCorrect(value);
    }

    public boolean isCutEnabled() {
        if (this.defaultText == null || this.defaultText.isDisposed()) {
            return false;
        }
        return this.defaultText.getSelectionCount() > 0;
    }

    public boolean isDeleteEnabled() {
        if (this.defaultText == null || this.defaultText.isDisposed()) {
            return false;
        }
        return this.defaultText.getSelectionCount() > 0 || this.defaultText.getCaretPosition() < this.defaultText.getCharCount();
    }

    public boolean isPasteEnabled() {
        return this.defaultText != null && !this.defaultText.isDisposed();
    }

    public boolean isSaveAllEnabled() {
        return this.defaultText != null && !this.defaultText.isDisposed();
    }

    public boolean isSelectAllEnabled() {
        if (this.defaultText == null || this.defaultText.isDisposed()) {
            return false;
        }
        return this.defaultText.getCharCount() > 0;
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        super.keyReleaseOccured(keyEvent);
    }

    protected void markDirty() {
        super.markDirty();
    }

    protected abstract Object openDialogBox(Control var1);

    public void performCopy() {
        this.defaultText.copy();
    }

    public void performCut() {
        this.defaultText.cut();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performDelete() {
        if (this.defaultText.getSelectionCount() > 0) {
            this.defaultText.insert("");
        } else {
            int pos = this.defaultText.getCaretPosition();
            if (pos < this.defaultText.getCharCount()) {
                this.defaultText.setSelection(pos, pos + 1);
                this.defaultText.insert("");
            }
        }
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performPaste() {
        this.defaultText.paste();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performSelectAll() {
        this.defaultText.selectAll();
        this.checkSelection();
        this.checkDeleteable();
    }

    protected void setErrorMessage(String message) {
        super.setErrorMessage(message);
    }

    public void setIgnoreDeactivate(boolean ignoreDeactivate) {
        this.ignoreDeactivate = ignoreDeactivate;
    }

    public boolean shouldCreate() {
        return this.shouldCreate;
    }

    private class DialogCellLayout
    extends Layout {
        private DialogCellLayout() {
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = TextDialogCellEditor.this.contents.computeSize(-1, -1, force);
            if (TextDialogCellEditor.this.button != null && TextDialogCellEditor.this.button.isVisible()) {
                Point buttonSize = TextDialogCellEditor.this.button.computeSize(-1, -1, force);
                Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
                return result;
            }
            return contentsSize;
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            if (TextDialogCellEditor.this.button != null) {
                Point size = TextDialogCellEditor.this.button.computeSize(-1, -1, force);
                if (TextDialogCellEditor.this.contents != null) {
                    TextDialogCellEditor.this.contents.setBounds(10, 0, bounds.width - size.x - 10, bounds.height);
                }
                TextDialogCellEditor.this.button.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
            }
        }
    }
}

