/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.actions.support;

import com.ibm.etools.diagram.model.internal.commands.support.ResourceTree;
import com.ibm.etools.diagram.ui.internal.actions.support.ResourcesTreeContentProvider;
import com.ibm.etools.diagram.ui.internal.actions.support.ResourcesTreeLabelProvider;
import com.ibm.etools.diagram.ui.internal.nls.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ConfirmDeleteResourcesDialog
extends SelectionDialog {
    private final ResourceTree tree;
    private CheckboxTreeViewer viewer;
    private boolean reentrant = false;

    public ConfirmDeleteResourcesDialog(Shell parentShell, ResourceTree tree) {
        super(parentShell);
        this.tree = tree;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        shell.setText(Messages.ConfirmResourceChanges);
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        Image image = this.getShell().getDisplay().getSystemImage(2);
        Label imgLabel = new Label(composite, 0);
        imgLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        imgLabel.setImage(image);
        Composite col2 = new Composite(composite, 0);
        col2.setLayout((Layout)new GridLayout());
        col2.setLayoutData((Object)new GridData(4, 4, true, true));
        Label text = new Label(col2, 0);
        text.setText(Messages.SelectResourceChangeToPerform);
        this.viewer = new CheckboxTreeViewer(col2);
        GridData data = new GridData(1808);
        data.heightHint = 100;
        data.widthHint = 450;
        this.viewer.getTree().setLayoutData((Object)data);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ResourcesTreeLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ResourcesTreeContentProvider());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ConfirmDeleteResourcesDialog.this.handleCheckStateChanged(event);
            }
        });
        this.viewer.setAutoExpandLevel(-1);
        this.viewer.setInput((Object)this.tree);
        this.viewer.setAllChecked(true);
        this.setResult(Arrays.asList(this.viewer.getCheckedElements()));
        Composite singleComposite = new Composite(col2, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        singleComposite.setLayout((Layout)layout);
        singleComposite.setLayoutData((Object)new GridData(768));
        Button selectAll = new Button(singleComposite, 8);
        selectAll.setText(Messages.SelectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfirmDeleteResourcesDialog.this.viewer.setAllChecked(true);
                ConfirmDeleteResourcesDialog.this.setResult(Arrays.asList(ConfirmDeleteResourcesDialog.this.viewer.getCheckedElements()));
            }
        });
        Button selectNone = new Button(singleComposite, 8);
        selectNone.setText(Messages.SelectNone);
        selectNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfirmDeleteResourcesDialog.this.viewer.setAllChecked(false);
                ConfirmDeleteResourcesDialog.this.setResult(Arrays.asList(ConfirmDeleteResourcesDialog.this.viewer.getCheckedElements()));
            }
        });
        return composite;
    }

    private void handleCheckStateChanged(CheckStateChangedEvent event) {
        if (!this.reentrant) {
            this.reentrant = true;
            boolean checked = event.getChecked();
            this.viewer.setSubtreeChecked(event.getElement(), checked);
            if (checked) {
                ITreeContentProvider provider = (ITreeContentProvider)this.viewer.getContentProvider();
                ArrayList<Object> parentObjects = new ArrayList<Object>();
                parentObjects.add(event.getElement());
                Object parent = provider.getParent(event.getElement());
                while (parent != null) {
                    parentObjects.add(parent);
                    parent = provider.getParent(parent);
                }
                HashSet<Object> checkedElements = new HashSet<Object>(Arrays.asList(this.viewer.getCheckedElements()));
                checkedElements.addAll(parentObjects);
                this.viewer.setCheckedElements(checkedElements.toArray(new Object[checkedElements.size()]));
                this.viewer.refresh();
            }
            this.setResult(Arrays.asList(this.viewer.getCheckedElements()));
            this.reentrant = false;
        }
    }
}

