/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.actions;

import com.ibm.etools.diagram.model.internal.commands.support.IDeletionCommand;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceDescriptor;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceTree;
import com.ibm.etools.diagram.ui.internal.actions.WorkspaceModifyGEFCommandWrapper;
import com.ibm.etools.diagram.ui.internal.actions.support.ConfirmDeleteResourcesDialog;
import com.ibm.etools.diagram.ui.internal.nls.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.GroupRequestViaKeyboard;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IWorkbenchPart;

public class PromptingDialogDeleteAction
extends DeleteAction {
    public PromptingDialogDeleteAction(IWorkbenchPart part) {
        super(part);
        this.setId("dialogDeleteWDE");
        this.setText(Messages.Delete);
        this.setLazyEnablementCalculation(true);
    }

    protected boolean calculateEnabled() {
        List objects = this.getSelectedObjects();
        if (objects.isEmpty()) {
            return false;
        }
        GroupRequestViaKeyboard deleteReq = new GroupRequestViaKeyboard((Object)"delete");
        deleteReq.setShowInformationDialog(false);
        ArrayList<ResourceTree> affectedObject = new ArrayList<ResourceTree>();
        CompositeCommand command = this.getDeleteCommand(objects, deleteReq, affectedObject);
        return command == null ? false : command.canExecute();
    }

    public Command createCommand(List<Object> objects) {
        if (objects.isEmpty()) {
            return null;
        }
        GroupRequestViaKeyboard deleteReq = new GroupRequestViaKeyboard((Object)"delete");
        deleteReq.setShowInformationDialog(false);
        CompoundCommand deleteCC = new CompoundCommand("");
        ArrayList<ResourceTree> affectedObject = new ArrayList<ResourceTree>();
        ResourceTree newTree = new ResourceTree();
        CompositeCommand command = this.getDeleteCommand(objects, deleteReq, affectedObject);
        if (command == null || !command.canExecute()) {
            return null;
        }
        for (ResourceTree o : affectedObject) {
            if (!(o instanceof ResourceTree)) continue;
            ResourceTree toBeAddedTree = o;
            boolean omitFromDialog = false;
            for (ResourceTree existingTree : newTree.getChildren()) {
                if (toBeAddedTree == null || existingTree == null || toBeAddedTree.getResource() != null && !this.treeEqual(existingTree, toBeAddedTree)) continue;
                omitFromDialog = true;
                break;
            }
            if (omitFromDialog) continue;
            newTree.addChild(toBeAddedTree);
        }
        if (newTree.recursiveSize() == 0) {
            if (command.size() > 0) {
                deleteCC.add((Command)new ICommandProxy((ICommand)command));
            }
        } else {
            ConfirmDeleteResourcesDialog dialog = new ConfirmDeleteResourcesDialog(this.getWorkbenchPart().getSite().getShell(), newTree);
            if (dialog.open() == 0) {
                List<Object> selectedResources = Arrays.asList(dialog.getResult());
                Map m = deleteReq.getExtendedData();
                ArrayList<Object> convertedResources = new ArrayList<Object>();
                for (Object o : selectedResources) {
                    if (o instanceof ResourceTree) {
                        ResourceTree tree = (ResourceTree)o;
                        ResourceDescriptor desc = tree.getResource();
                        if (desc == null) continue;
                        convertedResources.add(desc.getResource());
                        continue;
                    }
                    convertedResources.add(((ResourceDescriptor)o).getResource());
                }
                m.put("resources to delete", convertedResources);
                deleteCC.add((Command)new ICommandProxy((ICommand)this.getDeleteCommand(objects, deleteReq, null)));
            }
        }
        return deleteCC;
    }

    private CompositeCommand getDeleteCommand(List<Object> objects, GroupRequestViaKeyboard deleteReq, ArrayList<ResourceTree> affectedObject) {
        deleteReq.setShowInformationDialog(false);
        boolean containsSemanticElement = false;
        CompositeCommand command = null;
        ArrayList<EObject> semanticObjects = new ArrayList<EObject>();
        for (Object o : objects) {
            EObject oo;
            EditPart part;
            if (!(o instanceof EditPart) || !((part = (EditPart)o) instanceof IGraphicalEditPart) || (oo = ViewUtil.resolveSemanticElement((View)((View)part.getModel()))) == null) continue;
            semanticObjects.add(oo);
        }
        int i = 0;
        while (i < objects.size()) {
            if (objects.get(i) instanceof EditPart) {
                EditPart editPart = (EditPart)objects.get(i);
                if (editPart instanceof IGraphicalEditPart && !containsSemanticElement && ViewUtil.resolveSemanticElement((View)((View)editPart.getModel())) != null) {
                    containsSemanticElement = true;
                    deleteReq.setShowInformationDialog(true);
                }
                Map m = deleteReq.getExtendedData();
                m.put("selected resources", semanticObjects);
                Command command2 = editPart.getCommand((Request)deleteReq);
                if (command2 != null) {
                    if (affectedObject != null) {
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add(command2);
                        while (!list.isEmpty()) {
                            ResourceTree t;
                            Object o = list.remove(0);
                            if (o instanceof Command) {
                                Command c = (Command)o;
                                if (c instanceof ICommandProxy) {
                                    ICommandProxy proxy = (ICommandProxy)c;
                                    ICommand iCmd = proxy.getICommand();
                                    if (iCmd instanceof ICompositeCommand) {
                                        for (ICommand cc : (ICompositeCommand)iCmd) {
                                            list.add(cc);
                                        }
                                    }
                                    if (iCmd instanceof IDeletionCommand) {
                                        affectedObject.add(((IDeletionCommand)iCmd).getDeletionTree());
                                    }
                                }
                                if (!(c instanceof CompoundCommand)) continue;
                                CompoundCommand cmd = (CompoundCommand)c;
                                list.addAll(cmd.getCommands());
                                continue;
                            }
                            if (o instanceof IDeletionCommand && (t = ((IDeletionCommand)o).getDeletionTree()) != null && t.recursiveSize() > 0) {
                                affectedObject.add(t);
                            }
                            if (!(o instanceof ICompositeCommand)) continue;
                            for (ICommand cc : (ICompositeCommand)o) {
                                list.add(cc);
                            }
                        }
                    }
                    if (command == null) {
                        command = new CompositeCommand(command2.getLabel());
                    }
                    command.compose((IUndoableOperation)new CommandProxy(command2));
                }
            }
            ++i;
        }
        return command;
    }

    protected void handleSelectionChanged() {
    }

    public boolean isEnabled() {
        return this.calculateEnabled();
    }

    public void run() {
        Command command = this.createCommand(this.getSelectedObjects());
        if (command != null) {
            this.execute(new WorkspaceModifyGEFCommandWrapper(command));
        }
    }

    private boolean treeEqual(ResourceTree t1, ResourceTree t2) {
        boolean result = true;
        if (t1.recursiveSize() != t2.recursiveSize()) {
            return false;
        }
        List l1 = t1.getChildrenRecursive();
        List l2 = t2.getChildrenRecursive();
        int size = l1.size();
        int i = 0;
        while (i < size) {
            ResourceDescriptor l1RD = (ResourceDescriptor)l1.get(i);
            ResourceDescriptor l2RD = (ResourceDescriptor)l2.get(i);
            if (l1RD.getResource() == null || l2RD.getResource() == null || !l1RD.getResource().equals(l2RD.getResource())) {
                return false;
            }
            ++i;
        }
        return result;
    }
}

