/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.model.internal.services.configuration;

import com.ibm.etools.diagram.model.internal.DiagramModelPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gmf.runtime.common.core.service.AbstractProviderConfiguration;

public class ObjectDescriptorProviderConfiguration
extends AbstractProviderConfiguration {
    private final List<AbstractProviderConfiguration.ObjectDescriptor> objects = new ArrayList<AbstractProviderConfiguration.ObjectDescriptor>();
    private final List<Expression> enablements = new ArrayList<Expression>();

    private ObjectDescriptorProviderConfiguration(IConfigurationElement configElement) {
        IConfigurationElement[] configChildren = configElement.getChildren("object");
        int i = 0;
        while (i < configChildren.length) {
            this.objects.add(new AbstractProviderConfiguration.ObjectDescriptor(configChildren[i]));
            ++i;
        }
        IConfigurationElement[] enablement = configElement.getChildren("enablement");
        int i2 = 0;
        while (i2 < enablement.length) {
            IConfigurationElement element = enablement[i2];
            try {
                Expression exp = ElementHandler.getDefault().create(ExpressionConverter.getDefault(), element);
                this.enablements.add(exp);
            }
            catch (CoreException e) {
                DiagramModelPlugin.getPlugin().getLog().log(e.getStatus());
            }
            ++i2;
        }
    }

    public static ObjectDescriptorProviderConfiguration parse(IConfigurationElement element) {
        assert (element != null) : "null provider configuration element";
        return new ObjectDescriptorProviderConfiguration(element);
    }

    private boolean enablementSupports(Object object) {
        if (this.enablements.isEmpty()) {
            return true;
        }
        if (object == null) {
            return false;
        }
        EvaluationContext context = new EvaluationContext(null, object);
        for (Expression expression : this.enablements) {
            EvaluationResult result = null;
            try {
                result = expression.evaluate((IEvaluationContext)context);
            }
            catch (CoreException e) {
                DiagramModelPlugin.getPlugin().getLog().log(e.getStatus());
            }
            if (!EvaluationResult.TRUE.equals(result)) continue;
            return true;
        }
        return false;
    }

    private boolean objectSupports(Object object) {
        if (this.objects.isEmpty()) {
            return true;
        }
        if (object == null) {
            return false;
        }
        for (AbstractProviderConfiguration.ObjectDescriptor objectDesc : this.objects) {
            if (!objectDesc.sameAs(object)) continue;
            return true;
        }
        return false;
    }

    public boolean supports(Object object) {
        return this.objectSupports(object) && this.enablementSupports(object);
    }
}

