/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.model.internal.services;

import com.ibm.etools.diagram.model.internal.DiagramModelPlugin;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.operations.GetProvidersOperation;
import com.ibm.etools.diagram.model.internal.providers.IRealizationProvider;
import com.ibm.etools.diagram.model.internal.services.configuration.ObjectDescriptorProviderConfiguration;
import com.ibm.etools.model2.base.DelegatingSafeRunnable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.Service;

public class RealizationService
extends Service {
    private static RealizationService service = null;

    protected RealizationService() {
    }

    protected RealizationService(boolean optimized) {
        super(optimized);
    }

    protected RealizationService(boolean optimized, boolean optimistic) {
        super(optimized, optimistic);
    }

    public static RealizationService getInstance() {
        if (service == null) {
            service = new RealizationService(true, true);
            service.configureProviders(DiagramModelPlugin.getPluginId(), "RealizationProvider");
        }
        return service;
    }

    protected Object getCachingKey(IOperation operation) {
        return ((GetProvidersOperation)operation).getElement();
    }

    public boolean isRealized(final CommonElement realizable) {
        List list = this.execute(ExecutionStrategy.FORWARD, new GetProvidersOperation(realizable));
        boolean realized = list.size() != 0;
        Iterator iter = list.iterator();
        final Object[] resultHolder = new Object[1];
        while (iter.hasNext()) {
            final IRealizationProvider configurator = (IRealizationProvider)iter.next();
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(configurator){

                public void doRun() throws Exception {
                    resultHolder[0] = Boolean.FALSE;
                    resultHolder[0] = configurator.isRealized(realizable) ? Boolean.TRUE : Boolean.FALSE;
                }
            });
            realized &= ((Boolean)resultHolder[0]).booleanValue();
        }
        return realized;
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    private static class ProviderDescriptor
    extends Service.ProviderDescriptor {
        private ObjectDescriptorProviderConfiguration providerConfiguration;

        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
            this.providerConfiguration = ObjectDescriptorProviderConfiguration.parse(element);
            assert (this.providerConfiguration != null);
        }

        private boolean isSupportedInExtention(IOperation operation) {
            if (operation instanceof GetProvidersOperation) {
                GetProvidersOperation getConfigOp = (GetProvidersOperation)operation;
                return this.providerConfiguration.supports(getConfigOp.getElement());
            }
            return false;
        }

        public boolean provides(IOperation operation) {
            return this.isSupportedInExtention(operation);
        }
    }
}

