/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.model.internal.services;

import com.ibm.etools.diagram.model.internal.DiagramModelPlugin;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.emf.SubItem;
import com.ibm.etools.diagram.model.internal.model.DiagramModelElementTypeFactory;
import com.ibm.etools.diagram.model.internal.operations.GetEdgeGeneratorsOperation;
import com.ibm.etools.diagram.model.internal.operations.GetProvidersOperation;
import com.ibm.etools.diagram.model.internal.providers.IEdgeGeneratorProvider;
import com.ibm.etools.diagram.model.internal.services.DiagramFacetUtil;
import com.ibm.etools.diagram.model.internal.services.configuration.NodeTypesProviderConfiguration;
import com.ibm.etools.diagram.model.util.ModelUpdateUtils;
import com.ibm.etools.model2.base.DelegatingSafeRunnable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;

public class EdgeGeneratorService
extends Service {
    private static EdgeGeneratorService service = null;
    private Map<Item, List> operationsCache = null;

    protected EdgeGeneratorService() {
    }

    protected EdgeGeneratorService(boolean optimized) {
        super(optimized);
    }

    protected EdgeGeneratorService(boolean optimized, boolean optimistic) {
        super(optimized, optimistic);
    }

    public static EdgeGeneratorService getInstance() {
        if (service == null) {
            service = new EdgeGeneratorService(true, true);
            service.configureProviders(DiagramModelPlugin.getPluginId(), "EdgeGeneratorProvider");
        }
        return service;
    }

    public List<Object> generateExistingReferences(final Item item, final IElementType edgeType, final IElementType itemTypeToGenerate) {
        MNode node = item.getNode();
        if (node == null) {
            return Collections.EMPTY_LIST;
        }
        final ArrayList<Object> references = new ArrayList<Object>();
        List providers = this.execute(ExecutionStrategy.FORWARD, new GetEdgeGeneratorsOperation(item, edgeType));
        Iterator iter = providers.iterator();
        while (iter.hasNext()) {
            if (!this.getGenerableEdgeTypes(item).contains(edgeType)) continue;
            final IEdgeGeneratorProvider provider = (IEdgeGeneratorProvider)iter.next();
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(provider){

                public void doRun() throws Exception {
                    Collection sources = provider.generateSources(item, edgeType, itemTypeToGenerate);
                    if (sources != null) {
                        references.addAll(sources);
                    }
                }
            });
        }
        return references;
    }

    public Item getEdgesItem(List<Compartment> compartments, MEdge edge) {
        for (Compartment compartment : compartments) {
            EList<NodeItem> items = compartment.getItems();
            for (Item item : items) {
                if (this.isSourcedToItem(edge, item)) {
                    return item;
                }
                if (!(item instanceof NodeItem)) continue;
                EList<SubItem> children = ((NodeItem)item).getChildren();
                for (SubItem subItem : children) {
                    if (!this.isSourcedToItem(edge, subItem)) continue;
                    return subItem;
                }
            }
        }
        return null;
    }

    public List<IElementType> getGenerableEdgeTypes(Item nodeItem) {
        MNode node = nodeItem.getNode();
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ids = new ArrayList<String>();
        List providers = this.getAllProviders();
        for (ProviderDescriptor descriptor : providers) {
            if (!descriptor.isApplicable(nodeItem.getNode())) continue;
            ids.addAll(descriptor.getGeneratedEdgeTypes(nodeItem.getType()));
        }
        return ModelUpdateUtils.convertIdsToElements(ids);
    }

    public List<String> getGenerableEdgeTypes(MNode sourceNode) {
        ArrayList<String> results = new ArrayList<String>();
        List providers = this.getAllProviders();
        for (ProviderDescriptor descriptor : providers) {
            if (!descriptor.isApplicable(sourceNode)) continue;
            results.addAll(descriptor.getGeneratedEdgeTypes(null));
        }
        IFile file = WorkspaceSynchronizer.getFile((Resource)sourceNode.eResource());
        IProject project = file.getProject();
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            String compartment;
            List<String> requiredFacets;
            boolean exclude;
            String id = (String)iter.next();
            IElementType type = ElementTypeRegistry.getInstance().getType(id);
            if (!(type instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType)) continue;
            boolean bl = exclude = !((DiagramModelElementTypeFactory.DiagramModelSpecializationType)type).isShowInCreateMenu();
            if (!exclude && !(requiredFacets = ((DiagramModelElementTypeFactory.DiagramModelSpecializationType)type).getRequiresAnyFacetIds()).isEmpty()) {
                boolean hasFacet = false;
                Iterator<String> iterator = requiredFacets.iterator();
                while (iterator.hasNext() && !exclude) {
                    String facetid = iterator.next();
                    if (!DiagramFacetUtil.hasFacet(project, facetid)) continue;
                    hasFacet = true;
                    break;
                }
                boolean bl2 = exclude = !hasFacet;
            }
            if (!exclude && (compartment = ((DiagramModelElementTypeFactory.DiagramModelSpecializationType)type).getCompartment()) != null) {
                boolean foundCompartment = false;
                EList<Compartment> compartments = sourceNode.getCompartments();
                for (Compartment c : compartments) {
                    if (!c.getType().equals(compartment)) continue;
                    foundCompartment = true;
                    break;
                }
                boolean bl3 = exclude = !foundCompartment;
            }
            if (!exclude) continue;
            iter.remove();
        }
        return results;
    }

    public List<MEdge> getItemsEdges(Item item) {
        if (item == null) {
            return Collections.emptyList();
        }
        ArrayList<MEdge> results = new ArrayList<MEdge>();
        if (item.getNode() == null) {
            return results;
        }
        EList edges = item.getNode().getOutput();
        for (MEdge edge : edges) {
            if (!this.isSourcedToItem(edge, item)) continue;
            results.add(edge);
        }
        return results;
    }

    private GetEdgeGeneratorsOperation getOp(Item item, IElementType type) {
        ArrayList<WeakReference<GetEdgeGeneratorsOperation>> ops;
        GetEdgeGeneratorsOperation op = null;
        if (this.operationsCache == null) {
            this.operationsCache = new WeakHashMap<Item, List>();
        }
        if ((ops = this.operationsCache.get(item)) == null) {
            ops = new ArrayList<WeakReference<GetEdgeGeneratorsOperation>>();
            this.operationsCache.put(item, ops);
        } else {
            for (WeakReference weakReference : ops) {
                GetEdgeGeneratorsOperation cachedOp = (GetEdgeGeneratorsOperation)weakReference.get();
                if (cachedOp == null || !type.equals(cachedOp.getEdgeType())) continue;
                op = cachedOp;
                break;
            }
        }
        if (op == null) {
            op = new GetEdgeGeneratorsOperation(item, type);
            WeakReference<GetEdgeGeneratorsOperation> ref = new WeakReference<GetEdgeGeneratorsOperation>(op);
            ops.add(ref);
        }
        return op;
    }

    public boolean isSourcedToItem(final MEdge edge, final Item item) {
        if (item.getNode() == null) {
            return false;
        }
        IElementType type = edge.getElementType();
        if (type == null) {
            return false;
        }
        List providers = this.execute(ExecutionStrategy.FIRST, this.getOp(item, type));
        final Object[] resultHolder = new Object[1];
        for (final IEdgeGeneratorProvider provider : providers) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(provider){

                public void doRun() throws Exception {
                    if (provider.isSourcedToItem(edge, item)) {
                        resultHolder[0] = Boolean.TRUE;
                    }
                }
            });
            if (resultHolder[0] != Boolean.TRUE) continue;
            return true;
        }
        return false;
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    private static class ProviderDescriptor
    extends Service.ProviderDescriptor {
        private final NodeTypesProviderConfiguration providerConfiguration;
        private final Map<String, List<String>> edgeTypesIds;

        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
            this.providerConfiguration = NodeTypesProviderConfiguration.parse(element);
            assert (this.providerConfiguration != null);
            this.edgeTypesIds = new HashMap<String, List<String>>();
            IConfigurationElement[] edgeTypesContainer = element.getChildren("generatesEdgeTypes");
            int i = 0;
            while (i < edgeTypesContainer.length) {
                IConfigurationElement edgeTypes = edgeTypesContainer[i];
                IConfigurationElement[] edgeTypeArray = edgeTypes.getChildren("edgeType");
                int j = 0;
                while (j < edgeTypeArray.length) {
                    IConfigurationElement edgeType = edgeTypeArray[j];
                    String nodeItemIds = edgeType.getAttribute("nodeItemIds");
                    if (nodeItemIds != null && nodeItemIds.length() > 0) {
                        String[] ids = nodeItemIds.split(",");
                        int k = 0;
                        while (k < ids.length) {
                            String id = ids[k];
                            List<String> list = this.edgeTypesIds.get(id);
                            if (list == null) {
                                list = new ArrayList<String>();
                                this.edgeTypesIds.put(id, list);
                            }
                            list.add(edgeType.getAttribute("id"));
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }

        public List<String> getGeneratedEdgeTypes(String nodeTypeId) {
            if (nodeTypeId != null) {
                List<String> edgeTypes = this.edgeTypesIds.get(nodeTypeId);
                return edgeTypes == null ? Collections.emptyList() : edgeTypes;
            }
            ArrayList<String> edgeTypes = new ArrayList<String>();
            Collection<List<String>> subLists = this.edgeTypesIds.values();
            for (List<String> subList : subLists) {
                edgeTypes.addAll(subList);
            }
            return edgeTypes;
        }

        public boolean isApplicable(Object type) {
            return this.providerConfiguration.supports(type);
        }

        public boolean provides(IOperation operation) {
            if (operation instanceof GetProvidersOperation) {
                GetProvidersOperation getConfigOp = (GetProvidersOperation)operation;
                if (getConfigOp.getElement() == null) {
                    return false;
                }
                return this.isApplicable(getConfigOp.getElement());
            }
            if (operation instanceof GetEdgeGeneratorsOperation) {
                GetEdgeGeneratorsOperation op = (GetEdgeGeneratorsOperation)operation;
                if (op.getItem() == null || op.getItem().getNode() == null) {
                    return false;
                }
                MNode node = op.getItem().getNode();
                boolean applicable = this.isApplicable(node);
                if (!applicable) {
                    return false;
                }
                List<String> edgeTypes = this.edgeTypesIds.get(op.getItem().getType());
                if (edgeTypes == null || edgeTypes.size() == 0) {
                    return false;
                }
                boolean result = edgeTypes.contains(op.getEdgeType().getId());
                return result;
            }
            return false;
        }
    }
}

