/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.model.internal.services;

import com.ibm.etools.diagram.model.internal.Debug;
import com.ibm.etools.diagram.model.internal.DiagramModelPlugin;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.operations.GetProvidersOperation;
import com.ibm.etools.diagram.model.internal.providers.IConfiguratorProvider;
import com.ibm.etools.diagram.model.internal.services.configuration.ObjectDescriptorProviderConfiguration;
import com.ibm.etools.model2.base.DelegatingSafeRunnable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.Service;

public class ConfiguratorService
extends Service {
    private static ConfiguratorService service = null;

    protected ConfiguratorService() {
    }

    protected ConfiguratorService(boolean optimized) {
        super(optimized);
    }

    protected ConfiguratorService(boolean optimized, boolean optimistic) {
        super(optimized, optimistic);
    }

    public static ConfiguratorService getInstance() {
        if (service == null) {
            service = new ConfiguratorService(true, true);
            service.configureProviders(DiagramModelPlugin.getPluginId(), "ConfiguratorProvider");
        }
        return service;
    }

    public void configureExisting(final CommonElement hint, final Object existing, final Map options) {
        if (hint == null) {
            return;
        }
        Debug.println("C#configureExisting (" + hint + ") phase=" + options.get("configure phase"), Debug.DiagramTraceOptions.TRACE_SERVICES, null);
        List list = this.execute(ExecutionStrategy.FORWARD, new GetProvidersOperation(hint));
        for (final IConfiguratorProvider configurator : list) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(configurator){

                public void doRun() throws Exception {
                    configurator.configureExisting(hint, existing, options);
                }
            });
        }
    }

    public void configureLoad(final CommonElement hint) {
        if (hint == null) {
            return;
        }
        Debug.println("C#configureLoad (" + hint + ")", Debug.DiagramTraceOptions.TRACE_SERVICES, null);
        List list = this.execute(ExecutionStrategy.FORWARD, new GetProvidersOperation(hint));
        for (final IConfiguratorProvider configurator : list) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(configurator){

                public void doRun() throws Exception {
                    configurator.configureLoad(hint);
                }
            });
        }
    }

    public void configureNew(final CommonElement hint) {
        if (hint == null) {
            return;
        }
        Debug.println("C#configureNew (" + hint + ")", Debug.DiagramTraceOptions.TRACE_SERVICES, null);
        List list = this.execute(ExecutionStrategy.FORWARD, new GetProvidersOperation(hint));
        for (final IConfiguratorProvider configurator : list) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(configurator){

                public void doRun() throws Exception {
                    configurator.configureNew(hint);
                }
            });
        }
    }

    protected Object getCachingKey(IOperation operation) {
        return ((GetProvidersOperation)operation).getElement();
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    private static class ProviderDescriptor
    extends Service.ProviderDescriptor {
        private ObjectDescriptorProviderConfiguration providerConfiguration;

        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
            this.providerConfiguration = ObjectDescriptorProviderConfiguration.parse(element);
            assert (this.providerConfiguration != null);
        }

        private boolean isSupportedInExtention(IOperation operation) {
            if (operation instanceof GetProvidersOperation) {
                GetProvidersOperation getConfigOp = (GetProvidersOperation)operation;
                return this.providerConfiguration.supports(getConfigOp.getElement());
            }
            return false;
        }

        public boolean provides(IOperation operation) {
            return this.isSupportedInExtention(operation);
        }
    }
}

