/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.model.internal.propertytesters;

import com.ibm.etools.diagram.model.internal.DiagramModelPlugin;
import com.ibm.etools.diagram.model.internal.emf.MDiagram;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.Model;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class CommonElementPropertyTester
extends PropertyTester {
    public static boolean projectHasFacet(IProject project, String facetID, String facetVersion) {
        boolean hasFacet = false;
        if (ProjectFacetsManager.isProjectFacetDefined((String)facetID)) {
            IProjectFacet requiredFacet;
            IFacetedProject facetedProject = null;
            try {
                facetedProject = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException e) {
                DiagramModelPlugin.getPlugin().getLog().log(e.getStatus());
            }
            if (facetedProject != null && (requiredFacet = ProjectFacetsManager.getProjectFacet((String)facetID)) != null) {
                if (facetVersion != null) {
                    IProjectFacetVersion requiredFacetVersion = requiredFacet.getVersion(facetVersion);
                    if (requiredFacetVersion != null) {
                        hasFacet = facetedProject.hasProjectFacet(requiredFacetVersion);
                    }
                } else {
                    hasFacet = facetedProject.hasProjectFacet(requiredFacet);
                }
            }
        }
        return hasFacet;
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if ("modelid".equals(property)) {
            return this.testModelid(receiver, args, expectedValue);
        }
        if ("projectContainsAnyFacet".equals(property)) {
            return this.testProjectFacet(receiver, args, expectedValue);
        }
        return false;
    }

    private boolean testModelid(Object receiver, Object[] args, Object expectedValue) {
        Model model = null;
        if (receiver instanceof Model) {
            model = (Model)receiver;
        }
        if (model == null && receiver instanceof MEdge) {
            model = ((MEdge)receiver).getModel();
        }
        if (model == null) {
            MDiagram d = null;
            if (receiver instanceof MDiagram) {
                d = (MDiagram)receiver;
            }
            if (d == null && receiver instanceof MNode) {
                d = ((MNode)receiver).getParent();
            }
            if (d == null && receiver instanceof NodeItem) {
                d = ((NodeItem)receiver).getParent().getParent().getParent();
            }
            if (d != null) {
                model = d.getModel();
            }
        }
        return model == null ? false : model.getId().equals(expectedValue);
    }

    private boolean testProjectFacet(Object receiver, Object[] args, Object expectedValue) {
        IFile file;
        EObject object;
        Resource res;
        if (receiver instanceof EObject && (res = (object = (EObject)receiver).eResource()) != null && (file = WorkspaceSynchronizer.getFile((Resource)res)) != null) {
            IProject project = file.getProject();
            int i = 0;
            while (i < args.length) {
                Object arg = args[i];
                if (arg instanceof String && CommonElementPropertyTester.projectHasFacet(project, (String)arg, null)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

