/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.model.internal.emf.impl;

import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelPackage;
import com.ibm.etools.diagram.model.internal.emf.INode;
import com.ibm.etools.diagram.model.internal.emf.MDiagram;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.emf.impl.CommonElementImpl;
import com.ibm.etools.diagram.model.internal.model.DiagramModelElementTypeFactory;
import com.ibm.etools.diagram.model.internal.services.ConfiguratorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class MNodeImpl
extends CommonElementImpl
implements MNode {
    protected EList<MEdge> output;
    protected EList<MEdge> input;
    protected EList<Compartment> compartments;

    protected MNodeImpl() {
    }

    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == INode.class) {
            switch (derivedFeatureID) {
                case 5: {
                    return 0;
                }
                case 6: {
                    return 1;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID) {
            case 8: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 6, MDiagram.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == INode.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 5;
                }
                case 1: {
                    return 6;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getOutput();
            }
            case 6: {
                return this.getInput();
            }
            case 7: {
                return this.getCompartments();
            }
            case 8: {
                return this.getParent();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return ((InternalEList)this.getOutput()).basicAdd((Object)otherEnd, msgs);
            }
            case 6: {
                return ((InternalEList)this.getInput()).basicAdd((Object)otherEnd, msgs);
            }
            case 7: {
                return ((InternalEList)this.getCompartments()).basicAdd((Object)otherEnd, msgs);
            }
            case 8: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.eBasicSetContainer(otherEnd, 8, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return ((InternalEList)this.getOutput()).basicRemove((Object)otherEnd, msgs);
            }
            case 6: {
                return ((InternalEList)this.getInput()).basicRemove((Object)otherEnd, msgs);
            }
            case 7: {
                return ((InternalEList)this.getCompartments()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return this.eBasicSetContainer(null, 8, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return this.output != null && !this.output.isEmpty();
            }
            case 6: {
                return this.input != null && !this.input.isEmpty();
            }
            case 7: {
                return this.compartments != null && !this.compartments.isEmpty();
            }
            case 8: {
                return this.getParent() != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.getOutput().clear();
                this.getOutput().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getInput().clear();
                this.getInput().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    protected EClass eStaticClass() {
        return DiagramModelPackage.Literals.MNODE;
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.getOutput().clear();
                return;
            }
            case 6: {
                this.getInput().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public EList<Compartment> getCompartments() {
        if (this.compartments == null) {
            Compartment compartment;
            DiagramModelElementTypeFactory.DiagramModelSpecializationType compartmentType;
            this.compartments = new EObjectContainmentWithInverseEList(Compartment.class, (InternalEObject)this, 7, 5);
            Compartment title = (Compartment)EMFCoreUtil.create((EObject)this, (EReference)DiagramModelPackage.eINSTANCE.getMNode_Compartments(), (EClass)DiagramModelPackage.eINSTANCE.getCompartment());
            title.setType("wde.title");
            IElementType type = this.getElementType();
            if (!(type instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType)) {
                return this.compartments;
            }
            DiagramModelElementTypeFactory.DiagramModelSpecializationType specializationType = (DiagramModelElementTypeFactory.DiagramModelSpecializationType)type;
            List<String> ids = specializationType.getCompartmentIds();
            for (String id : ids) {
                compartmentType = (DiagramModelElementTypeFactory.DiagramModelSpecializationType)ElementTypeRegistry.getInstance().getType(id);
                if (!"primary".equals(compartmentType.getContainerType())) continue;
                compartment = (Compartment)EMFCoreUtil.create((EObject)this, (EReference)DiagramModelPackage.eINSTANCE.getMNode_Compartments(), (EClass)DiagramModelPackage.eINSTANCE.getCompartment());
                compartment.setType(id);
            }
            for (String id : ids) {
                compartmentType = (DiagramModelElementTypeFactory.DiagramModelSpecializationType)ElementTypeRegistry.getInstance().getType(id);
                if (!"secondary".equals(compartmentType.getContainerType())) continue;
                if (!compartmentType.getRequiresAnyFacetIds().isEmpty()) {
                    IFacetedProject fp;
                    IFile file = WorkspaceSynchronizer.getFile((Resource)this.eResource());
                    if (file == null || (fp = this.getFacetedProject(file.getProject())) == null) continue;
                    boolean foundFacet = false;
                    List<String> list = compartmentType.getRequiresAnyFacetIds();
                    for (String facetId : list) {
                        if (!fp.hasProjectFacet(this.getProjectFacet(facetId))) continue;
                        foundFacet = true;
                        break;
                    }
                    if (!foundFacet) continue;
                }
                compartment = (Compartment)EMFCoreUtil.create((EObject)this, (EReference)DiagramModelPackage.eINSTANCE.getMNode_Compartments(), (EClass)DiagramModelPackage.eINSTANCE.getCompartment());
                compartment.setType(id);
            }
            for (Compartment compartment2 : this.compartments) {
                ConfiguratorService.getInstance().configureNew(compartment2);
            }
        }
        return this.compartments;
    }

    private IFacetedProject getFacetedProject(IProject project) {
        try {
            return ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public EList<MEdge> getInput() {
        if (this.input == null) {
            this.input = new EObjectWithInverseResolvingEList(MEdge.class, (InternalEObject)this, 6, 8);
        }
        return this.input;
    }

    @Override
    public EList<MEdge> getOutput() {
        if (this.output == null) {
            this.output = new EObjectWithInverseResolvingEList(MEdge.class, (InternalEObject)this, 5, 7);
        }
        return this.output;
    }

    @Override
    public MDiagram getParent() {
        if (this.eContainerFeatureID != 8) {
            return null;
        }
        return (MDiagram)this.eContainer();
    }

    private IProjectFacet getProjectFacet(String facetId) {
        try {
            return ProjectFacetsManager.getProjectFacet((String)facetId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.compartments != null) {
            EList<Compartment> compartmentList = this.getCompartments();
            for (Compartment compartment : compartmentList) {
                compartment.refreshItems();
            }
        }
        if (this.input != null) {
            ArrayList<MEdge> inputs = new ArrayList<MEdge>((Collection<MEdge>)this.getInput());
            for (MEdge edge : inputs) {
                edge.refresh();
            }
        }
        if (this.output != null) {
            ArrayList<MEdge> outputs = new ArrayList<MEdge>((Collection<MEdge>)this.getOutput());
            for (MEdge edge : outputs) {
                edge.refresh();
            }
        }
    }

    @Override
    public String toString() {
        String s = "Resource Node: ";
        Property prop2 = this.getTitleProperty();
        if (prop2 != null) {
            s = String.valueOf(s) + prop2.getName() + "=" + prop2.getValue();
        } else {
            EList<Property> list = this.getProperties();
            for (Property prop2 : list) {
                s = String.valueOf(s) + prop2.getName() + "=" + prop2.getValue();
            }
        }
        return s;
    }
}

