/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.model.internal.emf.impl;

import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelFactory;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelPackage;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.emf.impl.CommonElementImpl;
import com.ibm.etools.diagram.model.internal.nls.Messages;
import com.ibm.etools.diagram.model.internal.services.NodeItemService;
import com.ibm.etools.diagram.model.util.ModelUpdateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;

public class CompartmentImpl
extends CommonElementImpl
implements Compartment {
    protected EList<NodeItem> items;

    protected CompartmentImpl() {
    }

    private void doRefresh() {
        NodeItemService.getInstance().refreshNode(this);
        if (this.getElementType() != null) {
            if (this.getItems().size() == 0) {
                NodeItem item = DiagramModelFactory.eINSTANCE.createNodeItem();
                item.setType("wde.no.items.placeholder");
                Property title = DiagramModelFactory.eINSTANCE.createProperty();
                title.setName("wde.no.items.placeholder");
                String value = Messages.CompartmentImpl_1;
                for (Property prop : this.getProperties()) {
                    if (!prop.getName().equals("empty.compartment.label")) continue;
                    value = prop.getValue();
                }
                title.setValue(value);
                title.setEditable(false);
                item.getTransientProperties().add((Object)title);
                item.setTitleProperty(title);
                this.getItems().add((Object)item);
            } else {
                int size = this.getItems().size();
                ArrayList<NodeItem> placeholders = new ArrayList<NodeItem>();
                for (NodeItem item : this.getItems()) {
                    if (!"wde.no.items.placeholder".equals(item.getType())) continue;
                    placeholders.add(item);
                }
                if (size - placeholders.size() > 0) {
                    this.getItems().removeAll(placeholders);
                } else if (size - placeholders.size() == 0 && placeholders.size() > 1) {
                    placeholders.remove(0);
                    this.getItems().remove(placeholders);
                }
            }
        }
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID) {
            case 5: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 7, MNode.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getParent();
            }
            case 6: {
                return this.getItems();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.eBasicSetContainer(otherEnd, 5, msgs);
            }
            case 6: {
                return ((InternalEList)this.getItems()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return this.eBasicSetContainer(null, 5, msgs);
            }
            case 6: {
                return ((InternalEList)this.getItems()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return this.getParent() != null;
            }
            case 6: {
                return this.items != null && !this.items.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.getItems().clear();
                this.getItems().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    protected EClass eStaticClass() {
        return DiagramModelPackage.Literals.COMPARTMENT;
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.getItems().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public IElementType getElementType() {
        String type = this.getType();
        if (type != null) {
            int i = type.indexOf(".wde.nodeItem");
            if (i >= 0) {
                type = type.substring(0, i);
            }
            return ElementTypeRegistry.getInstance().getType(type);
        }
        return null;
    }

    @Override
    public EList<NodeItem> getItems() {
        if (this.items == null) {
            this.items = new EObjectContainmentWithInverseEList(NodeItem.class, (InternalEObject)this, 6, 6);
            this.refreshItems();
        }
        return this.items;
    }

    @Override
    public MNode getParent() {
        if (this.eContainerFeatureID != 5) {
            return null;
        }
        return (MNode)this.eContainer();
    }

    @Override
    public EList<NodeItem> getSortedItems() {
        Comparator comparator = (Comparator)this.getAdapter(Comparator.class);
        if (comparator != null) {
            BasicEList list = new BasicEList(this.getItems());
            Collections.sort(list, comparator);
            return list;
        }
        return this.getItems();
    }

    @Override
    public void refreshItems() {
        block5: {
            if (this.items != null) {
                try {
                    TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this);
                    if (domain != null) {
                        Runnable refreshRunnable = new Runnable(){

                            @Override
                            public void run() {
                                CompartmentImpl.this.doRefresh();
                            }
                        };
                        ModelUpdateUtils.updateModelNoUndo(this.eResource(), refreshRunnable, true);
                    } else {
                        this.doRefresh();
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    if (this.items != null) break block5;
                    this.items = new EObjectContainmentWithInverseEList(NodeItem.class, (InternalEObject)this, 6, 6);
                }
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Compartment (type: ");
        result.append(this.type);
        result.append(") ");
        if (this.getParent() != null) {
            result.append(this.getParent());
        }
        return result.toString();
    }
}

