/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.model.internal.emf.impl;

import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelPackage;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.IRealizable;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.emf.impl.AdaptableImpl;
import com.ibm.etools.diagram.model.internal.services.ConfiguratorService;
import com.ibm.etools.diagram.model.internal.services.RealizationService;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;

public abstract class CommonElementImpl
extends AdaptableImpl
implements CommonElement {
    protected static final boolean REALIZED_EDEFAULT = false;
    protected boolean realized = false;
    protected EList<Property> persistedProperties;
    protected EList<Property> transientProperties;
    protected Property titleProperty;
    protected static final String TYPE_EDEFAULT = null;
    protected String type = TYPE_EDEFAULT;

    protected CommonElementImpl() {
    }

    public Property basicGetTitleProperty() {
        return this.titleProperty;
    }

    @Override
    public void configure() {
        ConfiguratorService.getInstance().configureNew(this);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IRealizable.class) {
            switch (derivedFeatureID) {
                case 0: {
                    return 0;
                }
            }
            return -1;
        }
        if (baseClass == IPropertyHolder.class) {
            switch (derivedFeatureID) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
            }
            return -1;
        }
        if (baseClass == TypedElement.class) {
            switch (derivedFeatureID) {
                case 4: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IRealizable.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 0;
                }
            }
            return -1;
        }
        if (baseClass == IPropertyHolder.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 3;
                }
            }
            return -1;
        }
        if (baseClass == TypedElement.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 4;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.isRealized() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 1: {
                return this.getPersistedProperties();
            }
            case 2: {
                return this.getTransientProperties();
            }
            case 3: {
                if (resolve) {
                    return this.getTitleProperty();
                }
                return this.basicGetTitleProperty();
            }
            case 4: {
                return this.getType();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getPersistedProperties()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getTransientProperties()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.realized;
            }
            case 1: {
                return this.persistedProperties != null && !this.persistedProperties.isEmpty();
            }
            case 2: {
                return this.transientProperties != null && !this.transientProperties.isEmpty();
            }
            case 3: {
                return this.titleProperty != null;
            }
            case 4: {
                return TYPE_EDEFAULT == null ? this.type != null : !TYPE_EDEFAULT.equals(this.type);
            }
        }
        return super.eIsSet(featureID);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setRealized((Boolean)newValue);
                return;
            }
            case 1: {
                this.getPersistedProperties().clear();
                this.getPersistedProperties().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getTransientProperties().clear();
                this.getTransientProperties().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setTitleProperty((Property)newValue);
                return;
            }
            case 4: {
                this.setType((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    protected EClass eStaticClass() {
        return DiagramModelPackage.Literals.COMMON_ELEMENT;
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setRealized(false);
                return;
            }
            case 1: {
                this.getPersistedProperties().clear();
                return;
            }
            case 2: {
                this.getTransientProperties().clear();
                return;
            }
            case 3: {
                this.setTitleProperty(null);
                return;
            }
            case 4: {
                this.setType(TYPE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public IElementType getElementType() {
        String type = this.getType();
        if (type != null) {
            int i = type.indexOf(".wde.nodeItem");
            if (i >= 0) {
                type = type.substring(0, i);
            }
            return ElementTypeRegistry.getInstance().getType(type);
        }
        return null;
    }

    @Override
    public EList<Property> getPersistedProperties() {
        if (this.persistedProperties == null) {
            this.persistedProperties = new EObjectContainmentEList(Property.class, (InternalEObject)this, 1);
        }
        return this.persistedProperties;
    }

    @Override
    public EList<Property> getProperties() {
        ArrayList<Property> children = new ArrayList<Property>();
        children.addAll((Collection<Property>)this.getPersistedProperties());
        children.addAll((Collection<Property>)this.getTransientProperties());
        return new BasicEList.UnmodifiableEList(children.size(), children.toArray());
    }

    @Override
    public Property getTitleProperty() {
        if (this.titleProperty != null && this.titleProperty.eIsProxy()) {
            InternalEObject oldTitleProperty = (InternalEObject)this.titleProperty;
            this.titleProperty = (Property)this.eResolveProxy(oldTitleProperty);
            if (this.titleProperty != oldTitleProperty && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldTitleProperty, (Object)this.titleProperty));
            }
        }
        return this.titleProperty;
    }

    @Override
    public EList<Property> getTransientProperties() {
        if (this.transientProperties == null) {
            this.transientProperties = new EObjectContainmentEList(Property.class, (InternalEObject)this, 2);
        }
        return this.transientProperties;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isRealized() {
        return this.realized;
    }

    @Override
    public void refresh() {
        this.refreshRealization();
    }

    @Override
    public void refreshRealization() {
        this.setRealized(RealizationService.getInstance().isRealized(this));
    }

    @Override
    public void setRealized(boolean newRealized) {
        boolean oldRealized = this.realized;
        this.realized = newRealized;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, oldRealized, this.realized));
        }
    }

    @Override
    public void setTitleProperty(Property newTitleProperty) {
        Property oldTitleProperty = this.titleProperty;
        this.titleProperty = newTitleProperty;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldTitleProperty, (Object)this.titleProperty));
        }
    }

    @Override
    public void setType(String newType) {
        String oldType = this.type;
        this.type = newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldType, (Object)this.type));
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(this.getClass().getName());
        result.append(" (realized: ");
        result.append(this.realized);
        result.append(", type: ");
        result.append(this.type);
        result.append(')');
        return result.toString();
    }
}

