/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.model.internal.edithelpers;

import com.ibm.etools.diagram.model.internal.DiagramModelPlugin;
import com.ibm.etools.diagram.model.internal.commands.IWorkspaceLockMarker;
import com.ibm.etools.diagram.model.internal.commands.IWorkspaceLockMarker2;
import com.ibm.etools.diagram.model.internal.nls.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class WorkspaceCompositeCommand
implements ICompositeCommand {
    private final CompositeTransactionalCommand nested;
    private static int nestingLayer = 0;

    public WorkspaceCompositeCommand(CompositeTransactionalCommand nested) {
        this.nested = nested;
    }

    public void add(IUndoableOperation operation) {
        this.nested.add(operation);
    }

    public void addContext(IUndoContext context) {
        this.nested.addContext(context);
    }

    public boolean canExecute() {
        return this.nested.canExecute();
    }

    public boolean canRedo() {
        return this.nested.canRedo();
    }

    public boolean canUndo() {
        return this.nested.canUndo();
    }

    public ICommand compose(IUndoableOperation operation) {
        if (operation != null) {
            this.add(operation);
        }
        return this;
    }

    public void dispose() {
        this.nested.dispose();
    }

    private void doExecute(boolean lockWorkspace, final IAdaptable info, final ExecutionException[] iteHolder, final IStatus[] statusHolder, IProgressMonitor monitor) throws CoreException {
        if (lockWorkspace) {
            IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor pm) throws CoreException {
                    try {
                        statusHolder[0] = WorkspaceCompositeCommand.this.nested.execute(pm, info);
                    }
                    catch (ExecutionException e) {
                        iteHolder[0] = e;
                    }
                }
            };
            IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
            ResourcesPlugin.getWorkspace().run(workspaceRunnable, (ISchedulingRule)rule, 0, monitor);
        } else {
            try {
                statusHolder[0] = this.nested.execute(monitor, info);
            }
            catch (ExecutionException e) {
                iteHolder[0] = e;
            }
        }
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ExecutionException[] iteHolder = new ExecutionException[1];
        IStatus[] statusHolder = new IStatus[1];
        try {
            Iterator itr = this.nested.iterator();
            boolean lockWorkspaceAndShowMonitor = false;
            while (itr.hasNext() && !lockWorkspaceAndShowMonitor) {
                IUndoableOperation op = (IUndoableOperation)itr.next();
                if (op instanceof IWorkspaceLockMarker2) {
                    lockWorkspaceAndShowMonitor = ((IWorkspaceLockMarker2)op).shouldLockWorkspace();
                    continue;
                }
                if (!(op instanceof IWorkspaceLockMarker)) continue;
                lockWorkspaceAndShowMonitor = true;
            }
            if (lockWorkspaceAndShowMonitor && nestingLayer == 0 && PlatformUI.getWorkbench().getDisplay().getThread() == Thread.currentThread() && Job.getJobManager().currentJob() == null) {
                final RunnableProgressMonitor runnable = new RunnableProgressMonitor(lockWorkspaceAndShowMonitor, info, iteHolder, statusHolder);
                InternalTransaction transaction = ((InternalTransactionalEditingDomain)this.nested.getEditingDomain()).getActiveTransaction();
                final RunnableWithResult runnableWithResult = transaction == null ? null : this.nested.getEditingDomain().createPrivilegedRunnable((Runnable)runnable);
                IRunnableWithProgress progressRunnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            nestingLayer = nestingLayer + 1;
                            runnable.setMonitor(monitor);
                            if (runnableWithResult == null) {
                                runnable.run();
                            } else {
                                runnableWithResult.run();
                            }
                        }
                        finally {
                            nestingLayer = nestingLayer - 1;
                        }
                    }
                };
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(progressRunnable);
            } else {
                this.doExecute(lockWorkspaceAndShowMonitor, info, iteHolder, statusHolder, monitor);
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (InvocationTargetException e) {
            String exceptionMsg;
            Throwable t = e.getCause();
            if (t instanceof CoreException) {
                return ((CoreException)t).getStatus();
            }
            if (t == null) {
                t = e;
            }
            if ((exceptionMsg = t.getLocalizedMessage()) == null) {
                exceptionMsg = t.getClass().getSimpleName();
            }
            String msg = NLS.bind((String)Messages.ErrorXPleaseSeeErrorLog, (Object)exceptionMsg);
            Status status = new Status(4, DiagramModelPlugin.getPluginId(), msg, t);
            return status;
        }
        catch (RuntimeException e) {
            String exceptionMsg;
            Throwable t = e.getCause();
            if (t instanceof CoreException) {
                return ((CoreException)t).getStatus();
            }
            if (t == null) {
                t = e;
            }
            if ((exceptionMsg = t.getLocalizedMessage()) == null) {
                exceptionMsg = t.getClass().getSimpleName();
            }
            String msg = NLS.bind((String)Messages.ErrorXPleaseSeeErrorLog, (Object)exceptionMsg);
            Status status = new Status(4, DiagramModelPlugin.getPluginId(), msg, t);
            return status;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ExecutionException(NLS.bind((String)Messages.ErrorXPleaseSeeErrorLog, (Object)e.getClass().getName()), (Throwable)e);
        }
        if (iteHolder[0] != null) {
            throw iteHolder[0];
        }
        return statusHolder[0];
    }

    public List getAffectedFiles() {
        return this.nested.getAffectedFiles();
    }

    public CommandResult getCommandResult() {
        return this.nested.getCommandResult();
    }

    public IUndoContext[] getContexts() {
        return this.nested.getContexts();
    }

    public String getLabel() {
        return this.nested.getLabel();
    }

    public boolean hasContext(IUndoContext context) {
        return this.nested.hasContext(context);
    }

    public boolean isEmpty() {
        return this.nested.isEmpty();
    }

    public Iterator iterator() {
        return this.nested.iterator();
    }

    public ListIterator listIterator() {
        return this.nested.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.nested.listIterator(index);
    }

    public IStatus redo(IProgressMonitor monitor, final IAdaptable info) throws ExecutionException {
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        final ExecutionException[] iteHolder = new ExecutionException[1];
        final IStatus[] statusHolder = new IStatus[1];
        try {
            IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor pm) throws CoreException {
                    try {
                        statusHolder[0] = WorkspaceCompositeCommand.this.nested.redo(pm, info);
                    }
                    catch (ExecutionException e) {
                        iteHolder[0] = e;
                    }
                }
            };
            ResourcesPlugin.getWorkspace().run(workspaceRunnable, (ISchedulingRule)rule, 0, monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (RuntimeException e) {
            Throwable t = e.getCause();
            if (t instanceof CoreException) {
                return ((CoreException)t).getStatus();
            }
            String exceptionMsg = t.getLocalizedMessage();
            if (exceptionMsg == null) {
                exceptionMsg = t.getClass().getSimpleName();
            }
            String msg = NLS.bind((String)Messages.ErrorXPleaseSeeErrorLog, (Object)exceptionMsg);
            Status status = new Status(4, DiagramModelPlugin.getPluginId(), msg, t);
            return status;
        }
        if (iteHolder[0] != null) {
            throw iteHolder[0];
        }
        return statusHolder[0];
    }

    public ICommand reduce() {
        return this;
    }

    public void remove(IUndoableOperation operation) {
        this.nested.remove(operation);
    }

    public void removeContext(IUndoContext context) {
        this.nested.removeContext(context);
    }

    public void setLabel(String label) {
        this.nested.setLabel(label);
    }

    public int size() {
        return this.nested.size();
    }

    public IStatus undo(IProgressMonitor monitor, final IAdaptable info) throws ExecutionException {
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        final ExecutionException[] iteHolder = new ExecutionException[1];
        final IStatus[] statusHolder = new IStatus[1];
        try {
            IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor pm) throws CoreException {
                    try {
                        statusHolder[0] = WorkspaceCompositeCommand.this.nested.undo(pm, info);
                    }
                    catch (ExecutionException e) {
                        iteHolder[0] = e;
                    }
                }
            };
            ResourcesPlugin.getWorkspace().run(workspaceRunnable, (ISchedulingRule)rule, 0, monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (RuntimeException e) {
            Throwable t = e.getCause();
            if (t instanceof CoreException) {
                return ((CoreException)t).getStatus();
            }
            String exceptionMsg = t.getLocalizedMessage();
            if (exceptionMsg == null) {
                exceptionMsg = t.getClass().getSimpleName();
            }
            String msg = NLS.bind((String)Messages.ErrorXPleaseSeeErrorLog, (Object)exceptionMsg);
            Status status = new Status(4, DiagramModelPlugin.getPluginId(), msg, t);
            return status;
        }
        if (iteHolder[0] != null) {
            throw iteHolder[0];
        }
        return statusHolder[0];
    }

    public class RunnableProgressMonitor
    implements Runnable {
        private IProgressMonitor monitor;
        private final IAdaptable info;
        private final ExecutionException[] iteHolder;
        private final IStatus[] statusHolder;
        private final boolean lockWorkspaceAndShowMonitor;

        public RunnableProgressMonitor(boolean lockWorkspaceAndShowMonitor, IAdaptable info, ExecutionException[] iteHolder, IStatus[] statusHolder) {
            this.lockWorkspaceAndShowMonitor = lockWorkspaceAndShowMonitor;
            this.info = info;
            this.iteHolder = iteHolder;
            this.statusHolder = statusHolder;
        }

        @Override
        public void run() {
            try {
                WorkspaceCompositeCommand.this.doExecute(this.lockWorkspaceAndShowMonitor, this.info, this.iteHolder, this.statusHolder, this.monitor);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }

        public void setMonitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }
    }
}

