/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.model.internal.edithelpers;

import com.ibm.etools.diagram.model.internal.Debug;
import com.ibm.etools.diagram.model.internal.commands.ReorientEdgeCommand;
import com.ibm.etools.diagram.model.internal.edithelpers.AbstractProviderEditHelper;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.providers.SourceReference;
import com.ibm.etools.diagram.model.internal.services.ConfiguratorService;
import com.ibm.etools.diagram.model.internal.services.EdgeResolverService;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;

public class EdgeEditHelper
extends AbstractProviderEditHelper {
    protected ICommand getConfigureCommand(final ConfigureRequest req) {
        return new ConfigureElementCommand(req){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                MEdge edge = (MEdge)req.getElementToConfigure();
                Boolean bool = (Boolean)req.getParameter("existing edge");
                if (bool != null && bool.booleanValue()) {
                    SourceReference ref = (SourceReference)req.getParameter("source reference");
                    MNode target = (MNode)req.getParameter("CreateRelationshipRequest.target");
                    EdgeResolverService.getInstance().instantiateEdge(edge, ref, target);
                    ConfiguratorService.getInstance().configureLoad(edge);
                } else {
                    edge.configure();
                }
                edge.getSource().refreshRealization();
                edge.getTarget().refreshRealization();
                edge.refreshRealization();
                return CommandResult.newOKCommandResult((Object)edge);
            }
        };
    }

    protected ICommand getEditContextCommand(final GetEditContextRequest req) {
        return new EditElementCommand(req.getLabel(), null, (IEditCommandRequest)req){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                CreateElementRequest createElementRequest;
                EObject container = null;
                IEditCommandRequest editRequest = req.getEditCommandRequest();
                if (editRequest instanceof CreateElementRequest && (createElementRequest = (CreateElementRequest)editRequest) instanceof CreateRelationshipRequest) {
                    CreateRelationshipRequest createRelationshipRequest = (CreateRelationshipRequest)createElementRequest;
                    EObject o = createRelationshipRequest.getSource();
                    while (o.eContainer() != null) {
                        o = o.eContainer();
                    }
                    container = o;
                    Debug.noop();
                }
                return CommandResult.newOKCommandResult(container);
            }
        };
    }

    @Override
    protected ICommand getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        return new ReorientEdgeCommand(req.getRelationship(), req);
    }
}

