/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.model.internal.edithelpers;

import com.ibm.etools.diagram.model.internal.Debug;
import com.ibm.etools.diagram.model.internal.edithelpers.IEditHelperAdviceDependency;
import com.ibm.etools.diagram.model.internal.edithelpers.WorkspaceCompositeCommand;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.model.internal.nls.Messages;
import com.ibm.etools.diagram.model.internal.requests.CreateNonModelElementRequest;
import com.ibm.etools.diagram.model.internal.requests.DestroyNonModelElementRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.commands.DuplicateEObjectsCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelper;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;

public abstract class AbstractProviderEditHelper
extends AbstractEditHelper {
    protected ICompositeCommand createCommand(IEditCommandRequest req) {
        CompositeTransactionalCommand result = new CompositeTransactionalCommand(req.getEditingDomain(), req.getLabel()){

            public CommandResult getCommandResult() {
                IStatus status;
                CommandResult result = super.getCommandResult();
                if (result != null && (status = result.getStatus()).getSeverity() == 0) {
                    Object returnObject = null;
                    Object returnValue = result.getReturnValue();
                    if (returnValue instanceof Collection) {
                        Collection collection = (Collection)returnValue;
                        if (!collection.isEmpty()) {
                            returnObject = collection.iterator().next();
                        }
                    } else {
                        returnObject = returnValue;
                    }
                    result = new CommandResult(status, returnObject);
                }
                return result;
            }

            public String getLabel() {
                List children;
                String superLabel = super.getLabel();
                if ((superLabel == null || superLabel.length() == 0) && (children = this.getChildren()) != null) {
                    for (IUndoableOperation op : children) {
                        if (op.getLabel() == null || op.getLabel().length() <= 0) continue;
                        return op.getLabel();
                    }
                }
                return super.getLabel();
            }
        };
        result.setTransactionNestingEnabled(true);
        return new WorkspaceCompositeCommand(result);
    }

    private IEditHelperAdvice[] createOrder(IEditHelperAdvice[] advice) {
        LinkedList<IEditHelperAdvice> ordering = new LinkedList<IEditHelperAdvice>();
        int i = 0;
        while (i < advice.length) {
            IEditHelperAdvice a = advice[i];
            if (a instanceof IEditHelperAdviceDependency) {
                Class dependencyClass = ((IEditHelperAdviceDependency)a).getEditHelperAdviceDependencyClass();
                ListIterator<IEditHelperAdvice> itr = ordering.listIterator();
                boolean added = false;
                while (itr.hasNext()) {
                    IEditHelperAdvice listAdvice = (IEditHelperAdvice)itr.next();
                    if (listAdvice.getClass() != dependencyClass) continue;
                    itr.add(a);
                    added = true;
                    break;
                }
                if (!added) {
                    ordering.addLast(a);
                }
            } else {
                ordering.addFirst(a);
            }
            ++i;
        }
        return ordering.toArray(new IEditHelperAdvice[ordering.size()]);
    }

    private IEditHelperAdvice[] getAdviceForType(IElementType type) {
        if (type != null) {
            IEditHelperAdvice[] advice = ElementTypeRegistry.getInstance().getEditHelperAdvice(type);
            advice = this.createOrder(advice);
            return advice;
        }
        return null;
    }

    private IEditHelperAdvice[] getAdviceForType(String type) {
        if (type != null) {
            IElementType elementtype = ElementTypeRegistry.getInstance().getType(type);
            return this.getAdviceForType(elementtype);
        }
        return null;
    }

    protected ICommand getDuplicateCommand(DuplicateElementsRequest req) {
        DuplicateCommand cmd = new DuplicateCommand(req.getEditingDomain(), Messages.DuplicateObject, req.getElementsToBeDuplicated(), req.getAllDuplicatedElementsMap());
        return cmd;
    }

    public ICommand getEditCommand(IEditCommandRequest req) {
        ICommand cmd = super.getEditCommand(req);
        if (cmd != null) {
            return cmd;
        }
        Debug.noop();
        return null;
    }

    protected IEditHelperAdvice[] getEditHelperAdvice(IEditCommandRequest req) {
        EObject container;
        EObject objectToDestroy;
        if (req instanceof GetEditContextRequest) {
            return null;
        }
        if (req instanceof CreateElementRequest) {
            return this.getAdviceForType(((CreateElementRequest)req).getElementType());
        }
        if (req instanceof DestroyElementRequest && (objectToDestroy = ((DestroyElementRequest)req).getElementToDestroy()) instanceof CommonElement) {
            MEdge e;
            MNode nodeSource;
            List list = (List)req.getParameter("selected resources");
            if (list != null && objectToDestroy instanceof MEdge && list.contains(nodeSource = (e = (MEdge)objectToDestroy).getSource())) {
                return new IEditHelperAdvice[0];
            }
            IElementType type = ((CommonElement)objectToDestroy).getElementType();
            ArrayList<IEditHelperAdvice> reverse = new ArrayList<IEditHelperAdvice>(Arrays.asList(this.getAdviceForType(type)));
            Collections.reverse(reverse);
            return reverse.toArray(new IEditHelperAdvice[reverse.size()]);
        }
        Object context = req.getEditHelperContext();
        if (context instanceof CommonElement) {
            return this.getAdviceForType(((CommonElement)context).getType());
        }
        if (context instanceof Property && (container = ((Property)context).eContainer()) instanceof CommonElement) {
            return this.getAdviceForType(((CommonElement)container).getType());
        }
        return this.createOrder(super.getEditHelperAdvice(req));
    }

    protected ICommand getInsteadCommand(IEditCommandRequest req) {
        ICommand cmd = super.getInsteadCommand(req);
        if (cmd != null) {
            return cmd;
        }
        if (req instanceof CreateNonModelElementRequest) {
            return IdentityCommand.INSTANCE;
        }
        if (req instanceof DestroyNonModelElementRequest) {
            return IdentityCommand.INSTANCE;
        }
        return null;
    }

    protected ICommand getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        return null;
    }

    private static class DuplicateCommand
    extends DuplicateEObjectsCommand {
        public DuplicateCommand(TransactionalEditingDomain editingDomain, String label, List eObjectsToBeDuplicated) {
            super(editingDomain, label, eObjectsToBeDuplicated);
        }

        public DuplicateCommand(TransactionalEditingDomain editingDomain, String label, List eObjectsToBeDuplicated, Map allDuplicatedObjectsMap) {
            super(editingDomain, label, eObjectsToBeDuplicated, allDuplicatedObjectsMap);
        }
    }
}

