/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.model.internal.commands;

import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.MDiagram;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.emf.SubItem;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.nls.Messages;
import com.ibm.etools.diagram.model.internal.services.EdgeResolverService;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;

public class ReorientEdgeCommand
extends EditElementCommand {
    public ReorientEdgeCommand(EObject elementToEdit, ReorientRelationshipRequest request) {
        super(Messages.RetargetEdge, elementToEdit, (IEditCommandRequest)request);
    }

    public static MNode getTargetNode(EObject target) {
        if (target instanceof MNode) {
            return (MNode)target;
        }
        if (target instanceof Compartment) {
            return ((Compartment)target).getParent();
        }
        if (target instanceof NodeItem) {
            return ((NodeItem)target).getNode();
        }
        if (target instanceof SubItem) {
            return ((SubItem)target).getParent().getNode();
        }
        return null;
    }

    public boolean canExecute() {
        ReorientRelationshipRequest request = (ReorientRelationshipRequest)this.getRequest();
        if (request.getDirection() == 1) {
            return false;
        }
        if (request.getNewRelationshipEnd() == null) {
            return false;
        }
        if (request.getNewRelationshipEnd() instanceof MDiagram) {
            return false;
        }
        MNode node = this.getTargetNode();
        if (node == null) {
            return false;
        }
        if (!node.isRealized()) {
            return false;
        }
        if (((MEdge)this.getElementToEdit()).getSource().equals(node)) {
            return false;
        }
        IElementType type = node.getElementType();
        IElementType relType = ((TypedElement)this.getElementToEdit()).getElementType();
        List<IElementType> list = EdgeResolverService.getInstance().getResolvableEdgeTypes(type);
        return list.contains(relType);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.getEdge().setTarget(this.getTargetNode());
        this.getEdge().refreshRealization();
        return CommandResult.newOKCommandResult();
    }

    protected MEdge getEdge() {
        return (MEdge)this.getElementToEdit();
    }

    protected MNode getTargetNode() {
        ReorientRelationshipRequest request = (ReorientRelationshipRequest)this.getRequest();
        return ReorientEdgeCommand.getTargetNode(request.getNewRelationshipEnd());
    }
}

