/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.model.internal.commands;

import com.ibm.etools.diagram.model.internal.Debug;
import com.ibm.etools.diagram.model.internal.commands.ProviderCreateRelationshipCommand;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelPackage;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.Model;
import com.ibm.etools.diagram.model.internal.services.EdgeGeneratorService;
import com.ibm.etools.diagram.model.internal.services.EdgeResolverService;
import com.ibm.etools.diagram.model.util.ModelUpdateUtils;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;

public class CreateEdgeCommand
extends ProviderCreateRelationshipCommand {
    private final Model container;

    public CreateEdgeCommand(CreateRelationshipRequest request) {
        super(request);
        EObject o = request.getSource();
        while (o.eContainer() != null) {
            o = o.eContainer();
        }
        this.container = (Model)o;
        Debug.noop();
    }

    @Override
    public boolean canExecute() {
        return true;
    }

    protected EObject doDefaultElementCreation() {
        MEdge edge = (MEdge)EMFCoreUtil.create((EObject)this.container, (EReference)DiagramModelPackage.eINSTANCE.getModel_Edges(), (EClass)this.getElementType().getEClass());
        MNode source = null;
        source = this.getSource() instanceof Item ? ((Item)this.getSource()).getNode() : (MNode)this.getSource();
        MNode target = (MNode)this.getTarget();
        edge.setSource(source);
        edge.setTarget(target);
        String type = this.getEdgeType();
        if (type != null) {
            edge.setType(type);
        }
        this.container.getEdges().add((Object)edge);
        return edge;
    }

    protected String getEdgeType() {
        IEditCommandRequest r = this.getRequest();
        if (r instanceof CreateRelationshipRequest) {
            CreateRelationshipRequest req = (CreateRelationshipRequest)r;
            return req.getElementType().getId();
        }
        return null;
    }

    public List<IElementType> getRelTypesOnSource(IAdaptable source) {
        CommonElement sourceNode = (MNode)source.getAdapter(MNode.class);
        if (sourceNode != null) {
            List<String> ids = EdgeGeneratorService.getInstance().getGenerableEdgeTypes((MNode)sourceNode);
            return ModelUpdateUtils.convertIdsToElements(ids);
        }
        sourceNode = (Item)source.getAdapter(Item.class);
        if (sourceNode != null) {
            return EdgeGeneratorService.getInstance().getGenerableEdgeTypes((Item)sourceNode);
        }
        return Collections.emptyList();
    }

    public List<IElementType> getRelTypesOnSourceAndTarget(IAdaptable source, IAdaptable target) {
        List<IElementType> ids = Collections.emptyList();
        if (source == null || target == null) {
            return ids;
        }
        MNode targetNode = (MNode)target.getAdapter(MNode.class);
        if (targetNode == null) {
            return ids;
        }
        List<IElementType> sourceTypes = this.getRelTypesOnSource(source);
        if (sourceTypes.size() == 0) {
            return ids;
        }
        IElementType targetType = targetNode.getElementType();
        ids = EdgeResolverService.getInstance().getResolvableEdgeTypes(sourceTypes, targetType);
        return ids;
    }
}

