/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ctc.cobol2xsd.util;

import com.ibm.adapter.framework.BaseException;
import com.ibm.etools.cobol.COBOL88Element;
import com.ibm.etools.cobol.COBOLComposedType;
import com.ibm.etools.cobol.COBOLElement;
import com.ibm.etools.cobol.COBOLSimpleType;
import com.ibm.etools.cobol.COBOLVariableLengthArray;
import com.ibm.etools.ctc.cobol2xsd.Cobol2XSDPlugin;
import com.ibm.etools.ctc.cobol2xsd.typesimport.CobolTypeHelper;
import com.ibm.etools.ctc.cobol2xsd.util.HashVectorTable;
import com.ibm.etools.ctc.cobol2xsd.util.JavaIdentifier;
import com.ibm.etools.tdlang.TDLangModelElement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;

public final class PropertyName {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 1998, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();

    private PropertyName() {
    }

    private static void createFieldList(COBOLElement item, HashVectorTable fieldList, Vector qualifiedName, Vector aInValidFieldList, boolean generateFlat) {
        COBOLComposedType composedType = (COBOLComposedType)item.getSharedType();
        EList list = composedType.getElement();
        for (COBOLElement field : list) {
            String path;
            Stack hashValue;
            String fieldName = field.getName();
            if (!JavaIdentifier.isValid(fieldName)) {
                aInValidFieldList.addElement(fieldName);
            }
            EList cobol88s = field.getContains();
            if (field.getArray() != null && (!generateFlat || field.getArray().getMaxUpper() != 1 || field.getArray() instanceof COBOLVariableLengthArray)) {
                hashValue = new Stack();
                int i = 0;
                while (i < qualifiedName.size()) {
                    hashValue.push(qualifiedName.elementAt(i));
                    ++i;
                }
                hashValue.push(fieldName);
                path = String.valueOf(PropertyName.getPathName(item)) + "/" + fieldName;
                hashValue.push(path);
                fieldList.put(fieldName, hashValue);
            } else if (field.getSharedType() instanceof COBOLComposedType) {
                qualifiedName.addElement(fieldName);
                PropertyName.createFieldList(field, fieldList, qualifiedName, aInValidFieldList, generateFlat);
                qualifiedName.removeElement(fieldName);
            } else if (field.getSharedType() instanceof COBOLSimpleType) {
                hashValue = new Stack();
                int i = 0;
                while (i < qualifiedName.size()) {
                    hashValue.push(qualifiedName.elementAt(i));
                    ++i;
                }
                hashValue.push(fieldName);
                path = String.valueOf(PropertyName.getPathName(item)) + "/" + fieldName;
                hashValue.push(path);
                fieldList.put(fieldName, hashValue);
            }
            if (cobol88s == null || cobol88s.size() <= 0 || !(cobol88s.get(0) instanceof COBOL88Element)) continue;
            qualifiedName.addElement(fieldName);
            PropertyName.create88FieldList(field, fieldList, qualifiedName, aInValidFieldList);
            qualifiedName.removeElement(fieldName);
        }
    }

    private static void create88FieldList(COBOLElement level88Field, HashVectorTable fieldList, Vector qualifiedName, Vector aInValidFieldList) {
        if (level88Field.getContains().isEmpty()) {
            return;
        }
        for (COBOL88Element element : level88Field.getContains()) {
            String element88Name = element.getName();
            if (!JavaIdentifier.isValidIdentifierSegment(element88Name = element88Name.replace('-', '_'))) {
                aInValidFieldList.addElement(element88Name);
            }
            Stack hashValue = new Stack();
            int i = 0;
            while (i < qualifiedName.size()) {
                hashValue.push(qualifiedName.elementAt(i));
                ++i;
            }
            hashValue.push(element88Name);
            String path = String.valueOf(PropertyName.getPathName(level88Field)) + "/" + element88Name;
            hashValue.push(path);
            fieldList.put(element88Name, hashValue);
        }
    }

    public static Hashtable getPropertyNameList(COBOLElement type, String topTypeName, int VAJStyle, boolean generateFlat) throws BaseException {
        Vector<String> vec = new Vector<String>();
        Vector inValidFieldList = new Vector();
        vec.addElement(topTypeName);
        HashVectorTable fieldList = new HashVectorTable();
        PropertyName.createFieldList(type, fieldList, vec, inValidFieldList, generateFlat);
        if (inValidFieldList.size() > 0) {
            String str = new String();
            int i = 0;
            while (i < inValidFieldList.size()) {
                str = String.valueOf(str) + inValidFieldList.elementAt(i) + "\n\t";
                ++i;
            }
            Status status = new Status(4, Cobol2XSDPlugin.getPluginID(), 4, str, null);
            throw new BaseException((IStatus)status);
        }
        Hashtable list = new Hashtable();
        PropertyName.qualifyGetSetName(fieldList, list, VAJStyle);
        return list;
    }

    private static void qualifyGetSetName(HashVectorTable hashList, Hashtable getSetNameList, int VAJStyle) {
        Enumeration cursor = hashList.keys();
        while (cursor.hasMoreElements()) {
            String key = cursor.nextElement().toString();
            Vector vec = (Vector)hashList.get(key);
            if (vec.size() > 1) {
                HashVectorTable tmpHashList = new HashVectorTable();
                Enumeration cursor1 = vec.elements();
                while (cursor1.hasMoreElements()) {
                    Stack hashValue = (Stack)cursor1.nextElement();
                    String drtName = hashValue.pop().toString();
                    String fieldName = hashValue.pop().toString();
                    String newKey = hashValue.size() > 1 ? String.valueOf(hashValue.pop().toString()) + "_" + key.substring(0, 1).toUpperCase() + key.substring(1) : String.valueOf(key.substring(0, 1).toUpperCase()) + key.substring(1);
                    hashValue.push(fieldName);
                    hashValue.push(drtName);
                    tmpHashList.put(newKey, hashValue);
                }
                PropertyName.qualifyGetSetName(tmpHashList, getSetNameList, VAJStyle);
                continue;
            }
            String keyName = ((Stack)vec.firstElement()).pop().toString();
            getSetNameList.put(keyName, key);
        }
    }

    private static String getPathName(COBOLElement element) {
        String refID = CobolTypeHelper.getID((TDLangModelElement)element);
        return refID.substring(refID.indexOf(":") + 1);
    }
}

