/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ctc.cobol2xsd.typesimport;

import com.ibm.adapter.framework.BaseException;
import com.ibm.etools.cobol.COBOL88Element;
import com.ibm.etools.cobol.COBOL88ElementValue;
import com.ibm.etools.cobol.COBOLAlphaNumericEditedType;
import com.ibm.etools.cobol.COBOLAlphaNumericType;
import com.ibm.etools.cobol.COBOLAlphabeticType;
import com.ibm.etools.cobol.COBOLClassifier;
import com.ibm.etools.cobol.COBOLComposedType;
import com.ibm.etools.cobol.COBOLDBCSType;
import com.ibm.etools.cobol.COBOLElement;
import com.ibm.etools.cobol.COBOLElementInitialValue;
import com.ibm.etools.cobol.COBOLExternalFloatType;
import com.ibm.etools.cobol.COBOLFactory;
import com.ibm.etools.cobol.COBOLInitialValueKind;
import com.ibm.etools.cobol.COBOLNumericEditedType;
import com.ibm.etools.cobol.COBOLNumericType;
import com.ibm.etools.cobol.COBOLRedefiningElement;
import com.ibm.etools.cobol.COBOLSimpleType;
import com.ibm.etools.cobol.COBOLUnicodeType;
import com.ibm.etools.cobol.COBOLVariableLengthArray;
import com.ibm.etools.ctc.cobol2xsd.Cobol2XSDPlugin;
import com.ibm.etools.ctc.cobol2xsd.MessageResource;
import com.ibm.etools.ctc.cobol2xsd.typesimport.CobolTypeHelper;
import com.ibm.etools.ctc.cobol2xsd.typesimport.GeneralUtil;
import com.ibm.etools.ctc.cobol2xsd.typesimport.XsdHelper;
import com.ibm.etools.ctc.cobol2xsd.util.PropertyName;
import com.ibm.etools.ctc.cobol2xsd.util.SchemaUtils;
import com.ibm.etools.tdlang.TDLangModelElement;
import com.ibm.etools.typedescriptor.AccessorValue;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import com.ibm.etools.typedescriptor.TypeDescriptorFactory;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDFactoryImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class CobolElementVisitor {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2004 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    protected IFile cobolFile;
    protected XSDComplexTypeDefinition topComplexType;
    protected boolean isThisTopComplexType = true;
    protected List topTypes;
    protected XSDFactory xsdFactory = XSDFactoryImpl.eINSTANCE;
    protected XSDSchema xsdSchema;
    protected CobolTypeHelper cobolHelper = CobolTypeHelper.getInstance();
    protected XsdHelper xsdHelper = XsdHelper.getInstance();
    protected GeneralUtil util = new GeneralUtil();
    protected Map xsdTypesTdBasePair;
    protected boolean overwriteTypes;
    protected String topTypeName;
    protected String origTopTypeName;
    protected Map pathXsdPair = new HashMap();
    protected String topTypePrefix;
    protected boolean generateFlat;
    private int offsetAdjustment = 0;
    protected int fieldVAJStyle = 0;
    protected Vector classNames;
    protected Vector fieldNames;
    protected boolean preserveCase;
    protected String appInfoSourceURI = "http://www.wsadie.com/appinfo";
    protected String annotationNSPrefix = "";
    protected String annotationNS = "";
    protected boolean generateTotalFractionDigitsFacet = false;
    protected boolean isInsideRedefine = false;
    public static final int VISIT_ITEM = 1;
    public static final int VISIT_CHILDREN = 2;

    public CobolElementVisitor() {
        this.topTypes = new ArrayList();
        this.classNames = new Vector();
        this.fieldNames = new Vector();
    }

    private XSDSchemaContent getParentXsdType(String path) {
        String parentPath;
        if (path.indexOf(":") >= 0) {
            path = this.getPathFromRefID(path);
        }
        if ((parentPath = this.cobolHelper.getParentPath(path)) == null) {
            return null;
        }
        return this.getThisXsdType(parentPath);
    }

    private XSDSchemaContent getThisXsdType(String path) {
        XSDElementDeclaration eleDec;
        XSDTypeDefinition type;
        Object val;
        if (path.indexOf(":") >= 0) {
            path = this.getPathFromRefID(path);
        }
        if ((val = this.pathXsdPair.get(path)) instanceof XSDElementDeclaration && (type = (eleDec = (XSDElementDeclaration)val).getTypeDefinition()) != null && type instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition ct = (XSDComplexTypeDefinition)type;
            if (((XSDParticle)ct.getContent()).getContent() instanceof XSDModelGroup) {
                List ctContents = this.xsdHelper.getModelGroupContents(ct);
                XSDModelGroupDefinition groupRef = (XSDModelGroupDefinition)((XSDParticle)ctContents.get(0)).getContent();
                return groupRef.getResolvedModelGroupDefinition();
            }
            return (XSDSchemaContent)((XSDParticle)ct.getContent()).getContent();
        }
        return (XSDSchemaContent)val;
    }

    protected String getPathFromRefID(String refID) {
        return this.cobolHelper.getPathFromRefID(refID);
    }

    private String getPathFromURI(URI uri) {
        return this.cobolHelper.getPathFromURI(uri);
    }

    public List getTopTypes() {
        return this.topTypes;
    }

    protected String getUniqueName(String path) {
        if (path.indexOf(":") >= 0) {
            path = this.getPathFromRefID(path);
        }
        if (this.fieldVAJStyle != 0) {
            Hashtable ht = (Hashtable)this.fieldNames.lastElement();
            String fieldName = (String)ht.get(path);
            return fieldName;
        }
        String thisName = this.cobolHelper.getElementNameFromPath(path, this.preserveCase);
        if (!this.generateFlat && !this.preserveCase) {
            thisName = this.util.toLowerUpperCaseToken(thisName, this.preserveCase);
        }
        while (true) {
            boolean hasDuplication;
            if (!(hasDuplication = false)) {
                thisName = this.util.getJavaNameFromXMLName(thisName);
            }
            Iterator it = this.pathXsdPair.values().iterator();
            while (it.hasNext() && this.generateFlat) {
                Element ele88;
                Object val = it.next();
                String xsdName = null;
                if (val instanceof XSDElementDeclaration) {
                    XSDElementDeclaration xsdEle = (XSDElementDeclaration)val;
                    xsdName = xsdEle.getName();
                } else if (val instanceof XSDComplexTypeDefinition) {
                    XSDComplexTypeDefinition xsdCT = (XSDComplexTypeDefinition)val;
                    xsdName = xsdCT.getName();
                } else if (val instanceof Element && (ele88 = (Element)val).getLocalName().equals("level88")) {
                    Text textNode = (Text)ele88.getFirstChild();
                    String textContent = textNode.getData();
                    xsdName = textContent.substring(0, textContent.indexOf(" "));
                }
                if (!thisName.equalsIgnoreCase(xsdName)) continue;
                hasDuplication = true;
                String parentPath = this.cobolHelper.getParentPath(path);
                String parentName = this.cobolHelper.getElementNameFromPath(parentPath, this.preserveCase);
                if (parentName.equalsIgnoreCase(this.origTopTypeName)) {
                    parentName = this.util.toLowerUpperCaseToken(this.topTypeName, this.preserveCase);
                }
                parentName = this.util.getJavaNameFromXMLName(parentName);
                String thisNameOriginal = thisName = String.valueOf(parentName) + "_" + thisName;
                String grandParentPath = this.cobolHelper.getParentPath(parentPath);
                path = grandParentPath == null ? thisNameOriginal : String.valueOf(grandParentPath) + "/" + thisNameOriginal;
            }
            if (!hasDuplication) break;
            thisName = this.cobolHelper.getElementNameFromPathNoCaseChange(path);
        }
        return thisName;
    }

    public XSDTypeDefinition getXSDType() {
        return this.topComplexType;
    }

    private void populateInitial(COBOLElement item, XSDElementDeclaration elementDec) {
        COBOLClassifier classifier;
        boolean hasInitialValue;
        EList initList = item.getInitial();
        boolean bl = hasInitialValue = initList != null && !initList.isEmpty();
        if (!hasInitialValue && !this.isInsideRedefine && !(item instanceof COBOLRedefiningElement) && ((classifier = item.getSharedType()) instanceof COBOLAlphabeticType || classifier instanceof COBOLAlphaNumericType || classifier instanceof COBOLNumericEditedType || classifier instanceof COBOLAlphaNumericEditedType || classifier instanceof COBOLDBCSType || classifier instanceof COBOLUnicodeType || classifier instanceof COBOLExternalFloatType)) {
            COBOLElementInitialValue initValue = COBOLFactory.eINSTANCE.createCOBOLElementInitialValue();
            initValue.setValueKind(COBOLInitialValueKind.SPACES_LITERAL);
            initList.add(initValue);
            hasInitialValue = true;
        }
        if (hasInitialValue) {
            XSDAnnotation annotation;
            COBOLElementInitialValue initValObj = (COBOLElementInitialValue)initList.get(0);
            if (initValObj == null) {
                return;
            }
            String initVal = initValObj.getInitVal();
            initVal = SchemaUtils.fixStringForSchema(initVal);
            COBOLSimpleType cobolSimType = (COBOLSimpleType)item.getSharedType();
            if (cobolSimType instanceof COBOLNumericType && initVal != null) {
                initVal = this.removeLeadingZeros(initVal);
            }
            if ((annotation = elementDec.getAnnotation()) == null) {
                annotation = this.xsdFactory.createXSDAnnotation();
                elementDec.setAnnotation(annotation);
            }
            if (this.xsdSchema.getElement() == null) {
                this.xsdSchema.updateElement();
            }
            Element appInfoElement = annotation.createApplicationInformation(this.appInfoSourceURI);
            annotation.getElement().appendChild(appInfoElement);
            Element initTag = annotation.getElement().getOwnerDocument().createElementNS(this.annotationNS, String.valueOf(this.annotationNSPrefix) + "initialValue");
            COBOLInitialValueKind valKind = initValObj.getValueKind();
            if (valKind != null) {
                if (valKind.equals(COBOLInitialValueKind.ZERO_VALUE_LITERAL)) {
                    initTag.setAttribute("kind", "ZERO");
                } else if (valKind.equals(COBOLInitialValueKind.SPACES_LITERAL)) {
                    initTag.setAttribute("kind", "SPACE");
                } else if (initVal != null) {
                    if (initVal.equals("0")) {
                        initTag.setAttribute("kind", "ZERO");
                    } else if (initVal.equals(" ")) {
                        initTag.setAttribute("kind", "SPACE");
                    } else if (initVal.equals("'")) {
                        initTag.setAttribute("kind", "ALL");
                        initTag.setAttribute("value", initVal);
                    } else if (item.getSharedType() instanceof COBOLAlphabeticType || item.getSharedType() instanceof COBOLAlphaNumericType) {
                        if (valKind.equals(COBOLInitialValueKind.ALL_LITERAL_LITERAL)) {
                            initTag.setAttribute("kind", "ALL");
                            initTag.setAttribute("value", initVal);
                        } else {
                            initTag.setAttribute("kind", valKind.getName());
                            initTag.setAttribute("value", initVal);
                        }
                    } else {
                        initTag.setAttribute("kind", valKind.getName());
                        initTag.setAttribute("value", initVal);
                    }
                } else {
                    initTag.setAttribute("kind", valKind.getName());
                }
                appInfoElement.appendChild(initTag);
            }
        }
    }

    private String removeLeadingZeros(String value) {
        String sign = "";
        String val = "";
        if (value.startsWith("+") || value.startsWith("-")) {
            sign = value.substring(0, 1);
            val = value.substring(1).trim();
        } else {
            val = value;
        }
        if (val.length() > 1) {
            int i = 0;
            while (i < val.length()) {
                int ch = UTF16.charAt((String)val, (int)i);
                if (ch != 48) {
                    val = val.substring(i);
                    break;
                }
                i += UTF16.getCharCount((int)ch);
            }
        }
        value = String.valueOf(sign) + val;
        return value;
    }

    public void setGenerateFlat(boolean gf) {
        this.generateFlat = gf;
    }

    public void setPreserveCase(boolean pc) {
        this.preserveCase = pc;
    }

    public void setOverwriteTypes(boolean ow) {
        this.overwriteTypes = ow;
    }

    public void setTopTypePrefix(String prefix) {
        this.topTypePrefix = prefix;
    }

    public void setXsdSchema(XSDSchema schema) {
        this.xsdSchema = schema;
    }

    public void setXsdTypesTdBasePair(Map pair) {
        this.xsdTypesTdBasePair = pair;
    }

    public void setXsdTypeName(String newName) {
        this.topTypeName = newName;
    }

    public void setVAJStyle(int style) {
        this.fieldVAJStyle = style;
    }

    private void adjustOffset(InstanceTDBase tdBase) {
        if (this.offsetAdjustment != 0) {
            tdBase.setOffset(String.valueOf(Integer.parseInt(tdBase.getOffset()) - this.offsetAdjustment));
        }
    }

    public boolean visit(Object item) throws BaseException {
        COBOLElement element;
        XSDSchemaContent thisParent;
        if (item instanceof COBOLElement) {
            this.visitCOBOLElement((COBOLElement)item);
        } else if (item instanceof COBOLSimpleType) {
            return false;
        }
        boolean currentIsInsideRedefine = this.isInsideRedefine;
        if (item instanceof COBOLRedefiningElement && (thisParent = this.getParentXsdType(CobolTypeHelper.getID((TDLangModelElement)((COBOLRedefiningElement)item)))) != null) {
            this.isInsideRedefine = true;
        }
        this.acceptItemVisitor(item, 2);
        this.isInsideRedefine = currentIsInsideRedefine;
        if (this.fieldVAJStyle == 1) {
            if (item instanceof COBOLElement) {
                element = (COBOLElement)item;
                if (element.getSharedType() instanceof COBOLComposedType && element.getArray() != null) {
                    this.fieldNames.removeElementAt(this.fieldNames.size() - 1);
                }
                if (element.getSharedType() instanceof COBOLComposedType) {
                    this.classNames.removeElementAt(this.classNames.size() - 1);
                }
            }
        } else if (this.fieldVAJStyle == 2 && item instanceof COBOLElement && (element = (COBOLElement)item).getSharedType() instanceof COBOLComposedType && element.getArray() != null) {
            this.fieldNames.removeElementAt(this.fieldNames.size() - 1);
            this.classNames.removeElementAt(this.classNames.size() - 1);
        }
        return true;
    }

    public void visitCOBOL88Element(COBOLElement item, XSDSchemaContent parent) throws BaseException {
        XSDAnnotation annotation = this.xsdFactory.createXSDAnnotation();
        XSDElementDeclaration elementDec = null;
        String refID = CobolTypeHelper.getID((TDLangModelElement)item);
        COBOLClassifier sharedType = item.getSharedType();
        boolean isSimpleNumericType = false;
        if (sharedType instanceof COBOLSimpleType) {
            XSDAnnotation elemAnn;
            if (sharedType instanceof COBOLNumericType) {
                isSimpleNumericType = true;
            }
            if ((elemAnn = (elementDec = (XSDElementDeclaration)this.getThisXsdType(refID)).getAnnotation()) == null) {
                elementDec.setAnnotation(annotation);
            } else {
                annotation = elemAnn;
            }
        } else {
            XSDModelGroupDefinition group = (XSDModelGroupDefinition)this.getThisXsdType(refID);
            XSDModelGroup modelGroup = this.xsdHelper.getModelGroup(group);
            XSDAnnotation groupAnn = modelGroup.getAnnotation();
            if (groupAnn == null) {
                modelGroup.setAnnotation(annotation);
            } else {
                annotation = groupAnn;
            }
        }
        if (this.xsdSchema.getElement() == null) {
            this.xsdSchema.updateElement();
        }
        Element annotationElement = annotation.getElement();
        EList appInfoList = annotation.getApplicationInformation(this.appInfoSourceURI);
        Element appInfoElement = null;
        if (appInfoList.isEmpty()) {
            appInfoElement = annotation.createApplicationInformation(this.appInfoSourceURI);
            annotationElement.appendChild(appInfoElement);
        } else {
            appInfoElement = (Element)appInfoList.get(0);
        }
        EList cobol88List = item.getContains();
        int i = cobol88List.size() - 1;
        while (i >= 0) {
            COBOL88Element cobol88 = (COBOL88Element)cobol88List.get(i);
            EList cobol88ValList = cobol88.getHas();
            String cobol88Name = cobol88.getName();
            cobol88Name = cobol88Name.replace('-', '_');
            String path88 = String.valueOf(refID) + "/" + cobol88Name;
            String level88Name = this.getUniqueName(this.getPathFromRefID(path88));
            if (this.fieldVAJStyle == 2) {
                level88Name = this.cobolHelper.fixCase(level88Name);
            }
            StringBuffer strBuffer = new StringBuffer(level88Name);
            int j = 0;
            while (j < cobol88ValList.size()) {
                COBOL88ElementValue cobol88Val = (COBOL88ElementValue)cobol88ValList.get(j);
                if (j == 0) {
                    strBuffer.append(" value ");
                } else {
                    strBuffer.append(", ");
                }
                if (cobol88Val.getLowerLimit() != null) {
                    String lowerLimit = GeneralUtil.getInstance().replaceSpaceWithUnicodeLiteral(cobol88Val.getLowerLimit());
                    if (isSimpleNumericType) {
                        lowerLimit = this.removeLeadingZeros(lowerLimit);
                    }
                    strBuffer.append(lowerLimit);
                }
                if (cobol88Val.getRange() != null && cobol88Val.getRange().booleanValue()) {
                    strBuffer.append(" THRU ");
                }
                if (cobol88Val.getUpperLimit() != null) {
                    String upperLimit = GeneralUtil.getInstance().replaceSpaceWithUnicodeLiteral(cobol88Val.getUpperLimit());
                    if (isSimpleNumericType) {
                        upperLimit = this.removeLeadingZeros(upperLimit);
                    }
                    strBuffer.append(upperLimit);
                }
                ++j;
            }
            Element ele88 = annotationElement.getOwnerDocument().createElementNS(this.annotationNS, String.valueOf(this.annotationNSPrefix) + "level88");
            String contents = strBuffer.toString();
            contents = SchemaUtils.fixStringForSchema(contents);
            Text text = annotationElement.getOwnerDocument().createTextNode(contents);
            ele88.appendChild(text);
            appInfoElement.appendChild(ele88);
            this.pathXsdPair.put(this.getPathFromRefID(path88), ele88);
            --i;
        }
    }

    public void visitCOBOLComposedType(COBOLElement item, XSDSchemaContent parent) throws BaseException {
        String refID = CobolTypeHelper.getID((TDLangModelElement)item);
        if (this.isThisTopComplexType) {
            if (!item.getInstanceTDBase().getOffset().equals("0")) {
                this.offsetAdjustment = Integer.parseInt(item.getInstanceTDBase().getOffset());
            }
            this.origTopTypeName = item.getName();
            if (UCharacter.isDigit((int)UTF16.charAt((String)this.topTypeName, (int)0))) {
                this.topTypeName = "__" + this.topTypeName;
            }
            this.topComplexType = this.xsdFactory.createXSDComplexTypeDefinition();
            this.topTypeName = this.util.getJavaNameFromXMLName(this.topTypeName);
            if (this.generateFlat) {
                this.topTypeName = this.util.capitalizeFirstLetter(this.topTypeName);
            }
            if (this.topTypePrefix != null && this.topTypePrefix.length() != 0) {
                this.topTypeName = String.valueOf(this.topTypePrefix) + this.topTypeName;
            }
            this.topComplexType.setName(this.topTypeName);
            if (this.fieldVAJStyle != 0) {
                Hashtable ht = PropertyName.getPropertyNameList(item, this.topTypeName, this.fieldVAJStyle, this.generateFlat);
                this.fieldNames.add(ht);
                this.classNames.add(this.topTypeName);
            }
            this.xsdHelper.addComplexTypeOrGroupToSchema((XSDSchemaContent)this.topComplexType, this.xsdSchema, this.overwriteTypes);
            this.topTypes.add(this.topComplexType);
            XSDParticle part = this.xsdFactory.createXSDParticle();
            XSDModelGroup modelGroup = this.xsdFactory.createXSDModelGroup();
            modelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
            part.setContent((XSDParticleContent)modelGroup);
            this.topComplexType.setContent((XSDComplexTypeContent)part);
            this.adjustOffset(item.getInstanceTDBase());
            this.xsdTypesTdBasePair.put(this.topComplexType, item.getInstanceTDBase());
            this.pathXsdPair.put(this.getPathFromRefID(refID), this.topComplexType);
            this.isThisTopComplexType = false;
        } else {
            XSDParticle groupPart;
            if (this.fieldVAJStyle == 1) {
                this.classNames.add(item.getName());
            }
            String groupName = this.xsdHelper.createGroupNameFromRefID(refID, this.topTypeName);
            if (this.topTypePrefix != null && this.topTypePrefix.length() != 0) {
                groupName = String.valueOf(this.topTypePrefix) + groupName.substring(this.topTypePrefix.length());
            } else if (UCharacter.isDigit((int)UTF16.charAt((String)groupName, (int)0))) {
                groupName = "__" + groupName;
            }
            XSDModelGroupDefinition group = this.xsdHelper.createGroupDef(groupName, "sequence", this.xsdSchema);
            group.setTargetNamespace(this.xsdSchema.getTargetNamespace());
            this.xsdHelper.addComplexTypeOrGroupToSchema((XSDSchemaContent)group, this.xsdSchema, this.overwriteTypes);
            this.topTypes.add(group);
            if (parent == null) {
                parent = this.getParentXsdType(refID);
            }
            this.adjustOffset(item.getInstanceTDBase());
            if (this.generateFlat) {
                groupPart = this.xsdHelper.createGroupRefParticle(group);
                this.xsdTypesTdBasePair.put(group, item.getInstanceTDBase());
            } else {
                groupPart = this.xsdHelper.createComplexTypeParticle(this.getUniqueName(refID), groupName, this.xsdSchema);
                this.xsdTypesTdBasePair.put(groupPart.getContent(), item.getInstanceTDBase());
            }
            XSDModelGroup parentModelGroup = this.xsdHelper.getModelGroup(parent);
            parentModelGroup.getContents().add((Object)groupPart);
            this.pathXsdPair.put(this.getPathFromRefID(refID), group);
            if (!this.generateFlat) {
                XSDComplexTypeDefinition complexType = this.xsdFactory.createXSDComplexTypeDefinition();
                complexType.setName(groupName);
                XSDParticle modelGroupParticle = this.xsdHelper.createGroupRefParticle(group);
                complexType.setContent((XSDComplexTypeContent)modelGroupParticle);
                this.xsdHelper.addComplexTypeOrGroupToSchema((XSDSchemaContent)complexType, this.xsdSchema, this.overwriteTypes);
                this.topTypes.add(complexType);
                ((XSDElementDeclaration)groupPart.getContent()).setTypeDefinition((XSDTypeDefinition)complexType);
            }
        }
    }

    public void visitCOBOLElement(COBOLElement item) throws BaseException {
        EList cobol88s = item.getContains();
        if (item instanceof COBOLRedefiningElement) {
            this.visitCOBOLRedefiningElement(item);
        } else if (item.getArray() != null) {
            boolean processed = false;
            if (this.generateFlat && item.getArray().getMaxUpper() == 1 && !(item.getArray() instanceof COBOLVariableLengthArray)) {
                item.getInstanceTDBase().getArrayDescr().clear();
                item.setArray(null);
                if (item.getSharedType() instanceof COBOLComposedType) {
                    this.visitCOBOLComposedType(item, null);
                } else {
                    this.visitCOBOLSimpleType(item, null);
                }
                processed = true;
            }
            if (!processed) {
                if (item.getArray() instanceof COBOLVariableLengthArray) {
                    this.visitCOBOLVariableLengthArray(item, null);
                } else {
                    this.visitCOBOLFixedLengthArray(item, null);
                }
            }
        } else if (item.getSharedType() instanceof COBOLComposedType) {
            this.visitCOBOLComposedType(item, null);
        } else if (item.getSharedType() instanceof COBOLSimpleType) {
            this.visitCOBOLSimpleType(item, null);
        }
        if (cobol88s != null && cobol88s.size() > 0 && cobol88s.get(0) instanceof COBOL88Element) {
            this.visitCOBOL88Element(item, null);
        }
    }

    public void visitCOBOLFixedLengthArray(COBOLElement item, XSDSchemaContent parent) throws BaseException {
        String refID = CobolTypeHelper.getID((TDLangModelElement)item);
        XSDParticle elePart = this.xsdFactory.createXSDParticle();
        XSDElementDeclaration elementDec = this.xsdFactory.createXSDElementDeclaration();
        String elementName = this.getUniqueName(refID);
        if (this.fieldVAJStyle == 2) {
            elementName = this.cobolHelper.fixCase(elementName);
        }
        elementDec.setName(elementName);
        elePart.setMinOccurs(item.getArray().getMaxUpper());
        elePart.setMaxOccurs(item.getArray().getMaxUpper());
        elePart.setContent((XSDParticleContent)elementDec);
        if (parent == null) {
            parent = this.getParentXsdType(this.getPathFromRefID(refID));
        }
        XSDModelGroup parentModelGroup = this.xsdHelper.getModelGroup(parent);
        parentModelGroup.getContents().add((Object)elePart);
        elementDec.setTargetNamespace(this.xsdSchema.getTargetNamespace());
        COBOLClassifier cobolType = item.getSharedType();
        if (cobolType instanceof COBOLSimpleType) {
            this.populateInitial(item, elementDec);
            XSDSimpleTypeDefinition simpType = this.xsdHelper.getXSDSimpleType((COBOLSimpleType)cobolType, this.xsdSchema, item.getInstanceTDBase(), this.isGenerateTotalFractionDigitsFacet());
            elementDec.setAnonymousTypeDefinition((XSDTypeDefinition)simpType);
            this.adjustOffset(item.getInstanceTDBase());
            this.xsdTypesTdBasePair.put(elementDec, item.getInstanceTDBase());
            this.pathXsdPair.put(this.getPathFromRefID(refID), elementDec);
        } else if (cobolType instanceof COBOLComposedType) {
            String crefID = CobolTypeHelper.getID((TDLangModelElement)cobolType);
            String groupName = this.xsdHelper.createGroupNameFromRefID(crefID, this.topTypeName);
            String ctName = new String();
            if (this.fieldVAJStyle == 0) {
                ctName = groupName;
                ctName = this.util.getJavaNameFromXMLName(ctName.toLowerCase());
                ctName = this.util.capitalizeFirstLetter(ctName);
            } else if (this.fieldVAJStyle == 1 || this.fieldVAJStyle == 2) {
                this.classNames.add(this.getUniqueName(refID));
                boolean first = true;
                Enumeration e = this.classNames.elements();
                while (e.hasMoreElements()) {
                    if (first) {
                        ctName = (String)e.nextElement();
                        first = false;
                        continue;
                    }
                    ctName = String.valueOf(ctName) + "_" + (String)e.nextElement();
                }
            }
            if (this.topTypePrefix != null && this.topTypePrefix.length() != 0) {
                ctName = String.valueOf(this.topTypePrefix) + ctName.substring(this.topTypePrefix.length());
            }
            if (this.fieldVAJStyle == 1 || this.fieldVAJStyle == 2) {
                Hashtable ht = PropertyName.getPropertyNameList(item, ctName, this.fieldVAJStyle, this.generateFlat);
                this.fieldNames.add(ht);
            }
            XSDComplexTypeDefinition xsdCT = this.xsdHelper.createComplexTypeWithModelGroup(ctName, "sequence");
            xsdCT.setTargetNamespace(this.xsdSchema.getTargetNamespace());
            elementDec.setTypeDefinition((XSDTypeDefinition)xsdCT);
            this.xsdHelper.addComplexTypeOrGroupToSchema((XSDSchemaContent)xsdCT, this.xsdSchema, this.overwriteTypes);
            if (this.topTypePrefix != null && this.topTypePrefix.length() != 0) {
                groupName = String.valueOf(this.topTypePrefix) + groupName.substring(this.topTypePrefix.length());
            }
            XSDModelGroupDefinition group = this.xsdHelper.createGroupDef(groupName, "sequence", this.xsdSchema);
            this.xsdHelper.addComplexTypeOrGroupToSchema((XSDSchemaContent)group, this.xsdSchema, this.overwriteTypes);
            XSDParticle groupRefPart = this.xsdHelper.createGroupRefParticle(group);
            XSDModelGroup ctModelGroup = this.xsdHelper.getModelGroup(xsdCT);
            ctModelGroup.getContents().add((Object)groupRefPart);
            this.adjustOffset(item.getInstanceTDBase());
            this.xsdTypesTdBasePair.put(elementDec, item.getInstanceTDBase());
            this.pathXsdPair.put(this.getPathFromRefID(refID), elementDec);
        }
    }

    public void visitCOBOLRedefiningElement(COBOLElement ele) throws BaseException {
        COBOLRedefiningElement thisEle = (COBOLRedefiningElement)ele;
        String eleRefID = CobolTypeHelper.getID((TDLangModelElement)ele);
        XSDSchemaContent thisParent = this.getParentXsdType(eleRefID);
        if (thisParent == null) {
            this.visitCOBOLComposedType((COBOLElement)thisEle, null);
            return;
        }
        COBOLElement redefEle = thisEle.getRedefines();
        while (redefEle instanceof COBOLRedefiningElement) {
            redefEle = ((COBOLRedefiningElement)redefEle).getRedefines();
        }
        String reDefEleRefID = CobolTypeHelper.getID((TDLangModelElement)redefEle);
        List types = this.xsdHelper.getModelGroupContents(thisParent);
        int i = 0;
        while (i < types.size()) {
            XSDParticle typePart = (XSDParticle)types.get(i);
            XSDParticleContent type = typePart.getContent();
            XSDElementDeclaration xsdEle = null;
            XSDModelGroupDefinition group = null;
            String candidateName = "";
            if (type instanceof XSDElementDeclaration) {
                XSDModelGroupDefinition groupRef;
                XSDComplexTypeDefinition ct;
                xsdEle = (XSDElementDeclaration)((XSDParticle)types.get(i)).getContent();
                XSDTypeDefinition typeRef = xsdEle.getTypeDefinition();
                if (typeRef != null && typeRef instanceof XSDComplexTypeDefinition && typePart.isSetMaxOccurs() && typePart.isSetMinOccurs()) {
                    ct = (XSDComplexTypeDefinition)typeRef;
                    List ctContents = this.xsdHelper.getModelGroupContents(ct);
                    groupRef = (XSDModelGroupDefinition)((XSDParticle)ctContents.get(0)).getContent();
                    XSDModelGroupDefinition xsdCont = groupRef.getResolvedModelGroupDefinition();
                    candidateName = this.xsdHelper.getNameForXSDSchemaContent((XSDSchemaContent)xsdCont);
                } else if (typeRef != null && typeRef instanceof XSDComplexTypeDefinition && !this.generateFlat) {
                    ct = (XSDComplexTypeDefinition)typeRef;
                    XSDParticleContent obj = ((XSDParticle)ct.getContent()).getContent();
                    if (obj instanceof XSDModelGroupDefinition) {
                        groupRef = (XSDModelGroupDefinition)obj;
                        group = groupRef.getResolvedModelGroupDefinition();
                        candidateName = group.getName();
                    } else {
                        candidateName = xsdEle.getName();
                    }
                } else {
                    candidateName = xsdEle.getName();
                }
            } else if (type instanceof XSDModelGroupDefinition) {
                XSDModelGroupDefinition groupRef = (XSDModelGroupDefinition)type;
                group = groupRef.getResolvedModelGroupDefinition();
                candidateName = group.getName();
            }
            String xsdName = this.xsdHelper.getNameForXSDSchemaContent(this.getThisXsdType(this.getPathFromRefID(reDefEleRefID)));
            String redefTypeName = this.xsdHelper.createGroupNameFromRefID(reDefEleRefID, this.topTypeName);
            if (candidateName.equals(xsdName)) {
                XSDParticle newGrpRefPart;
                String redefName = "RedefinedElement_" + redefTypeName + "_" + thisEle.getName().toLowerCase();
                if (this.topTypePrefix != null && this.topTypePrefix.length() != 0) {
                    redefName = String.valueOf(this.topTypePrefix) + redefName;
                }
                XSDModelGroupDefinition newGrp = this.xsdHelper.createGroupDef(redefName, "choice", this.xsdSchema);
                this.pathXsdPair.put(String.valueOf(this.getPathFromRefID(reDefEleRefID)) + "/" + redefName, newGrp);
                XSDParticle redefinedTypePart = (XSDParticle)types.get(i);
                types.remove(i);
                newGrp.getModelGroup().getContents().add((Object)redefinedTypePart);
                this.pathXsdPair.put(this.getPathFromRefID(reDefEleRefID), redefinedTypePart.getContent());
                this.xsdHelper.addComplexTypeOrGroupToSchema((XSDSchemaContent)newGrp, this.xsdSchema, this.overwriteTypes);
                this.topTypes.add(newGrp);
                if (this.generateFlat) {
                    newGrpRefPart = this.xsdHelper.createGroupRefParticle(newGrp);
                } else {
                    newGrpRefPart = this.xsdHelper.createGroupRefParticle(newGrp);
                    InstanceTDBase instTD = this.createInstanceTD(true);
                    instTD.setPlatformInfo(redefEle.getInstanceTDBase().getPlatformInfo());
                    int redefSize = Integer.parseInt(redefEle.getInstanceTDBase().getSize());
                    int eleSize = Integer.parseInt(thisEle.getInstanceTDBase().getSize());
                    String instSize = String.valueOf(Math.max(redefSize, eleSize));
                    instTD.setSize(instSize);
                    instTD.setContentSize(instSize);
                    instTD.setOffset(redefEle.getInstanceTDBase().getOffset());
                    this.xsdTypesTdBasePair.put(newGrpRefPart.getContent(), instTD);
                }
                types.add(newGrpRefPart);
                if (thisEle.getArray() != null) {
                    if (thisEle.getArray() instanceof COBOLVariableLengthArray) {
                        this.visitCOBOLVariableLengthArray((COBOLElement)thisEle, (XSDSchemaContent)newGrp);
                        break;
                    }
                    this.visitCOBOLFixedLengthArray((COBOLElement)thisEle, (XSDSchemaContent)newGrp);
                    break;
                }
                if (thisEle.getSharedType() instanceof COBOLComposedType) {
                    this.visitCOBOLComposedType((COBOLElement)thisEle, (XSDSchemaContent)newGrp);
                    break;
                }
                if (!(thisEle.getSharedType() instanceof COBOLSimpleType)) break;
                this.visitCOBOLSimpleType((COBOLElement)thisEle, (XSDSchemaContent)newGrp);
                break;
            }
            String redefStr = "";
            redefStr = this.topTypePrefix != null && this.topTypePrefix.length() != 0 ? String.valueOf(this.topTypePrefix) + "RedefinedElement_" : "RedefinedElement_";
            if (candidateName.startsWith(String.valueOf(redefStr) + redefTypeName)) {
                XSDParticle newGrpRefPart;
                String newGroupName = String.valueOf(candidateName) + "_" + thisEle.getName().toLowerCase();
                this.xsdHelper.removeTypeFromSchema(this.xsdSchema, group);
                group.setName(newGroupName);
                this.xsdHelper.addComplexTypeOrGroupToSchema((XSDSchemaContent)group, this.xsdSchema, this.overwriteTypes);
                if (this.generateFlat) {
                    newGrpRefPart = this.xsdHelper.createGroupRefParticle(group);
                } else {
                    newGrpRefPart = this.xsdHelper.createGroupRefParticle(group);
                    InstanceTDBase oldInstTD = (InstanceTDBase)this.xsdTypesTdBasePair.get(typePart.getContent());
                    this.xsdTypesTdBasePair.remove(typePart.getContent());
                    InstanceTDBase instTD = this.createInstanceTD(true);
                    instTD.setPlatformInfo(redefEle.getInstanceTDBase().getPlatformInfo());
                    int oldSize = Integer.parseInt(oldInstTD.getSize());
                    int eleSize = Integer.parseInt(thisEle.getInstanceTDBase().getSize());
                    String instSize = String.valueOf(Math.max(oldSize, eleSize));
                    instTD.setSize(instSize);
                    instTD.setContentSize(instSize);
                    instTD.setOffset(redefEle.getInstanceTDBase().getOffset());
                    this.xsdTypesTdBasePair.put(newGrpRefPart.getContent(), instTD);
                }
                types.remove(typePart);
                types.add(newGrpRefPart);
                if (thisEle.getArray() != null) {
                    if (thisEle.getArray() instanceof COBOLVariableLengthArray) {
                        this.visitCOBOLVariableLengthArray((COBOLElement)thisEle, (XSDSchemaContent)group);
                        break;
                    }
                    this.visitCOBOLFixedLengthArray((COBOLElement)thisEle, (XSDSchemaContent)group);
                    break;
                }
                if (thisEle.getSharedType() instanceof COBOLComposedType) {
                    this.visitCOBOLComposedType((COBOLElement)thisEle, (XSDSchemaContent)group);
                    break;
                }
                if (!(thisEle.getSharedType() instanceof COBOLSimpleType)) break;
                this.visitCOBOLSimpleType((COBOLElement)thisEle, (XSDSchemaContent)group);
                break;
            }
            ++i;
        }
    }

    public void visitCOBOLSimpleType(COBOLElement item, XSDSchemaContent parent) {
        String itemRefID = CobolTypeHelper.getID((TDLangModelElement)item);
        COBOLSimpleType cobolST = (COBOLSimpleType)item.getSharedType();
        String cRefID = CobolTypeHelper.getID((TDLangModelElement)cobolST);
        String name = this.getUniqueName(this.getPathFromRefID(cRefID));
        if (this.fieldVAJStyle == 2) {
            name = this.cobolHelper.fixCase(name);
        }
        XSDParticle elementPart = this.xsdFactory.createXSDParticle();
        XSDElementDeclaration elementDec = this.xsdFactory.createXSDElementDeclaration();
        elementDec.setName(name);
        elementPart.setContent((XSDParticleContent)elementDec);
        if (parent == null) {
            parent = this.getParentXsdType(itemRefID);
        }
        this.xsdHelper.getModelGroup(parent).getContents().add((Object)elementPart);
        this.populateInitial(item, elementDec);
        elementDec.setAnonymousTypeDefinition((XSDTypeDefinition)this.xsdHelper.getXSDSimpleType(cobolST, this.xsdSchema, item.getInstanceTDBase(), this.isGenerateTotalFractionDigitsFacet()));
        this.adjustOffset(item.getInstanceTDBase());
        this.xsdTypesTdBasePair.put(elementDec, item.getInstanceTDBase());
        this.pathXsdPair.put(this.getPathFromRefID(itemRefID), elementDec);
    }

    public void visitCOBOLVariableLengthArray(COBOLElement item, XSDSchemaContent parent) throws BaseException {
        COBOLVariableLengthArray variableAry = (COBOLVariableLengthArray)item.getArray();
        COBOLElement dependEle = variableAry.getDependingOn();
        String refID = CobolTypeHelper.getID((TDLangModelElement)item);
        String dependEleRefID = CobolTypeHelper.getID((TDLangModelElement)dependEle);
        XSDParticle elePart = this.xsdFactory.createXSDParticle();
        XSDElementDeclaration elementDec = this.xsdFactory.createXSDElementDeclaration();
        String elementName = this.getUniqueName(this.getPathFromRefID(refID));
        if (this.fieldVAJStyle == 2) {
            elementName = this.cobolHelper.fixCase(elementName);
        }
        elementDec.setName(elementName);
        elePart.setMinOccurs(variableAry.getMinUpper());
        elePart.setMaxOccurs(variableAry.getMaxUpper());
        elePart.setContent((XSDParticleContent)elementDec);
        if (parent == null) {
            parent = this.getParentXsdType(this.getPathFromRefID(refID));
        }
        XSDModelGroup parentModelGroup = this.xsdHelper.getModelGroup(parent);
        parentModelGroup.getContents().add((Object)elePart);
        elementDec.setTargetNamespace(this.xsdSchema.getTargetNamespace());
        COBOLClassifier cobolType = item.getSharedType();
        if (cobolType instanceof COBOLSimpleType) {
            XSDSimpleTypeDefinition simpType = this.xsdHelper.getXSDSimpleType((COBOLSimpleType)cobolType, this.xsdSchema, item.getInstanceTDBase(), this.isGenerateTotalFractionDigitsFacet());
            elementDec.setAnonymousTypeDefinition((XSDTypeDefinition)simpType);
            XSDAnnotation annotation = this.xsdFactory.createXSDAnnotation();
            elementDec.setAnnotation(annotation);
            if (this.xsdSchema.getElement() == null) {
                this.xsdSchema.updateElement();
            }
            Element annotationElement = annotation.getElement();
            Element appInfoElement = annotation.createApplicationInformation(this.appInfoSourceURI);
            annotationElement.appendChild(appInfoElement);
            Element dependingOnEle = annotationElement.getOwnerDocument().createElementNS(this.annotationNS, String.valueOf(this.annotationNSPrefix) + "dependingOn");
            XSDElementDeclaration dependType = (XSDElementDeclaration)this.getThisXsdType(dependEleRefID);
            if (dependType == null) {
                String errorMsg = MessageResource._ERROR_missing_depending_on_element;
                Status status = new Status(4, Cobol2XSDPlugin.getPluginID(), 4, errorMsg, null);
                throw new BaseException((IStatus)status);
            }
            String dependedName = this.generateFlat ? dependType.getName() : dependType.eResource().getURIFragment((EObject)dependType);
            Text text = annotationElement.getOwnerDocument().createTextNode(dependedName);
            dependingOnEle.appendChild(text);
            appInfoElement.appendChild(dependingOnEle);
            this.populateInitial(item, elementDec);
            this.adjustOffset(item.getInstanceTDBase());
            this.xsdTypesTdBasePair.put(elementDec, item.getInstanceTDBase());
            this.pathXsdPair.put(this.getPathFromRefID(refID), elementDec);
        } else if (cobolType instanceof COBOLComposedType) {
            COBOLComposedType cobolCT = (COBOLComposedType)cobolType;
            String cRefID = CobolTypeHelper.getID((TDLangModelElement)cobolCT);
            String groupName = this.xsdHelper.createGroupNameFromRefID(cRefID, this.topTypeName);
            String ctName = new String();
            if (this.fieldVAJStyle == 0) {
                ctName = groupName;
                ctName = this.util.getJavaNameFromXMLName(ctName.toLowerCase());
                ctName = this.util.capitalizeFirstLetter(ctName);
            } else if (this.fieldVAJStyle == 1 || this.fieldVAJStyle == 2) {
                this.classNames.add(this.getUniqueName(refID));
                boolean first = true;
                Enumeration e = this.classNames.elements();
                while (e.hasMoreElements()) {
                    if (first) {
                        ctName = (String)e.nextElement();
                        first = false;
                        continue;
                    }
                    ctName = String.valueOf(ctName) + "_" + (String)e.nextElement();
                }
            }
            if (this.topTypePrefix != null && this.topTypePrefix.length() != 0) {
                ctName = String.valueOf(this.topTypePrefix) + ctName.substring(this.topTypePrefix.length());
            }
            if (this.fieldVAJStyle == 1 || this.fieldVAJStyle == 2) {
                Hashtable ht = PropertyName.getPropertyNameList(item, ctName, this.fieldVAJStyle, this.generateFlat);
                this.fieldNames.add(ht);
            }
            XSDComplexTypeDefinition xsdCT = this.xsdHelper.createComplexTypeWithModelGroup(ctName, "sequence");
            xsdCT.setTargetNamespace(this.xsdSchema.getTargetNamespace());
            elementDec.setTypeDefinition((XSDTypeDefinition)xsdCT);
            this.xsdHelper.addComplexTypeOrGroupToSchema((XSDSchemaContent)xsdCT, this.xsdSchema, this.overwriteTypes);
            if (this.topTypePrefix != null && this.topTypePrefix.length() != 0) {
                groupName = String.valueOf(this.topTypePrefix) + groupName.substring(this.topTypePrefix.length());
            }
            XSDModelGroupDefinition group = this.xsdHelper.createGroupDef(groupName, "sequence", this.xsdSchema);
            this.xsdHelper.addComplexTypeOrGroupToSchema((XSDSchemaContent)group, this.xsdSchema, this.overwriteTypes);
            XSDParticle groupRefPart = this.xsdHelper.createGroupRefParticle(group);
            XSDModelGroup ctModelGroup = this.xsdHelper.getModelGroup(xsdCT);
            ctModelGroup.getContents().add((Object)groupRefPart);
            XSDAnnotation annotation = this.xsdFactory.createXSDAnnotation();
            elementDec.setAnnotation(annotation);
            if (this.xsdSchema.getElement() == null) {
                this.xsdSchema.updateElement();
            }
            Element annotationElement = annotation.getElement();
            Element appInfoElement = annotation.createApplicationInformation(this.appInfoSourceURI);
            annotationElement.appendChild(appInfoElement);
            Element dependingOnEle = annotationElement.getOwnerDocument().createElementNS(this.annotationNS, String.valueOf(this.annotationNSPrefix) + "dependingOn");
            XSDElementDeclaration dependType = (XSDElementDeclaration)this.getThisXsdType(dependEleRefID);
            if (dependType == null) {
                String errorMsg = MessageResource._ERROR_missing_depending_on_element;
                Status status = new Status(4, Cobol2XSDPlugin.getPluginID(), 4, errorMsg, null);
                throw new BaseException((IStatus)status);
            }
            String dependedName = this.generateFlat ? dependType.getName() : dependType.eResource().getURIFragment((EObject)dependType);
            Text text = annotationElement.getOwnerDocument().createTextNode(dependedName);
            dependingOnEle.appendChild(text);
            appInfoElement.appendChild(dependingOnEle);
            this.adjustOffset(item.getInstanceTDBase());
            this.xsdTypesTdBasePair.put(elementDec, item.getInstanceTDBase());
            this.pathXsdPair.put(this.getPathFromRefID(refID), elementDec);
        }
    }

    private InstanceTDBase createInstanceTD(boolean isAggregate) {
        Object instance = null;
        instance = isAggregate ? TypeDescriptorFactory.eINSTANCE.createAggregateInstanceTD() : TypeDescriptorFactory.eINSTANCE.createSimpleInstanceTD();
        instance.setAccessor(AccessorValue.READ_WRITE_LITERAL);
        instance.setAttributeInBit(Boolean.FALSE);
        return instance;
    }

    public String getAnnotationNS() {
        return this.annotationNS;
    }

    public void setAnnotationNS(String annotationNS) {
        this.annotationNS = annotationNS;
    }

    public String getAnnotationNSPrefix() {
        return this.annotationNSPrefix;
    }

    public void setAnnotationNSPrefix(String annotationNSPrefix) {
        this.annotationNSPrefix = annotationNSPrefix;
    }

    public String getAppInfoSourceURI() {
        return this.appInfoSourceURI;
    }

    public void setAppInfoSourceURI(String appInfoSourceURI) {
        this.appInfoSourceURI = appInfoSourceURI;
    }

    public void acceptItemVisitor(Object item, int depth) throws BaseException {
        if (depth == 1) {
            this.visit(item);
            return;
        }
        if (depth == 2) {
            depth = 1;
        }
        if (item instanceof COBOLComposedType) {
            COBOLComposedType composedType = (COBOLComposedType)item;
            EList elements = composedType.getElement();
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                this.acceptItemVisitor(iter.next(), depth);
            }
        } else if (item instanceof COBOLElement) {
            COBOLElement element = (COBOLElement)item;
            COBOLClassifier classifier = element.getSharedType();
            this.acceptItemVisitor(classifier, depth);
        }
    }

    public boolean isGenerateTotalFractionDigitsFacet() {
        return this.generateTotalFractionDigitsFacet;
    }

    public void setGenerateTotalFractionDigitsFacet(boolean generateTotalFractionDigitsFacet) {
        this.generateTotalFractionDigitsFacet = generateTotalFractionDigitsFacet;
    }
}

