/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ctc.c2xsd.typesimport;

import com.ibm.etools.c.CArray;
import com.ibm.etools.c.CClassifier;
import com.ibm.etools.c.CField;
import com.ibm.etools.c.CPointer;
import com.ibm.etools.c.CStructured;
import com.ibm.etools.c.CTypedef;
import com.ibm.etools.c.datatypes.CBitField;
import com.ibm.etools.c.datatypes.CChar;
import com.ibm.etools.c.datatypes.CDouble;
import com.ibm.etools.c.datatypes.CEnumeration;
import com.ibm.etools.c.datatypes.CFloat;
import com.ibm.etools.c.datatypes.CInt;
import com.ibm.etools.c.datatypes.CLong;
import com.ibm.etools.c.datatypes.CLongDouble;
import com.ibm.etools.c.datatypes.CLongLong;
import com.ibm.etools.c.datatypes.CShort;
import com.ibm.etools.c.datatypes.CSignedChar;
import com.ibm.etools.c.datatypes.CUnsignedChar;
import com.ibm.etools.c.datatypes.CUnsignedInt;
import com.ibm.etools.c.datatypes.CUnsignedLong;
import com.ibm.etools.c.datatypes.CUnsignedLongLong;
import com.ibm.etools.c.datatypes.CUnsignedShort;
import com.ibm.etools.c.datatypes.CWchar;
import com.ibm.etools.c.importer.CImporterResource;
import com.ibm.etools.c.importer.CTypeDescriptorBuilder;
import com.ibm.etools.c.importer.CTypeDescriptorHelper;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;

public class CTypeHelper {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2004 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private static CTypeHelper fieldInstance;
    private Resource importerResource = null;

    public static synchronized CTypeHelper getInstance() {
        if (fieldInstance == null) {
            fieldInstance = new CTypeHelper();
        }
        return fieldInstance;
    }

    public List getCTopElements() {
        ArrayList eleList = new ArrayList();
        for (Object possibleType : this.importerResource.getContents()) {
            if (!(possibleType instanceof CStructured) && (!(possibleType instanceof CTypedef) || ((CTypedef)possibleType).getDerives() == null)) continue;
            eleList.add(possibleType);
        }
        return eleList;
    }

    public InstanceTDBase cloneTDBase(InstanceTDBase orig, String offset) {
        InstanceTDBase newTDBase = CTypeDescriptorBuilder.clonedInstance((InstanceTDBase)orig);
        int intOffset = new Integer(orig.getOffset()) + new Integer(offset);
        newTDBase.setOffset(String.valueOf(intOffset));
        return newTDBase;
    }

    public String getRefName(CField field) {
        if (field.eContainer() instanceof CStructured) {
            return ((CStructured)field.eContainer()).getName();
        }
        return "";
    }

    public String getRefName(CStructured field) {
        if (field.eContainer() instanceof CStructured) {
            return ((CStructured)field.eContainer()).getName();
        }
        return "";
    }

    public void importC(IFile typesFile, HashMap options) throws Exception {
        String fullPath = typesFile.getLocation().toOSString();
        Resource.Factory factory = ResourceFactoryRegistryImpl.INSTANCE.getFactory(URI.createFileURI((String)fullPath));
        this.importerResource = factory.createResource(URI.createFileURI((String)fullPath));
        this.importerResource.load((Map)options);
    }

    public String getBaseTypeString(Object obj) {
        String base = "";
        if (obj instanceof CShort) {
            base = "short";
        } else if (obj instanceof CEnumeration) {
            int enumSize = CTypeDescriptorBuilder.calculateEnumSize((CEnumeration)((CEnumeration)obj));
            base = enumSize == 1 ? "byte" : (enumSize == 2 ? "short" : "int");
        } else if (obj instanceof CLong) {
            base = "int";
        } else if (obj instanceof CLongLong) {
            base = "long";
        } else if (obj instanceof CFloat) {
            base = "float";
        } else if (obj instanceof CDouble) {
            base = "double";
        } else if (obj instanceof CLongDouble) {
            base = CTypeDescriptorHelper.sizeof((CClassifier)((CClassifier)obj)) == 16 ? "decimal" : "double";
        } else if (obj instanceof CUnsignedShort) {
            base = "unsignedShort";
        } else if (obj instanceof CUnsignedLong) {
            base = "unsignedInt";
        } else if (obj instanceof CUnsignedLongLong) {
            base = "unsignedLong";
        } else if (obj instanceof CWchar) {
            base = "string";
        } else if (obj instanceof CUnsignedChar) {
            base = "unsignedByte";
        } else if (obj instanceof CSignedChar) {
            base = "byte";
        } else if (obj instanceof CChar) {
            base = "unsignedByte";
        } else if (obj instanceof CUnsignedInt) {
            base = "unsignedInt";
        } else if (obj instanceof CInt) {
            base = "int";
        } else if (obj instanceof CPointer || obj instanceof CBitField) {
            base = "hexBinary";
        }
        return base;
    }

    public Object getSimplestDerivedType(Object obj) {
        if (obj instanceof CTypedef) {
            return this.getSimplestDerivedType(((CTypedef)obj).getDerives());
        }
        return obj;
    }

    public Object getSimplestArrayDerivedType(Object obj) {
        if (obj instanceof CTypedef) {
            return this.getSimplestArrayDerivedType(((CTypedef)obj).getDerives());
        }
        if (obj instanceof CArray) {
            return this.getSimplestArrayDerivedType(((CArray)obj).getDerives());
        }
        return obj;
    }

    public String getImporterResourceURIFragment(Object obj) {
        String uriFragment = null;
        if (this.importerResource != null && obj instanceof EObject) {
            uriFragment = this.importerResource.getURIFragment((EObject)obj);
        }
        return uriFragment;
    }

    public Object getObject(String uriFragment) {
        return this.importerResource.getEObject(uriFragment);
    }

    public void setRefIDs(Object obj) {
        ((CImporterResource)this.importerResource).setRefIDs(obj);
    }

    public String getID(Object obj) {
        String uriFragment = null;
        if (this.importerResource != null && obj instanceof EObject) {
            uriFragment = this.importerResource.getURIFragment((EObject)obj);
        }
        return uriFragment;
    }
}

