/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ctc.c2xsd.typesimport;

import com.ibm.adapter.framework.BaseException;
import com.ibm.etools.c.CArray;
import com.ibm.etools.c.CClassifier;
import com.ibm.etools.c.CDatatype;
import com.ibm.etools.c.CDerivableType;
import com.ibm.etools.c.CField;
import com.ibm.etools.c.CPointer;
import com.ibm.etools.c.CStructured;
import com.ibm.etools.c.CTypedElement;
import com.ibm.etools.c.CTypedef;
import com.ibm.etools.c.datatypes.CBitField;
import com.ibm.etools.c.datatypes.CChar;
import com.ibm.etools.c.datatypes.CSignedChar;
import com.ibm.etools.c.datatypes.CUnsignedChar;
import com.ibm.etools.c.datatypes.CUnsignedShort;
import com.ibm.etools.c.importer.CPreferenceStore;
import com.ibm.etools.c.importer.CTypeDescriptorBuilder;
import com.ibm.etools.c.importer.CTypeDescriptorHelper;
import com.ibm.etools.ctc.c2xsd.C2xsdPlugin;
import com.ibm.etools.ctc.c2xsd.MessageResource;
import com.ibm.etools.ctc.c2xsd.typesimport.CTypeHelper;
import com.ibm.etools.ctc.c2xsd.typesimport.GeneralUtil;
import com.ibm.etools.ctc.c2xsd.typesimport.XsdHelper;
import com.ibm.etools.typedescriptor.ArrayTD;
import com.ibm.etools.typedescriptor.BaseTDType;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import com.ibm.etools.typedescriptor.SimpleInstanceTD;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDFactoryImpl;

public class CElementVisitor {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2004 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    protected IFile cFile;
    protected XSDComplexTypeDefinition topComplexType;
    protected XSDModelGroupDefinition currParent;
    protected boolean isThisTopComplexType = true;
    protected XSDFactory xsdFactory = XSDFactoryImpl.eINSTANCE;
    protected XSDSchema xsdSchema;
    protected XsdHelper xsdHelper = XsdHelper.getInstance();
    protected CTypeHelper cHelper = CTypeHelper.getInstance();
    protected Map xsdTypesTdBasePair;
    protected GeneralUtil util;
    protected boolean overwriteTypes;
    protected String topTypeName;
    protected String currTopTypeName;
    protected String prefix = "";
    protected boolean generateFlat;
    protected Map nameXsdPair = new HashMap();
    protected Map groupParentPair = new HashMap();
    protected Map groupNamePair = new HashMap();
    protected boolean preserveCase;
    public static final int VISIT_ITEM = 1;
    public static final int VISIT_CHILDREN = 2;

    public CElementVisitor() {
        this.util = new GeneralUtil();
    }

    private void addComplexTypeOrGroupToSchema(XSDSchemaContent schemaContent) throws BaseException {
        EList schemaContents = this.xsdSchema.getContents();
        int pos = this.xsdHelper.indexInContentsList((List)schemaContents, schemaContent);
        if (!(pos < 0 || pos >= 0 && this.overwriteTypes)) {
            String errorMsg = MessageResource._ERROR_error_types_name_collision;
            Status status = new Status(4, C2xsdPlugin.getPluginID(), 4, errorMsg, null);
            throw new BaseException((IStatus)status);
        }
        this.util.replaceOrAppendToList((List)schemaContents, schemaContent, pos);
    }

    private String getParentName(XSDModelGroupDefinition parent) {
        String parentName = "";
        if (parent != null) {
            if (this.groupNamePair.containsKey(parent)) {
                parentName = (String)this.groupNamePair.get(parent);
            } else {
                parentName = parent.getName();
                if (parentName.toUpperCase().startsWith(String.valueOf(this.currTopTypeName.toUpperCase()) + "_")) {
                    parentName = parentName.substring(this.currTopTypeName.length() + 1);
                }
            }
        }
        return parentName;
    }

    private String getUniqueName(String thisName, XSDModelGroupDefinition parent) {
        boolean hasDuplication;
        if (!this.generateFlat && !this.preserveCase) {
            thisName = this.util.toLowerUpperCaseToken(thisName);
        }
        block0: do {
            if (!(hasDuplication = false)) {
                thisName = this.util.getJavaNameFromXMLName(thisName);
            }
            Iterator it = this.nameXsdPair.keySet().iterator();
            while (it.hasNext() && this.generateFlat) {
                String xsdName = (String)it.next();
                if (!thisName.equalsIgnoreCase(xsdName)) continue;
                hasDuplication = true;
                String parentName = this.getParentName(parent);
                thisName = this.util.getJavaNameFromXMLName(String.valueOf(parentName) + "_" + thisName);
                parent = (XSDModelGroupDefinition)this.groupParentPair.get(parent);
                continue block0;
            }
        } while (hasDuplication);
        return thisName;
    }

    public XSDTypeDefinition getXSDType() {
        return this.topComplexType;
    }

    public void setGenerateFlat(boolean gf) {
        this.generateFlat = gf;
    }

    public void setPreserveCase(boolean pc) {
        this.preserveCase = pc;
    }

    public void setOverwriteTypes(boolean ow) {
        this.overwriteTypes = ow;
    }

    public void setXsdSchema(XSDSchema schema) {
        this.xsdSchema = schema;
    }

    public void setXsdTypesTdBasePair(Map pair) {
        this.xsdTypesTdBasePair = pair;
    }

    public void setXsdTypeName(String newName) {
        this.topTypeName = newName;
    }

    public void setXsdTypePrefix(String newPrefix) {
        this.prefix = newPrefix == null ? "" : newPrefix;
    }

    public boolean visit(Object item) throws BaseException {
        if (item instanceof CStructured) {
            this.visitCStructured((CStructured)item, false, "", "0");
            return false;
        }
        if (item instanceof CTypedef) {
            this.visitCTypedef((CTypedef)item, null, "", "0");
            return false;
        }
        if (item instanceof CField) {
            return false;
        }
        if (item instanceof CDatatype) {
            return false;
        }
        this.acceptItemVisitor(item, 2);
        return true;
    }

    private void createTopComplexType(CClassifier item) throws BaseException {
        XSDModelGroupDefinition topGroup = this.xsdHelper.createModelGroupDefinition(item);
        this.topTypeName = String.valueOf(this.prefix) + this.util.getJavaNameFromXMLName(this.topTypeName);
        topGroup.setName(this.topTypeName);
        topGroup.setTargetNamespace(this.xsdSchema.getTargetNamespace());
        this.addComplexTypeOrGroupToSchema((XSDSchemaContent)topGroup);
        this.currParent = topGroup;
        this.groupParentPair.put(topGroup, null);
        this.groupNamePair.put(topGroup, this.topTypeName);
        this.topComplexType = this.xsdHelper.createComplexTypeDefFromGroupDef(this.xsdSchema, topGroup, topGroup.getName());
        this.addComplexTypeOrGroupToSchema((XSDSchemaContent)this.topComplexType);
        this.currTopTypeName = topGroup.getName();
        try {
            InstanceTDBase aggregateInst = CTypeDescriptorBuilder.createInstance((boolean)true);
            int instSize = CTypeDescriptorHelper.sizeof((CClassifier)item);
            aggregateInst.setSize(String.valueOf(instSize));
            aggregateInst.setContentSize(String.valueOf(instSize));
            aggregateInst.setOffset("0");
            this.xsdTypesTdBasePair.put(this.topComplexType, aggregateInst);
        }
        catch (Exception e) {
            Status s = new Status(4, C2xsdPlugin.getPluginID(), 4, e.getLocalizedMessage(), (Throwable)e);
            throw new BaseException((IStatus)s);
        }
        this.isThisTopComplexType = false;
    }

    public boolean visitCStructured(CStructured item, boolean createComplexType, String outerName, String offset) throws BaseException {
        boolean parseTopComplexType;
        XSDModelGroupDefinition prevParent = null;
        String prevTopName = "";
        if (this.isThisTopComplexType) {
            this.createTopComplexType((CClassifier)item);
            parseTopComplexType = true;
        } else {
            if (this.currParent == null) {
                this.currParent = this.xsdHelper.findModelGroupParent(CTypeHelper.getInstance().getRefName(item), this.topComplexType);
            }
            prevParent = this.currParent;
            prevTopName = this.currTopTypeName;
            String groupName = String.valueOf(this.currParent.getName()) + this.util.getJavaNameFromXMLName("_" + outerName);
            if (!this.generateFlat) {
                if (!createComplexType) {
                    XSDParticle particle = this.xsdFactory.createXSDParticle();
                    XSDElementDeclaration elementDec = this.xsdFactory.createXSDElementDeclaration();
                    elementDec.setName(this.getUniqueName(outerName, this.currParent));
                    particle.setContent((XSDParticleContent)elementDec);
                    elementDec.setTypeDefinition((XSDTypeDefinition)this.xsdHelper.getXSDStructType(this.xsdSchema, groupName));
                    List contents = this.xsdHelper.getModelGroupContentsForGroupDef(this.currParent);
                    if (contents != null) {
                        contents.add(particle);
                    }
                    try {
                        InstanceTDBase aggregateInst = CTypeDescriptorBuilder.createInstance((boolean)true);
                        int instSize = CTypeDescriptorHelper.sizeof((CClassifier)item);
                        aggregateInst.setSize(String.valueOf(instSize));
                        aggregateInst.setContentSize(String.valueOf(instSize));
                        aggregateInst.setOffset(offset);
                        this.xsdTypesTdBasePair.put(elementDec, aggregateInst);
                    }
                    catch (Exception e) {
                        Status s = new Status(4, C2xsdPlugin.getPluginID(), 4, e.getLocalizedMessage(), (Throwable)e);
                        throw new BaseException((IStatus)s);
                    }
                }
                XSDModelGroupDefinition topGroup = this.xsdHelper.createModelGroupDefinition((CClassifier)item);
                topGroup.setName(groupName);
                topGroup.setTargetNamespace(this.xsdSchema.getTargetNamespace());
                this.addComplexTypeOrGroupToSchema((XSDSchemaContent)topGroup);
                this.groupParentPair.put(topGroup, this.currParent);
                this.groupNamePair.put(topGroup, groupName);
                this.currParent = topGroup;
                XSDComplexTypeDefinition complexType = this.xsdHelper.createComplexTypeDefFromGroupDef(this.xsdSchema, topGroup, topGroup.getName());
                this.addComplexTypeOrGroupToSchema((XSDSchemaContent)complexType);
                this.currTopTypeName = topGroup.getName();
            } else {
                XSDModelGroupDefinition topGroup = this.xsdHelper.createModelGroupDefinition((CClassifier)item);
                topGroup.setName(String.valueOf(this.currParent.getName()) + this.util.getJavaNameFromXMLName("_" + outerName));
                topGroup.setTargetNamespace(this.xsdSchema.getTargetNamespace());
                this.addComplexTypeOrGroupToSchema((XSDSchemaContent)topGroup);
                this.groupParentPair.put(topGroup, this.currParent);
                this.groupNamePair.put(topGroup, outerName);
                this.currParent = topGroup;
                if (createComplexType) {
                    XSDComplexTypeDefinition complexType = this.xsdHelper.createComplexTypeDefFromGroupDef(this.xsdSchema, topGroup, topGroup.getName());
                    this.addComplexTypeOrGroupToSchema((XSDSchemaContent)complexType);
                    this.currTopTypeName = topGroup.getName();
                } else {
                    XSDModelGroupDefinition modelGroupRef = this.xsdHelper.createGroupRefForGroup(topGroup);
                    XSDParticle modelGroupParticle = this.xsdFactory.createXSDParticle();
                    modelGroupParticle.setContent((XSDParticleContent)modelGroupRef);
                    List contents = this.xsdHelper.getModelGroupContentsForGroupDef(prevParent);
                    if (contents != null) {
                        contents.add(modelGroupParticle);
                    }
                }
            }
            parseTopComplexType = false;
        }
        Map saveNameXsdPair = this.nameXsdPair;
        if (createComplexType || !this.generateFlat) {
            this.nameXsdPair = new HashMap();
        }
        this.parseStructure(item.getContains(), offset, parseTopComplexType);
        if (createComplexType || !this.generateFlat) {
            this.nameXsdPair = saveNameXsdPair;
        }
        this.currParent = prevParent;
        this.currTopTypeName = prevTopName;
        return true;
    }

    private void parseStructure(EList structItems, String offset, boolean parsingTopComplex) throws BaseException {
        if (structItems == null) {
            return;
        }
        Iterator i = structItems.iterator();
        Vector fields = new Vector();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof CField) && !(obj instanceof CStructured)) continue;
            fields.add(obj);
        }
        int j = 0;
        while (j < fields.size()) {
            Object genField = fields.get(j);
            CField field = null;
            CClassifier type = null;
            String name = "";
            if (genField instanceof CField) {
                field = (CField)genField;
                type = field.getType();
                name = field.getName();
            } else {
                type = (CClassifier)genField;
                name = ((CClassifier)type).getName();
            }
            if (j == 0 && parsingTopComplex && field != null && !field.getInstanceTDBase().getOffset().equals("0")) {
                offset = String.valueOf(Integer.parseInt(offset) - Integer.parseInt(field.getInstanceTDBase().getOffset()));
            }
            this.processType(offset, field, type, name);
            ++j;
        }
    }

    private void processType(String offset, CField field, Object type, String name) throws BaseException {
        if (type instanceof CTypedef) {
            this.visitCTypedef((CTypedef)type, field, name, offset);
        } else if (type instanceof CStructured) {
            int intOffset = new Integer(offset);
            if (field != null) {
                intOffset += new Integer(field.getInstanceTDBase().getOffset()).intValue();
            }
            this.visitCStructured((CStructured)type, false, name, new Integer(intOffset).toString());
        } else if (type instanceof CArray) {
            Object derivedType;
            int dimension;
            if (!(!this.generateFlat || (dimension = this.xsdHelper.getProductOfArrayDimensions((CArray)type)) != 1 || ((CArray)type).getDerives() instanceof CArray || (derivedType = this.cHelper.getSimplestDerivedType(((CArray)type).getDerives())) instanceof CChar && !(derivedType instanceof CSignedChar) && !(derivedType instanceof CUnsignedChar) || derivedType instanceof CUnsignedShort && CPreferenceStore.isTreatUShortArrayAsDBCS())) {
                field.getInstanceTDBase().getArrayDescr().clear();
                this.processType(offset, field, ((CArray)type).getDerives(), name);
                return;
            }
            this.visitCArray(field, (CArray)type, this.currParent, offset);
        } else if (type instanceof CDatatype) {
            this.visitCDatatype(field, (CDatatype)type, this.currParent, offset);
        } else if (type instanceof CPointer) {
            this.visitCPointer(field, (CPointer)type, this.currParent, offset);
        }
    }

    public void visitCTypedef(CTypedef type, CField item, String name, String offset) throws BaseException {
        CDerivableType derivedType = type.getDerives();
        if (derivedType instanceof CStructured) {
            int intOffset = new Integer(offset);
            if (item != null) {
                intOffset += new Integer(item.getInstanceTDBase().getOffset()).intValue();
            }
            this.visitCStructured((CStructured)derivedType, false, name, String.valueOf(intOffset));
        } else if (derivedType instanceof CTypedef) {
            this.visitCTypedef((CTypedef)derivedType, item, name, offset);
        } else {
            if (item == null) {
                this.createTopComplexType((CClassifier)type);
            }
            if (derivedType instanceof CArray) {
                this.visitCArray(item, (CArray)derivedType, this.currParent, offset);
            } else if (derivedType instanceof CPointer) {
                this.visitCPointer(item, (CPointer)derivedType, this.currParent, offset);
            } else if (derivedType instanceof CDatatype) {
                this.visitCDatatype(item, (CDatatype)derivedType, this.currParent, offset);
            }
        }
    }

    public void visitCArray(CField item, CArray type, XSDModelGroupDefinition parent, String offset) throws BaseException {
        InstanceTDBase tdBase;
        Object derivedType;
        if (parent == null) {
            parent = this.currParent;
        }
        XSDParticle elementPart = this.xsdFactory.createXSDParticle();
        XSDElementDeclaration elementDec = this.xsdFactory.createXSDElementDeclaration();
        String name = null;
        name = item != null ? item.getName() : parent.getName();
        name = this.getUniqueName(name, parent);
        elementDec.setName(name);
        elementPart.setContent((XSDParticleContent)elementDec);
        List contents = this.xsdHelper.getModelGroupContentsForGroupDef(parent);
        if (contents != null) {
            contents.add(elementPart);
        }
        if ((derivedType = this.cHelper.getSimplestDerivedType(type.getDerives())) instanceof CChar && !(derivedType instanceof CSignedChar) && !(derivedType instanceof CUnsignedChar) || derivedType instanceof CUnsignedShort && CPreferenceStore.isTreatUShortArrayAsDBCS()) {
            elementDec.setAnonymousTypeDefinition((XSDTypeDefinition)this.xsdHelper.getXSDArrayType(type, this.xsdSchema, this.getParentName(parent), name));
        } else if (derivedType instanceof CArray) {
            Object secDerivedType = this.cHelper.getSimplestArrayDerivedType(((CArray)derivedType).getDerives());
            if (secDerivedType instanceof CChar && !(secDerivedType instanceof CSignedChar) && !(secDerivedType instanceof CUnsignedChar) || secDerivedType instanceof CUnsignedShort && CPreferenceStore.isTreatUShortArrayAsDBCS()) {
                elementDec.setAnonymousTypeDefinition((XSDTypeDefinition)this.xsdHelper.getXSDArrayType((CArray)derivedType, this.xsdSchema, this.getParentName(parent), name));
            } else {
                elementDec.setTypeDefinition((XSDTypeDefinition)this.xsdHelper.getXSDArrayType((CArray)derivedType, this.xsdSchema, this.getParentName(parent), name));
            }
            int arrayDim = this.xsdHelper.getProductOfArrayDimensions(type);
            elementPart.setMinOccurs(arrayDim);
            elementPart.setMaxOccurs(arrayDim);
        } else if (derivedType instanceof CPointer) {
            tdBase = null;
            if (item != null) {
                tdBase = item.getInstanceTDBase();
            } else {
                try {
                    tdBase = CTypeDescriptorBuilder.createInstanceForField((CClassifier)type);
                }
                catch (Exception e) {
                    Status s = new Status(4, C2xsdPlugin.getPluginID(), 4, e.getLocalizedMessage(), (Throwable)e);
                    throw new BaseException((IStatus)s);
                }
            }
            ArrayTD arrayTD = (ArrayTD)tdBase.getArrayDescr().get(0);
            String size = arrayTD.getStride();
            elementDec.setAnonymousTypeDefinition((XSDTypeDefinition)this.xsdHelper.getXSDPointerType((CPointer)derivedType, this.xsdSchema, size));
            elementPart.setMinOccurs(type.getDimension().intValue());
            elementPart.setMaxOccurs(type.getDimension().intValue());
        } else {
            elementDec.setTypeDefinition((XSDTypeDefinition)this.xsdHelper.getXSDArrayType(type, this.xsdSchema, parent.getName(), name));
            elementPart.setMinOccurs(type.getDimension().intValue());
            elementPart.setMaxOccurs(type.getDimension().intValue());
        }
        tdBase = null;
        if (item != null) {
            tdBase = this.cHelper.cloneTDBase(item.getInstanceTDBase(), offset);
        } else {
            try {
                tdBase = CTypeDescriptorBuilder.createInstanceForField((CClassifier)type);
            }
            catch (Exception e) {
                Status s = new Status(4, C2xsdPlugin.getPluginID(), 4, e.getLocalizedMessage(), (Throwable)e);
                throw new BaseException((IStatus)s);
            }
            tdBase.setOffset(offset);
        }
        this.xsdTypesTdBasePair.put(elementDec, tdBase);
        this.nameXsdPair.put(elementDec.getName(), elementDec);
        if (derivedType instanceof CArray) {
            derivedType = this.cHelper.getSimplestArrayDerivedType(((CArray)derivedType).getDerives());
        }
        if (derivedType instanceof CStructured) {
            int intOffset = new Integer(offset);
            if (item != null) {
                intOffset += new Integer(item.getInstanceTDBase().getOffset()).intValue();
            }
            this.visitCStructured((CStructured)derivedType, true, name, String.valueOf(intOffset));
        }
    }

    public void visitCDatatype(CField item, CDatatype type, XSDModelGroupDefinition parent, String offset) throws BaseException {
        if (parent == null) {
            parent = this.currParent;
        }
        String name = null;
        name = item != null ? item.getName() : parent.getName();
        if (type instanceof CBitField && (name == null || name.length() == 0)) {
            return;
        }
        XSDParticle elementPart = this.xsdFactory.createXSDParticle();
        XSDElementDeclaration elementDec = this.xsdFactory.createXSDElementDeclaration();
        elementDec.setName(this.getUniqueName(name, parent));
        if (type instanceof CChar && !(type instanceof CSignedChar) && !(type instanceof CUnsignedChar)) {
            elementDec.setAnonymousTypeDefinition((XSDTypeDefinition)this.xsdHelper.getXSDSimpleType(type, this.xsdSchema));
        } else {
            elementDec.setTypeDefinition((XSDTypeDefinition)this.xsdHelper.getXSDSimpleType(type, this.xsdSchema));
        }
        elementPart.setContent((XSDParticleContent)elementDec);
        List contents = this.xsdHelper.getModelGroupContentsForGroupDef(parent);
        if (contents != null) {
            contents.add(elementPart);
        }
        InstanceTDBase tdBase = null;
        if (item != null) {
            tdBase = this.cHelper.cloneTDBase(item.getInstanceTDBase(), offset);
        } else {
            tdBase = CTypeDescriptorBuilder.createInstance((boolean)false);
            int instSize = CTypeDescriptorHelper.sizeof((CClassifier)type);
            tdBase.setSize(String.valueOf(instSize));
            tdBase.setContentSize(String.valueOf(instSize));
            BaseTDType sharedType = null;
            try {
                sharedType = CTypeDescriptorBuilder.getTDType((CClassifier)type);
            }
            catch (Exception e) {
                Status s = new Status(4, C2xsdPlugin.getPluginID(), 4, e.getLocalizedMessage(), (Throwable)e);
                throw new BaseException((IStatus)s);
            }
            if (sharedType != null) {
                ((SimpleInstanceTD)tdBase).setSharedType(sharedType);
            }
            tdBase.setOffset(offset);
        }
        this.xsdTypesTdBasePair.put(elementDec, tdBase);
        this.nameXsdPair.put(elementDec.getName(), elementDec);
    }

    public void visitCPointer(CField item, CPointer type, XSDModelGroupDefinition parent, String offset) throws BaseException {
        if (parent == null) {
            parent = this.currParent;
        }
        XSDParticle elementPart = this.xsdFactory.createXSDParticle();
        XSDElementDeclaration elementDec = this.xsdFactory.createXSDElementDeclaration();
        String name = null;
        name = item != null ? item.getName() : parent.getName();
        elementDec.setName(this.getUniqueName(name, parent));
        InstanceTDBase tdBase = null;
        if (item != null) {
            tdBase = this.cHelper.cloneTDBase(item.getInstanceTDBase(), offset);
        } else {
            tdBase = CTypeDescriptorBuilder.createInstance((boolean)false);
            int instSize = CTypeDescriptorHelper.sizeof((CClassifier)type);
            tdBase.setSize(String.valueOf(instSize));
            tdBase.setContentSize(String.valueOf(instSize));
            BaseTDType sharedType = null;
            try {
                sharedType = CTypeDescriptorBuilder.getTDType((CClassifier)type);
            }
            catch (Exception e) {
                Status s = new Status(4, C2xsdPlugin.getPluginID(), 4, e.getLocalizedMessage(), (Throwable)e);
                throw new BaseException((IStatus)s);
            }
            if (sharedType != null) {
                ((SimpleInstanceTD)tdBase).setSharedType(sharedType);
            }
            tdBase.setOffset(offset);
        }
        elementDec.setAnonymousTypeDefinition((XSDTypeDefinition)this.xsdHelper.getXSDPointerType(type, this.xsdSchema, tdBase.getSize()));
        elementPart.setContent((XSDParticleContent)elementDec);
        List contents = this.xsdHelper.getModelGroupContentsForGroupDef(parent);
        if (contents != null) {
            contents.add(elementPart);
        }
        this.xsdTypesTdBasePair.put(elementDec, tdBase);
        this.nameXsdPair.put(elementDec.getName(), elementDec);
    }

    public void acceptItemVisitor(Object item, int depth) throws BaseException {
        if (depth == 1) {
            this.visit(item);
            return;
        }
        if (depth == 2) {
            depth = 1;
        }
        if (item instanceof CStructured) {
            CStructured structure = (CStructured)item;
            EList contents = structure.getContains();
            Iterator iter = contents.iterator();
            while (iter.hasNext()) {
                this.acceptItemVisitor(iter.next(), depth);
            }
        } else if (item instanceof CTypedElement) {
            CTypedElement element = (CTypedElement)item;
            CClassifier classifier = element.getType();
            this.acceptItemVisitor(classifier, depth);
        }
    }
}

