/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui.internal.widgets;

import com.ibm.etools.annotations.core.data.AnnotatedClassInfo;
import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.data.JavaElementInfo;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.etools.annotations.core.properties.ArrayAnnotationArgumentProperty;
import com.ibm.etools.annotations.core.properties.SingleAnnotationArgumentProperty;
import com.ibm.etools.annotations.core.properties.SingleValueArgumentProperty;
import com.ibm.etools.annotations.core.utils.AnnotationUtils;
import com.ibm.etools.annotations.ui.Activator;
import com.ibm.etools.annotations.ui.internal.data.AnnotationAttributeNodeSynchronizer;
import com.ibm.etools.annotations.ui.internal.data.AnnotationViewOverlayInfo;
import com.ibm.etools.annotations.ui.internal.data.EditAnnotationAction;
import com.ibm.etools.annotations.ui.internal.messages.AnnotationsUIMessages;
import com.ibm.etools.annotations.ui.internal.properties.AnnotationAttributeNodeProperty;
import com.ibm.etools.annotations.ui.internal.properties.AnnotationAttributePropertyGroup;
import com.ibm.etools.annotations.ui.internal.properties.AnnotationNodeProperty;
import com.ibm.etools.annotations.ui.internal.properties.JavaElementNodeProperty;
import com.ibm.etools.annotations.ui.internal.properties.UnknownAnnotationNodeProperty;
import com.ibm.etools.annotations.ui.internal.providers.AnnotationTreeLabelProvider;
import com.ibm.etools.annotations.ui.internal.utils.AnnotationUIUtils;
import com.ibm.etools.annotations.ui.internal.widgets.AnnotationAttributesUIWidget;
import com.ibm.etools.annotations.ui.internal.widgets.ArrayAnnotationArgumentPropertyUIWidget;
import com.ibm.etools.annotations.ui.internal.widgets.SingleAnnotationArgumentPropertyUIWidget;
import com.ibm.propertygroup.INodeProperty;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.spi.BaseNodeProperty;
import com.ibm.propertygroup.ui.datastores.DynamicGenStore;
import com.ibm.propertygroup.ui.internal.controls.NewPatternFilter;
import com.ibm.propertygroup.ui.internal.controls.ToolBarComposite;
import com.ibm.propertygroup.ui.internal.controls.ToolBarFilteredTreeViewer;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.listener.IPropertyUIChangeListener;
import com.ibm.propertygroup.ui.utilities.PropertyUIComposite;
import com.ibm.propertygroup.ui.utilities.PropertyUIFactory;
import com.ibm.propertygroup.ui.utilities.PropertyUIWidget;
import com.ibm.propertygroup.ui.widgets.PropertyUIScrollableComposite;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.details.JpaDetailsPage;
import org.eclipse.jpt.ui.details.JpaDetailsProvider;
import org.eclipse.jpt.ui.internal.platform.JpaPlatformUiRegistry;
import org.eclipse.jpt.ui.internal.widgets.PropertySheetWidgetFactory;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class AnnotationTreeWidget {
    public static final String ANNOTATION_TREE_ROOT_NODE_NAME = "Root";
    protected Image attributesImage_ = Activator.getImageDescriptor("icons/obj16/attribute_list.gif").createImage();
    protected Image jpaDetailsImage_ = Activator.getImageDescriptor("icons/obj16/jpa_details.gif").createImage();
    protected SashForm sashForm_;
    protected Composite javaElementInfoArea_;
    protected Composite emptyComposite_;
    protected TabFolder tabFolder_ = null;
    protected ToolBarComposite toolbarComposite_;
    protected TreeViewer treeViewer_;
    protected ScrolledComposite propertiesArea_;
    protected Label noProperties_;
    protected IContentProvider treeContentProvider_;
    protected IBaseLabelProvider treeLabelProvider_;
    protected TreeItem selectedItem_;
    protected AnnotationViewAttributesUIWidget attributesUIWidget_;
    protected PropertyUIFactory uiFactory_;
    protected AnnotatedClassInfo annotationModel_;
    protected ArrayList<IPropertyChangeListener> propertyListeners_;
    protected ArrayList<IPropertyUIChangeListener> uiListeners_;
    protected PropertyUIComposite propertyUIComposite_;
    protected AnnotationNodeProperty defaultAnnotationNodeProperty_;
    protected List<AnnotationInfo> annotationInfos_;
    protected DynamicGenStore dgStore_;
    protected int offset_ = -1;
    protected AnnotationAttributeNodeSynchronizer aaNodeSynchronizer_;
    protected EditAnnotationAction annotationAttributeEditAction_;
    protected Job populateProjectAnnotationJob_ = null;
    protected Hashtable<String, JpaPageInfo> jpaDetailsPages_;
    protected boolean stopDisplayingAttributeArea_ = false;

    public AnnotationTreeWidget(DynamicGenStore dgStore, AnnotatedClassInfo aci, ArrayList<IPropertyChangeListener> pListeners, ArrayList<IPropertyUIChangeListener> uiListeners) {
        this.annotationModel_ = aci;
        this.propertyListeners_ = pListeners;
        this.uiListeners_ = uiListeners;
        this.dgStore_ = dgStore;
        this.annotationAttributeEditAction_ = new AnnotationAttributeEditAction();
        this.jpaDetailsPages_ = new Hashtable();
    }

    public void createControls(Composite parent, PropertyUIFactory uiFactory) throws CoreException {
        this.uiFactory_ = uiFactory;
        IPropertyUIWidgetFactory factory = uiFactory.getUIFactory();
        this.createContainers(parent, factory);
        this.createTreeViewer((Composite)this.sashForm_.getChildren()[0], factory);
        this.createPropertyArea((Composite)this.sashForm_.getChildren()[1], factory);
        this.createJavaEEHelpLink((Composite)this.sashForm_.getChildren()[1], factory);
        this.createAttributesUIWidget();
        this.initTreeViewer();
        this.initSashForm();
    }

    protected void createContainers(Composite parent, IPropertyUIWidgetFactory factory) {
        this.sashForm_ = factory.createSashForm(parent, 256);
        Composite treeComposite = factory.createComposite((Composite)this.sashForm_, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        treeComposite.setLayout((Layout)layout);
        treeComposite.setLayoutData((Object)new GridData(1808));
        Composite propertyComposite = factory.createComposite((Composite)this.sashForm_, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        propertyComposite.setLayout((Layout)layout);
        propertyComposite.setLayoutData((Object)new GridData(1808));
    }

    protected void createTreeViewer(Composite treeComposite, IPropertyUIWidgetFactory factory) {
        this.toolbarComposite_ = factory.createToolBarComposite(treeComposite, factory.getBorderStyle());
        this.toolbarComposite_.setLayoutData((Object)new GridData(1808));
        ToolBar toolBar = this.toolbarComposite_.getToolBarManager().getControl();
        toolBar.setBackground(toolBar.getParent().getBackground());
        GridData gd = new GridData(128);
        toolBar.setLayoutData((Object)gd);
        toolBar.getParent().layout();
        ToolBarFilteredTreeViewer filteredTree = new ToolBarFilteredTreeViewer((Composite)this.toolbarComposite_, 0, new NewPatternFilter());
        filteredTree.setBackground(treeComposite.getDisplay().getSystemColor(25));
        this.treeViewer_ = filteredTree.getViewer();
        gd = new GridData(1808);
        gd.widthHint = 68;
        this.treeViewer_.getTree().setLayoutData((Object)gd);
        this.toolbarComposite_.setControl((Control)filteredTree);
        this.aaNodeSynchronizer_ = new AnnotationAttributeNodeSynchronizer(this.treeViewer_);
    }

    protected void createPropertyArea(Composite group, IPropertyUIWidgetFactory factory) {
        this.propertiesArea_ = factory.createScrolledComposite(group, 768);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginHeight = 0;
        this.propertiesArea_.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.widthHint = 138;
        this.propertiesArea_.setLayoutData((Object)gd);
        this.noProperties_ = factory.createLabel((Composite)this.propertiesArea_, "", 0);
        this.emptyComposite_ = factory.createComposite((Composite)this.propertiesArea_, 0);
        this.emptyComposite_.setLayout((Layout)new GridLayout());
        this.emptyComposite_.setLayoutData((Object)new GridData(1808));
        this.propertiesArea_.setContent((Control)this.noProperties_);
        this.propertiesArea_.setMinSize(this.noProperties_.computeSize(-1, -1));
    }

    protected void createJavaEEHelpLink(Composite group, IPropertyUIWidgetFactory factory) {
        Composite container = factory.createComposite(group, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 10;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(896));
        Hyperlink link = factory.createHyperlink(container, 64);
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                String helpId = "/com.ibm.jee5.doc/topics/cannotations.html";
                PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(helpId);
            }
        });
        link.setUnderlined(true);
        link.setText(AnnotationsUIMessages.ANNOTATIONS_UI_LABEL_JAVA_EE5_SUPPORT_FOR_ANNOTATIONS);
        link.setLayoutData((Object)new GridData(768));
        link.setForeground(group.getDisplay().getSystemColor(10));
    }

    protected void initTreeViewer() throws CoreException {
        this.treeViewer_.setContentProvider(this.getTreeContentProvider());
        this.treeViewer_.setLabelProvider(this.getTreeLabelProvider());
        this.treeViewer_.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(final SelectionChangedEvent event) {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AnnotationTreeWidget.this.performSelectTreeItem(event);
                    }
                });
            }
        });
        this.buildAnnotationTreeInput();
    }

    protected void initSashForm() {
        this.sashForm_.setWeights(new int[]{35, 65});
        if (this.treeViewer_.getInput() == null) {
            this.sashForm_.setMaximizedControl(this.sashForm_.getChildren()[0]);
        }
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.heightHint = 230;
        gridData.widthHint = 220;
        this.sashForm_.setLayoutData((Object)gridData);
        this.sashForm_.layout(true);
    }

    protected void createAttributesUIWidget() {
        this.attributesUIWidget_ = new AnnotationViewAttributesUIWidget(this.dgStore_, this.uiFactory_);
    }

    public void setTreeLabelProvider(IBaseLabelProvider newProvider) {
        this.treeLabelProvider_ = newProvider;
    }

    public IBaseLabelProvider getTreeLabelProvider() {
        if (this.treeLabelProvider_ == null) {
            this.treeLabelProvider_ = new AnnotationTreeLabelProvider();
        }
        return this.treeLabelProvider_;
    }

    public void setTreeContentProvider(IContentProvider newProvider) {
        this.treeContentProvider_ = newProvider;
    }

    public IContentProvider getTreeContentProvider() {
        if (this.treeContentProvider_ == null) {
            this.treeContentProvider_ = new TreeElementContentProvider();
        }
        return this.treeContentProvider_;
    }

    public void changeAnnotationModel(AnnotatedClassInfo newModel, int offset) throws CoreException {
        if (newModel != null && newModel.equals(this.annotationModel_) || newModel == null && this.annotationModel_ == null) {
            return;
        }
        Object input = this.treeViewer_.getInput();
        if (input != null && input instanceof INodeProperty) {
            this.removePropertyChangeListeners((INodeProperty)input);
        }
        this.annotationModel_ = newModel;
        this.offset_ = offset;
        this.buildAnnotationTreeInput();
        if (this.treeViewer_.getInput() == null) {
            this.sashForm_.setMaximizedControl(this.sashForm_.getChildren()[0]);
        } else {
            this.sashForm_.setMaximizedControl(null);
            this.sashForm_.setWeights(new int[]{35, 65});
        }
    }

    public void clearAnnotationTreeWidget() {
        if (this.propertyUIComposite_ != null && this.uiListeners_ != null && !this.uiListeners_.isEmpty()) {
            int i = 0;
            while (i < this.uiListeners_.size()) {
                this.propertyUIComposite_.removePropertyUIChangeListener(this.uiListeners_.get(i));
                ++i;
            }
        }
        if (this.javaElementInfoArea_ != null && !this.javaElementInfoArea_.isDisposed() && this.javaElementInfoArea_.getChildren().length > 0) {
            Control[] children = this.javaElementInfoArea_.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        this.attributesUIWidget_.clearWidget();
        Object input = this.treeViewer_.getInput();
        if (input != null && input instanceof INodeProperty) {
            this.removePropertyChangeListeners((INodeProperty)input);
        }
        this.aaNodeSynchronizer_.clearSynchronizer();
        this.defaultAnnotationNodeProperty_ = null;
        this.offset_ = -1;
        this.annotationModel_ = null;
        this.annotationInfos_ = null;
        this.selectedItem_ = null;
        if (input != null) {
            this.treeViewer_.setInput(null);
            this.sashForm_.setMaximizedControl(this.sashForm_.getChildren()[0]);
        }
    }

    public List<AnnotationInfo> getAnnotationInfoList() {
        return this.annotationInfos_;
    }

    public AnnotationNodeProperty getDefaultAnnotationNode() {
        return this.defaultAnnotationNodeProperty_;
    }

    public AnnotationInfo getDefaultAnnotationInfo() {
        return this.defaultAnnotationNodeProperty_ != null ? this.defaultAnnotationNodeProperty_.getAnnotationInfo() : null;
    }

    public TreeItem getAnnotationTreeItem(AnnotationInfo annoInfo) {
        TreeItem item = null;
        if (annoInfo != null) {
            IPath path = AnnotationUIUtils.buildAnnotationKey(annoInfo);
            TreeItem[] treeItems = this.treeViewer_.getTree().getItems();
            item = this.findAnnotationParentTreeItem(treeItems, path, 0);
            if (item == null) {
                ICompilationUnit unit = this.getCompilationUnit();
                IType type = null;
                if (unit != null) {
                    try {
                        IType[] types = unit.getAllTypes();
                        if (types != null && types.length > 0) {
                            type = types[0];
                        }
                    }
                    catch (Exception e) {
                        AnnotationUIUtils.showExceptionMessage(e, this.getShell(), null, e.getMessage());
                    }
                }
                if (type != null) {
                    Path newPath = new Path(type.getElementName());
                    newPath = newPath.append(AnnotationsUIMessages.ANNOTATIONS_UI_PROPERTY_UNKNOWN_ANNOTATION);
                    item = this.findAnnotationParentTreeItem(treeItems, (IPath)newPath, 0);
                }
            }
            if (item != null) {
                item = this.findAnnotationTreeItem(item, annoInfo);
            }
        }
        return item;
    }

    protected TreeItem findAnnotationTreeItem(TreeItem parentItem, AnnotationInfo annoInfo) {
        TreeItem[] annIs = parentItem.getItems();
        if (annIs != null) {
            String annoSegmentName = AnnotationUIUtils.buildAnnotationSegmentName(annoInfo);
            int nsIndex = annoSegmentName.lastIndexOf("@#");
            int start = 0;
            if (nsIndex != -1) {
                start = Integer.parseInt(annoSegmentName.substring(nsIndex + "@#".length()));
            }
            int i = start;
            while (i < annIs.length) {
                TreeItem annI = annIs[i];
                Object itemData = annI.getData();
                if (itemData instanceof AnnotationNodeProperty && this.sameAnnotationInfo(((AnnotationNodeProperty)((Object)itemData)).getAnnotationInfo(), annoInfo)) {
                    return annI;
                }
                ++i;
            }
        }
        return null;
    }

    public TreeItem getJavaElementTreeItem(IJavaElement javaElement) {
        if (javaElement != null) {
            IPath path = null;
            String name = AnnotationUIUtils.getJavaElementName(javaElement);
            if (name != null) {
                path = AnnotationUIUtils.buildFullQualifiedPath(javaElement, name);
            }
            if (path != null) {
                return this.findAnnotationParentTreeItem(this.treeViewer_.getTree().getItems(), path, 0);
            }
        }
        return null;
    }

    public void showFilterTextField(boolean checked) {
        ((ToolBarFilteredTreeViewer)this.toolbarComposite_.getControl()).showFilterTextField(checked);
    }

    protected TreeItem findAnnotationParentTreeItem(TreeItem[] items, IPath path, int index) {
        if (items != null) {
            String segment = path.segment(index);
            int start = 0;
            int nsIndex = segment.lastIndexOf("@#");
            if (nsIndex != -1) {
                start = Integer.parseInt(segment.substring(nsIndex + "@#".length()));
                segment = segment.substring(0, nsIndex);
            }
            int i = start;
            while (i < items.length) {
                if (items[i].getText().endsWith(segment)) {
                    Object data = items[i].getData();
                    this.treeViewer_.expandToLevel(data, 1);
                    if (index == path.segmentCount() - 1) {
                        return items[i];
                    }
                    return this.findAnnotationParentTreeItem(items[i].getItems(), path, index + 1);
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean sameAnnotationInfo(AnnotationInfo info1, AnnotationInfo info2) {
        if (info1 == info2) {
            return true;
        }
        if (info1 == null) return false;
        if (info2 == null) {
            return false;
        }
        try {
            IPath path2;
            if (!info1.getName().equals(info2.getName())) {
                return false;
            }
            IPath path1 = AnnotationUIUtils.buildAnnotationKey(info1);
            if (!path1.equals((Object)(path2 = AnnotationUIUtils.buildAnnotationKey(info2)))) {
                return false;
            }
            List attributes1 = info1.getAllAttributes();
            List attributes2 = info2.getAllAttributes();
            if (attributes1.size() != attributes2.size()) {
                return false;
            }
            int i = 0;
            while (true) {
                String typeName2;
                if (i >= attributes1.size()) {
                    return true;
                }
                IAnnotationAttributeProperty aap1 = (IAnnotationAttributeProperty)attributes1.get(i);
                IAnnotationAttributeProperty aap2 = (IAnnotationAttributeProperty)attributes2.get(i);
                if (!aap1.getName().equals(aap2.getName())) {
                    return false;
                }
                String typeName1 = aap1.getPropertyType().getType().toString();
                if (!typeName1.equals(typeName2 = aap2.getPropertyType().getType().toString())) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ArrayList<PropertyUIWidget> getPropertyWidgets() {
        if (this.propertyUIComposite_ != null) {
            return this.propertyUIComposite_.getUIWidgets();
        }
        return null;
    }

    public void select(int offset) {
        TreeItem item = this.getTreeItemByOffset(offset);
        this.offset_ = offset;
        this.selectTreeItem(item, true);
    }

    public AnnotationInfo select(IJavaElement je, String annotationLabelName) {
        TreeItem parentItem = this.getJavaElementTreeItem(je);
        TreeItem annoItem = null;
        AnnotationInfo retInfo = null;
        if (parentItem != null && parentItem.getItems() != null) {
            TreeItem[] annIs = parentItem.getItems();
            int i = 0;
            while (i < annIs.length) {
                TreeItem annI = annIs[i];
                Object itemData = annI.getData();
                if (itemData instanceof AnnotationNodeProperty && annI.getText().equals(annotationLabelName)) {
                    annoItem = annI;
                    retInfo = ((AnnotationNodeProperty)((Object)itemData)).getAnnotationInfo();
                    break;
                }
                ++i;
            }
        }
        if (annoItem != null) {
            this.selectTreeItem(annoItem, false);
        }
        return retInfo;
    }

    public boolean isFocusAttribute(IAnnotationAttributeProperty attribute) {
        PropertyUIWidget widget;
        return this.propertyUIComposite_ != null && (widget = this.propertyUIComposite_.getUIWidget(attribute.getName())) != null;
    }

    public IAnnotationAttributeProperty getFocusAttribute(IAnnotationAttributeProperty attribute) {
        PropertyUIWidget widget;
        if (this.propertyUIComposite_ != null && (widget = this.propertyUIComposite_.getUIWidget(attribute.getName())) != null) {
            List attributes;
            AnnotationInfo annoInfo = attribute.getParentAnnotation();
            if (!annoInfo.isImpliedAnnotation() && annoInfo.getAnnotation() == null && this.annotationInfos_ != null && (attributes = annoInfo.getDeclaredAttributes()) != null && !attributes.isEmpty()) {
                int i = 0;
                block0: while (i < attributes.size()) {
                    IAnnotationAttributeProperty attr = (IAnnotationAttributeProperty)attributes.get(i);
                    if (attribute.getName().equals(attr.getName())) {
                        int j = 0;
                        while (j < this.annotationInfos_.size()) {
                            AnnotationInfo newAnnoInfo = this.annotationInfos_.get(j);
                            if (this.sameAnnotationInfo(annoInfo, newAnnoInfo)) {
                                annoInfo.setAnnotation(newAnnoInfo.getAnnotation());
                                if (annoInfo.getParentElementInfo() != null) break block0;
                                annoInfo.setParentElementInfo(newAnnoInfo.getParentElementInfo());
                                break block0;
                            }
                            ++j;
                        }
                        break;
                    }
                    ++i;
                }
            }
            return attribute;
        }
        return null;
    }

    protected void selectTreeItem(TreeItem item, boolean unselectable) {
        Object data = null;
        Object object = data = item != null ? item.getData() : null;
        if (data != null) {
            this.treeViewer_.setSelection((ISelection)new StructuredSelection(data), true);
        } else if (unselectable) {
            this.treeViewer_.setSelection(null, true);
        }
    }

    public IAnnotationAttributeProperty setFocusTo(IAnnotationAttributeProperty attribute) {
        IAnnotationAttributeProperty retAttribute = attribute;
        AnnotationInfo annoInfo = attribute.getParentAnnotation();
        TreeItem item = this.getAnnotationTreeItem(annoInfo);
        if (item != null) {
            this.selectTreeItem(item, true);
            if (annoInfo.isImpliedAnnotation() || annoInfo.getAnnotation() == null) {
                annoInfo = ((AnnotationNodeProperty)((Object)item.getData())).getAnnotationInfo();
                List attributes = annoInfo.getDeclaredAttributes();
                if (attributes != null && !attributes.isEmpty()) {
                    int i = 0;
                    while (i < attributes.size()) {
                        IAnnotationAttributeProperty attr = (IAnnotationAttributeProperty)attributes.get(i);
                        if (attribute.getName().equals(attr.getName())) {
                            retAttribute = attr;
                            break;
                        }
                        ++i;
                    }
                }
            } else if (this.propertyUIComposite_ != null && !this.stopDisplayingAttributeArea_) {
                PropertyUIWidget widget;
                if (this.tabFolder_ != null && !this.tabFolder_.isDisposed() && this.tabFolder_.getSelection().length > 0) {
                    this.tabFolder_.setSelection(1);
                }
                if ((widget = this.propertyUIComposite_.getUIWidget(attribute.getName())) != null) {
                    Control control = widget.getDefaultFocusControl();
                    retAttribute = (IAnnotationAttributeProperty)widget.getProperty();
                    if (control != null) {
                        control.setFocus();
                        if (control instanceof Text) {
                            int stringLength = ((Text)control).getText().length();
                            ((Text)control).setSelection(stringLength, stringLength);
                        } else if (control instanceof Combo) {
                            int stringLength = ((Combo)control).getText().length();
                            ((Combo)control).setSelection(new Point(stringLength, stringLength));
                        } else if (control instanceof CCombo) {
                            int stringLength = ((CCombo)control).getText().length();
                            ((CCombo)control).setSelection(new Point(stringLength, stringLength));
                        }
                    }
                }
            }
        }
        return retAttribute;
    }

    protected TreeItem getTreeItemByOffset(int offset) {
        ICompilationUnit unit = this.getCompilationUnit();
        if (offset >= 0 && unit != null) {
            AnnotationInfo defaultAnnotationInfo = null;
            int i = 0;
            while (i < this.annotationInfos_.size()) {
                AnnotationInfo ai = this.annotationInfos_.get(i);
                if (!ai.isImpliedAnnotation() && ai.getAnnotation() != null && (ai = this.checkAnnotationInfoByOffset(ai, offset)) != null) {
                    defaultAnnotationInfo = ai;
                    break;
                }
                ++i;
            }
            if (defaultAnnotationInfo == null) {
                try {
                    return this.getJavaElementTreeItem(unit.getElementAt(offset));
                }
                catch (Exception e) {
                    AnnotationUIUtils.showExceptionMessage(e, this.getShell(), null, e.getMessage());
                }
            } else {
                return this.getAnnotationTreeItem(defaultAnnotationInfo);
            }
        }
        return null;
    }

    protected AnnotationInfo checkAnnotationInfoByOffset(AnnotationInfo info, int offset) {
        IAnnotation annotation = info.getAnnotation();
        if (annotation != null) {
            try {
                ISourceRange range = annotation.getSourceRange();
                int iStart = range.getOffset();
                int length = range.getLength();
                if (offset >= iStart && offset <= iStart + length) {
                    List attributes = info.getAllAttributes();
                    if (attributes != null && !attributes.isEmpty()) {
                        int i = 0;
                        while (i < attributes.size()) {
                            Object[] values;
                            IAnnotationAttributeProperty attribute = (IAnnotationAttributeProperty)attributes.get(i);
                            if (attribute instanceof SingleAnnotationArgumentProperty) {
                                AnnotationInfo annoInfo = (AnnotationInfo)((SingleAnnotationArgumentProperty)attribute).getValue();
                                if (annoInfo != null) {
                                    annoInfo = this.checkAnnotationInfoByOffset(annoInfo, offset);
                                }
                                if (annoInfo != null) {
                                    return annoInfo;
                                }
                            } else if (attribute instanceof ArrayAnnotationArgumentProperty && (values = ((ArrayAnnotationArgumentProperty)attribute).getValues()) != null && values.length > 0) {
                                int j = 0;
                                while (j < values.length) {
                                    AnnotationInfo annoInfo = (AnnotationInfo)values[j];
                                    if (annoInfo != null) {
                                        annoInfo = this.checkAnnotationInfoByOffset(annoInfo, offset);
                                    }
                                    if (annoInfo != null) {
                                        return annoInfo;
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                    }
                    return info;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public void refreshAnnotationModel() {
        try {
            this.buildAnnotationTreeInput();
        }
        catch (Exception e) {
            AnnotationUIUtils.showExceptionMessage(e, this.getShell(), null, e.getMessage());
        }
        if (this.treeViewer_.getInput() == null) {
            this.sashForm_.setMaximizedControl(this.sashForm_.getChildren()[0]);
        } else {
            this.sashForm_.setMaximizedControl(null);
            this.sashForm_.setWeights(new int[]{35, 65});
        }
    }

    protected void performSelectTreeItem(SelectionChangedEvent event) {
        TreeItem[] selectedItems = this.treeViewer_.getTree().getSelection();
        final TreeItem selected = selectedItems.length == 1 ? selectedItems[0] : null;
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (selected != null) {
                    if (!selected.equals(AnnotationTreeWidget.this.selectedItem_)) {
                        BaseNodeProperty node = (BaseNodeProperty)selected.getData();
                        node.setHighLighted();
                        if (!AnnotationTreeWidget.this.stopDisplayingAttributeArea_) {
                            IPropertyGroup pg = node.getActiveConfigurationProperties();
                            AnnotationTreeWidget.this.displayProperties(pg, AnnotationTreeWidget.this.selectedItem_, selected);
                        }
                    }
                } else if (!AnnotationTreeWidget.this.stopDisplayingAttributeArea_) {
                    AnnotationTreeWidget.this.displayProperties(null, AnnotationTreeWidget.this.selectedItem_, selected);
                }
                AnnotationTreeWidget.this.selectedItem_ = selected;
            }
        });
    }

    protected void buildAnnotationTreeInput() throws CoreException {
        JavaElementNodeProperty root = null;
        this.defaultAnnotationNodeProperty_ = null;
        this.selectedItem_ = null;
        this.aaNodeSynchronizer_.clearSynchronizer();
        List ais = AnnotationUtils.getAnnotationInfosForJavaElementInfo((AnnotatedClassInfo)this.annotationModel_, (boolean)false);
        if (ais != null && !ais.isEmpty()) {
            INodeProperty[] children;
            ICompilationUnit unit = this.getCompilationUnit();
            root = new JavaElementNodeProperty(ANNOTATION_TREE_ROOT_NODE_NAME, ANNOTATION_TREE_ROOT_NODE_NAME, ANNOTATION_TREE_ROOT_NODE_NAME, null);
            ArrayList<AnnotationInfo> copiedList = new ArrayList<AnnotationInfo>(ais);
            IType[] types = unit.getAllTypes();
            if (types != null && types.length > 0) {
                this.createAnnotationTreeNodesForClass(root, copiedList, unit.getAllTypes()[0], this.propertyListeners_);
            }
            if (!copiedList.isEmpty()) {
                int index = 0;
                int i = 0;
                while (i < copiedList.size()) {
                    IJavaElement je;
                    JavaElementInfo jei = copiedList.get(i).getParentJavaElementInfo();
                    if (jei != null && (je = jei.getJavaElement()).getElementType() == 11) {
                        BaseNodeProperty packageNode = this.buildJavaElementNodeProperty(copiedList, je, this.propertyListeners_);
                        root.addChild(index++, (INodeProperty)packageNode);
                    }
                    ++i;
                }
            }
            if (!copiedList.isEmpty() && (children = root.getChildren()).length > 0) {
                JavaElementNodeProperty jenp = (JavaElementNodeProperty)children[children.length - 1];
                UnknownAnnotationNodeProperty unknownNode = new UnknownAnnotationNodeProperty();
                int i = 0;
                while (i < copiedList.size()) {
                    unknownNode.addChild((INodeProperty)new AnnotationNodeProperty(copiedList.get(i), this.propertyListeners_));
                    ++i;
                }
                jenp.addChild((INodeProperty)unknownNode);
            }
        }
        this.annotationInfos_ = ais;
        this.treeViewer_.setInput(root);
        if (this.offset_ > 0) {
            this.select(this.offset_);
        } else if (this.defaultAnnotationNodeProperty_ != null) {
            this.getAnnotationTreeItem(this.defaultAnnotationNodeProperty_.getAnnotationInfo());
            this.treeViewer_.setSelection((ISelection)new StructuredSelection((Object)this.defaultAnnotationNodeProperty_), true);
        }
    }

    protected void createAnnotationTreeNodesForClass(BaseNodeProperty parent, List<AnnotationInfo> ais, IType type, List<IPropertyChangeListener> listeners) {
        if (!ais.isEmpty()) {
            try {
                BaseNodeProperty node = this.buildJavaElementNodeProperty(ais, (IJavaElement)type, listeners);
                if (node != null) {
                    IJavaElement[] children = type.getChildren();
                    if (children != null) {
                        int i = 0;
                        while (i < children.length) {
                            if (children[i].getElementType() != 7) {
                                BaseNodeProperty childNode = this.buildJavaElementNodeProperty(ais, children[i], listeners);
                                if (childNode != null) {
                                    node.addChild((INodeProperty)childNode);
                                }
                            } else {
                                this.createAnnotationTreeNodesForClass(node, ais, (IType)children[i], listeners);
                            }
                            ++i;
                        }
                    }
                    if (node.getChildren().length > 0) {
                        parent.addChild((INodeProperty)node);
                    }
                }
            }
            catch (Exception e) {
                AnnotationUIUtils.showExceptionMessage(e, this.getShell(), null, e.getMessage());
            }
        }
    }

    protected BaseNodeProperty buildJavaElementNodeProperty(List<AnnotationInfo> ais, IJavaElement je, List<IPropertyChangeListener> listeners) {
        ArrayList<AnnotationInfo> matchedAIs = this.getMatchedAnnotationInfo(ais, je);
        if (!matchedAIs.isEmpty() || je.getElementType() == 7) {
            String[] definitions = new String[3];
            try {
                switch (je.getElementType()) {
                    case 7: 
                    case 11: {
                        definitions[1] = definitions[2] = je.getElementName();
                        definitions[0] = definitions[2];
                        break;
                    }
                    case 9: {
                        IMethod method = (IMethod)je;
                        definitions[1] = definitions[2] = Signature.toString((String)method.getSignature(), (String)method.getElementName(), null, (boolean)true, (boolean)false);
                        definitions[0] = definitions[2];
                        break;
                    }
                    case 8: {
                        definitions[1] = definitions[2] = ((IField)je).getElementName();
                        definitions[0] = definitions[2];
                    }
                }
                if (definitions[0] != null && definitions[1] != null && definitions[2] != null) {
                    JavaElementNodeProperty jenp = new JavaElementNodeProperty(definitions[0], definitions[1], definitions[2], je);
                    int i = 0;
                    while (i < matchedAIs.size()) {
                        AnnotationInfo info = matchedAIs.get(i);
                        AnnotationNodeProperty anp = new AnnotationNodeProperty(info, listeners, this.aaNodeSynchronizer_);
                        jenp.addChild((INodeProperty)anp);
                        if (info.isDefaultInScope()) {
                            this.defaultAnnotationNodeProperty_ = anp;
                        }
                        ++i;
                    }
                    return jenp;
                }
            }
            catch (Exception e) {
                AnnotationUIUtils.showExceptionMessage(e, this.getShell(), null, e.getMessage());
            }
        }
        return null;
    }

    protected ArrayList<AnnotationInfo> getMatchedAnnotationInfo(List<AnnotationInfo> ais, IJavaElement je) {
        ArrayList<AnnotationInfo> matchedAIs = new ArrayList<AnnotationInfo>();
        int i = 0;
        while (i < ais.size()) {
            AnnotationInfo ai = ais.get(i);
            JavaElementInfo jei = ai.getParentJavaElementInfo();
            if (jei != null && jei.getJavaElement() == je) {
                matchedAIs.add(ai);
                ais.remove(i--);
            }
            ++i;
        }
        return matchedAIs;
    }

    protected void displayProperties(final IPropertyGroup properties, TreeItem oldItem, final TreeItem newItem) {
        PropertyUIScrollableComposite container;
        Control content;
        this.propertiesArea_.setContent(null);
        this.attributesUIWidget_.clearWidget();
        if (this.tabFolder_ != null && !this.tabFolder_.isDisposed() && this.tabFolder_.getItemCount() > 0 && (content = (container = (PropertyUIScrollableComposite)this.tabFolder_.getItem(1).getControl()).getContent()) != null && content.isDisposed()) {
            container.setContent((Control)this.emptyComposite_);
        }
        this.propertyUIComposite_ = null;
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                JpaStructureNode jpaNode = null;
                if (newItem != null) {
                    jpaNode = AnnotationTreeWidget.this.getJPAData(newItem.getData());
                }
                if (properties == null) {
                    Composite content;
                    if (jpaNode == null) {
                        if (newItem != null && (newItem.getData() instanceof JavaElementNodeProperty || newItem.getData() instanceof AnnotationAttributeNodeProperty)) {
                            AnnotationTreeWidget.this.createJavaElementInfoArea((Composite)AnnotationTreeWidget.this.propertiesArea_, newItem);
                            content = AnnotationTreeWidget.this.javaElementInfoArea_;
                        } else {
                            Control control = AnnotationTreeWidget.this.propertiesArea_.getContent();
                            if (control != null && !control.equals(AnnotationTreeWidget.this.noProperties_)) {
                                control.dispose();
                            }
                            content = AnnotationTreeWidget.this.noProperties_;
                        }
                    } else if (newItem != null && (newItem.getData() instanceof JavaElementNodeProperty || newItem.getData() instanceof AnnotationAttributeNodeProperty)) {
                        AnnotationTreeWidget.this.createJavaElementInfoArea((Composite)AnnotationTreeWidget.this.propertiesArea_, newItem);
                        content = AnnotationTreeWidget.this.javaElementInfoArea_;
                    } else {
                        content = AnnotationTreeWidget.this.createJPAInfoArea((Composite)AnnotationTreeWidget.this.propertiesArea_, jpaNode);
                    }
                    AnnotationTreeWidget.this.propertiesArea_.setContent((Control)content);
                    AnnotationTreeWidget.this.propertiesArea_.setMinSize(content.computeSize(-1, -1));
                } else if (jpaNode == null) {
                    AnnotationTreeWidget.this.generatePropertyGroupLayout((Composite)AnnotationTreeWidget.this.propertiesArea_, properties, newItem);
                } else {
                    PropertyUIScrollableComposite comp;
                    Control content;
                    if (AnnotationTreeWidget.this.tabFolder_ == null || AnnotationTreeWidget.this.tabFolder_.isDisposed()) {
                        AnnotationTreeWidget.this.tabFolder_ = AnnotationTreeWidget.this.createTabContainers((Composite)AnnotationTreeWidget.this.propertiesArea_);
                    }
                    if ((content = (comp = (PropertyUIScrollableComposite)AnnotationTreeWidget.this.tabFolder_.getItem(1).getControl()).getContent()) != null && content.isDisposed()) {
                        comp.setContent((Control)AnnotationTreeWidget.this.emptyComposite_);
                    }
                    AnnotationTreeWidget.this.generatePropertyGroupLayout((Composite)comp, properties, newItem);
                    if (AnnotationTreeWidget.this.tabFolder_.getSelectionIndex() == 0) {
                        comp.reflow(true);
                    }
                    comp = (PropertyUIScrollableComposite)AnnotationTreeWidget.this.tabFolder_.getItem(0).getControl();
                    content = AnnotationTreeWidget.this.createJPAInfoArea((Composite)comp, jpaNode);
                    comp.setContent(content);
                    if (AnnotationTreeWidget.this.tabFolder_.getSelectionIndex() == 1) {
                        comp.reflow(true);
                    }
                    AnnotationTreeWidget.this.propertiesArea_.setContent((Control)AnnotationTreeWidget.this.tabFolder_);
                }
            }
        });
    }

    protected JpaStructureNode getJPAData(Object nodeData) {
        int offset;
        if (nodeData instanceof AnnotationNodeProperty) {
            AnnotationInfo info = ((AnnotationNodeProperty)((Object)nodeData)).getAnnotationInfo();
            if (!info.isImpliedAnnotation() && info.getAnnotation() != null) {
                if (info.getCategorizationKey() != null && info.getCategorizationKey().equals("javax.persistence") && info.getOffset() > -1) {
                    return this.getJPAData(info.getOffset());
                }
            } else {
                IJavaElement je;
                JavaElementInfo jei = info.getParentJavaElementInfo();
                if (jei != null && jei.getJavaElement() != null && (je = jei.getJavaElement()) instanceof IMember) {
                    try {
                        return this.getJPAData(((IMember)je).getNameRange().getOffset());
                    }
                    catch (Exception exception) {}
                }
            }
        } else if (nodeData instanceof JavaElementNodeProperty && (offset = ((JavaElementNodeProperty)((Object)nodeData)).getJavaElementOffset()) > 0) {
            return this.getJPAData(offset);
        }
        return null;
    }

    protected JpaStructureNode getJPAData(int offset) {
        JpaFile jpaFile;
        if (this.getCompilationUnit() != null && (jpaFile = JptCorePlugin.getJpaFile((IFile)((IFile)this.getCompilationUnit().getResource()))) != null) {
            return jpaFile.getStructureNode(offset);
        }
        return null;
    }

    protected void createJavaElementInfoArea(Composite parent, final TreeItem treeItem) {
        IPropertyUIWidgetFactory factory = this.uiFactory_.getUIFactory();
        Composite container = this.javaElementInfoArea_;
        if (container == null) {
            container = factory.createComposite(parent, 0);
            container.setLayout((Layout)new GridLayout());
            container.setLayoutData((Object)new GridData(1808));
            this.javaElementInfoArea_ = container;
        } else {
            Control[] children = container.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        Section area = factory.createSection(container, 274);
        area.setText(AnnotationsUIMessages.ANNOTATIONS_UI_LABEL_ANNOTATION_SUMMARY);
        area.setExpanded(true);
        area.setLayoutData((Object)new GridData(1808));
        area.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                AnnotationTreeWidget.this.relayoutParents((Composite)((ExpandableComposite)e.getSource()));
            }
        });
        Composite comp = factory.createComposite((Composite)area, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1808));
        area.setClient((Control)comp);
        Label label = factory.createLabel(comp, 64);
        StringBuffer desc = new StringBuffer("'").append(treeItem.getText()).append("'").append(" - ");
        ArrayList<AnnotationNodeProperty> annotions = new ArrayList<AnnotationNodeProperty>();
        INodeProperty[] children = ((INodeProperty)treeItem.getData()).getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof AnnotationNodeProperty) {
                annotions.add((AnnotationNodeProperty)children[i]);
            }
            ++i;
        }
        int apNo = annotions.size();
        if (apNo < 2) {
            desc.append(apNo).append(" ").append(AnnotationsUIMessages.ANNOTATIONS_UI_LABEL_ANNOTATION);
        } else {
            desc.append(apNo).append(" ").append(AnnotationsUIMessages.ANNOTATIONS_UI_LABEL_ANNOTATIONS);
        }
        label.setText(desc.toString());
        int i2 = 0;
        while (i2 < apNo) {
            final AnnotationNodeProperty node = (AnnotationNodeProperty)((Object)annotions.get(i2));
            final Hyperlink link = new Hyperlink(comp, 0);
            link.setUnderlined(true);
            link.setText(node.getAnnotationLabel());
            GridData gd = new GridData(768);
            gd.horizontalIndent = 13;
            link.setLayoutData((Object)gd);
            link.setForeground(comp.getDisplay().getSystemColor(10));
            link.addHyperlinkListener(new IHyperlinkListener(){

                public void linkEntered(HyperlinkEvent e) {
                    link.setForeground(link.getDisplay().getSystemColor(9));
                }

                public void linkExited(HyperlinkEvent e) {
                    link.setForeground(link.getDisplay().getSystemColor(10));
                }

                public void linkActivated(HyperlinkEvent e) {
                    if (!AnnotationTreeWidget.this.treeViewer_.getTree().isDisposed()) {
                        AnnotationTreeWidget.this.treeViewer_.getTree().setFocus();
                        AnnotationTreeWidget.this.treeViewer_.expandToLevel(treeItem.getData(), 1);
                        AnnotationTreeWidget.this.treeViewer_.setSelection((ISelection)new StructuredSelection((Object)node), true);
                    }
                }
            });
            ++i2;
        }
    }

    protected Composite createJPAInfoArea(Composite parent, JpaStructureNode jpaNode) {
        JpaPageInfo pageInfo = this.jpaDetailsPages_.get(jpaNode.getId());
        if (pageInfo != null) {
            JpaDetailsPage<? extends JpaStructureNode> page = pageInfo.page_;
            if (!jpaNode.equals(pageInfo.jpaNode_)) {
                page.setSubject(null);
                page.setSubject(jpaNode);
                pageInfo.jpaNode_ = jpaNode;
            }
            return page.getControl().getParent();
        }
        IPropertyUIWidgetFactory factory = this.uiFactory_.getUIFactory();
        Composite container = factory.createComposite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        if (jpaNode.getJpaProject() != null) {
            String id;
            JpaDetailsPage page;
            String platformId = jpaNode.getJpaProject().getJpaPlatform().getId();
            JpaDetailsProvider provider = JpaPlatformUiRegistry.instance().jpaPlatform(platformId).detailsProvider(jpaNode);
            if (provider != null && (page = provider.buildDetailsPage(container, (Object)(id = jpaNode.getId()), (WidgetFactory)new PropertySheetWidgetFactory(new TabbedPropertySheetWidgetFactory()))) != null) {
                page.setSubject(jpaNode);
                this.jpaDetailsPages_.put(id, new JpaPageInfo((JpaDetailsPage<? extends JpaStructureNode>)page, jpaNode));
                return container;
            }
        }
        factory.createLabel(container, AnnotationsUIMessages.ANNOTATIONS_UI_LABEL_JPA_DEFAULT, 64);
        return container;
    }

    protected void relayoutParents(Composite comp) {
        if (comp == null || comp.isDisposed()) {
            return;
        }
        comp.layout();
        Composite parent = comp.getParent();
        if (parent != null) {
            if (parent instanceof PropertyUIScrollableComposite) {
                ((PropertyUIScrollableComposite)parent).reflow(true);
            } else if (parent instanceof ScrolledComposite) {
                Point p = comp.computeSize(-1, -1);
                comp.setSize(p.x, p.y);
                ((ScrolledComposite)parent).setMinSize(p);
                parent.layout();
            } else {
                this.relayoutParents(parent);
            }
        }
    }

    protected void generatePropertyGroupLayout(Composite parent, IPropertyGroup properties, TreeItem newItem) {
        List<IAnnotationAttributeProperty> pl = this.removePropertyChangeListeners(properties);
        try {
            this.propertyUIComposite_ = this.attributesUIWidget_.displayAttributes(parent, properties, newItem);
            if (this.propertyUIComposite_ != null && this.uiListeners_ != null && !this.uiListeners_.isEmpty()) {
                int i = 0;
                while (i < this.uiListeners_.size()) {
                    this.propertyUIComposite_.removePropertyUIChangeListener(this.uiListeners_.get(i));
                    this.propertyUIComposite_.addPropertyUIChangeListener(this.uiListeners_.get(i));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            AnnotationUIUtils.showExceptionMessage(e, this.getShell(), null, e.getMessage());
        }
        this.addPropertyChangeListeners(pl);
    }

    protected IPath buildTreeItemPath(TreeItem item) {
        ArrayList<String> segments = new ArrayList<String>(6);
        segments.add(item.getText());
        TreeItem parent = item.getParentItem();
        while (parent != null) {
            segments.add(0, parent.getText());
            parent = parent.getParentItem();
        }
        Path path = new Path((String)segments.get(0));
        int i = 1;
        while (i < segments.size()) {
            path = path.append((String)segments.get(i));
            ++i;
        }
        return path;
    }

    public void savePropertiesToStore(String key) {
        if (this.attributesUIWidget_ != null) {
            this.attributesUIWidget_.savePropertiesToStore(key);
        }
    }

    protected List<IAnnotationAttributeProperty> removePropertyChangeListeners(IPropertyGroup properties) {
        ArrayList<IAnnotationAttributeProperty> pls = new ArrayList<IAnnotationAttributeProperty>();
        IPropertyDescriptor[] ipds = properties.getProperties();
        if (ipds != null) {
            int i = 0;
            while (i < ipds.length) {
                if (ipds[i] instanceof SingleValueArgumentProperty) {
                    List<IPropertyChangeListener> listeners;
                    IPropertyDescriptor parent;
                    Object[] validValues = ((SingleValueArgumentProperty)ipds[i]).getPropertyType().getValidValues();
                    if (validValues != null && validValues.length > 0 && (parent = ipds[i].getParent()) != null && parent instanceof AnnotationAttributePropertyGroup && (listeners = ((AnnotationAttributePropertyGroup)parent).getAttributeListeners()) != null) {
                        int j = 0;
                        while (j < listeners.size()) {
                            IPropertyChangeListener lst = listeners.get(j);
                            ipds[i].removePropertyChangeListener(lst);
                            pls.add((IAnnotationAttributeProperty)ipds[i]);
                            ++j;
                        }
                    }
                } else if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipds[i])) {
                    List<IAnnotationAttributeProperty> subPLs = this.removePropertyChangeListeners((IPropertyGroup)ipds[i]);
                    pls.addAll(subPLs);
                }
                ++i;
            }
        }
        return pls;
    }

    protected void removePropertyChangeListeners(INodeProperty node) {
        INodeProperty[] children;
        if (node instanceof AnnotationNodeProperty) {
            ((AnnotationNodeProperty)node).removePropertyChangeListeners(this.propertyListeners_);
        }
        if ((children = node.getChildren()) != null && children.length > 0) {
            int i = 0;
            while (i < children.length) {
                this.removePropertyChangeListeners(children[i]);
                ++i;
            }
        }
    }

    protected void addPropertyChangeListeners(List<IAnnotationAttributeProperty> properties) {
        int i = 0;
        while (i < properties.size()) {
            IAnnotationAttributeProperty iaap = properties.get(i);
            AnnotationAttributePropertyGroup parent = (AnnotationAttributePropertyGroup)iaap.getParent();
            List<IPropertyChangeListener> listeners = parent.getAttributeListeners();
            if (listeners != null) {
                int j = 0;
                while (j < listeners.size()) {
                    IPropertyChangeListener lst = listeners.get(j);
                    iaap.addPropertyChangeListener(lst);
                    ++j;
                }
            }
            ++i;
        }
    }

    protected TabFolder createTabContainers(Composite parent) {
        IPropertyUIWidgetFactory factory = this.uiFactory_.getUIFactory();
        TabFolder tabFolder = factory.createTabFolder(parent, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem item = factory.createTabItem(tabFolder, 0, 0);
        item.setText(AnnotationsUIMessages.ANNOTATIONS_UI_TAB_JPA_DETAILS);
        item.setToolTipText(AnnotationsUIMessages.ANNOTATIONS_UI_TAB_JPA_DETAILS_DESC);
        String path = AnnotationViewOverlayInfo.instance().getIcon("javax.persistence");
        if (path != null) {
            this.jpaDetailsImage_ = Activator.getImageDescriptor(path).createImage();
        }
        item.setImage(this.jpaDetailsImage_);
        PropertyUIScrollableComposite container = factory.createPropertyUIScrollableComposite((Composite)tabFolder, 768);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        item.setControl((Control)container);
        item = factory.createTabItem(tabFolder, 0, 1);
        item.setText(AnnotationsUIMessages.ANNOTATIONS_UI_PROPERTYGROUP_ATTRIBUTES);
        item.setToolTipText(AnnotationsUIMessages.ANNOTATIONS_UI_PROPERTYGROUP_ATTRIBUTES_DESC);
        item.setImage(this.attributesImage_);
        container = factory.createPropertyUIScrollableComposite((Composite)tabFolder, 768);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        item.setControl((Control)container);
        return tabFolder;
    }

    public Shell getShell() {
        Control control;
        if (this.treeViewer_ != null && (control = this.treeViewer_.getControl()) != null && !control.isDisposed()) {
            return control.getShell();
        }
        return null;
    }

    public void dispose() {
        this.clearAnnotationTreeWidget();
        this.jpaDetailsPages_.clear();
        if (!this.attributesImage_.isDisposed()) {
            this.attributesImage_.dispose();
        }
        if (!this.jpaDetailsImage_.isDisposed()) {
            this.jpaDetailsImage_.dispose();
        }
        if (this.attributesUIWidget_ != null) {
            this.attributesUIWidget_.dispose();
        }
    }

    public void setContributionItem(IContributionItem[] newItems) {
        this.toolbarComposite_.replaceAllContributionItems(newItems);
    }

    public Composite getContainer() {
        return this.sashForm_;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer_;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.annotationModel_ != null ? (ICompilationUnit)this.annotationModel_.getJavaElementForThisClass() : null;
    }

    public void updateAttributeTab(AnnotationInfo annoInfo) {
        final TreeItem item = this.getAnnotationTreeItem(annoInfo);
        if (item != null) {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    AnnotationTreeWidget.this.selectTreeItem(item, true);
                    BaseNodeProperty node = (BaseNodeProperty)item.getData();
                    IPropertyGroup properties = node.getActiveConfigurationProperties();
                    if (properties != null) {
                        AnnotationTreeWidget.this.attributesUIWidget_.clearWidget();
                        AnnotationTreeWidget.this.propertyUIComposite_ = null;
                        PropertyUIScrollableComposite comp = (PropertyUIScrollableComposite)AnnotationTreeWidget.this.tabFolder_.getItem(1).getControl();
                        Control content = comp.getContent();
                        if (content != null && content.isDisposed()) {
                            comp.setContent((Control)AnnotationTreeWidget.this.emptyComposite_);
                        }
                        AnnotationTreeWidget.this.generatePropertyGroupLayout((Composite)comp, properties, item);
                        if (AnnotationTreeWidget.this.tabFolder_.getSelectionIndex() == 0) {
                            comp.reflow(true);
                        }
                    }
                }
            });
        }
    }

    public AnnotationInfo getSelectedJPAAnnotation() {
        Object o;
        StructuredSelection selection;
        if (this.tabFolder_ != null && !this.tabFolder_.isDisposed() && this.tabFolder_.getSelectionIndex() == 0 && this.propertiesArea_ != null && !this.propertiesArea_.isDisposed() && this.tabFolder_.equals(this.propertiesArea_.getContent()) && (selection = (StructuredSelection)this.treeViewer_.getSelection()) != null && !selection.isEmpty() && (o = ((TreeSelection)this.treeViewer_.getSelection()).getFirstElement()) instanceof AnnotationNodeProperty) {
            return ((AnnotationNodeProperty)((Object)o)).getAnnotationInfo();
        }
        return null;
    }

    public void stopDisplayingAttributes(boolean stop) {
        this.stopDisplayingAttributeArea_ = stop;
    }

    protected class AnnotationAttributeEditAction
    extends EditAnnotationAction {
        protected AnnotationAttributeEditAction() {
        }

        @Override
        public void performEdit(AnnotationInfo annoInfo) {
            Object parentInfo;
            if (AnnotationTreeWidget.this.selectedItem_ != null && (parentInfo = annoInfo.getParentElementInfo()) instanceof IAnnotationAttributeProperty) {
                Path path = new Path(((IAnnotationAttributeProperty)parentInfo).getName());
                AnnotationTreeWidget.this.treeViewer_.expandToLevel(AnnotationTreeWidget.this.selectedItem_.getData(), 1);
                TreeItem item = AnnotationTreeWidget.this.findAnnotationParentTreeItem(AnnotationTreeWidget.this.selectedItem_.getItems(), (IPath)path, 0);
                item = AnnotationTreeWidget.this.findAnnotationTreeItem(item, annoInfo);
                if (item != null) {
                    AnnotationTreeWidget.this.selectTreeItem(item, true);
                }
            }
        }
    }

    protected class AnnotationViewAttributesUIWidget
    extends AnnotationAttributesUIWidget {
        TreeItem treeItem_;

        public AnnotationViewAttributesUIWidget(DynamicGenStore dgStore, PropertyUIFactory uiFactory) {
            super(dgStore, uiFactory);
        }

        public PropertyUIComposite displayAttributes(Composite parent, IPropertyGroup pg, TreeItem newItem) throws CoreException {
            this.treeItem_ = newItem;
            return super.displayAttributes(parent, pg);
        }

        @Override
        protected void updatePropertyUIWidgets() {
            ArrayList widgets = this.propertyUIComposite_.getUIWidgets();
            ArrayList<SingleAnnotationArgumentPropertyUIWidget> singleAnnotationWidgets = new ArrayList<SingleAnnotationArgumentPropertyUIWidget>();
            IJavaProject project = null;
            int i = 0;
            while (i < widgets.size()) {
                PropertyUIWidget widget = (PropertyUIWidget)widgets.get(i);
                if (widget instanceof SingleAnnotationArgumentPropertyUIWidget) {
                    ((SingleAnnotationArgumentPropertyUIWidget)widget).setEditAction(AnnotationTreeWidget.this.annotationAttributeEditAction_);
                    singleAnnotationWidgets.add((SingleAnnotationArgumentPropertyUIWidget)widget);
                    if (project == null) {
                        SingleAnnotationArgumentProperty saap = (SingleAnnotationArgumentProperty)((SingleAnnotationArgumentPropertyUIWidget)widget).getProperty();
                        JavaElementInfo jeInfo = InternalUtils.getParentJavaElementInfo4Attribute((IAnnotationAttributeProperty)saap);
                        IJavaElement je = null;
                        if (jeInfo != null) {
                            je = jeInfo.getJavaElement();
                        }
                        if (je != null) {
                            project = je.getJavaProject();
                        }
                    }
                } else if (widget instanceof ArrayAnnotationArgumentPropertyUIWidget) {
                    ((ArrayAnnotationArgumentPropertyUIWidget)widget).setEditAction(AnnotationTreeWidget.this.annotationAttributeEditAction_);
                }
                ++i;
            }
            if (!singleAnnotationWidgets.isEmpty() && project != null) {
                this.updateSuggestionList(singleAnnotationWidgets, project);
            }
        }

        @Override
        protected boolean needToUpdatePropertyUIWidgets() {
            if (this.treeItem_ != null) {
                return this.treeItem_.getItemCount() > 0;
            }
            return super.needToUpdatePropertyUIWidgets();
        }
    }

    protected class JpaPageInfo {
        protected JpaDetailsPage<? extends JpaStructureNode> page_;
        protected JpaStructureNode jpaNode_;

        public JpaPageInfo(JpaDetailsPage<? extends JpaStructureNode> page, JpaStructureNode jpaNode) {
            this.page_ = page;
            this.jpaNode_ = jpaNode;
        }
    }

    protected class TreeElementContentProvider
    implements ITreeContentProvider {
        protected TreeElementContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] nodes;
            if (parentElement instanceof ArrayList) {
                return ((ArrayList)parentElement).toArray();
            }
            if (parentElement instanceof INodeProperty && (nodes = ((INodeProperty)parentElement).getChildren()) != null) {
                return nodes;
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

