/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui.internal.utils;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.ui.internal.properties.AnnotationNodeProperty;
import com.ibm.etools.annotations.ui.internal.properties.AttributeTreeProperty;
import com.ibm.etools.annotations.ui.internal.properties.JavaElementNodeProperty;
import com.ibm.etools.annotations.ui.internal.properties.UnknownAnnotationNodeProperty;
import com.ibm.etools.annotations.ui.internal.utils.AnnotationPropertyGroupWrapper;
import com.ibm.propertygroup.INodeProperty;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.BaseNodeProperty;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;

public class PropertyGroupFactory {
    public static final String ANNOTATION_PROPERTYGROUP_NAME = "AnnotationsGroup";
    public static final String ANNOTATION_TREE_PROPERTY_NAME = "AnnotationTree";
    public static final String ANNOTATION_TREE_ROOT_NODE_NAME = "Root";
    private static PropertyGroupFactory factory_;
    protected AnnotationNodeProperty defaultAnnotationNodeProperty_ = null;

    public static PropertyGroupFactory getFactory() {
        if (factory_ == null) {
            factory_ = new PropertyGroupFactory();
        }
        return factory_;
    }

    public AnnotationPropertyGroupWrapper createPropertyGroup(List<AnnotationInfo> ais, IPropertyChangeListener listener, ICompilationUnit unit) throws CoreException {
        INodeProperty[] children;
        if (ais == null) {
            return null;
        }
        this.defaultAnnotationNodeProperty_ = null;
        ArrayList<IPropertyChangeListener> list1 = new ArrayList<IPropertyChangeListener>(1);
        list1.add(listener);
        BasePropertyGroup pg = new BasePropertyGroup(ANNOTATION_PROPERTYGROUP_NAME, ANNOTATION_PROPERTYGROUP_NAME, ANNOTATION_PROPERTYGROUP_NAME);
        JavaElementNodeProperty root = new JavaElementNodeProperty(ANNOTATION_TREE_ROOT_NODE_NAME, ANNOTATION_TREE_ROOT_NODE_NAME, ANNOTATION_TREE_ROOT_NODE_NAME, null);
        ArrayList<AnnotationInfo> copiedList = new ArrayList<AnnotationInfo>(ais);
        this.createAnnotationTreeNodesForClass(root, copiedList, unit.getAllTypes()[0], list1);
        if (!copiedList.isEmpty()) {
            int index = 0;
            int i = 0;
            while (i < copiedList.size()) {
                IJavaElement je = copiedList.get(i).getParentJavaElementInfo().getJavaElement();
                if (je.getElementType() == 11) {
                    BaseNodeProperty packageNode = this.buildJavaElementNodeProperty(copiedList, je, list1);
                    root.addChild(index++, (INodeProperty)packageNode);
                }
                ++i;
            }
        }
        if (!copiedList.isEmpty() && (children = root.getChildren()).length > 0) {
            JavaElementNodeProperty jenp = (JavaElementNodeProperty)children[children.length - 1];
            UnknownAnnotationNodeProperty unknownNode = new UnknownAnnotationNodeProperty();
            int i = 0;
            while (i < copiedList.size()) {
                unknownNode.addChild((INodeProperty)new AnnotationNodeProperty(copiedList.get(i), list1));
                ++i;
            }
            jenp.addChild((INodeProperty)unknownNode);
        }
        AttributeTreeProperty tree = new AttributeTreeProperty(ANNOTATION_TREE_PROPERTY_NAME, ANNOTATION_TREE_PROPERTY_NAME, ANNOTATION_TREE_PROPERTY_NAME, (INodeProperty)root);
        tree.assignID("com.ibm.etools.annotations.ui.AnnotationTreePropertyUIExtension");
        tree.showRoot(false);
        tree.selectable(false);
        tree.setCompilationUnit(unit);
        pg.addProperty((IPropertyDescriptor)tree);
        AnnotationPropertyGroupWrapper wrapper = new AnnotationPropertyGroupWrapper((IPropertyGroup)pg);
        wrapper.setDefaultNode((INodeProperty)this.defaultAnnotationNodeProperty_);
        return wrapper;
    }

    protected void createAnnotationTreeNodesForClass(BaseNodeProperty parent, List<AnnotationInfo> ais, IType type, List<IPropertyChangeListener> listeners) {
        if (!ais.isEmpty()) {
            try {
                BaseNodeProperty node = this.buildJavaElementNodeProperty(ais, (IJavaElement)type, listeners);
                if (node != null) {
                    IJavaElement[] children = type.getChildren();
                    if (children != null) {
                        int i = 0;
                        while (i < children.length) {
                            if (children[i].getElementType() != 7) {
                                BaseNodeProperty childNode = this.buildJavaElementNodeProperty(ais, children[i], listeners);
                                if (childNode != null) {
                                    node.addChild((INodeProperty)childNode);
                                }
                            } else {
                                this.createAnnotationTreeNodesForClass(node, ais, (IType)children[i], listeners);
                            }
                            ++i;
                        }
                    }
                    if (node.getChildren().length > 0) {
                        parent.addChild((INodeProperty)node);
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    protected BaseNodeProperty buildJavaElementNodeProperty(List<AnnotationInfo> ais, IJavaElement je, List<IPropertyChangeListener> listeners) {
        ArrayList<AnnotationInfo> matchedAIs = this.getMatchedAnnotationInfo(ais, je);
        if (!matchedAIs.isEmpty() || je.getElementType() == 7) {
            String[] definitions = new String[3];
            try {
                switch (je.getElementType()) {
                    case 7: 
                    case 11: {
                        definitions[1] = definitions[2] = je.getElementName();
                        definitions[0] = definitions[2];
                        break;
                    }
                    case 9: {
                        IMethod method = (IMethod)je;
                        definitions[1] = definitions[2] = Signature.toString((String)method.getSignature(), (String)method.getElementName(), null, (boolean)true, (boolean)false);
                        definitions[0] = definitions[2];
                        break;
                    }
                    case 8: {
                        definitions[1] = definitions[2] = ((IField)je).getElementName();
                        definitions[0] = definitions[2];
                    }
                }
                if (definitions[0] != null && definitions[1] != null && definitions[2] != null) {
                    JavaElementNodeProperty jenp = new JavaElementNodeProperty(definitions[0], definitions[1], definitions[2], je);
                    int i = 0;
                    while (i < matchedAIs.size()) {
                        AnnotationInfo info = matchedAIs.get(i);
                        AnnotationNodeProperty anp = new AnnotationNodeProperty(info, listeners);
                        jenp.addChild((INodeProperty)anp);
                        if (info.isDefaultInScope()) {
                            this.defaultAnnotationNodeProperty_ = anp;
                        }
                        ++i;
                    }
                    return jenp;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    protected ArrayList<AnnotationInfo> getMatchedAnnotationInfo(List<AnnotationInfo> ais, IJavaElement je) {
        ArrayList<AnnotationInfo> matchedAIs = new ArrayList<AnnotationInfo>();
        int i = 0;
        while (i < ais.size()) {
            AnnotationInfo ai = ais.get(i);
            if (ai.getParentJavaElementInfo().getJavaElement() == je) {
                matchedAIs.add(ai);
                ais.remove(i--);
            }
            ++i;
        }
        return matchedAIs;
    }
}

