/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui.internal.providers;

import com.ibm.etools.annotations.ui.Activator;
import com.ibm.etools.annotations.ui.internal.data.AnnotationViewOverlayInfo;
import com.ibm.etools.annotations.ui.internal.properties.AnnotationAttributeNodeProperty;
import com.ibm.etools.annotations.ui.internal.properties.AnnotationNodeProperty;
import com.ibm.etools.annotations.ui.internal.properties.CategoryNodeProperty;
import com.ibm.etools.annotations.ui.internal.properties.JavaElementNodeProperty;
import com.ibm.etools.annotations.ui.internal.properties.SimpleAnnotationNodeProperty;
import com.ibm.etools.annotations.ui.internal.properties.SimpleCategoryProperty;
import com.ibm.etools.annotations.ui.internal.properties.UnknownAnnotationNodeProperty;
import com.ibm.etools.annotations.ui.internal.providers.AnnotationUIDecorator;
import com.ibm.propertygroup.INodeProperty;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class AnnotationTreeLabelProvider
extends LabelProvider {
    private Hashtable<String, Image> allocatedImages_ = new Hashtable();
    private AnnotationUIDecorator decorator_ = new AnnotationUIDecorator();

    public Image getImage(Object element) {
        if (element instanceof JavaElementNodeProperty) {
            IJavaElement je = ((JavaElementNodeProperty)((Object)element)).getJavaElement();
            if (je.getElementType() == 7) {
                return this.getImageFromFile("icons/obj16/class.gif");
            }
            if (je.getElementType() == 8) {
                return this.getImageFromFile("icons/obj16/field.gif");
            }
            if (je.getElementType() == 9) {
                return this.getImageFromFile("icons/obj16/method.gif");
            }
            if (je.getElementType() == 11) {
                return this.getImageFromFile("icons/obj16/package_obj.gif");
            }
        } else {
            if (element instanceof AnnotationNodeProperty) {
                Image image = this.getImageFromFile("icons/obj16/annotation2.gif");
                String pkgName = ((AnnotationNodeProperty)((Object)element)).getAnnotationInfo().getPackageName();
                String annoovrPath = AnnotationViewOverlayInfo.instance().getAnnoIconFromPackage(pkgName);
                if (((AnnotationNodeProperty)((Object)element)).getAnnotationInfo().isImpliedAnnotation()) {
                    return this.decorator_.decorateImage(image, this.getImageFromFile("icons/ovr16/imply_ovr.gif"));
                }
                if (annoovrPath != null) {
                    return this.decorator_.decorateImage(image, this.getImageFromFile(annoovrPath));
                }
                return image;
            }
            if (element instanceof AnnotationAttributeNodeProperty) {
                return this.getImageFromFile("icons/obj16/annotation_attribute_obj.gif");
            }
            if (element instanceof SimpleAnnotationNodeProperty) {
                return this.getImageFromFile("icons/obj16/annotation2.gif");
            }
            if (element instanceof CategoryNodeProperty || element instanceof SimpleCategoryProperty) {
                String iconPath = null;
                iconPath = element instanceof CategoryNodeProperty ? AnnotationViewOverlayInfo.instance().getIconFromLabel(((CategoryNodeProperty)((Object)element)).getName()) : AnnotationViewOverlayInfo.instance().getIconFromLabel(((SimpleCategoryProperty)((Object)element)).getName());
                if (iconPath != null) {
                    return this.getImageFromFile(iconPath);
                }
                iconPath = element instanceof CategoryNodeProperty ? AnnotationViewOverlayInfo.instance().getIconFromPackage(((CategoryNodeProperty)((Object)element)).getName()) : AnnotationViewOverlayInfo.instance().getIconFromPackage(((SimpleCategoryProperty)((Object)element)).getName());
                if (iconPath != null) {
                    return this.getImageFromFile(iconPath);
                }
                return this.getImageFromFile("icons/obj16/annotation_package.gif");
            }
            if (element instanceof UnknownAnnotationNodeProperty) {
                return this.getImageFromFile("icons/obj16/unknown_annotation.gif");
            }
        }
        return null;
    }

    protected Image getImageFromFile(String imageFileName) {
        if (imageFileName != null) {
            Image im = this.allocatedImages_.get(imageFileName);
            if (im != null) {
                return im;
            }
            im = Activator.getImageDescriptor(imageFileName).createImage();
            this.allocatedImages_.put(imageFileName, im);
            return im;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof AnnotationNodeProperty) {
            return ((AnnotationNodeProperty)((Object)element)).getAnnotationLabel();
        }
        if (element instanceof INodeProperty) {
            return ((INodeProperty)element).getDisplayName();
        }
        return "";
    }

    public void dispose() {
        super.dispose();
        Enumeration<Image> ims = this.allocatedImages_.elements();
        while (ims.hasMoreElements()) {
            Image i = ims.nextElement();
            if (i.isDisposed()) continue;
            i.dispose();
        }
        this.allocatedImages_.clear();
        this.decorator_.dispose();
    }
}

