/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui.internal.override;

import com.ibm.etools.annotations.ui.internal.override.DDOverrideIndicator;
import com.ibm.etools.annotations.ui.internal.override.DDOverrideIndicatorHelper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorPart;

public class DDOverrideModelManager {
    private IAnnotationModel fAnnotationModel;
    private Object fAnnotationModelLockObject;
    private Hashtable<String, Annotation> aIndicatorLists;
    private Hashtable aNewIndicatorList = new Hashtable();
    private Hashtable aNewIndicatorPositionList = new Hashtable();
    static final String DDANNOTATION_TYPE = "com.ibm.etools.annotations.ui.overrideDD";
    static final String DDANNOTATION_ICON = "icons/ovr16/override_ovr.gif";

    protected IAnnotationModel getCurrentModel() {
        return this.fAnnotationModel;
    }

    public DDOverrideModelManager(IEditorPart ePart, List aInfo, IProject project) {
        if (project == null || aInfo == null) {
            return;
        }
        this.fAnnotationModel = DDOverrideIndicatorHelper.getDDAnnotationModel(ePart);
        if (this.fAnnotationModel != null) {
            this.updateAllDDOverrides(this.fAnnotationModel, aInfo, project, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDDAnnotationIndicators() {
        if (this.aIndicatorLists == null) {
            return;
        }
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            Enumeration<Annotation> aList = this.aIndicatorLists.elements();
            while (aList != null && aList.hasMoreElements()) {
                Annotation DDann = aList.nextElement();
                if (this.fAnnotationModel.getPosition(DDann) == null) continue;
                this.fAnnotationModel.removeAnnotation(DDann);
            }
            this.aIndicatorLists.clear();
        }
    }

    private void updateAllDDOverrides(IAnnotationModel model, List aInfo, IProject project, IProgressMonitor progressMonitor) {
        if (progressMonitor.isCanceled()) {
            return;
        }
        this.fAnnotationModelLockObject = this.getLockObject(model);
        this.populateAnnotationOverrides(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateAnnotationOverrides(IAnnotationModel model_) {
        this.aNewIndicatorList = DDOverrideIndicatorHelper.getANewIndicatorList();
        this.aNewIndicatorPositionList = DDOverrideIndicatorHelper.getANewIndicatorPositionList();
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            DDOverrideIndicatorHelper.dumpandDeleteAllDDFromAnnotationsModel(model_);
            this.aIndicatorLists = new Hashtable();
            Enumeration key = this.aNewIndicatorList.keys();
            while (key != null && key.hasMoreElements()) {
                String annokey = (String)key.nextElement();
                DDOverrideIndicator oDD = (DDOverrideIndicator)((Object)this.aNewIndicatorList.get(annokey));
                Position oDDPos = (Position)this.aNewIndicatorPositionList.get(annokey);
                this.aIndicatorLists.put(annokey, oDD);
                if (model_.getPosition((Annotation)oDD) != null) continue;
                model_.addAnnotation((Annotation)oDD, oDDPos);
            }
        }
    }
}

