/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui.data;

import com.ibm.etools.annotations.core.data.AnnotatedClassInfo;
import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.data.JavaElementInfo;
import com.ibm.etools.annotations.core.data.JavaElementInfoPG;
import com.ibm.etools.annotations.core.internal.AnnotationParser;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.etools.annotations.core.utils.AnnotationUtils;
import com.ibm.etools.annotations.ui.Activator;
import com.ibm.etools.annotations.ui.AnnotationUIContextHelper;
import com.ibm.etools.annotations.ui.data.AnnotationViewAccessAdapter;
import com.ibm.etools.annotations.ui.data.AnnotationViewSelectionInfo;
import com.ibm.etools.annotations.ui.data.AnnotationViewWidgetMessageHandler;
import com.ibm.etools.annotations.ui.internal.dialogs.AddAnnotationDialog;
import com.ibm.etools.annotations.ui.internal.messages.AnnotationsUIMessages;
import com.ibm.etools.annotations.ui.internal.properties.AnnotationAttributeNodeProperty;
import com.ibm.etools.annotations.ui.internal.properties.AnnotationNodeProperty;
import com.ibm.etools.annotations.ui.internal.properties.JavaElementNodeProperty;
import com.ibm.etools.annotations.ui.internal.utils.AnnotationSourceModifier;
import com.ibm.etools.annotations.ui.internal.utils.AnnotationUIUtils;
import com.ibm.etools.annotations.ui.internal.widgets.AnnotationTreeWidget;
import com.ibm.propertygroup.INodeProperty;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.ui.datastores.DynamicGenStore;
import com.ibm.propertygroup.ui.internal.messages.PropertyUIMessages;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.listener.IPropertyUIChangeListener;
import com.ibm.propertygroup.ui.listener.PropertyUIChangeEvent;
import com.ibm.propertygroup.ui.plugin.PropertyUIPlugin;
import com.ibm.propertygroup.ui.utilities.PropertyUIFactory;
import com.ibm.propertygroup.ui.utilities.PropertyUIWidget;
import com.ibm.propertygroup.ui.widgets.PropertyUIScrollableComposite;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public class AnnotationViewWidget
implements IPropertyChangeListener,
IPropertyUIChangeListener {
    protected Composite blankArea_;
    protected TreeViewer viewer_;
    protected AnnotationTreeWidget annotationTreeWidget_;
    protected PropertyUIFactory factory_;
    protected PropertyUIScrollableComposite scroller_;
    protected int currentOffset_;
    protected AnnotatedClassInfo model_;
    protected IPropertyChangeListener propertyListener;
    protected IPropertyUIChangeListener propertyUIListener;
    AnnotationParser annotationParser_;
    protected AnnotationViewSynchronizer synchronizer_;
    protected IPartListener2 partListener_;
    protected IAction deleteAnnotationAction_;
    protected AnnotationSourceModifier asModifier_ = null;
    protected WorkingAttributeWrapper workingAttribute_ = null;
    protected AnnotationInfo newAddedAnnotation_ = null;
    protected IWorkbenchPart workingEditorPart_;
    protected Shell shell_;
    protected IWorkbenchPage workingPage_;
    protected AnnotationViewWidgetMessageHandler messageHandler_;
    protected AnnotationViewAccessAdapter editorAdapter_;
    protected String hostID_;
    protected boolean processSelectionChangedEvent_ = true;
    protected boolean isWorking_ = false;
    protected boolean modelNeedToBeUpdated_ = false;
    protected int modifyCount_;
    protected AnnotationViewOutlineChangedListener outlineChangedListener_ = new AnnotationViewOutlineChangedListener();
    protected boolean performReconcile_;
    protected ICompilationUnit workingCopy_;

    public AnnotationViewWidget() {
        this(null);
    }

    public AnnotationViewWidget(IWorkbenchPage workingPage) {
        this(workingPage, null);
    }

    public AnnotationViewWidget(IWorkbenchPage workingPage, String hostID) {
        this.initWidget(workingPage);
        this.hostID_ = hostID;
    }

    public void createWidgetControl(Composite parent) {
        this.factory_ = PropertyUIFactory.newInstance((boolean)true);
        this.factory_.isShowAll(true);
        this.factory_.setStyle(1);
        this.factory_.setRootGroupingStyle(2);
        this.factory_.setPropertyUIWidgetDelayedTimer(750);
        IPropertyUIWidgetFactory uiFactory = this.factory_.getUIFactory();
        this.scroller_ = uiFactory.createPropertyUIScrollableComposite(parent, 768);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.scroller_.setLayout((Layout)new GridLayout());
        this.scroller_.setLayoutData((Object)new GridData(1808));
        this.blankArea_ = uiFactory.createComposite((Composite)this.scroller_, 0);
        this.scroller_.setContent((Control)this.blankArea_);
        this.shell_ = parent.getShell();
        this.asModifier_ = new AnnotationSourceModifier();
        this.asModifier_.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("ANNOTATION_MODIFIER_ANNOTATION_CHANGED".equals(evt.getPropertyName())) {
                    if (evt.getOldValue() != null) {
                        ++AnnotationViewWidget.this.modifyCount_;
                    } else if (AnnotationViewWidget.this.modifyCount_ > 0) {
                        --AnnotationViewWidget.this.modifyCount_;
                    }
                }
            }
        });
        this.synchronizer_ = new AnnotationViewSynchronizer();
        this.startWorking();
        if (this.workingPage_ != null) {
            this.workingPage_.removePartListener(this.partListener_);
            this.workingPage_.addPartListener(this.partListener_);
        }
    }

    public void setMessageHandler(AnnotationViewWidgetMessageHandler newHandler) {
        this.messageHandler_ = newHandler;
    }

    public void setFocus() {
        if (this.viewer_ != null && !this.viewer_.getControl().isDisposed()) {
            this.viewer_.getControl().setFocus();
        }
    }

    public void dispose() {
        this.stopWorking();
        if (this.workingPage_ != null) {
            this.workingPage_.removePartListener(this.partListener_);
        }
        this.clear();
        if (this.asModifier_ != null) {
            this.asModifier_.dispose();
        }
        if (this.annotationTreeWidget_ != null) {
            this.annotationTreeWidget_.dispose();
        }
        if (this.workingCopy_ != null) {
            try {
                this.workingCopy_.discardWorkingCopy();
            }
            catch (Exception exception) {}
            this.workingCopy_ = null;
        }
    }

    public Control getWidgetContainer() {
        return this.scroller_;
    }

    public void propertyUIChange(PropertyUIChangeEvent evt) {
        if (evt.getSource() instanceof PropertyUIWidget) {
            PropertyUIWidget widget = (PropertyUIWidget)evt.getSource();
            int status = widget.getStatus();
            if (status != 4) {
                this.validateView();
            } else {
                this.showErrorMessage(4, widget.getErrorMessage());
            }
        }
    }

    public void propertyChange(com.ibm.propertygroup.PropertyChangeEvent evt) {
        if (evt.getPropertyChangeType() == 0) {
            IAnnotationAttributeProperty attribute;
            Object source = evt.getSource();
            if (source instanceof IAnnotationAttributeProperty && Display.getCurrent() != null && (attribute = this.annotationTreeWidget_.getFocusAttribute((IAnnotationAttributeProperty)source)) != null) {
                if (this.workingAttribute_ == null) {
                    this.workingAttribute_ = new WorkingAttributeWrapper();
                }
                if (this.workingAttribute_.attribute_ == null || attribute.getParentAnnotation() != this.workingAttribute_.attribute_.getParentAnnotation()) {
                    this.workingAttribute_.isIncomplete_ = InternalUtils.getIncompleteAttribute((AnnotationInfo)attribute.getParentAnnotation()) != null;
                }
                this.workingAttribute_.attribute_ = attribute;
                this.asModifier_.performModifyAttribute(evt, attribute);
            }
        } else if (evt.getSource() instanceof JavaElementInfoPG) {
            if (this.isWorking_) {
                if (Display.getCurrent() != null) {
                    this.refreshAnnotationModel();
                } else {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AnnotationViewWidget.this.refreshAnnotationModel();
                        }
                    });
                }
            } else {
                this.modelNeedToBeUpdated_ = true;
            }
        }
    }

    protected void initWidget(IWorkbenchPage page) {
        this.workingPage_ = page;
        this.propertyListener = this;
        this.propertyUIListener = this;
        this.partListener_ = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference ref) {
                if (AnnotationViewWidget.this.workingPage_ != null && AnnotationViewWidget.this.workingPage_.equals(ref.getPage())) {
                    IWorkbenchPart part = ref.getPart(false);
                    if (part != null && part instanceof ContentOutline) {
                        if (AnnotationViewWidget.this.isSupportedContentOutline((ContentOutline)part)) {
                            AnnotationViewWidget.this.outlineChangedListener_.setContentOutline((ContentOutline)part);
                        }
                    } else {
                        AnnotationViewWidget.this.processSelectionChangedEvent_ = true;
                        if (ref.getPage().getActiveEditor() != null) {
                            if (!AnnotationViewWidget.this.isSupportedEditorPart((IWorkbenchPart)ref.getPage().getActiveEditor()) && AnnotationViewWidget.this.model_ != null) {
                                AnnotationViewWidget.this.updateAnnotationModel(null, 0);
                                AnnotationViewWidget.this.processSelectionChangedEvent_ = false;
                            }
                        } else {
                            AnnotationViewWidget.this.updateAnnotationModel(null, 0);
                            AnnotationViewWidget.this.processSelectionChangedEvent_ = false;
                        }
                    }
                }
            }

            public void partClosed(IWorkbenchPartReference ref) {
                if (ref.getPage().getActiveEditor() == null && AnnotationViewWidget.this.model_ != null) {
                    AnnotationViewWidget.this.updateAnnotationModel(null, 0);
                }
            }

            public void partVisible(IWorkbenchPartReference ref) {
                if (ref.getId().equals(AnnotationViewWidget.this.hostID_)) {
                    AnnotationViewWidget.this.startWorking();
                }
            }

            public void partHidden(IWorkbenchPartReference ref) {
                if (ref.getId().equals(AnnotationViewWidget.this.hostID_)) {
                    AnnotationViewWidget.this.stopWorking();
                }
            }

            public void partDeactivated(IWorkbenchPartReference ref) {
                IWorkbenchPart part = ref.getPart(false);
                if (part != null && part instanceof ContentOutline && AnnotationViewWidget.this.outlineChangedListener_.isListeningContentOutline((ContentOutline)part)) {
                    AnnotationViewWidget.this.outlineChangedListener_.stopWorking();
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference ref) {
            }

            public void partInputChanged(IWorkbenchPartReference ref) {
            }

            public void partOpened(IWorkbenchPartReference ref) {
            }
        };
    }

    protected void startWorking() {
        IWorkbenchWindow wWindow;
        if (this.isWorking_) {
            return;
        }
        this.isWorking_ = true;
        this.processSelectionChangedEvent_ = true;
        if (this.workingPage_ == null && (wWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            this.workingPage_ = wWindow.getActivePage();
        }
        if (this.workingPage_ != null && this.synchronizer_ != null) {
            this.workingPage_.removePostSelectionListener((ISelectionListener)this.synchronizer_);
            this.workingPage_.addPostSelectionListener((ISelectionListener)this.synchronizer_);
            IEditorPart iEp = this.workingPage_.getActiveEditor();
            if (iEp != null) {
                if (iEp.getSite().getSelectionProvider() != null) {
                    this.performSelectionChanged((IWorkbenchPart)iEp, iEp.getSite().getSelectionProvider().getSelection());
                } else {
                    this.updateAnnotationModel(null, 0);
                }
            } else if (this.model_ != null) {
                this.updateAnnotationModel(null, 0);
            }
        } else if (this.model_ != null) {
            this.updateAnnotationModel(null, 0);
        }
        this.outlineChangedListener_.startWorking();
    }

    protected void stopWorking() {
        if (this.workingPage_ != null) {
            this.workingPage_.removePostSelectionListener((ISelectionListener)this.synchronizer_);
        }
        this.isWorking_ = false;
        this.processSelectionChangedEvent_ = false;
        this.outlineChangedListener_.stopWorking();
    }

    protected boolean validateView() {
        ArrayList<PropertyUIWidget> widgets;
        if (this.annotationTreeWidget_ != null && (widgets = this.annotationTreeWidget_.getPropertyWidgets()) != null) {
            boolean isWarning = false;
            String message = null;
            int i = 0;
            while (i < widgets.size()) {
                PropertyUIWidget widget = widgets.get(i);
                int status = widget.getStatus();
                switch (status) {
                    case 4: {
                        this.showErrorMessage(status, widget.getErrorMessage());
                        return false;
                    }
                    case 2: {
                        if (message != null) break;
                        message = widget.getErrorMessage();
                        isWarning = true;
                        break;
                    }
                    case 1: {
                        if (message != null) break;
                        message = widget.getErrorMessage();
                        isWarning = false;
                        break;
                    }
                }
                ++i;
            }
            if (message != null) {
                if (isWarning) {
                    this.showErrorMessage(2, message);
                } else {
                    this.showErrorMessage(1, message);
                }
                return true;
            }
        }
        this.showErrorMessage(0, null);
        return true;
    }

    protected void showErrorMessage(int status, String message) {
        if (this.editorAdapter_ != null) {
            this.editorAdapter_.showErrorMessage(status, message);
        }
        if (this.messageHandler_ != null) {
            this.messageHandler_.showErrorMessage(status, message);
        }
    }

    protected void refreshAnnotationModel() {
        boolean refreshWidget;
        List<AnnotationInfo> oldAis = this.annotationTreeWidget_.getAnnotationInfoList();
        List newAis = AnnotationUtils.getAnnotationInfosForJavaElementInfo((AnnotatedClassInfo)this.model_, (boolean)false);
        WorkingAttributeWrapper attribute = this.workingAttribute_;
        AnnotationInfo newAnnotation = this.newAddedAnnotation_;
        this.workingAttribute_ = null;
        this.newAddedAnnotation_ = null;
        if (!this.compareAnnotationInfoLists(oldAis, newAis) && (refreshWidget = true) && this.model_ != null) {
            try {
                int offset = -1;
                this.viewer_.removeSelectionChangedListener((ISelectionChangedListener)this.synchronizer_);
                this.removeModelChangedListener((JavaElementInfo)this.model_);
                if (this.modifyCount_ > 0 && (this.workingPage_ == null || this.hostID_ != null && !this.workingPage_.getActivePart().getSite().getId().equals(this.hostID_))) {
                    this.modifyCount_ = 0;
                }
                if (this.modifyCount_ > 0) {
                    AnnotationInfo annoInfo;
                    IAnnotationAttributeProperty retAttri;
                    offset = this.currentOffset_;
                    --this.modifyCount_;
                    boolean stop = true;
                    if (attribute != null) {
                        stop = !attribute.isIncomplete_;
                    }
                    this.annotationTreeWidget_.stopDisplayingAttributes(stop);
                    this.annotationTreeWidget_.refreshAnnotationModel();
                    if (attribute != null && (retAttri = this.annotationTreeWidget_.setFocusTo(attribute.attribute_)) != null && (annoInfo = retAttri.getParentAnnotation()) != null) {
                        offset = annoInfo.getOffset();
                    }
                    this.annotationTreeWidget_.stopDisplayingAttributes(false);
                } else if (newAnnotation != null) {
                    AnnotationInfo retInfo;
                    offset = this.currentOffset_;
                    this.annotationTreeWidget_.refreshAnnotationModel();
                    JavaElementInfo jeInfo = newAnnotation.getParentJavaElementInfo();
                    if (jeInfo != null && jeInfo.getJavaElement() != null && (retInfo = this.annotationTreeWidget_.select(jeInfo.getJavaElement(), AnnotationUIUtils.getAnnotationInfoLabel(newAnnotation))) != null) {
                        offset = retInfo.getOffset();
                    }
                } else {
                    IAnnotation annotation;
                    boolean showingJPAAnnotation = false;
                    AnnotationInfo jpaAnnoInfo = this.annotationTreeWidget_.getSelectedJPAAnnotation();
                    if (jpaAnnoInfo != null && (annotation = jpaAnnoInfo.getAnnotation()) != null) {
                        try {
                            ISourceRange range = annotation.getSourceRange();
                            int iStart = range.getOffset();
                            int length = range.getLength();
                            if (iStart <= this.currentOffset_ && this.currentOffset_ <= iStart + length) {
                                showingJPAAnnotation = true;
                            }
                        }
                        catch (Exception exception) {}
                    }
                    if (showingJPAAnnotation && this.workingPage_ != null && this.workingPage_.getActivePart().getSite().getId().equals(this.hostID_)) {
                        this.annotationTreeWidget_.stopDisplayingAttributes(true);
                        this.annotationTreeWidget_.refreshAnnotationModel();
                        this.annotationTreeWidget_.updateAttributeTab(jpaAnnoInfo);
                        this.annotationTreeWidget_.stopDisplayingAttributes(false);
                    } else {
                        this.annotationTreeWidget_.refreshAnnotationModel();
                    }
                }
                if (this.workingEditorPart_ != null && offset > -1) {
                    this.syncEditor(offset);
                }
                this.addModelChangedListener((JavaElementInfo)this.model_);
                this.viewer_.addSelectionChangedListener((ISelectionChangedListener)this.synchronizer_);
            }
            catch (Exception e) {
                AnnotationUIUtils.showExceptionMessage(e, this.shell_, null, e.getMessage());
            }
        }
    }

    protected boolean compareAnnotationInfoLists(List<AnnotationInfo> oldList, List<AnnotationInfo> newList) {
        if (oldList == null || newList == null) {
            return false;
        }
        if (oldList.size() != newList.size()) {
            return false;
        }
        int i = 0;
        while (i < oldList.size()) {
            AnnotationInfo anInfo = oldList.get(i);
            if (!newList.contains(anInfo)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void hookEditorListener() {
    }

    protected void updateToolBar(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)this.viewer_.getSelection();
        if (selection != null && !selection.isEmpty()) {
            for (Object element : selection) {
                if (element instanceof AnnotationNodeProperty && !((AnnotationNodeProperty)((Object)element)).getAnnotationInfo().isImpliedAnnotation()) continue;
                this.deleteAnnotationAction_.setEnabled(false);
                return;
            }
            this.deleteAnnotationAction_.setEnabled(true);
        } else {
            this.deleteAnnotationAction_.setEnabled(false);
        }
    }

    protected AnnotationParser getAnnotationParser() {
        return this.annotationParser_;
    }

    protected void createAnnotationTreeWidget() {
        try {
            AnnotatedClassInfo aModel = this.model_;
            if (aModel == null) {
                aModel = new AnnotatedClassInfo((IJavaElement)this.getCompilationUnit());
            }
            if (this.annotationTreeWidget_ == null) {
                ArrayList<IPropertyChangeListener> pList = new ArrayList<IPropertyChangeListener>(1);
                pList.add(this.propertyListener);
                ArrayList<IPropertyUIChangeListener> uiList = new ArrayList<IPropertyUIChangeListener>(1);
                uiList.add(this.propertyUIListener);
                this.annotationTreeWidget_ = new AnnotationTreeWidget(new DynamicGenStore((AbstractUIPlugin)Activator.getDefault()), aModel, pList, uiList);
                this.annotationTreeWidget_.createControls((Composite)this.scroller_, this.factory_);
                this.annotationTreeWidget_.setContributionItem(this.createContributionItems());
                this.viewer_ = this.annotationTreeWidget_.getTreeViewer();
                this.viewer_.removeSelectionChangedListener((ISelectionChangedListener)this.synchronizer_);
                this.viewer_.addSelectionChangedListener((ISelectionChangedListener)this.synchronizer_);
                this.viewer_.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(final SelectionChangedEvent event) {
                        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AnnotationViewWidget.this.updateToolBar(event);
                            }
                        });
                    }
                });
            } else {
                this.viewer_.removeSelectionChangedListener((ISelectionChangedListener)this.synchronizer_);
                this.annotationTreeWidget_.changeAnnotationModel(aModel, this.currentOffset_);
                this.viewer_.addSelectionChangedListener((ISelectionChangedListener)this.synchronizer_);
            }
            Composite container = this.annotationTreeWidget_.getContainer();
            if (!container.equals(this.scroller_.getContent())) {
                this.scroller_.setContent((Control)container);
                this.scroller_.reflow(true);
            }
        }
        catch (Exception e) {
            AnnotationUIUtils.showExceptionMessage(e, this.shell_, null, e.getMessage());
        }
    }

    protected IContributionItem[] createContributionItems() {
        Action addAnnotationAction = new Action("Add"){

            public void run() {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ICompilationUnit unit = AnnotationViewWidget.this.getCompilationUnit();
                        AddAnnotationDialog addAnnot = new AddAnnotationDialog((this).AnnotationViewWidget.this.shell_, AnnotationsUIMessages.ANNOTATIONS_UI_ACTION_ADD_ANNOTATION, AnnotationViewWidget.this.getDefaultJavaElement(unit));
                        int ret = addAnnot.open();
                        if (ret == 0) {
                            AnnotationInfo annInfo = addAnnot.getSelection();
                            IJavaElement targetJavaElement = addAnnot.getTargetJavaElement();
                            if (targetJavaElement == null) {
                                targetJavaElement = AnnotationUIContextHelper.getContextForContentAssist(unit, (this).AnnotationViewWidget.this.currentOffset_);
                            }
                            try {
                                annInfo.setJavaElementInfo(new JavaElementInfo(targetJavaElement, null));
                                (this).AnnotationViewWidget.this.newAddedAnnotation_ = annInfo;
                                AnnotationParser annotationParser = AnnotationViewWidget.this.getAnnotationParser();
                                annotationParser.addAnnotationToCU(unit, annInfo, targetJavaElement, false, (this).AnnotationViewWidget.this.performReconcile_);
                            }
                            catch (Exception e) {
                                AnnotationUIUtils.showExceptionMessage(e, (this).AnnotationViewWidget.this.shell_, null, e.getMessage());
                            }
                        }
                    }
                });
            }
        };
        addAnnotationAction.setToolTipText(AnnotationsUIMessages.ANNOTATIONS_UI_ACTION_ADD_ANNOTATION_DESC);
        addAnnotationAction.setImageDescriptor(Activator.getImageDescriptor("icons/obj16/addAnnotation.gif"));
        this.deleteAnnotationAction_ = new Action("Delete"){

            public void run() {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ICompilationUnit unit = AnnotationViewWidget.this.getCompilationUnit();
                        StructuredSelection selection = (StructuredSelection)(this).AnnotationViewWidget.this.viewer_.getSelection();
                        if (selection != null && !selection.isEmpty()) {
                            AnnotationParser annotationParser = AnnotationViewWidget.this.getAnnotationParser();
                            for (Object element : selection) {
                                if (!(element instanceof AnnotationNodeProperty)) continue;
                                AnnotationInfo annInfo = ((AnnotationNodeProperty)((Object)element)).getAnnotationInfo();
                                annotationParser.removeAnnotation(unit, annInfo, false, (this).AnnotationViewWidget.this.performReconcile_);
                            }
                        }
                    }
                });
            }
        };
        this.deleteAnnotationAction_.setToolTipText(AnnotationsUIMessages.ANNOTATIONS_UI_ACTION_DELETE_ANNOTATION_DESC);
        this.deleteAnnotationAction_.setImageDescriptor(Activator.getImageDescriptor("icons/obj16/deleteAnnotation.gif"));
        this.deleteAnnotationAction_.setEnabled(false);
        Action collapseAllAction = new Action("CollapseAll"){

            public void run() {
                if (AnnotationViewWidget.this.viewer_ != null && !AnnotationViewWidget.this.viewer_.getControl().isDisposed()) {
                    AnnotationViewWidget.this.viewer_.collapseAll();
                }
            }
        };
        collapseAllAction.setToolTipText(AnnotationsUIMessages.ANNOTATIONS_UI_ACTION_COLLAPSE_ALL_DESC);
        collapseAllAction.setImageDescriptor(Activator.getImageDescriptor("icons/obj16/collapseall.gif"));
        Action filterAction = new Action("FilterAction", 2){

            public void run() {
                boolean checked = this.isChecked();
                AnnotationViewWidget.this.annotationTreeWidget_.showFilterTextField(checked);
                if (checked) {
                    this.setToolTipText(PropertyUIMessages.PROPERTY_UI_WIDGETS_TOOLBAR_DISABLE_FILTER_DESC);
                } else {
                    this.setToolTipText(PropertyUIMessages.PROPERTY_UI_WIDGETS_TOOLBAR_ENABLE_FILTER_DESC);
                }
            }
        };
        filterAction.setToolTipText(PropertyUIMessages.PROPERTY_UI_WIDGETS_TOOLBAR_ENABLE_FILTER_DESC);
        filterAction.setImageDescriptor(PropertyUIPlugin.getImageDescriptor((String)"icons/filter_obj.gif"));
        return new IContributionItem[]{new ActionContributionItem((IAction)addAnnotationAction), new ActionContributionItem(this.deleteAnnotationAction_), new Separator(), new ActionContributionItem((IAction)collapseAllAction), new ActionContributionItem((IAction)filterAction)};
    }

    protected IJavaElement getDefaultJavaElement(ICompilationUnit cu) {
        ISelection sel;
        ICompilationUnit defaultJE = null;
        if (this.viewer_ != null && !this.viewer_.getControl().isDisposed() && !(sel = this.viewer_.getSelection()).isEmpty() && sel instanceof StructuredSelection) {
            Object oSel = ((StructuredSelection)sel).getFirstElement();
            if (oSel instanceof AnnotationNodeProperty) {
                AnnotationInfo annoInfo = ((AnnotationNodeProperty)((Object)oSel)).getAnnotationInfo();
                if (annoInfo != null && annoInfo.getParentJavaElementInfo() != null) {
                    defaultJE = annoInfo.getParentJavaElementInfo().getJavaElement();
                }
            } else if (oSel instanceof JavaElementNodeProperty) {
                defaultJE = ((JavaElementNodeProperty)((Object)oSel)).getJavaElement();
            }
        }
        if (defaultJE == null) {
            try {
                defaultJE = cu.getElementAt(this.currentOffset_);
                if (defaultJE == null) {
                    defaultJE = cu;
                }
            }
            catch (Exception exception) {
                defaultJE = cu;
            }
        }
        return defaultJE;
    }

    protected ICompilationUnit getCompilationUnit() {
        if (this.model_ != null) {
            return (ICompilationUnit)this.model_.getJavaElementForThisClass();
        }
        return this.getCompilationUnitFromEditor();
    }

    protected ICompilationUnit getCompilationUnitFromEditor() {
        IJavaElement javaElement;
        Object adapter;
        ICompilationUnit compUnit_ = null;
        if (this.editorAdapter_ == null && this.workingEditorPart_ != null && this.workingEditorPart_ instanceof IEditorPart && (adapter = ((IEditorPart)this.workingEditorPart_).getEditorInput().getAdapter(IJavaElement.class)) != null && (javaElement = (IJavaElement)adapter) instanceof ICompilationUnit) {
            compUnit_ = (ICompilationUnit)javaElement;
        }
        return compUnit_;
    }

    protected void clear() {
        if (this.annotationTreeWidget_ != null) {
            this.annotationTreeWidget_.clearAnnotationTreeWidget();
        }
        if (this.viewer_ != null) {
            this.viewer_.removeSelectionChangedListener((ISelectionChangedListener)this.synchronizer_);
        }
        if (this.model_ != null) {
            this.model_.makeSourceListener(false);
            this.removeModelChangedListener((JavaElementInfo)this.model_);
        }
        this.annotationParser_ = null;
        if (this.asModifier_ != null) {
            this.asModifier_.clearModifier();
        }
    }

    protected void performSynchronizeSourceView(final ISelection sel) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                int offset = -1;
                if (!sel.isEmpty() && sel instanceof StructuredSelection) {
                    Object oSel = ((StructuredSelection)sel).getFirstElement();
                    if (oSel instanceof AnnotationNodeProperty) {
                        offset = ((AnnotationNodeProperty)((Object)oSel)).getAnnotationInfo().getOffset();
                    } else if (oSel instanceof JavaElementNodeProperty) {
                        offset = ((JavaElementNodeProperty)((Object)oSel)).getJavaElementOffset();
                    } else if (oSel instanceof AnnotationAttributeNodeProperty) {
                        INodeProperty[] children = ((AnnotationAttributeNodeProperty)((Object)oSel)).getChildren();
                        if (children != null && children.length > 0) {
                            offset = ((AnnotationNodeProperty)children[0]).getAnnotationInfo().getOffset();
                            offset = offset > 2 ? offset - 2 : offset;
                        } else {
                            AnnotationInfo info = ((AnnotationAttributeNodeProperty)((Object)oSel)).getAnnotationAttributeProperty().getParentAnnotation();
                            if (info != null) {
                                offset = info.getOffset();
                            }
                        }
                    }
                }
                if (offset > 0 && AnnotationViewWidget.this.workingEditorPart_ != null) {
                    AnnotationViewWidget.this.syncEditor(offset);
                }
            }
        });
    }

    protected void performSynchronizeAnnotationTreeView(final int offset) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (AnnotationViewWidget.this.viewer_ != null && !AnnotationViewWidget.this.viewer_.getTree().isDisposed()) {
                    AnnotationViewWidget.this.viewer_.removeSelectionChangedListener((ISelectionChangedListener)AnnotationViewWidget.this.synchronizer_);
                    AnnotationViewWidget.this.annotationTreeWidget_.select(offset);
                    AnnotationViewWidget.this.showErrorMessage(0, null);
                    AnnotationViewWidget.this.viewer_.addSelectionChangedListener((ISelectionChangedListener)AnnotationViewWidget.this.synchronizer_);
                }
            }
        });
    }

    protected void addModelChangedListener(JavaElementInfo jei) {
        JavaElementInfo[] epa;
        AnnotationInfo[] ai;
        if (jei.getAnnotationInfoPG() != null) {
            jei.getAnnotationInfoPG().removePropertyChangeListener((IPropertyChangeListener)this);
            jei.getAnnotationInfoPG().addPropertyChangeListener((IPropertyChangeListener)this);
        }
        if (jei.getJavaElementInfoPG() != null) {
            jei.getJavaElementInfoPG().removePropertyChangeListener((IPropertyChangeListener)this);
            jei.getJavaElementInfoPG().addPropertyChangeListener((IPropertyChangeListener)this);
        }
        if ((ai = jei.getAnnotationInfoObjects()) != null) {
            int i = 0;
            while (i < ai.length) {
                ai[i].removePropertyChangeListener((IPropertyChangeListener)this);
                ai[i].addPropertyChangeListener((IPropertyChangeListener)this);
                ++i;
            }
        }
        if ((epa = jei.getJavaElementInfoObjects()) != null) {
            int i = 0;
            while (i < epa.length) {
                this.addModelChangedListener(epa[i]);
                ++i;
            }
        }
    }

    protected void removeModelChangedListener(JavaElementInfo jei) {
        JavaElementInfo[] epa;
        AnnotationInfo[] ai;
        if (jei.getAnnotationInfoPG() != null) {
            jei.getAnnotationInfoPG().removePropertyChangeListener((IPropertyChangeListener)this);
        }
        if (jei.getJavaElementInfoPG() != null) {
            jei.getJavaElementInfoPG().removePropertyChangeListener((IPropertyChangeListener)this);
        }
        if ((ai = jei.getAnnotationInfoObjects()) != null) {
            int i = 0;
            while (i < ai.length) {
                ai[i].removePropertyChangeListener((IPropertyChangeListener)this);
                ++i;
            }
        }
        if ((epa = jei.getJavaElementInfoObjects()) != null) {
            int i = 0;
            while (i < epa.length) {
                this.removeModelChangedListener(epa[i]);
                ++i;
            }
        }
    }

    protected void updateAnnotationModel(ICompilationUnit compUnit, int offset) {
        if (compUnit != null) {
            if (this.model_ == null || !this.model_.getJavaElementForThisClass().equals(compUnit)) {
                if (!compUnit.isWorkingCopy()) {
                    try {
                        compUnit = compUnit.getWorkingCopy(null);
                        this.performReconcile_ = true;
                        if (this.workingCopy_ != null && !this.workingCopy_.equals(compUnit)) {
                            this.workingCopy_.discardWorkingCopy();
                        }
                        this.workingCopy_ = compUnit;
                    }
                    catch (Exception exception) {}
                } else {
                    this.performReconcile_ = !this.isJDTEditorOpenForCU(compUnit);
                    if (this.workingCopy_ != null) {
                        try {
                            this.workingCopy_.discardWorkingCopy();
                        }
                        catch (Exception exception) {}
                        this.workingCopy_ = null;
                    }
                }
                this.currentOffset_ = -100;
                this.annotationParser_ = new AnnotationParser();
                if (this.asModifier_ != null) {
                    this.asModifier_.setModificationInfo(compUnit, this.annotationParser_, this.performReconcile_);
                }
                AnnotatedClassInfo classInfo = this.annotationParser_.getAnnotatedClassInfo((IJavaElement)compUnit, offset, true);
                if (this.model_ != null) {
                    this.model_.makeSourceListener(false);
                    this.removeModelChangedListener((JavaElementInfo)this.model_);
                }
                this.model_ = classInfo;
                try {
                    if (this.model_ == null) {
                        this.model_ = new AnnotatedClassInfo((IJavaElement)compUnit);
                    }
                    this.createAnnotationTreeWidget();
                    this.model_.makeSourceListener();
                    this.addModelChangedListener((JavaElementInfo)this.model_);
                }
                catch (Exception e) {
                    AnnotationUIUtils.showExceptionMessage(e, this.shell_, null, e.getMessage());
                }
            } else if (this.modelNeedToBeUpdated_) {
                this.viewer_.removeSelectionChangedListener((ISelectionChangedListener)this.synchronizer_);
                this.removeModelChangedListener((JavaElementInfo)this.model_);
                this.annotationTreeWidget_.refreshAnnotationModel();
                this.addModelChangedListener((JavaElementInfo)this.model_);
                this.viewer_.addSelectionChangedListener((ISelectionChangedListener)this.synchronizer_);
                this.modelNeedToBeUpdated_ = true;
            }
            if (this.currentOffset_ != offset) {
                this.currentOffset_ = offset;
                if (this.model_ != null) {
                    this.performSynchronizeAnnotationTreeView(offset);
                }
            }
        } else {
            this.clear();
            this.model_ = null;
            if (!this.scroller_.isDisposed() && !this.blankArea_.isDisposed()) {
                this.scroller_.setContent((Control)this.blankArea_);
            }
        }
    }

    protected boolean isJDTEditorOpenForCU(ICompilationUnit cu) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IEditorReference[] editorRefs = page.getEditorReferences();
            int i = 0;
            while (i < editorRefs.length) {
                Object adapter;
                IEditorPart part = editorRefs[i].getEditor(false);
                if (part != null && (adapter = part.getEditorInput().getAdapter(IJavaElement.class)) != null && adapter instanceof ICompilationUnit && ((ICompilationUnit)adapter).equals(cu)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void performSelectionChanged(SelectionChangedEvent event) {
        Control control = null;
        if (this.viewer_ != null) {
            control = this.viewer_.getControl();
        }
        if (!control.isDisposed() && control.isFocusControl()) {
            ISelection sel = event.getSelection();
            this.performSynchronizeSourceView(sel);
            this.showErrorMessage(0, null);
            this.modifyCount_ = 0;
        }
    }

    protected void performSelectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof ContentOutline) {
            this.editorAdapter_ = null;
            IContributedContentsView view = (IContributedContentsView)part.getAdapter(IContributedContentsView.class);
            if (view != null) {
                IWorkbenchPart cPart = view.getContributingPart();
                AnnotationViewAccessAdapter annotationViewAccessAdapter = this.editorAdapter_ = cPart != null ? (AnnotationViewAccessAdapter)cPart.getAdapter(AnnotationViewAccessAdapter.class) : null;
            }
            if (this.editorAdapter_ == null) {
                if (this.viewer_ != null && selection instanceof StructuredSelection) {
                    try {
                        int offset;
                        IMember m;
                        IMember jelt = null;
                        Object o = ((StructuredSelection)this.viewer_.getSelection()).getFirstElement();
                        if (o instanceof JavaElementNodeProperty) {
                            if (((JavaElementNodeProperty)((Object)o)).getJavaElement() instanceof IMember) {
                                jelt = (IMember)((JavaElementNodeProperty)((Object)o)).getJavaElement();
                            }
                        } else if (o instanceof AnnotationNodeProperty && ((AnnotationNodeProperty)((Object)o)).getAnnotationInfo().getParentJavaElementInfo() instanceof IMember) {
                            jelt = (IMember)((AnnotationNodeProperty)((Object)o)).getAnnotationInfo().getParentJavaElementInfo();
                        }
                        if (this.model_ != null && !((StructuredSelection)selection).isEmpty() && (jelt == null || !((StructuredSelection)selection).getFirstElement().equals(jelt) && !((StructuredSelection)selection).getFirstElement().equals(jelt.getParent())) && ((StructuredSelection)selection).getFirstElement() instanceof IMember && (m = (IMember)((StructuredSelection)selection).getFirstElement()).getNameRange() != null && this.currentOffset_ != (offset = m.getNameRange().getOffset())) {
                            this.currentOffset_ = offset;
                            this.performSynchronizeAnnotationTreeView(offset);
                        }
                    }
                    catch (JavaModelException e) {
                        AnnotationUIUtils.showExceptionMessage(e, this.shell_, null, e.getMessage());
                    }
                }
                return;
            }
        } else {
            this.editorAdapter_ = (AnnotationViewAccessAdapter)part.getAdapter(AnnotationViewAccessAdapter.class);
        }
        if (this.editorAdapter_ != null) {
            this.workingEditorPart_ = part;
            AnnotationViewSelectionInfo info = this.editorAdapter_.getSelectionInfo(part, selection);
            if (info != null) {
                this.updateAnnotationModel(info.getCompilationUnit(), info.getOffset());
            } else {
                this.updateAnnotationModel(null, 0);
            }
        } else if (part instanceof IEditorPart) {
            this.workingEditorPart_ = part;
            Object adapter = ((IEditorPart)this.workingEditorPart_).getEditorInput().getAdapter(IJavaElement.class);
            if (adapter != null && selection instanceof ITextSelection && adapter instanceof ICompilationUnit) {
                this.updateAnnotationModel((ICompilationUnit)adapter, ((ITextSelection)selection).getOffset());
            } else {
                this.updateAnnotationModel(null, 0);
            }
        } else {
            this.workingEditorPart_ = null;
        }
    }

    protected boolean isSupportedEditorPart(IWorkbenchPart part) {
        if (part != null) {
            Object adapter;
            IEditorPart iep;
            if (part.getAdapter(AnnotationViewAccessAdapter.class) != null) {
                return true;
            }
            if (part instanceof IEditorPart ? (iep = (IEditorPart)part).getEditorInput() != null && (adapter = iep.getEditorInput().getAdapter(IJavaElement.class)) != null && adapter instanceof ICompilationUnit : part instanceof ContentOutline && this.viewer_ != null) {
                return true;
            }
        }
        return false;
    }

    protected boolean isSupportedContentOutline(ContentOutline outline) {
        IWorkbenchPart part;
        IContributedContentsView view = (IContributedContentsView)outline.getAdapter(IContributedContentsView.class);
        return view != null && (part = view.getContributingPart()) != null && part.getAdapter(AnnotationViewAccessAdapter.class) != null;
    }

    protected void syncEditor(int offset) {
        if (this.workingPage_ != null && this.synchronizer_ != null) {
            this.workingPage_.removePostSelectionListener((ISelectionListener)this.synchronizer_);
        }
        this.currentOffset_ = offset;
        if (this.editorAdapter_ != null) {
            this.editorAdapter_.syncEditor(this.workingEditorPart_, offset);
        } else if (this.workingEditorPart_ instanceof IEditorPart) {
            AnnotationUIUtils.positionCursor(offset, (IEditorPart)this.workingEditorPart_);
        }
        if (this.workingPage_ != null && this.synchronizer_ != null) {
            this.workingPage_.addPostSelectionListener((ISelectionListener)this.synchronizer_);
        }
    }

    protected class AnnotationViewOutlineChangedListener
    implements ISelectionChangedListener {
        protected ContentOutline contentOutline_;

        protected AnnotationViewOutlineChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (AnnotationViewWidget.this.processSelectionChangedEvent_) {
                AnnotationViewWidget.this.performSelectionChanged((IWorkbenchPart)this.contentOutline_, event.getSelection());
            }
        }

        public void startWorking() {
            if (this.contentOutline_ != null && AnnotationViewWidget.this.isWorking_) {
                this.contentOutline_.removeSelectionChangedListener((ISelectionChangedListener)this);
                this.contentOutline_.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void stopWorking() {
            if (this.contentOutline_ != null) {
                this.contentOutline_.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void setContentOutline(ContentOutline newOutline) {
            if (newOutline == null) {
                this.stopWorking();
                this.contentOutline_ = null;
            } else if (!newOutline.equals(this.contentOutline_)) {
                this.stopWorking();
                this.contentOutline_ = newOutline;
                this.startWorking();
            } else {
                this.startWorking();
            }
        }

        public boolean isListeningContentOutline(ContentOutline outline) {
            return outline.equals(this.contentOutline_);
        }
    }

    protected class AnnotationViewSynchronizer
    implements ISelectionChangedListener,
    ISelectionListener {
        protected AnnotationViewSynchronizer() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            AnnotationViewWidget.this.performSelectionChanged(event);
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (AnnotationViewWidget.this.processSelectionChangedEvent_) {
                AnnotationViewWidget.this.performSelectionChanged(part, selection);
            }
        }
    }

    protected class WorkingAttributeWrapper {
        public IAnnotationAttributeProperty attribute_;
        public boolean isIncomplete_;

        protected WorkingAttributeWrapper() {
        }
    }
}

