/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui;

import com.ibm.etools.annotations.core.utils.AnnotationConstants;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AnnotationUIContextHelper {
    public static int contentassistoffset = 0;

    public static int getContentAssistOffset() {
        return contentassistoffset;
    }

    public static IJavaElement getContextWithEditorPart(ICompilationUnit cu) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEditorReference[] editorReferences = window.getActivePage().getEditorReferences();
        int i = 0;
        while (i < editorReferences.length) {
            ISelection selection;
            IEditorPart editor;
            if (editorReferences[i] != null && (editor = editorReferences[i].getEditor(false)) != null && editor.getEditorSite() != null && editor.getEditorSite().getSelectionProvider() != null && (selection = editor.getEditorSite().getSelectionProvider().getSelection()) instanceof ITextSelection) {
                ITextSelection textSel = (ITextSelection)selection;
                try {
                    IJavaElement selectJavaElement;
                    if (cu != null && textSel != null && textSel.getLength() > 0 && (selectJavaElement = cu.getElementAt(textSel.getOffset())) != null) {
                        if (textSel.getText() != null && textSel.getText().contains(selectJavaElement.getElementName())) {
                            return selectJavaElement;
                        }
                        if (textSel.getText() != null && textSel.getText().contains("@")) {
                            return selectJavaElement;
                        }
                        return selectJavaElement;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            ++i;
        }
        return null;
    }

    public static int getOffset(IJavaElement elm, int contentAssistOffset) {
        if (elm != null && elm instanceof ISourceReference) {
            try {
                String mySource = ((ISourceReference)elm).getSource();
                int rangeStartOffset = 0;
                ISourceRange range = ((ISourceReference)elm).getSourceRange();
                if (range != null && mySource != null) {
                    rangeStartOffset = range.getOffset();
                    if (contentAssistOffset <= rangeStartOffset) {
                        return rangeStartOffset;
                    }
                    int publicIndex = mySource.indexOf("public");
                    if (publicIndex != -1 && publicIndex + rangeStartOffset + 5 >= contentAssistOffset) {
                        return contentAssistOffset;
                    }
                    return rangeStartOffset;
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
                return -1;
            }
        }
        return -1;
    }

    public static int getLength(IJavaElement elm) {
        if (elm instanceof ISourceReference) {
            try {
                ISourceRange range = ((ISourceReference)elm).getSourceRange();
                if (range != null) {
                    return range.getLength();
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
                return -1;
            }
        }
        return -1;
    }

    public static IJavaElement getContextForContentAssist(ICompilationUnit cu, int offset) {
        contentassistoffset = offset;
        IJavaElement elm = null;
        if (cu == null) {
            return null;
        }
        try {
            elm = cu.getElementAt(offset);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (elm != null) {
            if (elm.getElementType() == 8 || elm.getElementType() == 9 || elm.getElementType() == 13 || elm.getElementType() == 11) {
                AnnotationConstants.debug((Object)("return xxx..elm=" + elm.getElementName() + " xxx.type=" + elm.getElementType()));
                return elm;
            }
            if (elm.getElementType() == 7) {
                int javaElementOffset = AnnotationUIContextHelper.getOffset(elm, offset);
                int javaElementLength = AnnotationUIContextHelper.getLength(elm);
                if (javaElementOffset != -1 && javaElementLength != -1 && offset <= javaElementOffset) {
                    return elm;
                }
                if (javaElementOffset != -1 && javaElementLength != -1 && offset > javaElementOffset) {
                    try {
                        int j = offset;
                        while (j <= javaElementOffset + javaElementLength) {
                            IJavaElement tempElem = cu.getElementAt(j);
                            if (tempElem.getElementType() != 7 && offset <= j) {
                                elm = tempElem;
                                return elm;
                            }
                            ++j;
                        }
                        return elm;
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                        return elm;
                    }
                }
            }
            return elm;
        }
        elm = AnnotationUIContextHelper.getContextWithEditorPart(cu);
        if (elm == null) {
            elm = AnnotationUIContextHelper.getTypeContextWithoutEditorPart(cu);
        }
        return elm;
    }

    public static IJavaElement getTypeContextWithoutEditorPart(ICompilationUnit cu) {
        if (cu == null) {
            return null;
        }
        int classType = 7;
        if (cu.getPrimary() != null) {
            try {
                IJavaElement[] all = cu.getPrimary().getChildren();
                if (all != null) {
                    int i = 0;
                    while (i < all.length) {
                        if (all[i] != null && classType == all[i].getElementType()) {
                            return all[i];
                        }
                        ++i;
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String AsString(String Tname) {
        StringBuffer strbuf = new StringBuffer("\"");
        strbuf.append(Tname);
        strbuf.append("\"");
        return strbuf.toString();
    }

    public static String processType(ICompilationUnit cu, int offset) {
        try {
            IJavaElement selectJavaElement = cu.getElementAt(offset);
            if (selectJavaElement != null) {
                return selectJavaElement.getElementName();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        IJavaElement elm = AnnotationUIContextHelper.getTypeContextWithoutEditorPart(cu);
        if (elm != null) {
            return elm.getElementName();
        }
        return null;
    }

    public static String processType(ICompilationUnit cu, IJavaElement jcontext) {
        if (jcontext != null) {
            return jcontext.getElementName();
        }
        return AnnotationUIContextHelper.getClassType(cu, jcontext);
    }

    public static String getClassType(ICompilationUnit cu, IJavaElement jcontext) {
        if (jcontext == null) {
            return null;
        }
        try {
            IType[] typeList = cu.getAllTypes();
            if (typeList != null && typeList.length > 0) {
                int i = 0;
                while (i < typeList.length) {
                    IType type = typeList[i];
                    IJavaElement elem = type.getPrimaryElement();
                    if (elem != null && jcontext != null && elem.getElementType() == 7) {
                        return elem.getElementName();
                    }
                    ++i;
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return null;
    }
}

