/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.check.agent13.update;

import com.ibm.cic.agent.core.CmdOptions;
import com.ibm.cic.agent.core.HeadlessInvocation;
import com.ibm.cic.agent.core.api.IAgent;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.agent.internal.ui.AgentUI;
import com.ibm.cic.agent.internal.ui.AgentUIApplication;
import com.ibm.cic.agent.internal.ui.utils.UpdateAgentUtils;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.ui.internal.CicCommonUiPlugin;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Version;

public class CheckAgentUpdateSelectionExpressionRunnable {
    private static final VersionRange AGENT_13_RANGE = new VersionRange("[1.3.0,1.3.1000)");
    private static final String IM_INSTALLER_VERSION = "im.installer.version";
    private static final String IM_INSTALLER_INTERNAL_VERSION = "im.installer.internal.version";
    private static final String IM_VERSION = "im.version";
    private static final String IM_INTERNAL_VERSION = "im.internal.version";
    private ISelectionExpression.EvaluationContext context;
    private IAgent agent;
    private static boolean updateCheckInAsyncExecQueue = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public CheckAgentUpdateSelectionExpressionRunnable(ISelectionExpression.EvaluationContext context) {
        this.context = context;
    }

    public Object run() throws Exception {
        IOffering offering;
        this.agent = this.getAgent();
        if (this.agent == null || !this.agent.isCheckingPrerequisites()) {
            return Status.OK_STATUS;
        }
        Version runningAgentVersion = this.getRunningAgentInternalVersion();
        boolean is13agent = AGENT_13_RANGE.isIncluded(runningAgentVersion);
        if (!is13agent) {
            return Status.OK_STATUS;
        }
        if (!HeadlessInvocation.isHeadlessInvocation((CmdOptions)AgentUIApplication.getCmdOptions()) && this.isFinalPrereqCheck() && !updateCheckInAsyncExecQueue) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        CheckAgentUpdateSelectionExpressionRunnable.this.checkForAgentUpdate();
                    }
                    catch (Throwable throwable) {
                        Object var1_2 = null;
                        updateCheckInAsyncExecQueue = false;
                        throw throwable;
                    }
                    {
                        Object var1_3 = null;
                    }
                    updateCheckInAsyncExecQueue = false;
                }
            });
            updateCheckInAsyncExecQueue = true;
        }
        if ((offering = this.getOffering()) == null) {
            return Status.OK_STATUS;
        }
        LinkedProperties properties = offering.getProperties();
        VersionRange agentTolerance = new VersionRange(properties.getProperty("im.tolerance", "1.3.1000"));
        VersionRange displayableAgentTolerance = new VersionRange(properties.getProperty("displayable.im.tolerance", "1.3.1"));
        Version[] runningAgentVersions = this.getRunningAgentVersions();
        String msg = NLS.bind((String)Messages.Agent_agentNotTolerated, (Object[])new Object[]{OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offering), agentTolerance, runningAgentVersions[0], displayableAgentTolerance, runningAgentVersions[1]});
        Status errorStatus = new Status(4, "com.ibm.cic.agent.core", msg);
        return errorStatus;
    }

    private void checkForAgentUpdate() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                UpdateAgentUtils.checkForAgentUpdate((IProgressMonitor)monitor);
            }
        };
        try {
            CicCommonUiPlugin.getDefault().runWithSocketMonitor(true, runnable);
        }
        catch (InvocationTargetException e) {
            AgentUI.logException((Throwable)e);
        }
        catch (InterruptedException e) {
            AgentUI.logException((Throwable)e);
        }
    }

    private IAgent getAgent() {
        Object adapter;
        if (!(this.context instanceof IAdaptable)) {
            return null;
        }
        IAdaptable adaptable = (IAdaptable)this.context;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.cic.agent.core.api.IAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = adaptable.getAdapter((Class)clazz)) == null || !(adapter instanceof IAgent)) {
            return null;
        }
        return (IAgent)adapter;
    }

    private IOffering getOffering() {
        Object adapter;
        if (!(this.context instanceof IAdaptable)) {
            return null;
        }
        IAdaptable adaptable = (IAdaptable)this.context;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.ibm.cic.common.core.model.IOffering");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = adaptable.getAdapter((Class)clazz)) == null || !(adapter instanceof IOffering)) {
            return null;
        }
        return (IOffering)adapter;
    }

    private Version getVersion(String name) {
        String value = System.getProperty(name);
        if (value == null) {
            return Version.emptyVersion;
        }
        return new Version(value);
    }

    private Version getRunningAgentInternalVersion() {
        Version installerInternalVersion = this.getVersion(IM_INSTALLER_INTERNAL_VERSION);
        if (!Version.emptyVersion.equals((Object)installerInternalVersion)) {
            return installerInternalVersion;
        }
        Version internalVersion = this.getVersion(IM_INTERNAL_VERSION);
        if (!Version.emptyVersion.equals((Object)internalVersion)) {
            return internalVersion;
        }
        IOffering offering = this.getAgentOffering();
        if (offering != null) {
            return offering.getVersion();
        }
        return Version.emptyVersion;
    }

    private Version getRunningAgentVersion() {
        Version installerVersion = this.getVersion(IM_INSTALLER_VERSION);
        if (!Version.emptyVersion.equals((Object)installerVersion)) {
            return installerVersion;
        }
        Version version = this.getVersion(IM_VERSION);
        if (!Version.emptyVersion.equals((Object)version)) {
            return version;
        }
        IOffering offering = this.getAgentOffering();
        if (offering != null) {
            return new Version(OfferingUtil.getDisplayableVersion((IOfferingOrFix)offering));
        }
        return Version.emptyVersion;
    }

    private Version[] getRunningAgentVersions() {
        return new Version[]{this.getRunningAgentInternalVersion(), this.getRunningAgentVersion()};
    }

    private IProfile getAgentProfile() {
        IProfile[] profiles = this.agent.getAllProfiles();
        int i = 0;
        while (i < profiles.length) {
            IProfile profile = profiles[i];
            if ("self".equals(profile.getProfileKind())) {
                return profile;
            }
            ++i;
        }
        return null;
    }

    private IOffering getAgentOffering() {
        IProfile agentProfile = this.getAgentProfile();
        IOffering installedAgentOffering = null;
        if (agentProfile != null) {
            installedAgentOffering = this.getInstalledOffering(agentProfile, (IIdentity)new SimpleIdentity("com.ibm.cic.agent"));
        }
        return installedAgentOffering;
    }

    private IOffering getInstalledOffering(IProfile profile, IIdentity id) {
        IOffering[] offerings = profile.getInstalledOfferings();
        int i = 0;
        while (i < offerings.length) {
            IOffering offering = offerings[i];
            if (id.equals(offering.getIdentity())) {
                return offering;
            }
            ++i;
        }
        return null;
    }

    private boolean isFinalPrereqCheck() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("com.ibm.cic.agent.internal.ui.wizards.UpdateWizard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String updateWizardClassName = clazz.getName();
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("com.ibm.cic.agent.internal.ui.wizards.InstallWizard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String installWizardClassName = clazz2.getName();
        Exception e = new Exception();
        StackTraceElement[] stackTrace = e.getStackTrace();
        int count = Math.min(32, stackTrace.length);
        int i = 0;
        while (i < count) {
            StackTraceElement element = stackTrace[i];
            if ((element.getClassName().equals(updateWizardClassName) || element.getClassName().equals(installWizardClassName)) && element.getMethodName().equals("addPages")) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

