/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.ws.internal.finder.ui.navigator.project;

import com.ibm.ccl.ws.finder.core.WSInfo;
import com.ibm.ccl.ws.finder.core.event.WebServiceChangeEvent;
import com.ibm.ccl.ws.internal.finder.ui.navigator.AbstractServiceRootNode;
import com.ibm.ccl.ws.internal.finder.ui.navigator.AbstractServiceRootObjectProvider;
import com.ibm.ccl.ws.internal.finder.ui.navigator.project.ServiceRootNode;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;

public class ServiceRootObjectProvider
extends AbstractServiceRootObjectProvider
implements IResourceChangeListener,
IActivityManagerListener {
    public ServiceRootObjectProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 4);
        IWorkbenchActivitySupport support = PlatformUI.getWorkbench().getActivitySupport();
        support.getActivityManager().addActivityManagerListener((IActivityManagerListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractServiceRootNode createRootNode(IProject project) {
        String name = project.getName();
        AbstractServiceRootNode rootNode = null;
        Map map = this.rootNodes;
        synchronized (map) {
            rootNode = (AbstractServiceRootNode)this.rootNodes.get(name);
            if (rootNode == null) {
                rootNode = new ServiceRootNode(project);
                this.rootNodes.put(name, rootNode);
            }
        }
        return rootNode;
    }

    protected AbstractServiceRootNode getRootNode(WSInfo info) {
        return (AbstractServiceRootNode)this.rootNodes.get(info.getProject().getName());
    }

    protected void handleWebServiceChanged(WebServiceChangeEvent event) {
        IProject project;
        AbstractServiceRootNode rootNode;
        if (event.getType() == 4 && (rootNode = (AbstractServiceRootNode)this.rootNodes.get((project = (IProject)event.getSource()).getName())) != null) {
            rootNode.clearChildren();
            if (rootNode.isVisible()) {
                this.notifyListeners(rootNode);
            } else if (rootNode.hasChildren()) {
                this.notifyListeners(project);
            }
        }
    }

    public void webServiceChanged(WebServiceChangeEvent event) {
        switch (event.getType()) {
            case 0: 
            case 1: 
            case 2: {
                WSInfo info = (WSInfo)event.getSource();
                if (info.getProject().isAccessible()) break;
                return;
            }
        }
        super.webServiceChanged(event);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IProject project = (IProject)event.getResource();
        this.rootNodes.remove(project.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
        if (!activityManagerEvent.haveEnabledActivityIdsChanged()) {
            return;
        }
        Map map = this.rootNodes;
        synchronized (map) {
            for (String name : this.rootNodes.keySet()) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                if (!project.isAccessible()) continue;
                AbstractServiceRootNode root = (AbstractServiceRootNode)this.rootNodes.get(name);
                root.clearChildren();
                this.notifyListeners(project);
            }
        }
    }

    public void dispose() {
        IWorkbenchActivitySupport support = PlatformUI.getWorkbench().getActivitySupport();
        support.getActivityManager().removeActivityManagerListener((IActivityManagerListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }
}

