/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.ws.internal.finder.ui.navigator;

import com.ibm.ccl.ws.finder.ui.Activator;
import com.ibm.ccl.ws.finder.ui.FinderUIMessages;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IPluginContribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRootRegistry {
    private static final String SERVICE_ROOT_EXTENSION_ID = "com.ibm.ccl.ws.finder.ui.ServiceRoot";
    private static ServiceRootRegistry instance = null;
    private List<ServiceRoot> serviceRoots = new ArrayList<ServiceRoot>();
    private Map<String, ServiceRoot> serviceRootLookup = new Hashtable<String, ServiceRoot>();

    private ServiceRootRegistry() {
        this.init();
    }

    private void init() {
        IConfigurationElement[] configs;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configs = extensionRegistry.getConfigurationElementsFor(SERVICE_ROOT_EXTENSION_ID);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            ServiceRoot serviceRoot = new ServiceRoot();
            serviceRoot.pluginId = config.getContributor().getName();
            serviceRoot.id = config.getAttribute("id");
            if (!this.serviceRoots.contains(serviceRoot)) {
                serviceRoot.label = config.getAttribute("label");
                serviceRoot.categoryIds = new ArrayList();
                IConfigurationElement[] iConfigurationElementArray2 = config.getChildren("category");
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement category = iConfigurationElementArray2[n4];
                    String categoryId = category.getAttribute("id");
                    if (categoryId != null) {
                        serviceRoot.categoryIds.add(categoryId);
                        this.serviceRootLookup.put(categoryId, serviceRoot);
                    }
                    ++n4;
                }
                if (!serviceRoot.categoryIds.isEmpty()) {
                    if (config.getAttribute("adapterFactory") != null) {
                        try {
                            serviceRoot.adapterFactory = (IAdapterFactory)config.createExecutableExtension("adapterFactory");
                        }
                        catch (ClassCastException e) {
                            Status status = new Status(4, "com.ibm.ccl.ws.finder.ui", FinderUIMessages.ERR_CAST, (Throwable)e);
                            Activator.getDefault().getLog().log((IStatus)status);
                        }
                        catch (CoreException e) {
                            Activator.getDefault().getLog().log(e.getStatus());
                        }
                    }
                    this.serviceRoots.add(serviceRoot);
                }
            }
            ++n2;
        }
    }

    public static synchronized ServiceRootRegistry getInstance() {
        if (instance == null) {
            instance = new ServiceRootRegistry();
        }
        return instance;
    }

    public List<ServiceRoot> getServiceRoots() {
        return this.serviceRoots;
    }

    public ServiceRoot getServiceRoot(String categoryId) {
        return this.serviceRootLookup.get(categoryId);
    }

    public static class ServiceRoot
    implements IPluginContribution {
        private String pluginId;
        private String id;
        private String label;
        private IAdapterFactory adapterFactory;
        private List<String> categoryIds;

        public String getPluginId() {
            return this.pluginId;
        }

        public String getLocalId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public IAdapterFactory getAdapterFactory() {
            return this.adapterFactory;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ServiceRoot) {
                return this.id.equals(((ServiceRoot)obj).id);
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

