/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.ws.internal.finder.ui.navigator;

import com.ibm.ccl.ws.finder.core.WSInfo;
import com.ibm.ccl.ws.finder.ui.FinderUIMessages;
import com.ibm.ccl.ws.internal.finder.ui.navigator.OpenAction;
import com.ibm.ccl.ws.internal.finder.ui.navigator.ServiceRootRegistry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class OpenActionProvider
extends CommonActionProvider {
    private OpenAction openAction;
    private IMenuManager openWithSubMenu;
    private boolean usedInView;

    public void init(ICommonActionExtensionSite site) {
        super.init(site);
        this.usedInView = site.getViewSite() instanceof ICommonViewerWorkbenchSite;
        if (!this.usedInView) {
            return;
        }
        ICommonViewerWorkbenchSite viewSite = (ICommonViewerWorkbenchSite)site.getViewSite();
        IWorkbenchPage page = viewSite.getPage();
        this.openAction = new OpenAction(page);
        this.openWithSubMenu = new MenuManager(FinderUIMessages.OPEN_WITH);
        if (site.getViewSite() != null && "com.ibm.ccl.ws.finder.ui.view.services".equals(site.getViewSite().getId())) {
            viewSite.getActionBars().getMenuManager().add((IAction)this.openAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (!this.usedInView) {
            return;
        }
        this.openAction.setEnabled(false);
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object item = selection.getFirstElement();
        if (!(item instanceof WSInfo)) {
            return;
        }
        WSInfo info = (WSInfo)item;
        ServiceRootRegistry.ServiceRoot root = ServiceRootRegistry.getInstance().getServiceRoot(info.getCategoryId());
        if (root == null) {
            return;
        }
        IAdapterFactory adapterFactory = root.getAdapterFactory();
        if (adapterFactory != null) {
            IEditorInput input = (IEditorInput)adapterFactory.getAdapter((Object)info, IEditorInput.class);
            this.openAction.setEditorInput(input);
            if (this.openAction.isEnabled()) {
                actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
            }
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (!this.usedInView) {
            return;
        }
        if (this.openAction.isEnabled()) {
            menu.appendToGroup("group.open", (IAction)this.openAction);
            IFile file = this.openAction.getFile();
            if (file != null) {
                this.openWithSubMenu.removeAll();
                this.openWithSubMenu.add((IContributionItem)new OpenWithMenu(this.openAction.getPage(), (IAdaptable)file));
                menu.appendToGroup("group.openWith", (IContributionItem)this.openWithSubMenu);
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.openWithSubMenu.dispose();
    }
}

