/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.welcome.internal.brochures.loader;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BrochureXMLParser {
    public static final String TAG_BROCHURE_CONTENT = "brochure";
    private Document document;

    public BrochureXMLParser(String content) {
        try {
            Element rootElement;
            this.document = this.parse(content);
            if (this.document != null && !(rootElement = this.document.getDocumentElement()).getTagName().equals(TAG_BROCHURE_CONTENT)) {
                this.document = null;
            }
        }
        catch (Exception e) {
            Log.error((String)("Could not load Brochure content file: " + content), (Throwable)e);
        }
    }

    private Document parse(String fileURI) {
        Document document = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setValidating(false);
            docFactory.setNamespaceAware(true);
            docFactory.setExpandEntityReferences(false);
            DocumentBuilder parser = docFactory.newDocumentBuilder();
            parser.setEntityResolver(null);
            document = parser.parse(fileURI);
            return document;
        }
        catch (SAXParseException spe) {
            StringBuffer buffer = new StringBuffer("IntroParser error in line ");
            buffer.append(spe.getLineNumber());
            buffer.append(", uri ");
            buffer.append(spe.getSystemId());
            buffer.append("\n");
            buffer.append(spe.getMessage());
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            Log.error((String)buffer.toString(), (Throwable)x);
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            Log.error((String)((Throwable)x).getMessage(), (Throwable)x);
        }
        catch (ParserConfigurationException pce) {
            Log.error((String)pce.getMessage(), (Throwable)pce);
        }
        catch (IOException ioe) {
            Log.error((String)ioe.getMessage(), (Throwable)ioe);
        }
        return null;
    }

    public Document getDocument() {
        return this.document;
    }
}

