/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.welcome.bits.contentproviders;

import com.ibm.ccl.welcome.bits.contentproviders.BrochureNav;
import com.ibm.ccl.welcome.bits.contentproviders.BrochureNavIdException;
import com.ibm.ccl.welcome.bits.contentproviders.ExternalizedStrings;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.intro.config.IIntroContentProviderSite;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IIntroXHTMLContentProvider;
import org.eclipse.ui.intro.config.IntroURLFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class BottomBrochureNav
extends BrochureNav
implements IIntroXHTMLContentProvider {
    private Form form;
    private Composite client;

    public void createContent(String id, Element parent) {
        try {
            this.setUp(id, parent);
        }
        catch (BrochureNavIdException e) {
            if (Platform.inDebugMode()) {
                parent.appendChild(this.dom.createTextNode(e.getMessage()));
            }
            return;
        }
        Element footer = this.dom.createElement("div");
        footer.setAttribute("class", "bits-footer");
        Element brochureGradient = this.dom.createElement("div");
        brochureGradient.setAttribute("class", "toolbar-gradient");
        brochureGradient.appendChild(this.dom.createComment("Div needs contents to space correctly"));
        Element brochureGrey = this.dom.createElement("div");
        brochureGrey.setAttribute("class", "toolbar-background");
        brochureGrey.appendChild(this.dom.createComment("Div needs contents to space correctly"));
        Element leftColumn = this.dom.createElement("div");
        leftColumn.setAttribute("class", "previous-column");
        this.addPrevious(leftColumn);
        Element centerColumn = this.dom.createElement("div");
        centerColumn.setAttribute("class", "current-column");
        this.addCurrent(centerColumn);
        Element rightColumn = this.dom.createElement("div");
        rightColumn.setAttribute("class", "next-column");
        this.addNext(rightColumn);
        footer.appendChild(brochureGradient);
        footer.appendChild(leftColumn);
        footer.appendChild(brochureGrey);
        footer.appendChild(centerColumn);
        footer.appendChild(rightColumn);
        parent.appendChild(footer);
    }

    private void addPrevious(Element col1) {
        Text prevText = this.dom.createTextNode(ExternalizedStrings.getString("BottomBrochureNav.Previous"));
        this.addPrevious(col1, prevText);
    }

    private void addCurrent(Element col2) {
        String currentString = NLS.bind((String)ExternalizedStrings.getString("BottomBrochureNav.PageOf"), (Object)(Integer.valueOf(this.currentBrochure.getPageNumber(this.currentPage)) + 1), (Object)this.currentBrochure.numberOfPages());
        String s = String.valueOf(this.currentBrochure.getTitle()) + ": " + currentString;
        col2.appendChild(this.dom.createTextNode(s));
    }

    private void addNext(Element col3) {
        Text nextText = this.dom.createTextNode(ExternalizedStrings.getString("BottomBrochureNav.Next"));
        this.addNext(col3, nextText);
    }

    public void init(IIntroContentProviderSite site) {
    }

    public void createContent(String id, PrintWriter out) {
        try {
            DocumentBuilder loader = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = loader.newDocument();
            Element parent = document.createElement("div");
            parent.setAttribute("ID", "brochure");
            this.createContent(id, parent);
            out.write(this.getStringRepresentation(parent));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void createContent(String id, Composite parent, FormToolkit toolkit) {
        try {
            this.setUp(id);
        }
        catch (BrochureNavIdException e) {
            if (Platform.inDebugMode()) {
                System.out.println(e.getMessage());
            }
            return;
        }
        this.client = toolkit.createComposite(parent);
        TableWrapData td = new TableWrapData(128, 128);
        td.grabHorizontal = true;
        this.client.setLayoutData((Object)td);
        GridData gridData1 = new GridData();
        gridData1.verticalAlignment = 2;
        gridData1.horizontalAlignment = 1;
        GridData gridData2 = new GridData();
        gridData2.verticalAlignment = 2;
        gridData2.horizontalAlignment = 2;
        GridData gridData3 = new GridData();
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.verticalAlignment = 2;
        gridData3.horizontalAlignment = 3;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = true;
        this.client.setLayout((Layout)gridLayout);
        if (this.currentPage.hasPrevious()) {
            Hyperlink previousLink = toolkit.createHyperlink(this.client, ExternalizedStrings.getString("BottomBrochureNav.Previous"), 0);
            previousLink.setHref((Object)("http://org.eclipse.ui.intro/showPage?id=" + this.currentPage.getPrevious().getId()));
            previousLink.setLayoutData((Object)gridData1);
            previousLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    BottomBrochureNav.this.doNavigate((String)e.getHref());
                }
            });
        } else {
            toolkit.createLabel(this.client, "          ");
        }
        Label label = toolkit.createLabel(this.client, String.valueOf(this.currentBrochure.getTitle()) + ": " + ExternalizedStrings.getString("BottomBrochureNav.Page") + " " + (this.currentBrochure.getPageNumber(this.currentPage) + 1) + " " + ExternalizedStrings.getString("BottomBrochureNav.Of") + " " + this.currentBrochure.numberOfPages());
        label.setLayoutData((Object)gridData2);
        if (this.currentPage.hasNext()) {
            Hyperlink nextLink = toolkit.createHyperlink(this.client, ExternalizedStrings.getString("BottomBrochureNav.Next"), 0);
            nextLink.setHref((Object)("http://org.eclipse.ui.intro/showPage?id=" + this.currentPage.getNext().getId()));
            nextLink.setLayoutData((Object)gridData3);
            nextLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    BottomBrochureNav.this.doNavigate((String)e.getHref());
                }
            });
        } else {
            Label filler = toolkit.createLabel(this.client, "          ");
            filler.setLayoutData((Object)gridData3);
        }
    }

    public void dispose() {
        this.client.dispose();
    }

    private void doNavigate(final String url) {
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IIntroURL introUrl = IntroURLFactory.createIntroURL((String)url);
                if (introUrl != null) {
                    introUrl.execute();
                    return;
                }
                BottomBrochureNav.this.openBrowser(url);
            }
        });
    }

    private void openBrowser(String href) {
        try {
            URL url = new URL(href);
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            support.getExternalBrowser().openURL(url);
        }
        catch (PartInitException partInitException) {
        }
        catch (MalformedURLException malformedURLException) {}
    }
}

