/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gallery.common.wizards;

import com.ibm.ccl.ua.wizards.Activator;
import com.ibm.gallery.common.wizards.ProjectImportMessages;
import com.ibm.gallery.common.wizards.ProjectImportOperation;
import com.ibm.gallery.common.wizards.ProjectImportWizardPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class ProjectImportWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private ProjectImportWizardPage[] pages;
    private IConfigurationElement configElement;

    private void initializeDefaultPageImageDescriptor() {
        if (this.configElement != null) {
            String banner = this.configElement.getAttribute("banner");
            if (banner != null) {
                ImageDescriptor desc = this.getImageDescriptor(banner);
                this.setDefaultPageImageDescriptor(desc);
            } else {
                ImageDescriptor desc = this.getImageDescriptor("images/import_wiz.gif");
                this.setDefaultPageImageDescriptor(desc);
            }
        }
    }

    protected ImageDescriptor getImageDescriptor(String banner) {
        try {
            ImageDescriptor image = Activator.imageDescriptorFromPlugin((String)"com.ibm.gallery.common", (String)banner);
            return image;
        }
        catch (Exception exception) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public void addPages() {
        super.addPages();
        IConfigurationElement[] children = this.configElement.getChildren("projectsetup");
        if (children == null || children.length == 0) {
            Activator.logWarning("descriptor must contain one ore more projectsetup tags");
            return;
        }
        this.pages = new ProjectImportWizardPage[children.length];
        int i = 0;
        while (i < children.length) {
            this.pages[i] = new ProjectImportWizardPage(i, children[i]);
            this.addPage((IWizardPage)this.pages[i]);
            ++i;
        }
    }

    public boolean performFinish() {
        ProjectImportOperation runnable = new ProjectImportOperation(this.pages);
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)runnable);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            this.handleException(e.getTargetException());
            return false;
        }
        catch (InterruptedException e) {
            Activator.logWarning("ProjectImportWizard performFinish() " + e);
            e.printStackTrace();
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        IResource res = runnable.getElementToOpen();
        if (res != null) {
            this.openResource(res);
        }
        return true;
    }

    private void handleException(Throwable target) {
        String title = ProjectImportMessages.getString("ProjectImportWizard.op_error.title");
        String message = ProjectImportMessages.getString("ProjectImportWizard.op_error.message");
        if (target instanceof CoreException) {
            IStatus status = ((CoreException)target).getStatus();
            ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)status);
            Activator.logError("ProjectImportWizard:" + status, target);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)target.getMessage());
            Activator.logError("ProjectImportWizard:", target);
        }
    }

    private void openResource(final IResource resource) {
        if (resource.getType() != 1) {
            return;
        }
        IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        final IWorkbenchPage activePage = window.getActivePage();
        if (activePage != null) {
            Display display = this.getShell().getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)((IFile)resource), (boolean)true);
                    }
                    catch (PartInitException e) {
                        Activator.logError("ProjectImportWizard:", e);
                    }
                }
            });
            BasicNewResourceWizard.selectAndReveal((IResource)resource, (IWorkbenchWindow)activePage.getWorkbenchWindow());
        }
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
        this.initializeDefaultPageImageDescriptor();
        String title = this.configElement.getAttribute("name");
        if (title != null) {
            this.setWindowTitle(title);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private class ImportOverwriteQuery
    implements IOverwriteQuery {
        private ImportOverwriteQuery() {
        }

        public String queryOverwrite(String file) {
            String[] returnCodes = new String[]{"YES", "NO", "ALL", "CANCEL"};
            int returnVal = this.openDialog(file);
            return returnVal < 0 ? "CANCEL" : returnCodes[returnVal];
        }

        private int openDialog(final String file) {
            final int[] result = new int[]{1};
            ProjectImportWizard.this.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    String title = ProjectImportMessages.getString("ProjectImportWizard.overwritequery.title");
                    String msg = ProjectImportMessages.getFormattedString("ProjectImportWizard.overwritequery.message", file);
                    String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
                    MessageDialog dialog = new MessageDialog(ProjectImportWizard.this.getShell(), title, null, msg, 3, options, 0);
                    result[0] = dialog.open();
                }
            });
            return result[0];
        }
    }
}

