/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gallery.common.wizards;

import com.ibm.ccl.ua.wizards.Activator;
import com.ibm.gallery.common.wizards.GalleryConstants;
import java.text.MessageFormat;
import org.eclipse.help.ILiveHelpAction;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class GalleryWizardAction
implements ILiveHelpAction,
GalleryConstants {
    protected String wizID;

    public abstract IWizard getWizard();

    public void initWizard(IWizard wizard) {
    }

    public void setInitializationString(String wiz) {
        this.wizID = wiz;
    }

    public void run() {
        RunnableWizardDelegate runnableWizard = new RunnableWizardDelegate(this);
        Display.getDefault().syncExec((Runnable)runnableWizard);
    }

    private class RunnableWizardDelegate
    implements Runnable {
        private GalleryWizardAction actionDelegate;

        public RunnableWizardDelegate(GalleryWizardAction delegate) {
            this.actionDelegate = delegate;
        }

        public void run() {
            IWizard wizard = this.actionDelegate.getWizard();
            if (wizard == null) {
                String actionDelegateClassName = this.actionDelegate.getClass().getName();
                String message = MessageFormat.format("_ERROR_GALLERY_WIZACTION_NO_WIZARD", actionDelegateClassName);
                Activator.logWarning(message);
            }
            try {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && wizard != null) {
                    this.actionDelegate.initWizard(wizard);
                    Shell shell = window.getShell();
                    shell.setMinimized(false);
                    shell.forceActive();
                    WizardDialog dialog = new WizardDialog(window.getShell(), wizard);
                    dialog.create();
                    dialog.open();
                }
            }
            catch (Exception e) {
                Activator.logError("Exception in GalleryWizardAction: ", e);
                Activator.logWarning("wizard = " + wizard);
                e.printStackTrace();
            }
        }
    }
}

