/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gallery.common.wizards;

import com.ibm.gallery.common.wizards.ExampleProjectMessages;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExampleProjectCreationWizardPage
extends WizardPage {
    private IStatus currStatus = ExampleProjectCreationWizardPage.createStatus(0, "");
    private boolean pageVisible;
    private IConfigurationElement configElement;
    String[] natureIds;
    String[] references;
    String[] importDests;
    String[] importSrcs;
    String wizardPlugin;
    String remoteWizURL;
    String nameLabel;
    String projName;
    String finalPerspective;
    String wizDescription;
    String wizPageTitle;
    String wizLabel;
    String wizPageDescription;
    String projectNature;
    String projectSrc;
    String projectDest;
    private Text fTextControl;

    public ExampleProjectCreationWizardPage(int pageNumber, IConfigurationElement elem) {
        super("page" + pageNumber);
        this.configElement = elem;
        this.setTitle(this.getAttribute(elem, "pagetitle"));
        this.setDescription(this.getAttribute(elem, "pagedescription"));
        this.nameLabel = this.getAttribute(elem, "label");
        this.projName = this.getAttribute(elem, "name");
    }

    public ExampleProjectCreationWizardPage(int pageNumber, String wizardTitle, String wizardDescription, String wizFinalPerspective, String projectName, String wizardPageDescription, String wizardLabel, String wizardProjectNature, String wizardProjectSrc, String wizardProjectDest, String pluginName, String wizURL) {
        super("page" + pageNumber);
        this.setTitle(wizardTitle);
        this.setDescription(wizardDescription);
        this.nameLabel = wizardTitle;
        this.projName = projectName;
        this.finalPerspective = wizFinalPerspective;
        this.wizDescription = wizardDescription;
        this.wizPageDescription = wizardPageDescription;
        this.wizPageTitle = wizardLabel;
        this.projectNature = wizardProjectNature;
        this.projectSrc = wizardProjectSrc;
        this.projectDest = wizardProjectDest;
        this.wizardPlugin = pluginName;
        this.remoteWizURL = wizURL;
        this.buildPageArrays();
    }

    private String getAttribute(IConfigurationElement elem, String tag) {
        String res = elem.getAttribute(tag);
        if (res == null) {
            return tag;
        }
        return res;
    }

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "sgez0101");
        Composite composite = new Composite(parent, 0);
        GridLayout gd = new GridLayout();
        gd.numColumns = 2;
        composite.setLayout((Layout)gd);
        Label label = new Label(composite, 16384);
        label.setText(this.nameLabel);
        label.setLayoutData((Object)new GridData());
        this.fTextControl = new Text(composite, 2052);
        this.fTextControl.setText(this.projName);
        this.fTextControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ExampleProjectCreationWizardPage.this.fTextControl.isDisposed()) {
                    ExampleProjectCreationWizardPage.this.validateText(ExampleProjectCreationWizardPage.this.fTextControl.getText());
                }
            }
        });
        this.fTextControl.setLayoutData((Object)new GridData(768));
        this.setControl((Control)composite);
    }

    private void validateText(String text) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateName(text, 4);
        if (status.isOK() && workspace.getRoot().getProject(text).exists()) {
            status = ExampleProjectCreationWizardPage.createStatus(4, ExampleProjectMessages.getString("ExampleProjectCreationWizardPage.error.alreadyexists"));
        }
        this.updateStatus(status);
        this.projName = text;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.pageVisible = visible;
        if (visible && this.currStatus.matches(4)) {
            this.currStatus = ExampleProjectCreationWizardPage.createStatus(4, "");
        }
        this.updateStatus(this.currStatus);
    }

    private void updateStatus(IStatus status) {
        this.currStatus = status;
        this.setPageComplete(!status.matches(4));
        if (this.pageVisible) {
            ExampleProjectCreationWizardPage.applyToStatusLine((DialogPage)this, status);
        }
    }

    private static void applyToStatusLine(DialogPage page, IStatus status) {
        String errorMessage = null;
        String warningMessage = null;
        String statusMessage = status.getMessage();
        if (statusMessage.length() > 0) {
            if (status.matches(4)) {
                errorMessage = statusMessage;
            } else if (!status.isOK()) {
                warningMessage = statusMessage;
            }
        }
        page.setErrorMessage(errorMessage);
        page.setMessage(warningMessage);
    }

    private static IStatus createStatus(int severity, String message) {
        return new Status(severity, "com.ibm.ccl.ua.wizards", severity, message, null);
    }

    public String getName() {
        return this.projName;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    public void buildPageArrays() {
        this.natureIds = this.projectNature.split(",");
        this.references = new String[0];
        this.importDests = this.projectDest.split(",");
        this.importSrcs = this.projectSrc.split(",");
    }
}

