/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gallery.common.wizards;

import com.ibm.ccl.ua.wizards.Activator;
import com.ibm.gallery.common.wizards.ExampleProjectCreationWizardPage;
import com.ibm.gallery.common.wizards.ExampleProjectMessages;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.osgi.framework.Bundle;

public class ExampleProjectCreationOperation
implements IRunnableWithProgress {
    private IResource elementToOpen = null;
    private ExampleProjectCreationWizardPage[] fPages;
    private IOverwriteQuery overwriteQuery;

    public ExampleProjectCreationOperation(ExampleProjectCreationWizardPage[] pages, IOverwriteQuery newOverwriteQuery) {
        this.fPages = pages;
        this.overwriteQuery = newOverwriteQuery;
    }

    public ExampleProjectCreationOperation(ExampleProjectCreationWizardPage[] pages) {
        this.fPages = pages;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(ExampleProjectMessages.getString("ExampleProjectCreationOperation.op_desc"), this.fPages.length);
            IWorkspaceRoot root = Activator.getWorkspace().getRoot();
            int i = 0;
            while (i < this.fPages.length) {
                this.createProject(root, this.fPages[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public IResource getElementToOpen() {
        return this.elementToOpen;
    }

    private void createProject(IWorkspaceRoot root, ExampleProjectCreationWizardPage page, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IConfigurationElement desc = page.getConfigurationElement();
        if (desc != null) {
            IResource fileToOpen;
            IConfigurationElement[] imports = desc.getChildren("import");
            IConfigurationElement[] natures = desc.getChildren("nature");
            IConfigurationElement[] references = desc.getChildren("references");
            int nImports = imports == null ? 0 : imports.length;
            int nNatures = natures == null ? 0 : natures.length;
            int nReferences = references == null ? 0 : references.length;
            monitor.beginTask(ExampleProjectMessages.getString("ExampleProjectCreationOperation.op_desc_proj"), nImports + 1);
            String name = page.getName();
            String[] natureIds = new String[nNatures];
            int i = 0;
            while (i < nNatures) {
                natureIds[i] = natures[i].getAttribute("id");
                ++i;
            }
            IProject[] referencedProjects = new IProject[nReferences];
            int i2 = 0;
            while (i2 < nReferences) {
                referencedProjects[i2] = root.getProject(references[i2].getAttribute("id"));
                ++i2;
            }
            File projectFolderFile = new File(Platform.getLocation().append(name).toOSString());
            projectFolderFile.mkdirs();
            int i3 = 0;
            while (i3 < nImports) {
                this.doImports(projectFolderFile, imports[i3], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ++i3;
            }
            IProject proj = this.configNewProject(root, name, natureIds, referencedProjects, monitor);
            String open = desc.getAttribute("open");
            if (open != null && open.length() > 0 && (fileToOpen = proj.findMember((IPath)new Path(open))) != null) {
                this.elementToOpen = fileToOpen;
            }
        } else {
            IResource fileToOpen;
            String[] natureIds = page.natureIds;
            String[] references = page.references;
            String[] importDests = page.importDests;
            String[] importSrcs = page.importSrcs;
            String wizardPlugin = page.wizardPlugin;
            int nImports = importSrcs.length;
            int cfr_ignored_0 = natureIds.length;
            int nReferences = references.length;
            monitor.beginTask(ExampleProjectMessages.getString("ExampleProjectCreationOperation.op_desc_proj"), nImports + 1);
            String name = page.getName();
            IProject[] referencedProjects = new IProject[nReferences];
            int i = 0;
            while (i < nReferences) {
                referencedProjects[i] = root.getProject(references[i]);
                ++i;
            }
            File projectFolderFile = new File(Platform.getLocation().append(name).toOSString());
            projectFolderFile.mkdirs();
            int i4 = 0;
            while (i4 < nImports) {
                this.doImports(projectFolderFile, importDests[i4], importSrcs[i4], wizardPlugin, page, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ++i4;
            }
            IProject proj = this.configNewProject(root, name, natureIds, referencedProjects, monitor);
            String open = null;
            if (open != null && open.length() > 0 && (fileToOpen = proj.findMember((IPath)new Path(open))) != null) {
                this.elementToOpen = fileToOpen;
            }
        }
    }

    private IProject configNewProject(IWorkspaceRoot root, String name, String[] natureIds, IProject[] referencedProjects, IProgressMonitor monitor) throws InvocationTargetException {
        try {
            IProject project = root.getProject(name);
            if (!project.exists()) {
                project.create(null);
            }
            if (!project.isOpen()) {
                project.open(null);
            }
            IProjectDescription desc = project.getDescription();
            boolean setDescriptor = false;
            if (natureIds.length > 0) {
                desc.setNatureIds(natureIds);
                setDescriptor = true;
            }
            if (referencedProjects.length > 0) {
                desc.setReferencedProjects(referencedProjects);
                setDescriptor = true;
            }
            if (setDescriptor) {
                project.setDescription(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            return project;
        }
        catch (CoreException e) {
            Activator.logError("ExampleProjectCreationOperation configNewProject() ", e);
            e.printStackTrace();
            throw new InvocationTargetException(e);
        }
    }

    private void doImports(File project, IConfigurationElement curr, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            File destDirectory;
            String name = curr.getAttribute("dest");
            if (name == null || name.length() == 0) {
                destDirectory = project;
            } else {
                IPath destPath = new Path(project.getAbsolutePath()).append(name);
                destDirectory = new File(destPath.toOSString());
                if (!destDirectory.exists()) {
                    destDirectory.mkdirs();
                }
            }
            String importPath = curr.getAttribute("src");
            if (importPath == null) {
                importPath = "";
                Activator.logWarning("projectsetup descriptor: import missing");
                return;
            }
            ZipFile zipFile = this.getZipFileFromPluginDir(importPath, this.getContributingPlugin(curr));
            this.importFilesFromZip(zipFile, destDirectory, (IProgressMonitor)new SubProgressMonitor(monitor, zipFile.size()));
        }
        catch (Exception e) {
            Activator.logWarning("ExampleProjectCreationOperation doImports() " + e);
            e.printStackTrace();
            throw new InvocationTargetException(e);
        }
    }

    private void doImports(File project, String dest, String src, String contributingPlugin, ExampleProjectCreationWizardPage thisPage, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            File destDirectory;
            String name = dest;
            if (name == null || name.length() == 0) {
                destDirectory = project;
            } else {
                IPath destPath = new Path(project.getAbsolutePath()).append(name);
                destDirectory = new File(destPath.toOSString());
                if (!destDirectory.exists()) {
                    destDirectory.mkdirs();
                }
            }
            String importPath = src;
            if (importPath == null) {
                importPath = "";
                Activator.logWarning("projectsetup descriptor: import missing");
                return;
            }
            ZipFile zipFile = this.getRemoteZipFileFromStream(importPath, contributingPlugin, thisPage.remoteWizURL);
            this.importFilesFromZip(zipFile, destDirectory, (IProgressMonitor)new SubProgressMonitor(monitor, zipFile.size()));
        }
        catch (Exception e) {
            Activator.logWarning("ExampleProjectCreationOperation doImports() " + e);
            e.printStackTrace();
            throw new InvocationTargetException(e);
        }
    }

    private String getContributingPlugin(IConfigurationElement configurationElement) {
        Object parent = configurationElement;
        while (parent != null) {
            if (parent instanceof IExtension) {
                return ((IExtension)parent).getNamespaceIdentifier();
            }
            parent = parent.getParent();
        }
        return null;
    }

    private ZipFile getZipFileFromPluginDir(String pluginRelativePath, String symbolicName) throws CoreException {
        try {
            Bundle bundle = Platform.getBundle((String)symbolicName);
            URL starterURL = new URL(bundle.getEntry("/"), pluginRelativePath);
            return new ZipFile(FileLocator.toFileURL((URL)starterURL).getFile());
        }
        catch (IOException e) {
            String message = String.valueOf(pluginRelativePath) + ": " + e.getMessage();
            Status status = new Status(4, "com.ibm.ccl.ua.wizards", 4, message, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private ZipFile getRemoteZipFileFromStream(String pluginRelativePath, String symbolicName, String remoteWizURL) throws CoreException {
        try {
            int len;
            String wizardPathString = remoteWizURL.endsWith("/") ? String.valueOf(remoteWizURL) + "importFileReader" + '?' + "pluginName" + '=' + symbolicName + "&importSrc=" + pluginRelativePath : String.valueOf(remoteWizURL) + "/importFileReader" + '?' + "pluginName" + '=' + symbolicName + "&importSrc=" + pluginRelativePath;
            URL remoteImportFileURL = new URL(wizardPathString);
            IWorkspace userWorkspace = ResourcesPlugin.getWorkspace();
            String workspaceLocation = userWorkspace.getRoot().getLocation().toOSString();
            File zipToImport = new File(String.valueOf(workspaceLocation) + "//tempsample.zip");
            InputStream in = remoteImportFileURL.openStream();
            FileOutputStream out = new FileOutputStream(zipToImport);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
            ZipFile sampleZip = new ZipFile(String.valueOf(workspaceLocation) + "//tempsample.zip");
            return sampleZip;
        }
        catch (IOException e) {
            String message = String.valueOf(pluginRelativePath) + ": " + e.getMessage();
            Status status = new Status(4, "com.ibm.ccl.ua.wizards", 4, message, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void importFilesFromZip(ZipFile srcZipFile, File destDirectory, IProgressMonitor monitor) throws IOException, FileNotFoundException, InterruptedException {
        try {
            Enumeration<? extends ZipEntry> e = srcZipFile.entries();
            while (e.hasMoreElements()) {
                block25: {
                    ZipEntry zipEntry = e.nextElement();
                    File file = new File(destDirectory, zipEntry.getName());
                    if (!zipEntry.isDirectory()) {
                        int len;
                        Object[] buffer;
                        Closeable os;
                        Closeable is;
                        Path path;
                        File parentFile = file.getParentFile();
                        if (parentFile != null && !parentFile.exists()) {
                            parentFile.mkdirs();
                        }
                        if ((path = new Path(file.getPath())).getFileExtension() != null && path.getFileExtension().equals("java")) {
                            is = null;
                            os = null;
                            try {
                                is = new InputStreamReader(srcZipFile.getInputStream(zipEntry), "ISO-8859-1");
                                os = new OutputStreamWriter((OutputStream)new FileOutputStream(file), ResourcesPlugin.getEncoding());
                                buffer = new char[102400];
                                while (true) {
                                    if ((len = ((Reader)is).read((char[])buffer)) < 0) {
                                        break block25;
                                    }
                                    ((OutputStreamWriter)os).write((char[])buffer, 0, len);
                                }
                            }
                            finally {
                                if (is != null) {
                                    ((InputStreamReader)is).close();
                                }
                                if (os != null) {
                                    ((OutputStreamWriter)os).close();
                                }
                            }
                        }
                        is = null;
                        os = null;
                        try {
                            try {
                                is = srcZipFile.getInputStream(zipEntry);
                                os = new FileOutputStream(file);
                                buffer = new byte[102400];
                                while ((len = ((InputStream)is).read((byte[])buffer)) >= 0) {
                                    ((OutputStream)os).write((byte[])buffer, 0, len);
                                }
                            }
                            catch (Exception exception) {
                                if (is != null) {
                                    ((InputStream)is).close();
                                }
                                if (os != null) {
                                    ((OutputStream)os).close();
                                }
                                break block25;
                            }
                        }
                        catch (Throwable throwable) {
                            if (is != null) {
                                ((InputStream)is).close();
                            }
                            if (os != null) {
                                ((OutputStream)os).close();
                            }
                            throw throwable;
                        }
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                    }
                }
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
        finally {
            srcZipFile.close();
            monitor.done();
        }
    }
}

