/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.wsdl.ui.extension.dialogs;

import com.ibm.ccl.sca.core.bean.IDataBean;
import com.ibm.ccl.sca.internal.core.bean.interfaces.WSDL;
import com.ibm.ccl.sca.ui.contributions.ISelectionDialog;
import com.ibm.ccl.sca.wsdl.ui.messages.Messages;
import java.net.URI;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.core.search.scope.SearchScope;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSearchListDialogConfiguration;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentDescriptionProvider;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentList;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentSearchListProvider;
import org.eclipse.wst.common.ui.internal.search.dialogs.ScopedComponentSearchListDialog;
import org.eclipse.wst.wsdl.ui.internal.edit.WSDLBaseSearchListProvider;
import org.eclipse.wst.wsdl.ui.internal.edit.WSDLComponentDescriptionProvider;
import org.eclipse.wst.wsdl.ui.internal.search.IWSDLSearchConstants;

public class WSDLInterfaceSelectionDialog
implements ISelectionDialog {
    private ScopedComponentSearchListDialog dialog;

    public WSDLInterfaceSelectionDialog(Shell shell, IResource currentResource) {
        WSDLComponentDescriptionProvider descriptionProvider = new WSDLComponentDescriptionProvider();
        WSDLPortTypeSearchProvider searchListProvider = new WSDLPortTypeSearchProvider();
        ComponentSearchListDialogConfiguration configuration = new ComponentSearchListDialogConfiguration();
        configuration.setFilterLabelText(Messages.LABEL_NAME_PATTERN);
        configuration.setListLabelText(Messages.LABEL_MATCHED_PORT_TYPES);
        configuration.setDescriptionProvider((IComponentDescriptionProvider)descriptionProvider);
        configuration.setSearchListProvider((IComponentSearchListProvider)searchListProvider);
        String dialogTitle = Messages.TITLE_SELECT_WSDL_PORT_TYPE;
        this.dialog = new ScopedComponentSearchListDialog(shell, dialogTitle, configuration);
        this.dialog.setCurrentResource(currentResource);
        this.dialog.setShowCurrentResourceSearchScopeBug250815(false);
    }

    public boolean close() {
        return this.dialog.close();
    }

    public void create() {
        this.dialog.create();
    }

    public int open() {
        return this.dialog.open();
    }

    public IDataBean getDataBean() {
        ComponentSpecification selectedComponent = this.dialog.getSelectedComponent();
        if (selectedComponent == null) {
            return null;
        }
        QName name = new QName(selectedComponent.getQualifier(), selectedComponent.getName());
        IFile file = selectedComponent.getFile();
        URI wsdlURI = file.getLocation().toFile().toURI();
        WSDL intf = new WSDL();
        intf.setPath(file.getFullPath());
        intf.setPortType(name);
        intf.setProject(file.getProject());
        intf.setWsdlURI(wsdlURI);
        intf.setProperty("XML_VALUE", (Object)(String.valueOf(name.getNamespaceURI()) + "#wsdl.interface(" + name.getLocalPart() + ")"));
        return intf;
    }

    public class WSDLPortTypeSearchProvider
    extends WSDLBaseSearchListProvider {
        public void populateComponentList(IComponentList list, SearchScope scope, IProgressMonitor pm) {
            HashMap exclusions = new HashMap();
            this.searchOutsideCurrentResource(list, scope, IWSDLSearchConstants.PORT_TYPE_META_NAME, exclusions);
        }
    }
}

