/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.ui.validation;

import com.ibm.ccl.sca.core.validation.IValidationRule;
import com.ibm.ccl.sca.core.validation.IValidationRuleFactory;
import com.ibm.ccl.sca.core.validation.SeparatorRule;
import com.ibm.ccl.sca.internal.core.validation.ValidationPreferences;
import com.ibm.ccl.sca.internal.core.validation.ValidationRuleFactoryExtension;
import com.ibm.ccl.sca.internal.core.validation.ValidationRuleFactoryExtensionRegistry;
import com.ibm.ccl.sca.ui.messages.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

public class ValidationRulesConfiguration {
    private List<IValidationRuleFactory> factories = new ArrayList<IValidationRuleFactory>();
    private List<Pair<String, String[]>> configs = new ArrayList<Pair<String, String[]>>();
    private List<Pair<IValidationRule, ComboViewer>> rules = new ArrayList<Pair<IValidationRule, ComboViewer>>();
    private IProject project;
    private ValidationPreferences preferences;
    private TabFolder tabFolder;
    private boolean dirty = false;

    public ValidationRulesConfiguration(IProject project) {
        this.project = project;
        this.preferences = new ValidationPreferences(project);
    }

    public void addSection(String label, String ... ids) {
        this.configs.add(new Pair<String, String[]>(label, ids));
    }

    private List<IValidationRule> getRules(String[] ids) {
        ArrayList<IValidationRule> rules = new ArrayList<IValidationRule>();
        int i = 0;
        while (i < ids.length) {
            IValidationRuleFactory factory;
            ValidationRuleFactoryExtension extension = ValidationRuleFactoryExtensionRegistry.INSTANCE.getExtension(ids[i]);
            if (extension != null && (factory = extension.getFactory()) != null && !this.factories.contains(factory)) {
                this.factories.add(factory);
                List rulesFromFactory = factory.getAllRules();
                if (rulesFromFactory != null) {
                    rules.addAll(rulesFromFactory);
                }
            }
            ++i;
        }
        return rules;
    }

    private void createComboViewer(Composite client, IValidationRule rule) {
        ComboViewer combo = new ComboViewer(client);
        combo.setContentProvider((IContentProvider)new ArrayContentProvider());
        combo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                int severity = (Integer)element;
                switch (severity) {
                    case 0: {
                        return Messages.LABEL_IGNORE;
                    }
                    case 1: {
                        return Messages.LABEL_WARNING;
                    }
                }
                return Messages.LABEL_ERROR;
            }
        });
        combo.setInput((Object)new Integer[]{0, 1, 2});
        combo.setSelection((ISelection)new StructuredSelection((Object)this.preferences.getSeverity(rule.getID(), rule.getDefaultSeverity())));
        this.rules.add(new Pair<IValidationRule, ComboViewer>(rule, combo));
        combo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                ValidationRulesConfiguration.this.dirty = true;
            }
        });
    }

    private void visit(Control control, IControlVisitorAction action) {
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.visit(child, action);
                ++n2;
            }
        }
        action.accept(control);
    }

    private Link createLink(Composite parent, String text, final Control control, final int index) {
        Link link = new Link(parent, 0);
        link.setText("<a>" + text + "</a>");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValidationRulesConfiguration.this.visit(control, new IControlVisitorAction(){

                    @Override
                    public void accept(Control control) {
                        Combo combo;
                        if (control instanceof Combo && (combo = (Combo)control).getSelectionIndex() != index) {
                            combo.select(index);
                            ValidationRulesConfiguration.this.dirty = true;
                        }
                    }
                });
            }
        });
        return link;
    }

    private Composite createLinkArea(Composite parent, Control control) {
        Composite description = new Composite(parent, 0);
        GridLayout layout = new GridLayout(6, false);
        layout.marginTop = 5;
        description.setLayout((Layout)layout);
        Control[] controls = new Control[4];
        Label label = new Label(description, 0);
        label.setText(Messages.LABEL_SET_ALL_AS);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        controls[0] = label;
        controls[1] = this.createLink(description, Messages.LABEL_IGNORE, control, 0);
        label = new Label(description, 0);
        label.setText("|");
        controls[2] = this.createLink(description, Messages.LABEL_WARNING, control, 1);
        label = new Label(description, 0);
        label.setText("|");
        controls[3] = this.createLink(description, Messages.LABEL_ERROR, control, 2);
        description.setTabList(controls);
        return description;
    }

    private Composite createContainer(Composite container, SeparatorRule separator, IExpansionListener listener) {
        int style = 18;
        if (separator.isExpanded()) {
            style |= 0x40;
        }
        Section section = new Section(container, style);
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        section.setText(separator.getDescription());
        section.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        section.addExpansionListener(listener);
        section.marginHeight = 2;
        Composite clientContainer = new Composite((Composite)section, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        clientContainer.setLayout((Layout)layout);
        Composite description = this.createLinkArea((Composite)section, (Control)clientContainer);
        section.setDescriptionControl((Control)description);
        section.setClient((Control)clientContainer);
        section.setTabList(new Control[]{section.getTabList()[0], description, clientContainer});
        return clientContainer;
    }

    private void createScrolledComposite(Composite parent, Pair<String, String[]> config) {
        final ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 512);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        final Composite content = new Composite((Composite)scrolledComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        content.setLayout((Layout)layout);
        ExpansionAdapter listener = new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                scrolledComposite.setMinSize(content.computeSize(-1, -1));
            }
        };
        Composite container = content;
        Composite client = null;
        for (IValidationRule rule : this.getRules((String[])config.second)) {
            if (rule instanceof SeparatorRule) {
                if (rule.getDescription() != null) {
                    container = this.createContainer(container, (SeparatorRule)rule, (IExpansionListener)listener);
                } else if (!container.equals(content)) {
                    container = container.getParent().getParent();
                }
                client = null;
                continue;
            }
            if (rule.isHidden()) continue;
            if (client == null) {
                client = new Composite(container, 0);
                client.setLayoutData((Object)new GridData(4, 4, true, false));
                layout = new GridLayout(2, false);
                layout.marginHeight = 0;
                client.setLayout((Layout)layout);
            }
            Label description = new Label(client, 0);
            description.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
            description.setText(rule.getDescription());
            this.createComboViewer(client, rule);
        }
        scrolledComposite.setContent((Control)content);
        scrolledComposite.setMinSize(content.computeSize(-1, -1));
    }

    public void createInto(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        for (Pair<String, String[]> config : this.configs) {
            if (((String[])config.second).length == 0) continue;
            TabItem item = new TabItem(this.tabFolder, 0);
            item.setText((String)config.first);
            Composite composite = new Composite((Composite)this.tabFolder, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            composite.setLayout((Layout)layout);
            this.createLinkArea(composite, (Control)composite).setLayoutData((Object)new GridData(4, 4, true, false));
            new Label(composite, 258).setLayoutData((Object)new GridData(4, 4, true, false));
            this.createScrolledComposite(composite, config);
            item.setControl((Control)composite);
        }
    }

    public void setEnabled(final boolean enabled) {
        this.visit((Control)this.tabFolder, new IControlVisitorAction(){

            @Override
            public void accept(Control control) {
                control.setEnabled(enabled);
            }
        });
    }

    public void restoreDefaults() {
        for (Pair<IValidationRule, ComboViewer> pair : this.rules) {
            IStructuredSelection selection = (IStructuredSelection)((ComboViewer)pair.second).getSelection();
            int severity = this.preferences.getDefaultSeverity(((IValidationRule)pair.first).getID(), ((IValidationRule)pair.first).getDefaultSeverity());
            if (selection.getFirstElement().equals(severity)) continue;
            ((ComboViewer)pair.second).setSelection((ISelection)new StructuredSelection((Object)severity));
            this.dirty = true;
        }
    }

    public void applyChanges(boolean useProjectSettings) {
        if (this.dirty && this.project == null || useProjectSettings) {
            for (Pair<IValidationRule, ComboViewer> pair : this.rules) {
                IStructuredSelection selection = (IStructuredSelection)((ComboViewer)pair.second).getSelection();
                this.preferences.setSeverity(((IValidationRule)pair.first).getID(), ((Integer)selection.getFirstElement()).intValue(), ((IValidationRule)pair.first).getDefaultSeverity());
            }
        }
        this.preferences.save(useProjectSettings);
        this.dirty = false;
    }

    public boolean isUsingProjectSettings() {
        return this.preferences.isUsingProjectSettings();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private static interface IControlVisitorAction {
        public void accept(Control var1);
    }

    private static class Pair<A, B> {
        A first;
        B second;

        Pair(A first, B second) {
            this.first = first;
            this.second = second;
        }
    }
}

