/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.ui.util;

import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.widgets.Display;

public class EventTimer {
    private Set<Runnable> runSet = new HashSet<Runnable>();
    private TimerThread timerThread;
    private static EventTimer timerInstance;
    private static int instanceCount;

    public static synchronized EventTimer acquireTimer() {
        if (timerInstance == null) {
            timerInstance = new EventTimer();
            instanceCount = 0;
        }
        ++instanceCount;
        return timerInstance;
    }

    public static synchronized void releaseTimer() {
        if (--instanceCount == 0) {
            timerInstance.dispose();
            timerInstance = null;
        }
    }

    private EventTimer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Runnable runnable) {
        Set<Runnable> set = this.runSet;
        synchronized (set) {
            if (this.timerThread == null) {
                this.timerThread = new TimerThread();
                this.timerThread.start();
            }
            while (this.timerThread.getTimerState() == ThreadState.starting) {
                try {
                    this.runSet.wait(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.runSet.add(runnable);
            this.runSet.notify();
        }
    }

    public void dispose() {
        if (this.timerThread != null) {
            this.timerThread.stopThread();
        }
    }

    static enum ThreadState {
        starting,
        waiting,
        timing,
        dying;

    }

    private class TimerThread
    extends Thread {
        private ThreadState state = ThreadState.starting;
        private long waitTime = 500L;
        private static /* synthetic */ int[] $SWITCH_TABLE$com$ibm$ccl$sca$ui$util$EventTimer$ThreadState;

        private TimerThread() {
        }

        public ThreadState getTimerState() {
            return this.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopThread() {
            Set set = EventTimer.this.runSet;
            synchronized (set) {
                this.state = ThreadState.dying;
                EventTimer.this.runSet.notify();
                EventTimer.this.timerThread = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            var1_1 = EventTimer.access$0(EventTimer.this);
            synchronized (var1_1) {
                block14: while (true) lbl-1000:
                // 9 sources

                {
                    if (this.state == ThreadState.dying) {
                        return;
                    }
                    switch (TimerThread.$SWITCH_TABLE$com$ibm$ccl$sca$ui$util$EventTimer$ThreadState()[this.state.ordinal()]) {
                        case 1: {
                            this.state = ThreadState.waiting;
                            ** break;
                        }
                        case 2: {
                            try {
                                EventTimer.access$0(EventTimer.this).wait();
                                if (EventTimer.access$0(EventTimer.this).size() <= 0 || this.state == ThreadState.dying) continue block14;
                                this.state = ThreadState.timing;
                            }
                            catch (InterruptedException exc) {
                                SCAToolsUIPlugin.traceError(exc);
                            }
                            continue block14;
                        }
                        case 3: {
                            try {
                                timestamp = System.currentTimeMillis();
                                EventTimer.access$0(EventTimer.this).wait(this.waitTime);
                                if (timestamp + this.waitTime > System.currentTimeMillis() && this.state != ThreadState.dying) continue block14;
                                var5_6 = EventTimer.access$0(EventTimer.this).iterator();
                                while (true) {
                                    if (!var5_6.hasNext()) {
                                        EventTimer.access$0(EventTimer.this).clear();
                                        this.state = ThreadState.waiting;
                                        ** break;
                                    }
                                    runnable = (Runnable)var5_6.next();
                                    try {
                                        Display.getDefault().asyncExec(runnable);
                                    }
                                    catch (Exception exc) {
                                        exc.printStackTrace();
                                    }
                                }
                            }
                            catch (InterruptedException exc) {
                                SCAToolsUIPlugin.traceError(exc);
                                continue block14;
                            }
                        }
                    }
                }
            }
        }

        static /* synthetic */ int[] $SWITCH_TABLE$com$ibm$ccl$sca$ui$util$EventTimer$ThreadState() {
            if ($SWITCH_TABLE$com$ibm$ccl$sca$ui$util$EventTimer$ThreadState != null) {
                return $SWITCH_TABLE$com$ibm$ccl$sca$ui$util$EventTimer$ThreadState;
            }
            int[] nArray = new int[ThreadState.values().length];
            try {
                nArray[ThreadState.dying.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ThreadState.starting.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ThreadState.timing.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ThreadState.waiting.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$com$ibm$ccl$sca$ui$util$EventTimer$ThreadState = nArray;
            return nArray;
        }
    }
}

